/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.display;

import com.amazon.ask.model.interfaces.display.Image;
import com.amazon.ask.model.interfaces.display.TextContent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ListItem {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="image")
    private Image image = null;
    @JsonProperty(value="textContent")
    private TextContent textContent = null;

    public static Builder builder() {
        return new Builder();
    }

    private ListItem(Builder builder) {
        this.token = builder.token;
        this.image = builder.image;
        this.textContent = builder.textContent;
    }

    public String getToken() {
        return this.token;
    }

    public Image getImage() {
        return this.image;
    }

    public TextContent getTextContent() {
        return this.textContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListItem interfacesDisplayListItem = (ListItem)o;
        return Objects.equals(this.token, interfacesDisplayListItem.token) && Objects.equals(this.image, interfacesDisplayListItem.image) && Objects.equals(this.textContent, interfacesDisplayListItem.textContent);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.image, this.textContent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListItem {\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    textContent: ").append(this.toIndentedString(this.textContent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String token;
        private Image image;
        private TextContent textContent;

        private Builder() {
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="image")
        public Builder withImage(Image image) {
            this.image = image;
            return this;
        }

        @JsonProperty(value="textContent")
        public Builder withTextContent(TextContent textContent) {
            this.textContent = textContent;
            return this;
        }

        public ListItem build() {
            return new ListItem(this);
        }
    }
}

