/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.deviceAddress;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Address {
    @JsonProperty(value="addressLine1")
    private String addressLine1 = null;
    @JsonProperty(value="addressLine2")
    private String addressLine2 = null;
    @JsonProperty(value="addressLine3")
    private String addressLine3 = null;
    @JsonProperty(value="countryCode")
    private String countryCode = null;
    @JsonProperty(value="stateOrRegion")
    private String stateOrRegion = null;
    @JsonProperty(value="city")
    private String city = null;
    @JsonProperty(value="districtOrCounty")
    private String districtOrCounty = null;
    @JsonProperty(value="postalCode")
    private String postalCode = null;

    public static Builder builder() {
        return new Builder();
    }

    private Address(Builder builder) {
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.countryCode = builder.countryCode;
        this.stateOrRegion = builder.stateOrRegion;
        this.city = builder.city;
        this.districtOrCounty = builder.districtOrCounty;
        this.postalCode = builder.postalCode;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getStateOrRegion() {
        return this.stateOrRegion;
    }

    public String getCity() {
        return this.city;
    }

    public String getDistrictOrCounty() {
        return this.districtOrCounty;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address servicesDeviceAddressAddress = (Address)o;
        return Objects.equals(this.addressLine1, servicesDeviceAddressAddress.addressLine1) && Objects.equals(this.addressLine2, servicesDeviceAddressAddress.addressLine2) && Objects.equals(this.addressLine3, servicesDeviceAddressAddress.addressLine3) && Objects.equals(this.countryCode, servicesDeviceAddressAddress.countryCode) && Objects.equals(this.stateOrRegion, servicesDeviceAddressAddress.stateOrRegion) && Objects.equals(this.city, servicesDeviceAddressAddress.city) && Objects.equals(this.districtOrCounty, servicesDeviceAddressAddress.districtOrCounty) && Objects.equals(this.postalCode, servicesDeviceAddressAddress.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.addressLine1, this.addressLine2, this.addressLine3, this.countryCode, this.stateOrRegion, this.city, this.districtOrCounty, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    addressLine1: ").append(this.toIndentedString(this.addressLine1)).append("\n");
        sb.append("    addressLine2: ").append(this.toIndentedString(this.addressLine2)).append("\n");
        sb.append("    addressLine3: ").append(this.toIndentedString(this.addressLine3)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    stateOrRegion: ").append(this.toIndentedString(this.stateOrRegion)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    districtOrCounty: ").append(this.toIndentedString(this.districtOrCounty)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String addressLine1;
        private String addressLine2;
        private String addressLine3;
        private String countryCode;
        private String stateOrRegion;
        private String city;
        private String districtOrCounty;
        private String postalCode;

        private Builder() {
        }

        @JsonProperty(value="addressLine1")
        public Builder withAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        @JsonProperty(value="addressLine2")
        public Builder withAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        @JsonProperty(value="addressLine3")
        public Builder withAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        @JsonProperty(value="countryCode")
        public Builder withCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @JsonProperty(value="stateOrRegion")
        public Builder withStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        @JsonProperty(value="city")
        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        @JsonProperty(value="districtOrCounty")
        public Builder withDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        @JsonProperty(value="postalCode")
        public Builder withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Address build() {
            return new Address(this);
        }
    }
}

