/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.BaseServiceClient;
import com.amazon.ask.model.services.Pair;
import com.amazon.ask.model.services.ServiceClientResponse;
import com.amazon.ask.model.services.ServiceException;
import com.amazon.ask.model.services.listManagement.AlexaList;
import com.amazon.ask.model.services.listManagement.AlexaListItem;
import com.amazon.ask.model.services.listManagement.AlexaListMetadata;
import com.amazon.ask.model.services.listManagement.AlexaListsMetadata;
import com.amazon.ask.model.services.listManagement.CreateListItemRequest;
import com.amazon.ask.model.services.listManagement.CreateListRequest;
import com.amazon.ask.model.services.listManagement.Error;
import com.amazon.ask.model.services.listManagement.ForbiddenError;
import com.amazon.ask.model.services.listManagement.ListManagementService;
import com.amazon.ask.model.services.listManagement.UpdateListItemRequest;
import com.amazon.ask.model.services.listManagement.UpdateListRequest;
import java.util.ArrayList;
import java.util.HashMap;

public class ListManagementServiceClient
extends BaseServiceClient
implements ListManagementService {
    public ListManagementServiceClient(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public AlexaListsMetadata getListsMetadata() throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListsMetadata.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(ForbiddenError.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        return (AlexaListsMetadata)this.invoke("GET", "https://api.amazonalexa.com/", "/v2/householdlists/", queryParams, headerParams, pathParams, serviceResponseDefinitions, null, AlexaListsMetadata.class);
    }

    @Override
    public void deleteList(String listId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        this.invoke("DELETE", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/", queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null);
    }

    @Override
    public void deleteListItem(String listId, String itemId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("itemId", itemId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(null, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        this.invoke("DELETE", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/items/{itemId}/", queryParams, headerParams, pathParams, serviceResponseDefinitions, null, null);
    }

    @Override
    public AlexaListItem getListItem(String listId, String itemId) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("itemId", itemId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListItem.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        return (AlexaListItem)this.invoke("GET", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/items/{itemId}/", queryParams, headerParams, pathParams, serviceResponseDefinitions, null, AlexaListItem.class);
    }

    @Override
    public AlexaListItem updateListItem(String listId, String itemId, UpdateListItemRequest updateListItemRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("itemId", itemId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListItem.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "Conflict"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        return (AlexaListItem)this.invoke("PUT", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/items/{itemId}/", queryParams, headerParams, pathParams, serviceResponseDefinitions, updateListItemRequest, AlexaListItem.class);
    }

    @Override
    public AlexaListItem createListItem(String listId, CreateListItemRequest createListItemRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListItem.class, 201, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        return (AlexaListItem)this.invoke("POST", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/items/", queryParams, headerParams, pathParams, serviceResponseDefinitions, createListItemRequest, AlexaListItem.class);
    }

    @Override
    public AlexaListMetadata updateList(String listId, UpdateListRequest updateListRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListMetadata.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "List not found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "Conflict"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        return (AlexaListMetadata)this.invoke("PUT", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/", queryParams, headerParams, pathParams, serviceResponseDefinitions, updateListRequest, AlexaListMetadata.class);
    }

    @Override
    public AlexaList getList(String listId, String status) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("listId", listId);
        pathParams.put("status", status);
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaList.class, 200, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 404, "Not Found"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        return (AlexaList)this.invoke("GET", "https://api.amazonalexa.com/", "/v2/householdlists/{listId}/{status}/", queryParams, headerParams, pathParams, serviceResponseDefinitions, null, AlexaList.class);
    }

    @Override
    public AlexaListMetadata createList(CreateListRequest createListRequest) throws ServiceException {
        ArrayList<Pair<String, String>> queryParams = new ArrayList<Pair<String, String>>();
        HashMap<String, String> pathParams = new HashMap<String, String>();
        ArrayList<Pair<String, String>> headerParams = new ArrayList<Pair<String, String>>();
        headerParams.add(new Pair<String, String>("Content-type", "application/json"));
        String apiAuthorizationValue = "Bearer " + this.authorizationValue;
        headerParams.add(new Pair<String, String>("Authorization", apiAuthorizationValue));
        ArrayList<ServiceClientResponse> serviceResponseDefinitions = new ArrayList<ServiceClientResponse>();
        serviceResponseDefinitions.add(new ServiceClientResponse(AlexaListMetadata.class, 201, "Success"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 400, "Bad Request"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 403, "Forbidden"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 409, "Conflict"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 500, "Internal Server Error"));
        serviceResponseDefinitions.add(new ServiceClientResponse(Error.class, 0, "Internal Server Error"));
        return (AlexaListMetadata)this.invoke("POST", "https://api.amazonalexa.com/", "/v2/householdlists/", queryParams, headerParams, pathParams, serviceResponseDefinitions, createListRequest, AlexaListMetadata.class);
    }
}

