/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.ui;

import com.amazon.ask.model.ui.Card;
import com.amazon.ask.model.ui.Image;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class StandardCard
extends Card {
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="text")
    private String text = null;
    @JsonProperty(value="image")
    private Image image = null;

    public static Builder builder() {
        return new Builder();
    }

    private StandardCard(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Standard";
        this.title = builder.title;
        this.text = builder.text;
        this.image = builder.image;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardCard uiStandardCard = (StandardCard)o;
        return Objects.equals(this.title, uiStandardCard.title) && Objects.equals(this.text, uiStandardCard.text) && Objects.equals(this.image, uiStandardCard.image) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.title, this.text, this.image, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandardCard {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String title;
        private String text;
        private Image image;

        private Builder() {
        }

        @JsonProperty(value="title")
        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="text")
        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        @JsonProperty(value="image")
        public Builder withImage(Image image) {
            this.image = image;
            return this;
        }

        public StandardCard build() {
            return new StandardCard(this);
        }
    }
}

