/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetResponse
extends Response {
    public S3Object object;

    public GetResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            Map<String, List<String>> metadata = this.extractMetadata(connection);
            this.object = new S3Object(connection.getInputStream(), metadata);
        }
    }

    private Map<String, List<String>> extractMetadata(HttpURLConnection conn) {
        TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
        Map<String, List<String>> headers = conn.getHeaderFields();
        for (String key : headers.keySet()) {
            if (key == null || !key.startsWith("x-amz-meta-")) continue;
            metadata.put(key.substring("x-amz-meta-".length()), headers.get(key));
        }
        return metadata;
    }

    static byte[] slurpInputStream(InputStream stream) throws IOException {
        int count;
        int chunkSize = 2048;
        byte[] buf = new byte[2048];
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
        while ((count = stream.read(buf)) != -1) {
            byteStream.write(buf, 0, count);
        }
        return byteStream.toByteArray();
    }
}

