/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CommonPrefixEntry;
import com.amazon.s3.ListEntry;
import com.amazon.s3.Owner;
import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SimpleTimeZone;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ListBucketResponse
extends Response {
    public String name = null;
    public String prefix = null;
    public String marker = null;
    public String delimiter = null;
    public int maxKeys = 0;
    public boolean isTruncated = false;
    public String nextMarker = null;
    public List<ListEntry> entries = null;
    public List<CommonPrefixEntry> commonPrefixEntries = null;

    public ListBucketResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            try {
                XMLReader xr = Utils.createXMLReader();
                ListBucketHandler handler = new ListBucketHandler();
                xr.setContentHandler(handler);
                xr.setErrorHandler(handler);
                xr.parse(new InputSource(connection.getInputStream()));
                this.name = handler.getName();
                this.prefix = handler.getPrefix();
                this.marker = handler.getMarker();
                this.delimiter = handler.getDelimiter();
                this.maxKeys = handler.getMaxKeys();
                this.isTruncated = handler.getIsTruncated();
                this.nextMarker = handler.getNextMarker();
                this.entries = handler.getKeyEntries();
                this.commonPrefixEntries = handler.getCommonPrefixEntries();
            }
            catch (SAXException e) {
                throw new RuntimeException("Unexpected error parsing ListBucket xml", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListBucketHandler
    extends DefaultHandler {
        private String name_ = null;
        private String prefix_ = null;
        private String marker_ = null;
        private String delimiter_ = null;
        private int maxKeys_ = 0;
        private boolean isTruncated_ = false;
        private String nextMarker_ = null;
        private boolean isEchoedPrefix = false;
        private List<ListEntry> keyEntries = new ArrayList<ListEntry>();
        private ListEntry keyEntry = null;
        private List<CommonPrefixEntry> commonPrefixEntries_ = new ArrayList<CommonPrefixEntry>();
        private CommonPrefixEntry commonPrefixEntry = null;
        private StringBuffer currText = null;
        private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public ListBucketHandler() {
            this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
            this.currText = new StringBuffer();
        }

        @Override
        public void startDocument() {
            this.isEchoedPrefix = true;
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Contents")) {
                this.keyEntry = new ListEntry();
            } else if (name.equals("Owner")) {
                this.keyEntry.owner = new Owner();
            } else if (name.equals("CommonPrefixes")) {
                this.commonPrefixEntry = new CommonPrefixEntry();
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            if (name.equals("Name")) {
                this.name_ = this.currText.toString();
            } else if (name.equals("Prefix") && this.isEchoedPrefix) {
                this.prefix_ = this.currText.toString();
                this.isEchoedPrefix = false;
            } else if (name.equals("Marker")) {
                this.marker_ = this.currText.toString();
            } else if (name.equals("MaxKeys")) {
                this.maxKeys_ = Integer.parseInt(this.currText.toString());
            } else if (name.equals("Delimiter")) {
                this.delimiter_ = this.currText.toString();
            } else if (name.equals("IsTruncated")) {
                this.isTruncated_ = Boolean.parseBoolean(this.currText.toString());
            } else if (name.equals("NextMarker")) {
                this.nextMarker_ = this.currText.toString();
            } else if (name.equals("Contents")) {
                this.keyEntries.add(this.keyEntry);
            } else if (name.equals("Key")) {
                this.keyEntry.key = this.currText.toString();
            } else if (name.equals("LastModified")) {
                try {
                    this.keyEntry.lastModified = this.iso8601Parser.parse(this.currText.toString());
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unexpected date format in list bucket output", e);
                }
            } else if (name.equals("ETag")) {
                this.keyEntry.eTag = this.currText.toString();
            } else if (name.equals("Size")) {
                this.keyEntry.size = Long.parseLong(this.currText.toString());
            } else if (name.equals("StorageClass")) {
                this.keyEntry.storageClass = this.currText.toString();
            } else if (name.equals("ID")) {
                this.keyEntry.owner.id = this.currText.toString();
            } else if (name.equals("DisplayName")) {
                this.keyEntry.owner.displayName = this.currText.toString();
            } else if (name.equals("CommonPrefixes")) {
                this.commonPrefixEntries_.add(this.commonPrefixEntry);
            } else if (name.equals("Prefix")) {
                this.commonPrefixEntry.prefix = this.currText.toString();
            }
            if (this.currText.length() != 0) {
                this.currText = new StringBuffer();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }

        public String getName() {
            return this.name_;
        }

        public String getPrefix() {
            return this.prefix_;
        }

        public String getMarker() {
            return this.marker_;
        }

        public String getDelimiter() {
            return this.delimiter_;
        }

        public int getMaxKeys() {
            return this.maxKeys_;
        }

        public boolean getIsTruncated() {
            return this.isTruncated_;
        }

        public String getNextMarker() {
            return this.nextMarker_;
        }

        public List<ListEntry> getKeyEntries() {
            return this.keyEntries;
        }

        public List<CommonPrefixEntry> getCommonPrefixEntries() {
            return this.commonPrefixEntries_;
        }
    }
}

