/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudfront;

import javax.annotation.Generated;

import com.amazonaws.services.cloudfront.model.*;
import com.amazonaws.*;
import com.amazonaws.services.cloudfront.waiters.AmazonCloudFrontWaiters;

/**
 * Abstract implementation of {@code AmazonCloudFront}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonCloudFront implements AmazonCloudFront {

    protected AbstractAmazonCloudFront() {
    }

    @Override
    public void setEndpoint(String endpoint) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void setRegion(com.amazonaws.regions.Region region) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCloudFrontOriginAccessIdentityResult createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDistributionResult createDistribution(CreateDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDistributionWithTagsResult createDistributionWithTags(CreateDistributionWithTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFieldLevelEncryptionConfigResult createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFieldLevelEncryptionProfileResult createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInvalidationResult createInvalidation(CreateInvalidationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePublicKeyResult createPublicKey(CreatePublicKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStreamingDistributionResult createStreamingDistribution(CreateStreamingDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStreamingDistributionWithTagsResult createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCloudFrontOriginAccessIdentityResult deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDistributionResult deleteDistribution(DeleteDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFieldLevelEncryptionConfigResult deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFieldLevelEncryptionProfileResult deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePublicKeyResult deletePublicKey(DeletePublicKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStreamingDistributionResult deleteStreamingDistribution(DeleteStreamingDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCloudFrontOriginAccessIdentityResult getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCloudFrontOriginAccessIdentityConfigResult getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDistributionResult getDistribution(GetDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDistributionConfigResult getDistributionConfig(GetDistributionConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFieldLevelEncryptionResult getFieldLevelEncryption(GetFieldLevelEncryptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFieldLevelEncryptionConfigResult getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFieldLevelEncryptionProfileResult getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFieldLevelEncryptionProfileConfigResult getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInvalidationResult getInvalidation(GetInvalidationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPublicKeyResult getPublicKey(GetPublicKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPublicKeyConfigResult getPublicKeyConfig(GetPublicKeyConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStreamingDistributionResult getStreamingDistribution(GetStreamingDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStreamingDistributionConfigResult getStreamingDistributionConfig(GetStreamingDistributionConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCloudFrontOriginAccessIdentitiesResult listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDistributionsResult listDistributions(ListDistributionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDistributionsByWebACLIdResult listDistributionsByWebACLId(ListDistributionsByWebACLIdRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFieldLevelEncryptionConfigsResult listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFieldLevelEncryptionProfilesResult listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInvalidationsResult listInvalidations(ListInvalidationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPublicKeysResult listPublicKeys(ListPublicKeysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStreamingDistributionsResult listStreamingDistributions(ListStreamingDistributionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCloudFrontOriginAccessIdentityResult updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDistributionResult updateDistribution(UpdateDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFieldLevelEncryptionConfigResult updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFieldLevelEncryptionProfileResult updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePublicKeyResult updatePublicKey(UpdatePublicKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStreamingDistributionResult updateStreamingDistribution(UpdateStreamingDistributionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonCloudFrontWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
