/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudtrail.model.AdvancedEventSelector;
import com.amazonaws.services.cloudtrail.model.transform.SourceConfigMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SourceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean applyToAllRegions;
    private SdkInternalList<AdvancedEventSelector> advancedEventSelectors;

    public void setApplyToAllRegions(Boolean applyToAllRegions) {
        this.applyToAllRegions = applyToAllRegions;
    }

    public Boolean getApplyToAllRegions() {
        return this.applyToAllRegions;
    }

    public SourceConfig withApplyToAllRegions(Boolean applyToAllRegions) {
        this.setApplyToAllRegions(applyToAllRegions);
        return this;
    }

    public Boolean isApplyToAllRegions() {
        return this.applyToAllRegions;
    }

    public List<AdvancedEventSelector> getAdvancedEventSelectors() {
        if (this.advancedEventSelectors == null) {
            this.advancedEventSelectors = new SdkInternalList();
        }
        return this.advancedEventSelectors;
    }

    public void setAdvancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
        if (advancedEventSelectors == null) {
            this.advancedEventSelectors = null;
            return;
        }
        this.advancedEventSelectors = new SdkInternalList(advancedEventSelectors);
    }

    public SourceConfig withAdvancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
        if (this.advancedEventSelectors == null) {
            this.setAdvancedEventSelectors((Collection<AdvancedEventSelector>)new SdkInternalList(advancedEventSelectors.length));
        }
        for (AdvancedEventSelector ele : advancedEventSelectors) {
            this.advancedEventSelectors.add((Object)ele);
        }
        return this;
    }

    public SourceConfig withAdvancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
        this.setAdvancedEventSelectors(advancedEventSelectors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplyToAllRegions() != null) {
            sb.append("ApplyToAllRegions: ").append(this.getApplyToAllRegions()).append(",");
        }
        if (this.getAdvancedEventSelectors() != null) {
            sb.append("AdvancedEventSelectors: ").append(this.getAdvancedEventSelectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfig)) {
            return false;
        }
        SourceConfig other = (SourceConfig)obj;
        if (other.getApplyToAllRegions() == null ^ this.getApplyToAllRegions() == null) {
            return false;
        }
        if (other.getApplyToAllRegions() != null && !other.getApplyToAllRegions().equals(this.getApplyToAllRegions())) {
            return false;
        }
        if (other.getAdvancedEventSelectors() == null ^ this.getAdvancedEventSelectors() == null) {
            return false;
        }
        return other.getAdvancedEventSelectors() == null || other.getAdvancedEventSelectors().equals(this.getAdvancedEventSelectors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplyToAllRegions() == null ? 0 : this.getApplyToAllRegions().hashCode());
        hashCode = 31 * hashCode + (this.getAdvancedEventSelectors() == null ? 0 : this.getAdvancedEventSelectors().hashCode());
        return hashCode;
    }

    public SourceConfig clone() {
        try {
            return (SourceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

