/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAlarmsRequestMarshaller
implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {
    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {
        if (describeAlarmsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList alarmNamesList = (SdkInternalList)describeAlarmsRequest.getAlarmNames();
        if (!alarmNamesList.isEmpty() || !alarmNamesList.isAutoConstruct()) {
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        if (describeAlarmsRequest.getAlarmNamePrefix() != null) {
            request.addParameter("AlarmNamePrefix", StringUtils.fromString((String)describeAlarmsRequest.getAlarmNamePrefix()));
        }
        if (describeAlarmsRequest.getStateValue() != null) {
            request.addParameter("StateValue", StringUtils.fromString((String)describeAlarmsRequest.getStateValue()));
        }
        if (describeAlarmsRequest.getActionPrefix() != null) {
            request.addParameter("ActionPrefix", StringUtils.fromString((String)describeAlarmsRequest.getActionPrefix()));
        }
        if (describeAlarmsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmsRequest.getMaxRecords()));
        }
        if (describeAlarmsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmsRequest.getNextToken()));
        }
        return request;
    }
}

