/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codepipeline.model.ActionCategory;
import com.amazonaws.services.codepipeline.model.ActionConfigurationProperty;
import com.amazonaws.services.codepipeline.model.ActionTypeSettings;
import com.amazonaws.services.codepipeline.model.ArtifactDetails;
import com.amazonaws.services.codepipeline.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCustomActionTypeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String category;
    private String provider;
    private String version;
    private ActionTypeSettings settings;
    private List<ActionConfigurationProperty> configurationProperties;
    private ArtifactDetails inputArtifactDetails;
    private ArtifactDetails outputArtifactDetails;
    private List<Tag> tags;

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public CreateCustomActionTypeRequest withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public void setCategory(ActionCategory category) {
        this.withCategory(category);
    }

    public CreateCustomActionTypeRequest withCategory(ActionCategory category) {
        this.category = category.toString();
        return this;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public CreateCustomActionTypeRequest withProvider(String provider) {
        this.setProvider(provider);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CreateCustomActionTypeRequest withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setSettings(ActionTypeSettings settings) {
        this.settings = settings;
    }

    public ActionTypeSettings getSettings() {
        return this.settings;
    }

    public CreateCustomActionTypeRequest withSettings(ActionTypeSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public List<ActionConfigurationProperty> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Collection<ActionConfigurationProperty> configurationProperties) {
        if (configurationProperties == null) {
            this.configurationProperties = null;
            return;
        }
        this.configurationProperties = new ArrayList<ActionConfigurationProperty>(configurationProperties);
    }

    public CreateCustomActionTypeRequest withConfigurationProperties(ActionConfigurationProperty ... configurationProperties) {
        if (this.configurationProperties == null) {
            this.setConfigurationProperties(new ArrayList<ActionConfigurationProperty>(configurationProperties.length));
        }
        for (ActionConfigurationProperty ele : configurationProperties) {
            this.configurationProperties.add(ele);
        }
        return this;
    }

    public CreateCustomActionTypeRequest withConfigurationProperties(Collection<ActionConfigurationProperty> configurationProperties) {
        this.setConfigurationProperties(configurationProperties);
        return this;
    }

    public void setInputArtifactDetails(ArtifactDetails inputArtifactDetails) {
        this.inputArtifactDetails = inputArtifactDetails;
    }

    public ArtifactDetails getInputArtifactDetails() {
        return this.inputArtifactDetails;
    }

    public CreateCustomActionTypeRequest withInputArtifactDetails(ArtifactDetails inputArtifactDetails) {
        this.setInputArtifactDetails(inputArtifactDetails);
        return this;
    }

    public void setOutputArtifactDetails(ArtifactDetails outputArtifactDetails) {
        this.outputArtifactDetails = outputArtifactDetails;
    }

    public ArtifactDetails getOutputArtifactDetails() {
        return this.outputArtifactDetails;
    }

    public CreateCustomActionTypeRequest withOutputArtifactDetails(ArtifactDetails outputArtifactDetails) {
        this.setOutputArtifactDetails(outputArtifactDetails);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateCustomActionTypeRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateCustomActionTypeRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getProvider() != null) {
            sb.append("Provider: ").append(this.getProvider()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getConfigurationProperties() != null) {
            sb.append("ConfigurationProperties: ").append(this.getConfigurationProperties()).append(",");
        }
        if (this.getInputArtifactDetails() != null) {
            sb.append("InputArtifactDetails: ").append(this.getInputArtifactDetails()).append(",");
        }
        if (this.getOutputArtifactDetails() != null) {
            sb.append("OutputArtifactDetails: ").append(this.getOutputArtifactDetails()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomActionTypeRequest)) {
            return false;
        }
        CreateCustomActionTypeRequest other = (CreateCustomActionTypeRequest)obj;
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getProvider() == null ^ this.getProvider() == null) {
            return false;
        }
        if (other.getProvider() != null && !other.getProvider().equals(this.getProvider())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getConfigurationProperties() == null ^ this.getConfigurationProperties() == null) {
            return false;
        }
        if (other.getConfigurationProperties() != null && !other.getConfigurationProperties().equals(this.getConfigurationProperties())) {
            return false;
        }
        if (other.getInputArtifactDetails() == null ^ this.getInputArtifactDetails() == null) {
            return false;
        }
        if (other.getInputArtifactDetails() != null && !other.getInputArtifactDetails().equals(this.getInputArtifactDetails())) {
            return false;
        }
        if (other.getOutputArtifactDetails() == null ^ this.getOutputArtifactDetails() == null) {
            return false;
        }
        if (other.getOutputArtifactDetails() != null && !other.getOutputArtifactDetails().equals(this.getOutputArtifactDetails())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getProvider() == null ? 0 : this.getProvider().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationProperties() == null ? 0 : this.getConfigurationProperties().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifactDetails() == null ? 0 : this.getInputArtifactDetails().hashCode());
        hashCode = 31 * hashCode + (this.getOutputArtifactDetails() == null ? 0 : this.getOutputArtifactDetails().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateCustomActionTypeRequest clone() {
        return (CreateCustomActionTypeRequest)super.clone();
    }
}

