/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.InputArtifact;
import com.amazonaws.services.codepipeline.model.RuleTypeId;
import com.amazonaws.services.codepipeline.model.transform.RuleDeclarationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleDeclaration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private RuleTypeId ruleTypeId;
    private Map<String, String> configuration;
    private List<InputArtifact> inputArtifacts;
    private String roleArn;
    private String region;
    private Integer timeoutInMinutes;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RuleDeclaration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRuleTypeId(RuleTypeId ruleTypeId) {
        this.ruleTypeId = ruleTypeId;
    }

    public RuleTypeId getRuleTypeId() {
        return this.ruleTypeId;
    }

    public RuleDeclaration withRuleTypeId(RuleTypeId ruleTypeId) {
        this.setRuleTypeId(ruleTypeId);
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public RuleDeclaration withConfiguration(Map<String, String> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public RuleDeclaration addConfigurationEntry(String key, String value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, String>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public RuleDeclaration clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public List<InputArtifact> getInputArtifacts() {
        return this.inputArtifacts;
    }

    public void setInputArtifacts(Collection<InputArtifact> inputArtifacts) {
        if (inputArtifacts == null) {
            this.inputArtifacts = null;
            return;
        }
        this.inputArtifacts = new ArrayList<InputArtifact>(inputArtifacts);
    }

    public RuleDeclaration withInputArtifacts(InputArtifact ... inputArtifacts) {
        if (this.inputArtifacts == null) {
            this.setInputArtifacts(new ArrayList<InputArtifact>(inputArtifacts.length));
        }
        for (InputArtifact ele : inputArtifacts) {
            this.inputArtifacts.add(ele);
        }
        return this;
    }

    public RuleDeclaration withInputArtifacts(Collection<InputArtifact> inputArtifacts) {
        this.setInputArtifacts(inputArtifacts);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public RuleDeclaration withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public RuleDeclaration withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public RuleDeclaration withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRuleTypeId() != null) {
            sb.append("RuleTypeId: ").append(this.getRuleTypeId()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getInputArtifacts() != null) {
            sb.append("InputArtifacts: ").append(this.getInputArtifacts()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDeclaration)) {
            return false;
        }
        RuleDeclaration other = (RuleDeclaration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRuleTypeId() == null ^ this.getRuleTypeId() == null) {
            return false;
        }
        if (other.getRuleTypeId() != null && !other.getRuleTypeId().equals(this.getRuleTypeId())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getInputArtifacts() == null ^ this.getInputArtifacts() == null) {
            return false;
        }
        if (other.getInputArtifacts() != null && !other.getInputArtifacts().equals(this.getInputArtifacts())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        return other.getTimeoutInMinutes() == null || other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRuleTypeId() == null ? 0 : this.getRuleTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifacts() == null ? 0 : this.getInputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        return hashCode;
    }

    public RuleDeclaration clone() {
        try {
            return (RuleDeclaration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

