/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.comprehend.model.BlockReference;
import java.util.List;

@SdkInternalApi
public class BlockReferenceMarshaller {
    private static final MarshallingInfo<String> BLOCKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockId").build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").build();
    private static final MarshallingInfo<List> CHILDBLOCKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChildBlocks").build();
    private static final BlockReferenceMarshaller instance = new BlockReferenceMarshaller();

    public static BlockReferenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(BlockReference blockReference, ProtocolMarshaller protocolMarshaller) {
        if (blockReference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)blockReference.getBlockId(), BLOCKID_BINDING);
            protocolMarshaller.marshall((Object)blockReference.getBeginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall((Object)blockReference.getEndOffset(), ENDOFFSET_BINDING);
            protocolMarshaller.marshall(blockReference.getChildBlocks(), CHILDBLOCKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

