/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehendmedical;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalAsync;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalAsyncClientBuilder;
import com.amazonaws.services.comprehendmedical.AWSComprehendMedicalClient;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesRequest;
import com.amazonaws.services.comprehendmedical.model.DetectEntitiesResult;
import com.amazonaws.services.comprehendmedical.model.DetectPHIRequest;
import com.amazonaws.services.comprehendmedical.model.DetectPHIResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSComprehendMedicalAsyncClient
extends AWSComprehendMedicalClient
implements AWSComprehendMedicalAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSComprehendMedicalAsyncClientBuilder asyncBuilder() {
        return AWSComprehendMedicalAsyncClientBuilder.standard();
    }

    AWSComprehendMedicalAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request) {
        return this.detectEntitiesAsync(request, null);
    }

    @Override
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request, final AsyncHandler<DetectEntitiesRequest, DetectEntitiesResult> asyncHandler) {
        final DetectEntitiesRequest finalRequest = (DetectEntitiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectEntitiesResult>(){

            @Override
            public DetectEntitiesResult call() throws Exception {
                DetectEntitiesResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDetectEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectPHIResult> detectPHIAsync(DetectPHIRequest request) {
        return this.detectPHIAsync(request, null);
    }

    @Override
    public Future<DetectPHIResult> detectPHIAsync(DetectPHIRequest request, final AsyncHandler<DetectPHIRequest, DetectPHIResult> asyncHandler) {
        final DetectPHIRequest finalRequest = (DetectPHIRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectPHIResult>(){

            @Override
            public DetectPHIResult call() throws Exception {
                DetectPHIResult result = null;
                try {
                    result = AWSComprehendMedicalAsyncClient.this.executeDetectPHI(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

