/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.computeoptimizer.model.RecommendationPreferenceName;
import com.amazonaws.services.computeoptimizer.model.ResourceType;
import com.amazonaws.services.computeoptimizer.model.Scope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteRecommendationPreferencesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceType;
    private Scope scope;
    private List<String> recommendationPreferenceNames;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public DeleteRecommendationPreferencesRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public DeleteRecommendationPreferencesRequest withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public DeleteRecommendationPreferencesRequest withScope(Scope scope) {
        this.setScope(scope);
        return this;
    }

    public List<String> getRecommendationPreferenceNames() {
        return this.recommendationPreferenceNames;
    }

    public void setRecommendationPreferenceNames(Collection<String> recommendationPreferenceNames) {
        if (recommendationPreferenceNames == null) {
            this.recommendationPreferenceNames = null;
            return;
        }
        this.recommendationPreferenceNames = new ArrayList<String>(recommendationPreferenceNames);
    }

    public DeleteRecommendationPreferencesRequest withRecommendationPreferenceNames(String ... recommendationPreferenceNames) {
        if (this.recommendationPreferenceNames == null) {
            this.setRecommendationPreferenceNames(new ArrayList<String>(recommendationPreferenceNames.length));
        }
        for (String ele : recommendationPreferenceNames) {
            this.recommendationPreferenceNames.add(ele);
        }
        return this;
    }

    public DeleteRecommendationPreferencesRequest withRecommendationPreferenceNames(Collection<String> recommendationPreferenceNames) {
        this.setRecommendationPreferenceNames(recommendationPreferenceNames);
        return this;
    }

    public DeleteRecommendationPreferencesRequest withRecommendationPreferenceNames(RecommendationPreferenceName ... recommendationPreferenceNames) {
        ArrayList<String> recommendationPreferenceNamesCopy = new ArrayList<String>(recommendationPreferenceNames.length);
        for (RecommendationPreferenceName value : recommendationPreferenceNames) {
            recommendationPreferenceNamesCopy.add(value.toString());
        }
        if (this.getRecommendationPreferenceNames() == null) {
            this.setRecommendationPreferenceNames(recommendationPreferenceNamesCopy);
        } else {
            this.getRecommendationPreferenceNames().addAll(recommendationPreferenceNamesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getRecommendationPreferenceNames() != null) {
            sb.append("RecommendationPreferenceNames: ").append(this.getRecommendationPreferenceNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommendationPreferencesRequest)) {
            return false;
        }
        DeleteRecommendationPreferencesRequest other = (DeleteRecommendationPreferencesRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getRecommendationPreferenceNames() == null ^ this.getRecommendationPreferenceNames() == null) {
            return false;
        }
        return other.getRecommendationPreferenceNames() == null || other.getRecommendationPreferenceNames().equals(this.getRecommendationPreferenceNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendationPreferenceNames() == null ? 0 : this.getRecommendationPreferenceNames().hashCode());
        return hashCode;
    }

    public DeleteRecommendationPreferencesRequest clone() {
        return (DeleteRecommendationPreferencesRequest)super.clone();
    }
}

