/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.Gpu;

@SdkInternalApi
public class GpuMarshaller {
    private static final MarshallingInfo<Integer> GPUCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gpuCount").build();
    private static final MarshallingInfo<Integer> GPUMEMORYSIZEINMIB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gpuMemorySizeInMiB").build();
    private static final GpuMarshaller instance = new GpuMarshaller();

    public static GpuMarshaller getInstance() {
        return instance;
    }

    public void marshall(Gpu gpu, ProtocolMarshaller protocolMarshaller) {
        if (gpu == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gpu.getGpuCount(), GPUCOUNT_BINDING);
            protocolMarshaller.marshall((Object)gpu.getGpuMemorySizeInMiB(), GPUMEMORYSIZEINMIB_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

