/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.AZMode;
import com.amazonaws.services.elasticache.model.AuthTokenUpdateStrategyType;
import com.amazonaws.services.elasticache.model.IpDiscovery;
import com.amazonaws.services.elasticache.model.LogDeliveryConfigurationRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyCacheClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cacheClusterId;
    private Integer numCacheNodes;
    private SdkInternalList<String> cacheNodeIdsToRemove;
    private String aZMode;
    private SdkInternalList<String> newAvailabilityZones;
    private SdkInternalList<String> cacheSecurityGroupNames;
    private SdkInternalList<String> securityGroupIds;
    private String preferredMaintenanceWindow;
    private String notificationTopicArn;
    private String cacheParameterGroupName;
    private String notificationTopicStatus;
    private Boolean applyImmediately;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private String cacheNodeType;
    private String authToken;
    private String authTokenUpdateStrategy;
    private SdkInternalList<LogDeliveryConfigurationRequest> logDeliveryConfigurations;
    private String ipDiscovery;

    public ModifyCacheClusterRequest() {
    }

    public ModifyCacheClusterRequest(String cacheClusterId) {
        this.setCacheClusterId(cacheClusterId);
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public ModifyCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.setCacheClusterId(cacheClusterId);
        return this;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public ModifyCacheClusterRequest withNumCacheNodes(Integer numCacheNodes) {
        this.setNumCacheNodes(numCacheNodes);
        return this;
    }

    public List<String> getCacheNodeIdsToRemove() {
        if (this.cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = new SdkInternalList();
        }
        return this.cacheNodeIdsToRemove;
    }

    public void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        if (cacheNodeIdsToRemove == null) {
            this.cacheNodeIdsToRemove = null;
            return;
        }
        this.cacheNodeIdsToRemove = new SdkInternalList(cacheNodeIdsToRemove);
    }

    public ModifyCacheClusterRequest withCacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
        if (this.cacheNodeIdsToRemove == null) {
            this.setCacheNodeIdsToRemove((Collection<String>)new SdkInternalList(cacheNodeIdsToRemove.length));
        }
        for (String ele : cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove.add((Object)ele);
        }
        return this;
    }

    public ModifyCacheClusterRequest withCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
        this.setCacheNodeIdsToRemove(cacheNodeIdsToRemove);
        return this;
    }

    public void setAZMode(String aZMode) {
        this.aZMode = aZMode;
    }

    public String getAZMode() {
        return this.aZMode;
    }

    public ModifyCacheClusterRequest withAZMode(String aZMode) {
        this.setAZMode(aZMode);
        return this;
    }

    public void setAZMode(AZMode aZMode) {
        this.withAZMode(aZMode);
    }

    public ModifyCacheClusterRequest withAZMode(AZMode aZMode) {
        this.aZMode = aZMode.toString();
        return this;
    }

    public List<String> getNewAvailabilityZones() {
        if (this.newAvailabilityZones == null) {
            this.newAvailabilityZones = new SdkInternalList();
        }
        return this.newAvailabilityZones;
    }

    public void setNewAvailabilityZones(Collection<String> newAvailabilityZones) {
        if (newAvailabilityZones == null) {
            this.newAvailabilityZones = null;
            return;
        }
        this.newAvailabilityZones = new SdkInternalList(newAvailabilityZones);
    }

    public ModifyCacheClusterRequest withNewAvailabilityZones(String ... newAvailabilityZones) {
        if (this.newAvailabilityZones == null) {
            this.setNewAvailabilityZones((Collection<String>)new SdkInternalList(newAvailabilityZones.length));
        }
        for (String ele : newAvailabilityZones) {
            this.newAvailabilityZones.add((Object)ele);
        }
        return this;
    }

    public ModifyCacheClusterRequest withNewAvailabilityZones(Collection<String> newAvailabilityZones) {
        this.setNewAvailabilityZones(newAvailabilityZones);
        return this;
    }

    public List<String> getCacheSecurityGroupNames() {
        if (this.cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = new SdkInternalList();
        }
        return this.cacheSecurityGroupNames;
    }

    public void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        if (cacheSecurityGroupNames == null) {
            this.cacheSecurityGroupNames = null;
            return;
        }
        this.cacheSecurityGroupNames = new SdkInternalList(cacheSecurityGroupNames);
    }

    public ModifyCacheClusterRequest withCacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
        if (this.cacheSecurityGroupNames == null) {
            this.setCacheSecurityGroupNames((Collection<String>)new SdkInternalList(cacheSecurityGroupNames.length));
        }
        for (String ele : cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames.add((Object)ele);
        }
        return this;
    }

    public ModifyCacheClusterRequest withCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
        this.setCacheSecurityGroupNames(cacheSecurityGroupNames);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new SdkInternalList();
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new SdkInternalList(securityGroupIds);
    }

    public ModifyCacheClusterRequest withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds((Collection<String>)new SdkInternalList(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add((Object)ele);
        }
        return this;
    }

    public ModifyCacheClusterRequest withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public ModifyCacheClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setNotificationTopicArn(String notificationTopicArn) {
        this.notificationTopicArn = notificationTopicArn;
    }

    public String getNotificationTopicArn() {
        return this.notificationTopicArn;
    }

    public ModifyCacheClusterRequest withNotificationTopicArn(String notificationTopicArn) {
        this.setNotificationTopicArn(notificationTopicArn);
        return this;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public ModifyCacheClusterRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.setCacheParameterGroupName(cacheParameterGroupName);
        return this;
    }

    public void setNotificationTopicStatus(String notificationTopicStatus) {
        this.notificationTopicStatus = notificationTopicStatus;
    }

    public String getNotificationTopicStatus() {
        return this.notificationTopicStatus;
    }

    public ModifyCacheClusterRequest withNotificationTopicStatus(String notificationTopicStatus) {
        this.setNotificationTopicStatus(notificationTopicStatus);
        return this;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public ModifyCacheClusterRequest withApplyImmediately(Boolean applyImmediately) {
        this.setApplyImmediately(applyImmediately);
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public ModifyCacheClusterRequest withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public ModifyCacheClusterRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public ModifyCacheClusterRequest withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public ModifyCacheClusterRequest withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public ModifyCacheClusterRequest withCacheNodeType(String cacheNodeType) {
        this.setCacheNodeType(cacheNodeType);
        return this;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public ModifyCacheClusterRequest withAuthToken(String authToken) {
        this.setAuthToken(authToken);
        return this;
    }

    public void setAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
        this.authTokenUpdateStrategy = authTokenUpdateStrategy;
    }

    public String getAuthTokenUpdateStrategy() {
        return this.authTokenUpdateStrategy;
    }

    public ModifyCacheClusterRequest withAuthTokenUpdateStrategy(String authTokenUpdateStrategy) {
        this.setAuthTokenUpdateStrategy(authTokenUpdateStrategy);
        return this;
    }

    public void setAuthTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
        this.withAuthTokenUpdateStrategy(authTokenUpdateStrategy);
    }

    public ModifyCacheClusterRequest withAuthTokenUpdateStrategy(AuthTokenUpdateStrategyType authTokenUpdateStrategy) {
        this.authTokenUpdateStrategy = authTokenUpdateStrategy.toString();
        return this;
    }

    public List<LogDeliveryConfigurationRequest> getLogDeliveryConfigurations() {
        if (this.logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = new SdkInternalList();
        }
        return this.logDeliveryConfigurations;
    }

    public void setLogDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
        if (logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = null;
            return;
        }
        this.logDeliveryConfigurations = new SdkInternalList(logDeliveryConfigurations);
    }

    public ModifyCacheClusterRequest withLogDeliveryConfigurations(LogDeliveryConfigurationRequest ... logDeliveryConfigurations) {
        if (this.logDeliveryConfigurations == null) {
            this.setLogDeliveryConfigurations((Collection<LogDeliveryConfigurationRequest>)new SdkInternalList(logDeliveryConfigurations.length));
        }
        for (LogDeliveryConfigurationRequest ele : logDeliveryConfigurations) {
            this.logDeliveryConfigurations.add((Object)ele);
        }
        return this;
    }

    public ModifyCacheClusterRequest withLogDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
        this.setLogDeliveryConfigurations(logDeliveryConfigurations);
        return this;
    }

    public void setIpDiscovery(String ipDiscovery) {
        this.ipDiscovery = ipDiscovery;
    }

    public String getIpDiscovery() {
        return this.ipDiscovery;
    }

    public ModifyCacheClusterRequest withIpDiscovery(String ipDiscovery) {
        this.setIpDiscovery(ipDiscovery);
        return this;
    }

    public void setIpDiscovery(IpDiscovery ipDiscovery) {
        this.withIpDiscovery(ipDiscovery);
    }

    public ModifyCacheClusterRequest withIpDiscovery(IpDiscovery ipDiscovery) {
        this.ipDiscovery = ipDiscovery.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: ").append(this.getCacheClusterId()).append(",");
        }
        if (this.getNumCacheNodes() != null) {
            sb.append("NumCacheNodes: ").append(this.getNumCacheNodes()).append(",");
        }
        if (this.getCacheNodeIdsToRemove() != null) {
            sb.append("CacheNodeIdsToRemove: ").append(this.getCacheNodeIdsToRemove()).append(",");
        }
        if (this.getAZMode() != null) {
            sb.append("AZMode: ").append(this.getAZMode()).append(",");
        }
        if (this.getNewAvailabilityZones() != null) {
            sb.append("NewAvailabilityZones: ").append(this.getNewAvailabilityZones()).append(",");
        }
        if (this.getCacheSecurityGroupNames() != null) {
            sb.append("CacheSecurityGroupNames: ").append(this.getCacheSecurityGroupNames()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getNotificationTopicArn() != null) {
            sb.append("NotificationTopicArn: ").append(this.getNotificationTopicArn()).append(",");
        }
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: ").append(this.getCacheParameterGroupName()).append(",");
        }
        if (this.getNotificationTopicStatus() != null) {
            sb.append("NotificationTopicStatus: ").append(this.getNotificationTopicStatus()).append(",");
        }
        if (this.getApplyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.getApplyImmediately()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.getSnapshotRetentionLimit()).append(",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.getSnapshotWindow()).append(",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.getCacheNodeType()).append(",");
        }
        if (this.getAuthToken() != null) {
            sb.append("AuthToken: ").append(this.getAuthToken()).append(",");
        }
        if (this.getAuthTokenUpdateStrategy() != null) {
            sb.append("AuthTokenUpdateStrategy: ").append(this.getAuthTokenUpdateStrategy()).append(",");
        }
        if (this.getLogDeliveryConfigurations() != null) {
            sb.append("LogDeliveryConfigurations: ").append(this.getLogDeliveryConfigurations()).append(",");
        }
        if (this.getIpDiscovery() != null) {
            sb.append("IpDiscovery: ").append(this.getIpDiscovery());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCacheClusterRequest)) {
            return false;
        }
        ModifyCacheClusterRequest other = (ModifyCacheClusterRequest)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getNumCacheNodes() == null ^ this.getNumCacheNodes() == null) {
            return false;
        }
        if (other.getNumCacheNodes() != null && !other.getNumCacheNodes().equals(this.getNumCacheNodes())) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() == null ^ this.getCacheNodeIdsToRemove() == null) {
            return false;
        }
        if (other.getCacheNodeIdsToRemove() != null && !other.getCacheNodeIdsToRemove().equals(this.getCacheNodeIdsToRemove())) {
            return false;
        }
        if (other.getAZMode() == null ^ this.getAZMode() == null) {
            return false;
        }
        if (other.getAZMode() != null && !other.getAZMode().equals(this.getAZMode())) {
            return false;
        }
        if (other.getNewAvailabilityZones() == null ^ this.getNewAvailabilityZones() == null) {
            return false;
        }
        if (other.getNewAvailabilityZones() != null && !other.getNewAvailabilityZones().equals(this.getNewAvailabilityZones())) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() == null ^ this.getCacheSecurityGroupNames() == null) {
            return false;
        }
        if (other.getCacheSecurityGroupNames() != null && !other.getCacheSecurityGroupNames().equals(this.getCacheSecurityGroupNames())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getNotificationTopicArn() == null ^ this.getNotificationTopicArn() == null) {
            return false;
        }
        if (other.getNotificationTopicArn() != null && !other.getNotificationTopicArn().equals(this.getNotificationTopicArn())) {
            return false;
        }
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.getNotificationTopicStatus() == null ^ this.getNotificationTopicStatus() == null) {
            return false;
        }
        if (other.getNotificationTopicStatus() != null && !other.getNotificationTopicStatus().equals(this.getNotificationTopicStatus())) {
            return false;
        }
        if (other.getApplyImmediately() == null ^ this.getApplyImmediately() == null) {
            return false;
        }
        if (other.getApplyImmediately() != null && !other.getApplyImmediately().equals(this.getApplyImmediately())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getAuthToken() == null ^ this.getAuthToken() == null) {
            return false;
        }
        if (other.getAuthToken() != null && !other.getAuthToken().equals(this.getAuthToken())) {
            return false;
        }
        if (other.getAuthTokenUpdateStrategy() == null ^ this.getAuthTokenUpdateStrategy() == null) {
            return false;
        }
        if (other.getAuthTokenUpdateStrategy() != null && !other.getAuthTokenUpdateStrategy().equals(this.getAuthTokenUpdateStrategy())) {
            return false;
        }
        if (other.getLogDeliveryConfigurations() == null ^ this.getLogDeliveryConfigurations() == null) {
            return false;
        }
        if (other.getLogDeliveryConfigurations() != null && !other.getLogDeliveryConfigurations().equals(this.getLogDeliveryConfigurations())) {
            return false;
        }
        if (other.getIpDiscovery() == null ^ this.getIpDiscovery() == null) {
            return false;
        }
        return other.getIpDiscovery() == null || other.getIpDiscovery().equals(this.getIpDiscovery());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getNumCacheNodes() == null ? 0 : this.getNumCacheNodes().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeIdsToRemove() == null ? 0 : this.getCacheNodeIdsToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getAZMode() == null ? 0 : this.getAZMode().hashCode());
        hashCode = 31 * hashCode + (this.getNewAvailabilityZones() == null ? 0 : this.getNewAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSecurityGroupNames() == null ? 0 : this.getCacheSecurityGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicArn() == null ? 0 : this.getNotificationTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTopicStatus() == null ? 0 : this.getNotificationTopicStatus().hashCode());
        hashCode = 31 * hashCode + (this.getApplyImmediately() == null ? 0 : this.getApplyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getAuthToken() == null ? 0 : this.getAuthToken().hashCode());
        hashCode = 31 * hashCode + (this.getAuthTokenUpdateStrategy() == null ? 0 : this.getAuthTokenUpdateStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getLogDeliveryConfigurations() == null ? 0 : this.getLogDeliveryConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getIpDiscovery() == null ? 0 : this.getIpDiscovery().hashCode());
        return hashCode;
    }

    public ModifyCacheClusterRequest clone() {
        return (ModifyCacheClusterRequest)super.clone();
    }
}

