/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CopyServerlessCacheSnapshotRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyServerlessCacheSnapshotRequestMarshaller
implements Marshaller<Request<CopyServerlessCacheSnapshotRequest>, CopyServerlessCacheSnapshotRequest> {
    public Request<CopyServerlessCacheSnapshotRequest> marshall(CopyServerlessCacheSnapshotRequest copyServerlessCacheSnapshotRequest) {
        if (copyServerlessCacheSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyServerlessCacheSnapshotRequest, "AmazonElastiCache");
        request.addParameter("Action", "CopyServerlessCacheSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyServerlessCacheSnapshotRequest.getSourceServerlessCacheSnapshotName() != null) {
            request.addParameter("SourceServerlessCacheSnapshotName", StringUtils.fromString((String)copyServerlessCacheSnapshotRequest.getSourceServerlessCacheSnapshotName()));
        }
        if (copyServerlessCacheSnapshotRequest.getTargetServerlessCacheSnapshotName() != null) {
            request.addParameter("TargetServerlessCacheSnapshotName", StringUtils.fromString((String)copyServerlessCacheSnapshotRequest.getTargetServerlessCacheSnapshotName()));
        }
        if (copyServerlessCacheSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copyServerlessCacheSnapshotRequest.getKmsKeyId()));
        }
        if (!copyServerlessCacheSnapshotRequest.getTags().isEmpty() || !((SdkInternalList)copyServerlessCacheSnapshotRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)copyServerlessCacheSnapshotRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

