/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ParameterNameValue;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyCacheParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyCacheParameterGroupRequest>, ModifyCacheParameterGroupRequest> {
    public Request<ModifyCacheParameterGroupRequest> marshall(ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) {
        if (modifyCacheParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyCacheParameterGroupRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyCacheParameterGroup");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheParameterGroupRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyCacheParameterGroupRequest.getCacheParameterGroupName()));
        }
        if (!modifyCacheParameterGroupRequest.getParameterNameValues().isEmpty() || !((SdkInternalList)modifyCacheParameterGroupRequest.getParameterNameValues()).isAutoConstruct()) {
            SdkInternalList parameterNameValuesList = (SdkInternalList)modifyCacheParameterGroupRequest.getParameterNameValues();
            int parameterNameValuesListIndex = 1;
            for (ParameterNameValue parameterNameValuesListValue : parameterNameValuesList) {
                if (parameterNameValuesListValue != null) {
                    if (parameterNameValuesListValue.getParameterName() != null) {
                        request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterName", StringUtils.fromString((String)parameterNameValuesListValue.getParameterName()));
                    }
                    if (parameterNameValuesListValue.getParameterValue() != null) {
                        request.addParameter("ParameterNameValues.ParameterNameValue." + parameterNameValuesListIndex + ".ParameterValue", StringUtils.fromString((String)parameterNameValuesListValue.getParameterValue()));
                    }
                }
                ++parameterNameValuesListIndex;
            }
        }
        return request;
    }
}

