/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateLoadBalancerPolicyRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerPolicyRequest>, CreateLoadBalancerPolicyRequest> {
    public Request<CreateLoadBalancerPolicyRequest> marshall(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        if (createLoadBalancerPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerPolicyRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateLoadBalancerPolicy");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerPolicyRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.getLoadBalancerName()));
        }
        if (createLoadBalancerPolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.getPolicyName()));
        }
        if (createLoadBalancerPolicyRequest.getPolicyTypeName() != null) {
            request.addParameter("PolicyTypeName", StringUtils.fromString((String)createLoadBalancerPolicyRequest.getPolicyTypeName()));
        }
        if (!createLoadBalancerPolicyRequest.getPolicyAttributes().isEmpty() || !((SdkInternalList)createLoadBalancerPolicyRequest.getPolicyAttributes()).isAutoConstruct()) {
            SdkInternalList policyAttributesList = (SdkInternalList)createLoadBalancerPolicyRequest.getPolicyAttributes();
            int policyAttributesListIndex = 1;
            for (PolicyAttribute policyAttributesListValue : policyAttributesList) {
                if (policyAttributesListValue.getAttributeName() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeName", StringUtils.fromString((String)policyAttributesListValue.getAttributeName()));
                }
                if (policyAttributesListValue.getAttributeValue() != null) {
                    request.addParameter("PolicyAttributes.member." + policyAttributesListIndex + ".AttributeValue", StringUtils.fromString((String)policyAttributesListValue.getAttributeValue()));
                }
                ++policyAttributesListIndex;
            }
        }
        return request;
    }
}

