/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.Resource;
import com.amazonaws.services.globalaccelerator.model.transform.AttachmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Attachment
implements Serializable,
Cloneable,
StructuredPojo {
    private String attachmentArn;
    private String name;
    private List<String> principals;
    private List<Resource> resources;
    private Date lastModifiedTime;
    private Date createdTime;

    public void setAttachmentArn(String attachmentArn) {
        this.attachmentArn = attachmentArn;
    }

    public String getAttachmentArn() {
        return this.attachmentArn;
    }

    public Attachment withAttachmentArn(String attachmentArn) {
        this.setAttachmentArn(attachmentArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Attachment withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<String> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<String>(principals);
    }

    public Attachment withPrincipals(String ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<String>(principals.length));
        }
        for (String ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public Attachment withPrincipals(Collection<String> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public Attachment withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public Attachment withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Attachment withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Attachment withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachmentArn() != null) {
            sb.append("AttachmentArn: ").append(this.getAttachmentArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        if (other.getAttachmentArn() == null ^ this.getAttachmentArn() == null) {
            return false;
        }
        if (other.getAttachmentArn() != null && !other.getAttachmentArn().equals(this.getAttachmentArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        if (other.getPrincipals() != null && !other.getPrincipals().equals(this.getPrincipals())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        return other.getCreatedTime() == null || other.getCreatedTime().equals(this.getCreatedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachmentArn() == null ? 0 : this.getAttachmentArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        return hashCode;
    }

    public Attachment clone() {
        try {
            return (Attachment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

