/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrass.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListBulkDeploymentDetailedReportsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /** A list of the individual group deployments in the bulk deployment operation. */
    private java.util.List<BulkDeploymentResult> deployments;
    /** The token for the next set of results, or ''null'' if there are no additional results. */
    private String nextToken;

    /**
     * A list of the individual group deployments in the bulk deployment operation.
     * 
     * @return A list of the individual group deployments in the bulk deployment operation.
     */

    public java.util.List<BulkDeploymentResult> getDeployments() {
        return deployments;
    }

    /**
     * A list of the individual group deployments in the bulk deployment operation.
     * 
     * @param deployments
     *        A list of the individual group deployments in the bulk deployment operation.
     */

    public void setDeployments(java.util.Collection<BulkDeploymentResult> deployments) {
        if (deployments == null) {
            this.deployments = null;
            return;
        }

        this.deployments = new java.util.ArrayList<BulkDeploymentResult>(deployments);
    }

    /**
     * A list of the individual group deployments in the bulk deployment operation.
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDeployments(java.util.Collection)} or {@link #withDeployments(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param deployments
     *        A list of the individual group deployments in the bulk deployment operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListBulkDeploymentDetailedReportsResult withDeployments(BulkDeploymentResult... deployments) {
        if (this.deployments == null) {
            setDeployments(new java.util.ArrayList<BulkDeploymentResult>(deployments.length));
        }
        for (BulkDeploymentResult ele : deployments) {
            this.deployments.add(ele);
        }
        return this;
    }

    /**
     * A list of the individual group deployments in the bulk deployment operation.
     * 
     * @param deployments
     *        A list of the individual group deployments in the bulk deployment operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListBulkDeploymentDetailedReportsResult withDeployments(java.util.Collection<BulkDeploymentResult> deployments) {
        setDeployments(deployments);
        return this;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @param nextToken
     *        The token for the next set of results, or ''null'' if there are no additional results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @return The token for the next set of results, or ''null'' if there are no additional results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * The token for the next set of results, or ''null'' if there are no additional results.
     * 
     * @param nextToken
     *        The token for the next set of results, or ''null'' if there are no additional results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListBulkDeploymentDetailedReportsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDeployments() != null)
            sb.append("Deployments: ").append(getDeployments()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListBulkDeploymentDetailedReportsResult == false)
            return false;
        ListBulkDeploymentDetailedReportsResult other = (ListBulkDeploymentDetailedReportsResult) obj;
        if (other.getDeployments() == null ^ this.getDeployments() == null)
            return false;
        if (other.getDeployments() != null && other.getDeployments().equals(this.getDeployments()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDeployments() == null) ? 0 : getDeployments().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListBulkDeploymentDetailedReportsResult clone() {
        try {
            return (ListBulkDeploymentDetailedReportsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
