/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.transform.CisTargetsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CisTargets
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> accountIds;
    private Map<String, List<String>> targetResourceTags;

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public CisTargets withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public CisTargets withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public Map<String, List<String>> getTargetResourceTags() {
        return this.targetResourceTags;
    }

    public void setTargetResourceTags(Map<String, List<String>> targetResourceTags) {
        this.targetResourceTags = targetResourceTags;
    }

    public CisTargets withTargetResourceTags(Map<String, List<String>> targetResourceTags) {
        this.setTargetResourceTags(targetResourceTags);
        return this;
    }

    public CisTargets addTargetResourceTagsEntry(String key, List<String> value) {
        if (null == this.targetResourceTags) {
            this.targetResourceTags = new HashMap<String, List<String>>();
        }
        if (this.targetResourceTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targetResourceTags.put(key, value);
        return this;
    }

    public CisTargets clearTargetResourceTagsEntries() {
        this.targetResourceTags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getTargetResourceTags() != null) {
            sb.append("TargetResourceTags: ").append(this.getTargetResourceTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisTargets)) {
            return false;
        }
        CisTargets other = (CisTargets)obj;
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getTargetResourceTags() == null ^ this.getTargetResourceTags() == null) {
            return false;
        }
        return other.getTargetResourceTags() == null || other.getTargetResourceTags().equals(this.getTargetResourceTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getTargetResourceTags() == null ? 0 : this.getTargetResourceTags().hashCode());
        return hashCode;
    }

    public CisTargets clone() {
        try {
            return (CisTargets)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CisTargetsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

