/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.TestCaseDefinition;
import com.amazonaws.services.iotdeviceadvisor.model.transform.TestCaseMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TestCase
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Map<String, String> configuration;
    private TestCaseDefinition test;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TestCase withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public TestCase withConfiguration(Map<String, String> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public TestCase addConfigurationEntry(String key, String value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, String>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public TestCase clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public void setTest(TestCaseDefinition test) {
        this.test = test;
    }

    public TestCaseDefinition getTest() {
        return this.test;
    }

    public TestCase withTest(TestCaseDefinition test) {
        this.setTest(test);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getTest() != null) {
            sb.append("Test: ").append(this.getTest());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCase)) {
            return false;
        }
        TestCase other = (TestCase)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getTest() == null ^ this.getTest() == null) {
            return false;
        }
        return other.getTest() == null || other.getTest().equals(this.getTest());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTest() == null ? 0 : this.getTest().hashCode());
        return hashCode;
    }

    public TestCase clone() {
        try {
            return (TestCase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TestCaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

