/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kafka.model.KafkaClusterDescription;

@SdkInternalApi
public class KafkaClusterDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> AMAZONMSKCLUSTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonMskCluster").build();
    private static final MarshallingInfo<String> KAFKACLUSTERALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kafkaClusterAlias").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcConfig").build();
    private static final KafkaClusterDescriptionMarshaller instance = new KafkaClusterDescriptionMarshaller();

    public static KafkaClusterDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(KafkaClusterDescription kafkaClusterDescription, ProtocolMarshaller protocolMarshaller) {
        if (kafkaClusterDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kafkaClusterDescription.getAmazonMskCluster(), AMAZONMSKCLUSTER_BINDING);
            protocolMarshaller.marshall((Object)kafkaClusterDescription.getKafkaClusterAlias(), KAFKACLUSTERALIAS_BINDING);
            protocolMarshaller.marshall((Object)kafkaClusterDescription.getVpcConfig(), VPCCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

