/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.outposts.AWSOutpostsAsync;
import com.amazonaws.services.outposts.AWSOutpostsAsyncClientBuilder;
import com.amazonaws.services.outposts.AWSOutpostsClient;
import com.amazonaws.services.outposts.model.CancelCapacityTaskRequest;
import com.amazonaws.services.outposts.model.CancelCapacityTaskResult;
import com.amazonaws.services.outposts.model.CancelOrderRequest;
import com.amazonaws.services.outposts.model.CancelOrderResult;
import com.amazonaws.services.outposts.model.CreateOrderRequest;
import com.amazonaws.services.outposts.model.CreateOrderResult;
import com.amazonaws.services.outposts.model.CreateOutpostRequest;
import com.amazonaws.services.outposts.model.CreateOutpostResult;
import com.amazonaws.services.outposts.model.CreateSiteRequest;
import com.amazonaws.services.outposts.model.CreateSiteResult;
import com.amazonaws.services.outposts.model.DeleteOutpostRequest;
import com.amazonaws.services.outposts.model.DeleteOutpostResult;
import com.amazonaws.services.outposts.model.DeleteSiteRequest;
import com.amazonaws.services.outposts.model.DeleteSiteResult;
import com.amazonaws.services.outposts.model.GetCapacityTaskRequest;
import com.amazonaws.services.outposts.model.GetCapacityTaskResult;
import com.amazonaws.services.outposts.model.GetCatalogItemRequest;
import com.amazonaws.services.outposts.model.GetCatalogItemResult;
import com.amazonaws.services.outposts.model.GetConnectionRequest;
import com.amazonaws.services.outposts.model.GetConnectionResult;
import com.amazonaws.services.outposts.model.GetOrderRequest;
import com.amazonaws.services.outposts.model.GetOrderResult;
import com.amazonaws.services.outposts.model.GetOutpostInstanceTypesRequest;
import com.amazonaws.services.outposts.model.GetOutpostInstanceTypesResult;
import com.amazonaws.services.outposts.model.GetOutpostRequest;
import com.amazonaws.services.outposts.model.GetOutpostResult;
import com.amazonaws.services.outposts.model.GetOutpostSupportedInstanceTypesRequest;
import com.amazonaws.services.outposts.model.GetOutpostSupportedInstanceTypesResult;
import com.amazonaws.services.outposts.model.GetSiteAddressRequest;
import com.amazonaws.services.outposts.model.GetSiteAddressResult;
import com.amazonaws.services.outposts.model.GetSiteRequest;
import com.amazonaws.services.outposts.model.GetSiteResult;
import com.amazonaws.services.outposts.model.ListAssetsRequest;
import com.amazonaws.services.outposts.model.ListAssetsResult;
import com.amazonaws.services.outposts.model.ListCapacityTasksRequest;
import com.amazonaws.services.outposts.model.ListCapacityTasksResult;
import com.amazonaws.services.outposts.model.ListCatalogItemsRequest;
import com.amazonaws.services.outposts.model.ListCatalogItemsResult;
import com.amazonaws.services.outposts.model.ListOrdersRequest;
import com.amazonaws.services.outposts.model.ListOrdersResult;
import com.amazonaws.services.outposts.model.ListOutpostsRequest;
import com.amazonaws.services.outposts.model.ListOutpostsResult;
import com.amazonaws.services.outposts.model.ListSitesRequest;
import com.amazonaws.services.outposts.model.ListSitesResult;
import com.amazonaws.services.outposts.model.ListTagsForResourceRequest;
import com.amazonaws.services.outposts.model.ListTagsForResourceResult;
import com.amazonaws.services.outposts.model.StartCapacityTaskRequest;
import com.amazonaws.services.outposts.model.StartCapacityTaskResult;
import com.amazonaws.services.outposts.model.StartConnectionRequest;
import com.amazonaws.services.outposts.model.StartConnectionResult;
import com.amazonaws.services.outposts.model.TagResourceRequest;
import com.amazonaws.services.outposts.model.TagResourceResult;
import com.amazonaws.services.outposts.model.UntagResourceRequest;
import com.amazonaws.services.outposts.model.UntagResourceResult;
import com.amazonaws.services.outposts.model.UpdateOutpostRequest;
import com.amazonaws.services.outposts.model.UpdateOutpostResult;
import com.amazonaws.services.outposts.model.UpdateSiteAddressRequest;
import com.amazonaws.services.outposts.model.UpdateSiteAddressResult;
import com.amazonaws.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest;
import com.amazonaws.services.outposts.model.UpdateSiteRackPhysicalPropertiesResult;
import com.amazonaws.services.outposts.model.UpdateSiteRequest;
import com.amazonaws.services.outposts.model.UpdateSiteResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSOutpostsAsyncClient
extends AWSOutpostsClient
implements AWSOutpostsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSOutpostsAsyncClientBuilder asyncBuilder() {
        return AWSOutpostsAsyncClientBuilder.standard();
    }

    AWSOutpostsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSOutpostsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelCapacityTaskResult> cancelCapacityTaskAsync(CancelCapacityTaskRequest request) {
        return this.cancelCapacityTaskAsync(request, null);
    }

    @Override
    public Future<CancelCapacityTaskResult> cancelCapacityTaskAsync(CancelCapacityTaskRequest request, final AsyncHandler<CancelCapacityTaskRequest, CancelCapacityTaskResult> asyncHandler) {
        final CancelCapacityTaskRequest finalRequest = (CancelCapacityTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelCapacityTaskResult>(){

            @Override
            public CancelCapacityTaskResult call() throws Exception {
                CancelCapacityTaskResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCancelCapacityTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelOrderResult> cancelOrderAsync(CancelOrderRequest request) {
        return this.cancelOrderAsync(request, null);
    }

    @Override
    public Future<CancelOrderResult> cancelOrderAsync(CancelOrderRequest request, final AsyncHandler<CancelOrderRequest, CancelOrderResult> asyncHandler) {
        final CancelOrderRequest finalRequest = (CancelOrderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelOrderResult>(){

            @Override
            public CancelOrderResult call() throws Exception {
                CancelOrderResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCancelOrder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOrderResult> createOrderAsync(CreateOrderRequest request) {
        return this.createOrderAsync(request, null);
    }

    @Override
    public Future<CreateOrderResult> createOrderAsync(CreateOrderRequest request, final AsyncHandler<CreateOrderRequest, CreateOrderResult> asyncHandler) {
        final CreateOrderRequest finalRequest = (CreateOrderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOrderResult>(){

            @Override
            public CreateOrderResult call() throws Exception {
                CreateOrderResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCreateOrder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOutpostResult> createOutpostAsync(CreateOutpostRequest request) {
        return this.createOutpostAsync(request, null);
    }

    @Override
    public Future<CreateOutpostResult> createOutpostAsync(CreateOutpostRequest request, final AsyncHandler<CreateOutpostRequest, CreateOutpostResult> asyncHandler) {
        final CreateOutpostRequest finalRequest = (CreateOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOutpostResult>(){

            @Override
            public CreateOutpostResult call() throws Exception {
                CreateOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCreateOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request) {
        return this.createSiteAsync(request, null);
    }

    @Override
    public Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request, final AsyncHandler<CreateSiteRequest, CreateSiteResult> asyncHandler) {
        final CreateSiteRequest finalRequest = (CreateSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSiteResult>(){

            @Override
            public CreateSiteResult call() throws Exception {
                CreateSiteResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeCreateSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOutpostResult> deleteOutpostAsync(DeleteOutpostRequest request) {
        return this.deleteOutpostAsync(request, null);
    }

    @Override
    public Future<DeleteOutpostResult> deleteOutpostAsync(DeleteOutpostRequest request, final AsyncHandler<DeleteOutpostRequest, DeleteOutpostResult> asyncHandler) {
        final DeleteOutpostRequest finalRequest = (DeleteOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOutpostResult>(){

            @Override
            public DeleteOutpostResult call() throws Exception {
                DeleteOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeDeleteOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request) {
        return this.deleteSiteAsync(request, null);
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request, final AsyncHandler<DeleteSiteRequest, DeleteSiteResult> asyncHandler) {
        final DeleteSiteRequest finalRequest = (DeleteSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSiteResult>(){

            @Override
            public DeleteSiteResult call() throws Exception {
                DeleteSiteResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeDeleteSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCapacityTaskResult> getCapacityTaskAsync(GetCapacityTaskRequest request) {
        return this.getCapacityTaskAsync(request, null);
    }

    @Override
    public Future<GetCapacityTaskResult> getCapacityTaskAsync(GetCapacityTaskRequest request, final AsyncHandler<GetCapacityTaskRequest, GetCapacityTaskResult> asyncHandler) {
        final GetCapacityTaskRequest finalRequest = (GetCapacityTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCapacityTaskResult>(){

            @Override
            public GetCapacityTaskResult call() throws Exception {
                GetCapacityTaskResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetCapacityTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCatalogItemResult> getCatalogItemAsync(GetCatalogItemRequest request) {
        return this.getCatalogItemAsync(request, null);
    }

    @Override
    public Future<GetCatalogItemResult> getCatalogItemAsync(GetCatalogItemRequest request, final AsyncHandler<GetCatalogItemRequest, GetCatalogItemResult> asyncHandler) {
        final GetCatalogItemRequest finalRequest = (GetCatalogItemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCatalogItemResult>(){

            @Override
            public GetCatalogItemResult call() throws Exception {
                GetCatalogItemResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetCatalogItem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request) {
        return this.getConnectionAsync(request, null);
    }

    @Override
    public Future<GetConnectionResult> getConnectionAsync(GetConnectionRequest request, final AsyncHandler<GetConnectionRequest, GetConnectionResult> asyncHandler) {
        final GetConnectionRequest finalRequest = (GetConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConnectionResult>(){

            @Override
            public GetConnectionResult call() throws Exception {
                GetConnectionResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOrderResult> getOrderAsync(GetOrderRequest request) {
        return this.getOrderAsync(request, null);
    }

    @Override
    public Future<GetOrderResult> getOrderAsync(GetOrderRequest request, final AsyncHandler<GetOrderRequest, GetOrderResult> asyncHandler) {
        final GetOrderRequest finalRequest = (GetOrderRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOrderResult>(){

            @Override
            public GetOrderResult call() throws Exception {
                GetOrderResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetOrder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutpostResult> getOutpostAsync(GetOutpostRequest request) {
        return this.getOutpostAsync(request, null);
    }

    @Override
    public Future<GetOutpostResult> getOutpostAsync(GetOutpostRequest request, final AsyncHandler<GetOutpostRequest, GetOutpostResult> asyncHandler) {
        final GetOutpostRequest finalRequest = (GetOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutpostResult>(){

            @Override
            public GetOutpostResult call() throws Exception {
                GetOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutpostInstanceTypesResult> getOutpostInstanceTypesAsync(GetOutpostInstanceTypesRequest request) {
        return this.getOutpostInstanceTypesAsync(request, null);
    }

    @Override
    public Future<GetOutpostInstanceTypesResult> getOutpostInstanceTypesAsync(GetOutpostInstanceTypesRequest request, final AsyncHandler<GetOutpostInstanceTypesRequest, GetOutpostInstanceTypesResult> asyncHandler) {
        final GetOutpostInstanceTypesRequest finalRequest = (GetOutpostInstanceTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutpostInstanceTypesResult>(){

            @Override
            public GetOutpostInstanceTypesResult call() throws Exception {
                GetOutpostInstanceTypesResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetOutpostInstanceTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOutpostSupportedInstanceTypesResult> getOutpostSupportedInstanceTypesAsync(GetOutpostSupportedInstanceTypesRequest request) {
        return this.getOutpostSupportedInstanceTypesAsync(request, null);
    }

    @Override
    public Future<GetOutpostSupportedInstanceTypesResult> getOutpostSupportedInstanceTypesAsync(GetOutpostSupportedInstanceTypesRequest request, final AsyncHandler<GetOutpostSupportedInstanceTypesRequest, GetOutpostSupportedInstanceTypesResult> asyncHandler) {
        final GetOutpostSupportedInstanceTypesRequest finalRequest = (GetOutpostSupportedInstanceTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetOutpostSupportedInstanceTypesResult>(){

            @Override
            public GetOutpostSupportedInstanceTypesResult call() throws Exception {
                GetOutpostSupportedInstanceTypesResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetOutpostSupportedInstanceTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSiteResult> getSiteAsync(GetSiteRequest request) {
        return this.getSiteAsync(request, null);
    }

    @Override
    public Future<GetSiteResult> getSiteAsync(GetSiteRequest request, final AsyncHandler<GetSiteRequest, GetSiteResult> asyncHandler) {
        final GetSiteRequest finalRequest = (GetSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSiteResult>(){

            @Override
            public GetSiteResult call() throws Exception {
                GetSiteResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSiteAddressResult> getSiteAddressAsync(GetSiteAddressRequest request) {
        return this.getSiteAddressAsync(request, null);
    }

    @Override
    public Future<GetSiteAddressResult> getSiteAddressAsync(GetSiteAddressRequest request, final AsyncHandler<GetSiteAddressRequest, GetSiteAddressResult> asyncHandler) {
        final GetSiteAddressRequest finalRequest = (GetSiteAddressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSiteAddressResult>(){

            @Override
            public GetSiteAddressResult call() throws Exception {
                GetSiteAddressResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeGetSiteAddress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssetsResult> listAssetsAsync(ListAssetsRequest request) {
        return this.listAssetsAsync(request, null);
    }

    @Override
    public Future<ListAssetsResult> listAssetsAsync(ListAssetsRequest request, final AsyncHandler<ListAssetsRequest, ListAssetsResult> asyncHandler) {
        final ListAssetsRequest finalRequest = (ListAssetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssetsResult>(){

            @Override
            public ListAssetsResult call() throws Exception {
                ListAssetsResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListAssets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCapacityTasksResult> listCapacityTasksAsync(ListCapacityTasksRequest request) {
        return this.listCapacityTasksAsync(request, null);
    }

    @Override
    public Future<ListCapacityTasksResult> listCapacityTasksAsync(ListCapacityTasksRequest request, final AsyncHandler<ListCapacityTasksRequest, ListCapacityTasksResult> asyncHandler) {
        final ListCapacityTasksRequest finalRequest = (ListCapacityTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCapacityTasksResult>(){

            @Override
            public ListCapacityTasksResult call() throws Exception {
                ListCapacityTasksResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListCapacityTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCatalogItemsResult> listCatalogItemsAsync(ListCatalogItemsRequest request) {
        return this.listCatalogItemsAsync(request, null);
    }

    @Override
    public Future<ListCatalogItemsResult> listCatalogItemsAsync(ListCatalogItemsRequest request, final AsyncHandler<ListCatalogItemsRequest, ListCatalogItemsResult> asyncHandler) {
        final ListCatalogItemsRequest finalRequest = (ListCatalogItemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCatalogItemsResult>(){

            @Override
            public ListCatalogItemsResult call() throws Exception {
                ListCatalogItemsResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListCatalogItems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOrdersResult> listOrdersAsync(ListOrdersRequest request) {
        return this.listOrdersAsync(request, null);
    }

    @Override
    public Future<ListOrdersResult> listOrdersAsync(ListOrdersRequest request, final AsyncHandler<ListOrdersRequest, ListOrdersResult> asyncHandler) {
        final ListOrdersRequest finalRequest = (ListOrdersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOrdersResult>(){

            @Override
            public ListOrdersResult call() throws Exception {
                ListOrdersResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListOrders(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOutpostsResult> listOutpostsAsync(ListOutpostsRequest request) {
        return this.listOutpostsAsync(request, null);
    }

    @Override
    public Future<ListOutpostsResult> listOutpostsAsync(ListOutpostsRequest request, final AsyncHandler<ListOutpostsRequest, ListOutpostsResult> asyncHandler) {
        final ListOutpostsRequest finalRequest = (ListOutpostsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOutpostsResult>(){

            @Override
            public ListOutpostsResult call() throws Exception {
                ListOutpostsResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListOutposts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSitesResult> listSitesAsync(ListSitesRequest request) {
        return this.listSitesAsync(request, null);
    }

    @Override
    public Future<ListSitesResult> listSitesAsync(ListSitesRequest request, final AsyncHandler<ListSitesRequest, ListSitesResult> asyncHandler) {
        final ListSitesRequest finalRequest = (ListSitesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSitesResult>(){

            @Override
            public ListSitesResult call() throws Exception {
                ListSitesResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListSites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartCapacityTaskResult> startCapacityTaskAsync(StartCapacityTaskRequest request) {
        return this.startCapacityTaskAsync(request, null);
    }

    @Override
    public Future<StartCapacityTaskResult> startCapacityTaskAsync(StartCapacityTaskRequest request, final AsyncHandler<StartCapacityTaskRequest, StartCapacityTaskResult> asyncHandler) {
        final StartCapacityTaskRequest finalRequest = (StartCapacityTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartCapacityTaskResult>(){

            @Override
            public StartCapacityTaskResult call() throws Exception {
                StartCapacityTaskResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeStartCapacityTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartConnectionResult> startConnectionAsync(StartConnectionRequest request) {
        return this.startConnectionAsync(request, null);
    }

    @Override
    public Future<StartConnectionResult> startConnectionAsync(StartConnectionRequest request, final AsyncHandler<StartConnectionRequest, StartConnectionResult> asyncHandler) {
        final StartConnectionRequest finalRequest = (StartConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartConnectionResult>(){

            @Override
            public StartConnectionResult call() throws Exception {
                StartConnectionResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeStartConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOutpostResult> updateOutpostAsync(UpdateOutpostRequest request) {
        return this.updateOutpostAsync(request, null);
    }

    @Override
    public Future<UpdateOutpostResult> updateOutpostAsync(UpdateOutpostRequest request, final AsyncHandler<UpdateOutpostRequest, UpdateOutpostResult> asyncHandler) {
        final UpdateOutpostRequest finalRequest = (UpdateOutpostRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOutpostResult>(){

            @Override
            public UpdateOutpostResult call() throws Exception {
                UpdateOutpostResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeUpdateOutpost(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request) {
        return this.updateSiteAsync(request, null);
    }

    @Override
    public Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request, final AsyncHandler<UpdateSiteRequest, UpdateSiteResult> asyncHandler) {
        final UpdateSiteRequest finalRequest = (UpdateSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSiteResult>(){

            @Override
            public UpdateSiteResult call() throws Exception {
                UpdateSiteResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeUpdateSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSiteAddressResult> updateSiteAddressAsync(UpdateSiteAddressRequest request) {
        return this.updateSiteAddressAsync(request, null);
    }

    @Override
    public Future<UpdateSiteAddressResult> updateSiteAddressAsync(UpdateSiteAddressRequest request, final AsyncHandler<UpdateSiteAddressRequest, UpdateSiteAddressResult> asyncHandler) {
        final UpdateSiteAddressRequest finalRequest = (UpdateSiteAddressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSiteAddressResult>(){

            @Override
            public UpdateSiteAddressResult call() throws Exception {
                UpdateSiteAddressResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeUpdateSiteAddress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSiteRackPhysicalPropertiesResult> updateSiteRackPhysicalPropertiesAsync(UpdateSiteRackPhysicalPropertiesRequest request) {
        return this.updateSiteRackPhysicalPropertiesAsync(request, null);
    }

    @Override
    public Future<UpdateSiteRackPhysicalPropertiesResult> updateSiteRackPhysicalPropertiesAsync(UpdateSiteRackPhysicalPropertiesRequest request, final AsyncHandler<UpdateSiteRackPhysicalPropertiesRequest, UpdateSiteRackPhysicalPropertiesResult> asyncHandler) {
        final UpdateSiteRackPhysicalPropertiesRequest finalRequest = (UpdateSiteRackPhysicalPropertiesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSiteRackPhysicalPropertiesResult>(){

            @Override
            public UpdateSiteRackPhysicalPropertiesResult call() throws Exception {
                UpdateSiteRackPhysicalPropertiesResult result = null;
                try {
                    result = AWSOutpostsAsyncClient.this.executeUpdateSiteRackPhysicalProperties(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

