/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataAggregation;
import com.amazonaws.services.quicksight.model.TopicCalculatedField;
import com.amazonaws.services.quicksight.model.TopicColumn;
import com.amazonaws.services.quicksight.model.TopicFilter;
import com.amazonaws.services.quicksight.model.TopicNamedEntity;
import com.amazonaws.services.quicksight.model.transform.DatasetMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DatasetMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String datasetArn;
    private String datasetName;
    private String datasetDescription;
    private DataAggregation dataAggregation;
    private List<TopicFilter> filters;
    private List<TopicColumn> columns;
    private List<TopicCalculatedField> calculatedFields;
    private List<TopicNamedEntity> namedEntities;

    public void setDatasetArn(String datasetArn) {
        this.datasetArn = datasetArn;
    }

    public String getDatasetArn() {
        return this.datasetArn;
    }

    public DatasetMetadata withDatasetArn(String datasetArn) {
        this.setDatasetArn(datasetArn);
        return this;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public DatasetMetadata withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public void setDatasetDescription(String datasetDescription) {
        this.datasetDescription = datasetDescription;
    }

    public String getDatasetDescription() {
        return this.datasetDescription;
    }

    public DatasetMetadata withDatasetDescription(String datasetDescription) {
        this.setDatasetDescription(datasetDescription);
        return this;
    }

    public void setDataAggregation(DataAggregation dataAggregation) {
        this.dataAggregation = dataAggregation;
    }

    public DataAggregation getDataAggregation() {
        return this.dataAggregation;
    }

    public DatasetMetadata withDataAggregation(DataAggregation dataAggregation) {
        this.setDataAggregation(dataAggregation);
        return this;
    }

    public List<TopicFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<TopicFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<TopicFilter>(filters);
    }

    public DatasetMetadata withFilters(TopicFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<TopicFilter>(filters.length));
        }
        for (TopicFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DatasetMetadata withFilters(Collection<TopicFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<TopicColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<TopicColumn> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<TopicColumn>(columns);
    }

    public DatasetMetadata withColumns(TopicColumn ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<TopicColumn>(columns.length));
        }
        for (TopicColumn ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public DatasetMetadata withColumns(Collection<TopicColumn> columns) {
        this.setColumns(columns);
        return this;
    }

    public List<TopicCalculatedField> getCalculatedFields() {
        return this.calculatedFields;
    }

    public void setCalculatedFields(Collection<TopicCalculatedField> calculatedFields) {
        if (calculatedFields == null) {
            this.calculatedFields = null;
            return;
        }
        this.calculatedFields = new ArrayList<TopicCalculatedField>(calculatedFields);
    }

    public DatasetMetadata withCalculatedFields(TopicCalculatedField ... calculatedFields) {
        if (this.calculatedFields == null) {
            this.setCalculatedFields(new ArrayList<TopicCalculatedField>(calculatedFields.length));
        }
        for (TopicCalculatedField ele : calculatedFields) {
            this.calculatedFields.add(ele);
        }
        return this;
    }

    public DatasetMetadata withCalculatedFields(Collection<TopicCalculatedField> calculatedFields) {
        this.setCalculatedFields(calculatedFields);
        return this;
    }

    public List<TopicNamedEntity> getNamedEntities() {
        return this.namedEntities;
    }

    public void setNamedEntities(Collection<TopicNamedEntity> namedEntities) {
        if (namedEntities == null) {
            this.namedEntities = null;
            return;
        }
        this.namedEntities = new ArrayList<TopicNamedEntity>(namedEntities);
    }

    public DatasetMetadata withNamedEntities(TopicNamedEntity ... namedEntities) {
        if (this.namedEntities == null) {
            this.setNamedEntities(new ArrayList<TopicNamedEntity>(namedEntities.length));
        }
        for (TopicNamedEntity ele : namedEntities) {
            this.namedEntities.add(ele);
        }
        return this;
    }

    public DatasetMetadata withNamedEntities(Collection<TopicNamedEntity> namedEntities) {
        this.setNamedEntities(namedEntities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatasetArn() != null) {
            sb.append("DatasetArn: ").append(this.getDatasetArn()).append(",");
        }
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: ").append(this.getDatasetName()).append(",");
        }
        if (this.getDatasetDescription() != null) {
            sb.append("DatasetDescription: ").append(this.getDatasetDescription()).append(",");
        }
        if (this.getDataAggregation() != null) {
            sb.append("DataAggregation: ").append(this.getDataAggregation()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns()).append(",");
        }
        if (this.getCalculatedFields() != null) {
            sb.append("CalculatedFields: ").append(this.getCalculatedFields()).append(",");
        }
        if (this.getNamedEntities() != null) {
            sb.append("NamedEntities: ").append(this.getNamedEntities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetMetadata)) {
            return false;
        }
        DatasetMetadata other = (DatasetMetadata)obj;
        if (other.getDatasetArn() == null ^ this.getDatasetArn() == null) {
            return false;
        }
        if (other.getDatasetArn() != null && !other.getDatasetArn().equals(this.getDatasetArn())) {
            return false;
        }
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getDatasetDescription() == null ^ this.getDatasetDescription() == null) {
            return false;
        }
        if (other.getDatasetDescription() != null && !other.getDatasetDescription().equals(this.getDatasetDescription())) {
            return false;
        }
        if (other.getDataAggregation() == null ^ this.getDataAggregation() == null) {
            return false;
        }
        if (other.getDataAggregation() != null && !other.getDataAggregation().equals(this.getDataAggregation())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getCalculatedFields() == null ^ this.getCalculatedFields() == null) {
            return false;
        }
        if (other.getCalculatedFields() != null && !other.getCalculatedFields().equals(this.getCalculatedFields())) {
            return false;
        }
        if (other.getNamedEntities() == null ^ this.getNamedEntities() == null) {
            return false;
        }
        return other.getNamedEntities() == null || other.getNamedEntities().equals(this.getNamedEntities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatasetArn() == null ? 0 : this.getDatasetArn().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetDescription() == null ? 0 : this.getDatasetDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDataAggregation() == null ? 0 : this.getDataAggregation().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getCalculatedFields() == null ? 0 : this.getCalculatedFields().hashCode());
        hashCode = 31 * hashCode + (this.getNamedEntities() == null ? 0 : this.getNamedEntities().hashCode());
        return hashCode;
    }

    public DatasetMetadata clone() {
        try {
            return (DatasetMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatasetMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

