/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.Slot;

@SdkInternalApi
public class SlotMarshaller {
    private static final MarshallingInfo<String> SLOTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SlotId").build();
    private static final MarshallingInfo<String> VISUALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisualId").build();
    private static final SlotMarshaller instance = new SlotMarshaller();

    public static SlotMarshaller getInstance() {
        return instance;
    }

    public void marshall(Slot slot, ProtocolMarshaller protocolMarshaller) {
        if (slot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)slot.getSlotId(), SLOTID_BINDING);
            protocolMarshaller.marshall((Object)slot.getVisualId(), VISUALID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

