/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal.validation;

import com.amazonaws.services.stepfunctions.builder.internal.validation.Location;
import com.amazonaws.services.stepfunctions.builder.internal.validation.Problem;
import com.amazonaws.services.stepfunctions.builder.internal.validation.ProblemReporter;
import com.amazonaws.util.CollectionUtils;
import com.amazonaws.util.StringUtils;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.Map;

final class ValidationContext {
    private final ValidationContext parentContext;
    private final Location location;
    private final String identifier;
    private final ProblemReporter problemReporter;

    private ValidationContext(Builder builder) {
        this.parentContext = builder.parentContext;
        this.location = builder.location;
        this.identifier = builder.identifier;
        this.problemReporter = builder.problemReporter;
    }

    public String getPath() {
        String parentPath = this.parentContext == null ? "" : this.parentContext.getPath() + ".";
        switch (this.location) {
            case Branch: 
            case Retrier: 
            case Catcher: 
            case Choice: 
            case State: {
                return String.format("%s%s[%s]", parentPath, this.location.toString(), this.identifier);
            }
            case StateMachine: {
                return "StateMachine";
            }
        }
        return "Unknown";
    }

    public void assertNotNull(Object propertyValue, String propertyName) {
        if (propertyValue == null) {
            this.problemReporter.report(new Problem(this, String.format("%s is a required property.", propertyName)));
        }
    }

    public void assertStringNotEmpty(String propertyValue, String propertyName) {
        if (StringUtils.isNullOrEmpty((String)propertyValue)) {
            this.problemReporter.report(new Problem(this, String.format("%s is a required property.", propertyName)));
        }
    }

    public void assertNotEmpty(Collection<?> collection, String propertyName) {
        if (CollectionUtils.isNullOrEmpty(collection)) {
            this.problemReporter.report(new Problem(this, String.format("%s requires one or more items", propertyName)));
        }
    }

    public void assertNotEmpty(Map<?, ?> map, String propertyName) {
        if (map == null || map.size() == 0) {
            this.problemReporter.report(new Problem(this, String.format("%s requires one or more entries", propertyName)));
        }
    }

    public void assertIsPositiveIfPresent(Integer integer, String propertyName) {
        if (integer != null && integer <= 0) {
            this.problemReporter.report(new Problem(this, String.format("%s must be positive", propertyName)));
        }
    }

    public void assertIsNotNegativeIfPresent(Integer integer, String propertyName) {
        if (integer != null && integer < 0) {
            this.problemReporter.report(new Problem(this, String.format("%s must be non negative", propertyName)));
        }
    }

    public void assertIsValidInputPath(String path) {
        this.assertIsValidJsonPath(path, "InputPath");
    }

    public void assertIsValidOutputPath(String path) {
        this.assertIsValidJsonPath(path, "OutputPath");
    }

    public void assertIsValidResultPath(String path) {
        this.assertIsValidReferencePath(path, "ResultPath");
    }

    public void assertIsValidJsonPath(String path, String propertyName) {
        if (path == null) {
            return;
        }
        if (path.isEmpty()) {
            this.problemReporter.report(new Problem(this, String.format("%s cannot be empty", propertyName)));
            return;
        }
        try {
            JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        }
        catch (InvalidPathException e) {
            this.problemReporter.report(new Problem(this, String.format("%s with value '%s' is not a valid JsonPath. %s", propertyName, path, e.getMessage())));
        }
    }

    public void assertIsValidReferencePath(String path, String propertyName) {
        if (path == null) {
            return;
        }
        if (path.isEmpty()) {
            this.problemReporter.report(new Problem(this, String.format("%s cannot be empty", propertyName)));
            return;
        }
        try {
            if (!JsonPath.isPathDefinite((String)path)) {
                this.problemReporter.report(new Problem(this, String.format("%s with value '%s' is not a definite reference path.", propertyName, path)));
            }
        }
        catch (InvalidPathException e) {
            this.problemReporter.report(new Problem(this, String.format("%s with value '%s' is not a valid JsonPath. %s", propertyName, path, e.getMessage())));
        }
    }

    public ValidationContext state(String stateName) {
        return this.newChildContext().identifier(stateName).location(Location.State).build();
    }

    public ValidationContext retrier(int index) {
        return this.newChildContext().identifier(String.valueOf(index)).location(Location.Retrier).build();
    }

    public ValidationContext branch(int index) {
        return this.newChildContext().identifier(String.valueOf(index)).location(Location.Branch).build();
    }

    public ValidationContext choice(int index) {
        return this.newChildContext().identifier(String.valueOf(index)).location(Location.Choice).build();
    }

    public ValidationContext catcher(int index) {
        return this.newChildContext().identifier(String.valueOf(index)).location(Location.Catcher).build();
    }

    private Builder newChildContext() {
        return ValidationContext.builder().parentContext(this).problemReporter(this.problemReporter);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ValidationContext parentContext;
        private Location location;
        private String identifier;
        private ProblemReporter problemReporter;

        private Builder() {
        }

        public Builder parentContext(ValidationContext parentContext) {
            this.parentContext = parentContext;
            return this;
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder problemReporter(ProblemReporter problemReporter) {
            this.problemReporter = problemReporter;
            return this;
        }

        public ValidationContext build() {
            return new ValidationContext(this);
        }
    }
}

