/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.Tag;
import com.amazonaws.services.wafv2.model.transform.TagInfoForResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagInfoForResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceARN;
    private List<Tag> tagList;

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public TagInfoForResource withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public List<Tag> getTagList() {
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new ArrayList<Tag>(tagList);
    }

    public TagInfoForResource withTagList(Tag ... tagList) {
        if (this.tagList == null) {
            this.setTagList(new ArrayList<Tag>(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add(ele);
        }
        return this;
    }

    public TagInfoForResource withTagList(Collection<Tag> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN()).append(",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: ").append(this.getTagList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagInfoForResource)) {
            return false;
        }
        TagInfoForResource other = (TagInfoForResource)obj;
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        return other.getTagList() == null || other.getTagList().equals(this.getTagList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        return hashCode;
    }

    public TagInfoForResource clone() {
        try {
            return (TagInfoForResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TagInfoForResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

