/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.sdb;

import com.amazonaws.sdb.AmazonSimpleDB;
import com.amazonaws.sdb.AmazonSimpleDBConfig;
import com.amazonaws.sdb.AmazonSimpleDBException;
import com.amazonaws.sdb.model.Attribute;
import com.amazonaws.sdb.model.CreateDomainRequest;
import com.amazonaws.sdb.model.CreateDomainResponse;
import com.amazonaws.sdb.model.DeleteAttributesRequest;
import com.amazonaws.sdb.model.DeleteAttributesResponse;
import com.amazonaws.sdb.model.DeleteDomainRequest;
import com.amazonaws.sdb.model.DeleteDomainResponse;
import com.amazonaws.sdb.model.Error;
import com.amazonaws.sdb.model.ErrorResponse;
import com.amazonaws.sdb.model.GetAttributesRequest;
import com.amazonaws.sdb.model.GetAttributesResponse;
import com.amazonaws.sdb.model.ListDomainsRequest;
import com.amazonaws.sdb.model.ListDomainsResponse;
import com.amazonaws.sdb.model.PutAttributesRequest;
import com.amazonaws.sdb.model.PutAttributesResponse;
import com.amazonaws.sdb.model.QueryRequest;
import com.amazonaws.sdb.model.QueryResponse;
import com.amazonaws.sdb.model.QueryWithAttributesRequest;
import com.amazonaws.sdb.model.QueryWithAttributesResponse;
import com.amazonaws.sdb.model.ReplaceableAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleDBClient
implements AmazonSimpleDB {
    private final Log log = LogFactory.getLog(AmazonSimpleDBClient.class);
    private String awsAccessKeyId = null;
    private String awsSecretAccessKey = null;
    private AmazonSimpleDBConfig config = null;
    private HttpClient httpClient = null;
    private ExecutorService asyncExecutor;
    private static JAXBContext jaxbContext;
    private static ThreadLocal<Unmarshaller> unmarshaller;
    private static Pattern ERROR_PATTERN_ONE;
    private static Pattern ERROR_PATTERN_TWO;
    private static Pattern ERROR_PATTERN_THREE;

    public AmazonSimpleDBClient(String string, String string2) {
        this(string, string2, new AmazonSimpleDBConfig());
    }

    public AmazonSimpleDBClient(String string, String string2, int n) {
        this(string, string2, new AmazonSimpleDBConfig().withMaxAsyncThreads(n));
    }

    public AmazonSimpleDBClient(String string, String string2, AmazonSimpleDBConfig amazonSimpleDBConfig) {
        this.awsAccessKeyId = string;
        this.awsSecretAccessKey = string2;
        this.config = amazonSimpleDBConfig;
        this.httpClient = this.configureHttpClient();
        this.asyncExecutor = new ThreadPoolExecutor(amazonSimpleDBConfig.getMaxAsyncThreads(), amazonSimpleDBConfig.getMaxAsyncThreads(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(amazonSimpleDBConfig.getMaxAsyncQueueSize()){

            @Override
            public boolean offer(Runnable runnable) {
                AmazonSimpleDBClient.this.log.debug((Object)"Maximum number of concurrent threads reached, queuing task...");
                return super.offer(runnable);
            }
        }, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "AmazonSimpleDBClient-Thread-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                AmazonSimpleDBClient.this.log.debug((Object)("ThreadFactory created new thread: " + thread.getName()));
                return thread;
            }
        }, new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                AmazonSimpleDBClient.this.log.debug((Object)("Maximum number of concurrent threads reached, and queue is full. Running task in the calling thread..." + Thread.currentThread().getName()));
                if (!threadPoolExecutor.isShutdown()) {
                    runnable.run();
                }
            }
        });
    }

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws AmazonSimpleDBException {
        return this.invoke(CreateDomainResponse.class, this.convertCreateDomain(createDomainRequest));
    }

    @Override
    public Future<CreateDomainResponse> createDomainAsync(final CreateDomainRequest createDomainRequest) {
        Future<CreateDomainResponse> future = this.asyncExecutor.submit(new Callable<CreateDomainResponse>(){

            @Override
            public CreateDomainResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.createDomain(createDomainRequest);
            }
        });
        return future;
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws AmazonSimpleDBException {
        return this.invoke(ListDomainsResponse.class, this.convertListDomains(listDomainsRequest));
    }

    @Override
    public Future<ListDomainsResponse> listDomainsAsync(final ListDomainsRequest listDomainsRequest) {
        Future<ListDomainsResponse> future = this.asyncExecutor.submit(new Callable<ListDomainsResponse>(){

            @Override
            public ListDomainsResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.listDomains(listDomainsRequest);
            }
        });
        return future;
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws AmazonSimpleDBException {
        return this.invoke(DeleteDomainResponse.class, this.convertDeleteDomain(deleteDomainRequest));
    }

    @Override
    public Future<DeleteDomainResponse> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) {
        Future<DeleteDomainResponse> future = this.asyncExecutor.submit(new Callable<DeleteDomainResponse>(){

            @Override
            public DeleteDomainResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.deleteDomain(deleteDomainRequest);
            }
        });
        return future;
    }

    @Override
    public PutAttributesResponse putAttributes(PutAttributesRequest putAttributesRequest) throws AmazonSimpleDBException {
        return this.invoke(PutAttributesResponse.class, this.convertPutAttributes(putAttributesRequest));
    }

    @Override
    public Future<PutAttributesResponse> putAttributesAsync(final PutAttributesRequest putAttributesRequest) {
        Future<PutAttributesResponse> future = this.asyncExecutor.submit(new Callable<PutAttributesResponse>(){

            @Override
            public PutAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.putAttributes(putAttributesRequest);
            }
        });
        return future;
    }

    @Override
    public GetAttributesResponse getAttributes(GetAttributesRequest getAttributesRequest) throws AmazonSimpleDBException {
        return this.invoke(GetAttributesResponse.class, this.convertGetAttributes(getAttributesRequest));
    }

    @Override
    public Future<GetAttributesResponse> getAttributesAsync(final GetAttributesRequest getAttributesRequest) {
        Future<GetAttributesResponse> future = this.asyncExecutor.submit(new Callable<GetAttributesResponse>(){

            @Override
            public GetAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.getAttributes(getAttributesRequest);
            }
        });
        return future;
    }

    @Override
    public DeleteAttributesResponse deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) throws AmazonSimpleDBException {
        return this.invoke(DeleteAttributesResponse.class, this.convertDeleteAttributes(deleteAttributesRequest));
    }

    @Override
    public Future<DeleteAttributesResponse> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest) {
        Future<DeleteAttributesResponse> future = this.asyncExecutor.submit(new Callable<DeleteAttributesResponse>(){

            @Override
            public DeleteAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.deleteAttributes(deleteAttributesRequest);
            }
        });
        return future;
    }

    @Override
    public QueryResponse query(QueryRequest queryRequest) throws AmazonSimpleDBException {
        return this.invoke(QueryResponse.class, this.convertQuery(queryRequest));
    }

    @Override
    public Future<QueryResponse> queryAsync(final QueryRequest queryRequest) {
        Future<QueryResponse> future = this.asyncExecutor.submit(new Callable<QueryResponse>(){

            @Override
            public QueryResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.query(queryRequest);
            }
        });
        return future;
    }

    @Override
    public QueryWithAttributesResponse queryWithAttributes(QueryWithAttributesRequest queryWithAttributesRequest) throws AmazonSimpleDBException {
        return this.invoke(QueryWithAttributesResponse.class, this.convertQueryWithAttributes(queryWithAttributesRequest));
    }

    @Override
    public Future<QueryWithAttributesResponse> queryWithAttributesAsync(final QueryWithAttributesRequest queryWithAttributesRequest) {
        Future<QueryWithAttributesResponse> future = this.asyncExecutor.submit(new Callable<QueryWithAttributesResponse>(){

            @Override
            public QueryWithAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBClient.this.queryWithAttributes(queryWithAttributesRequest);
            }
        });
        return future;
    }

    private HttpClient configureHttpClient() {
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setParameter("http.useragent", (Object)this.config.getUserAgent());
        httpClientParams.setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod httpMethod, IOException iOException, int n) {
                if (n > 3) {
                    AmazonSimpleDBClient.this.log.debug((Object)"Maximum Number of Retry attempts reached, will not retry");
                    return false;
                }
                AmazonSimpleDBClient.this.log.debug((Object)("Retrying request. Attempt " + n));
                if (iOException instanceof NoHttpResponseException) {
                    AmazonSimpleDBClient.this.log.debug((Object)"Retrying on NoHttpResponseException");
                    return true;
                }
                if (iOException instanceof InterruptedIOException) {
                    AmazonSimpleDBClient.this.log.debug((Object)"Will not retry on InterruptedIOException", (Throwable)iOException);
                    return false;
                }
                if (iOException instanceof UnknownHostException) {
                    AmazonSimpleDBClient.this.log.debug((Object)"Will not retry on UnknownHostException", (Throwable)iOException);
                    return false;
                }
                if (!httpMethod.isRequestSent()) {
                    AmazonSimpleDBClient.this.log.debug((Object)"Retrying on failed sent request");
                    return true;
                }
                return false;
            }
        });
        HostConfiguration hostConfiguration = new HostConfiguration();
        HttpConnectionManagerParams httpConnectionManagerParams = new HttpConnectionManagerParams();
        httpConnectionManagerParams.setConnectionTimeout(50000);
        httpConnectionManagerParams.setSoTimeout(50000);
        httpConnectionManagerParams.setStaleCheckingEnabled(true);
        httpConnectionManagerParams.setTcpNoDelay(true);
        httpConnectionManagerParams.setMaxTotalConnections(this.config.getMaxAsyncQueueSize());
        httpConnectionManagerParams.setMaxConnectionsPerHost(hostConfiguration, this.config.getMaxAsyncQueueSize());
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        multiThreadedHttpConnectionManager.setParams(httpConnectionManagerParams);
        this.httpClient = new HttpClient(httpClientParams, (HttpConnectionManager)multiThreadedHttpConnectionManager);
        if (this.config.isSetProxyHost() && this.config.isSetProxyPort()) {
            this.log.info((Object)("Configuring Proxy. Proxy Host: " + this.config.getProxyHost() + "Proxy Port: " + this.config.getProxyPort()));
            hostConfiguration.setProxy(this.config.getProxyHost(), this.config.getProxyPort());
            if (this.config.isSetProxyUsername() && this.config.isSetProxyPassword()) {
                this.httpClient.getState().setProxyCredentials(new AuthScope(this.config.getProxyHost(), this.config.getProxyPort()), (Credentials)new UsernamePasswordCredentials(this.config.getProxyUsername(), this.config.getProxyPassword()));
            }
        }
        this.httpClient.setHostConfiguration(hostConfiguration);
        return this.httpClient;
    }

    private <T> T invoke(Class<T> clazz, Map<String, String> map) throws AmazonSimpleDBException {
        String string = map.get("Action");
        T t = null;
        String string2 = null;
        PostMethod postMethod = new PostMethod(this.config.getServiceURL());
        int n = -1;
        this.log.debug((Object)("Invoking" + string + " request. Current parameters: " + map));
        try {
            this.log.debug((Object)"Setting content-type to application/x-www-form-urlencoded; charset=utf-8...");
            postMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            this.log.debug((Object)"Adding required parameters...");
            this.addRequiredParametersToRequest(postMethod, map);
            this.log.debug((Object)("Done adding additional required parameteres. Parameters now: " + map));
            boolean bl = true;
            int n2 = 0;
            do {
                this.log.debug((Object)("Sending Request to host:  " + this.config.getServiceURL()));
                try {
                    n = this.httpClient.executeMethod((HttpMethod)postMethod);
                    string2 = this.getResponsBodyAsString(postMethod.getResponseBodyAsStream());
                    if (n == 200) {
                        bl = false;
                        this.log.debug((Object)("Received Response. Status: " + n + ". " + "Response Body: " + string2));
                        this.log.debug((Object)("Attempting to unmarshal into the " + string + "Response type..."));
                        t = clazz.cast(this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(string2))));
                        this.log.debug((Object)("Unmarshalled response into " + string + "Response type."));
                        continue;
                    }
                    this.log.debug((Object)("Received Response. Status: " + n + ". " + "Response Body: " + string2));
                    if ((n == 500 || n == 503) && this.pauseIfRetryNeeded(++n2)) {
                        bl = true;
                        continue;
                    }
                    this.log.debug((Object)"Attempting to unmarshal into the ErrorResponse type...");
                    ErrorResponse errorResponse = (ErrorResponse)this.getUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(string2)));
                    this.log.debug((Object)"Unmarshalled response into the ErrorResponse type.");
                    Error error = errorResponse.getError().get(0);
                    throw new AmazonSimpleDBException(error.getMessage(), n, error.getCode(), error.getType(), null, errorResponse.getRequestId(), errorResponse.toXML());
                }
                catch (JAXBException jAXBException) {
                    this.log.debug((Object)"Caught JAXBException", (Throwable)jAXBException);
                    this.log.debug((Object)("Response cannot be unmarshalled neither as " + string + "Response or ErrorResponse types." + "Checking for other possible errors."));
                    AmazonSimpleDBException amazonSimpleDBException = this.processErrors(string2, n);
                    throw amazonSimpleDBException;
                }
                catch (IOException iOException) {
                    this.log.error((Object)"Caught IOException exception", (Throwable)iOException);
                    throw new AmazonSimpleDBException("Internal Error", iOException);
                }
                catch (Exception exception) {
                    this.log.error((Object)"Caught Exception", (Throwable)exception);
                    throw new AmazonSimpleDBException(exception);
                }
                finally {
                    postMethod.releaseConnection();
                }
            } while (bl);
        }
        catch (AmazonSimpleDBException amazonSimpleDBException) {
            this.log.error((Object)"Caught AmazonSimpleDBException", (Throwable)amazonSimpleDBException);
            throw amazonSimpleDBException;
        }
        catch (Throwable throwable) {
            this.log.error((Object)"Caught Exception", throwable);
            throw new AmazonSimpleDBException(throwable);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponsBodyAsString(InputStream inputStream) throws IOException {
        String string = null;
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1024];
            while (0 < (n = inputStreamReader.read(cArray))) {
                stringBuilder.append(cArray, 0, n);
            }
            string = stringBuilder.toString();
        }
        finally {
            inputStream.close();
        }
        return string;
    }

    private boolean pauseIfRetryNeeded(int n) throws InterruptedException {
        if (n <= this.config.getMaxErrorRetry()) {
            long l = (long)(Math.pow(4.0, n) * 100.0);
            this.log.debug((Object)("Retriable error detected, will retry in " + l + "ms, attempt numer: " + n));
            Thread.sleep(l);
            return true;
        }
        return false;
    }

    private void addRequiredParametersToRequest(PostMethod postMethod, Map<String, String> map) throws SignatureException {
        map.put("Version", this.config.getServiceVersion());
        map.put("SignatureVersion", this.config.getSignatureVersion());
        map.put("Timestamp", this.getFormattedTimestamp());
        map.put("AWSAccessKeyId", this.awsAccessKeyId);
        map.put("Signature", this.signParameters(map, this.awsSecretAccessKey));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            postMethod.addParameter(entry.getKey(), entry.getValue());
        }
    }

    private AmazonSimpleDBException processErrors(String string, int n) {
        AmazonSimpleDBException amazonSimpleDBException = null;
        Matcher matcher = null;
        if (string != null && string.startsWith("<")) {
            matcher = ERROR_PATTERN_ONE.matcher(string);
            if (matcher.matches()) {
                amazonSimpleDBException = new AmazonSimpleDBException(matcher.group(3), n, matcher.group(2), "Unknown", null, matcher.group(1), string);
            } else {
                matcher = ERROR_PATTERN_TWO.matcher(string);
                if (matcher.matches()) {
                    amazonSimpleDBException = new AmazonSimpleDBException(matcher.group(2), n, matcher.group(1), "Unknown", null, matcher.group(4), string);
                } else {
                    matcher = ERROR_PATTERN_THREE.matcher(string);
                    if (matcher.matches()) {
                        this.log.error((Object)("Error found in the response: " + string));
                        amazonSimpleDBException = new AmazonSimpleDBException(matcher.group(2), n, matcher.group(1), "Unknown", matcher.group(3), matcher.group(5), string);
                    } else {
                        amazonSimpleDBException = new AmazonSimpleDBException("Internal Error", n);
                        this.log.error((Object)("Service Error. Response Status: " + n));
                    }
                }
            }
        } else {
            amazonSimpleDBException = new AmazonSimpleDBException("Internal Error", n);
            this.log.error((Object)("Service Error. Response Status: " + n));
        }
        return amazonSimpleDBException;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(new Date());
    }

    private String signParameters(Map<String, String> map, String string) throws SignatureException {
        String string2 = map.get("SignatureVersion");
        StringBuffer stringBuffer = new StringBuffer();
        if ("0".equals(string2)) {
            stringBuffer.append(map.get("Action")).append(map.get("Timestamp"));
        } else if ("1".equals(string2)) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            map.remove("Signature");
            treeMap.putAll(map);
            for (Map.Entry entry : treeMap.entrySet()) {
                stringBuffer.append(entry.getKey());
                stringBuffer.append(entry.getValue());
            }
        } else {
            throw new SignatureException("Invalid Signature Version specified");
        }
        return this.sign(stringBuffer.toString(), string);
    }

    private String sign(String string, String string2) throws SignatureException {
        byte[] byArray;
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(string2.getBytes(), "HmacSHA1"));
            byArray = Base64.encodeBase64((byte[])mac.doFinal(string.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            throw new SignatureException("Failed to generate signature: " + exception.getMessage(), exception);
        }
        return new String(byArray);
    }

    private Unmarshaller getUnmarshaller() {
        return unmarshaller.get();
    }

    private Map<String, String> convertCreateDomain(CreateDomainRequest createDomainRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "CreateDomain");
        if (createDomainRequest.isSetDomainName()) {
            hashMap.put("DomainName", createDomainRequest.getDomainName());
        }
        return hashMap;
    }

    private Map<String, String> convertListDomains(ListDomainsRequest listDomainsRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "ListDomains");
        if (listDomainsRequest.isSetMaxNumberOfDomains()) {
            hashMap.put("MaxNumberOfDomains", listDomainsRequest.getMaxNumberOfDomains() + "");
        }
        if (listDomainsRequest.isSetNextToken()) {
            hashMap.put("NextToken", listDomainsRequest.getNextToken());
        }
        return hashMap;
    }

    private Map<String, String> convertDeleteDomain(DeleteDomainRequest deleteDomainRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeleteDomain");
        if (deleteDomainRequest.isSetDomainName()) {
            hashMap.put("DomainName", deleteDomainRequest.getDomainName());
        }
        return hashMap;
    }

    private Map<String, String> convertPutAttributes(PutAttributesRequest putAttributesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "PutAttributes");
        if (putAttributesRequest.isSetDomainName()) {
            hashMap.put("DomainName", putAttributesRequest.getDomainName());
        }
        if (putAttributesRequest.isSetItemName()) {
            hashMap.put("ItemName", putAttributesRequest.getItemName());
        }
        List<ReplaceableAttribute> list = putAttributesRequest.getAttribute();
        for (ReplaceableAttribute replaceableAttribute : list) {
            if (replaceableAttribute.isSetName()) {
                hashMap.put("Attribute." + (list.indexOf(replaceableAttribute) + 1) + "." + "Name", replaceableAttribute.getName());
            }
            if (replaceableAttribute.isSetValue()) {
                hashMap.put("Attribute." + (list.indexOf(replaceableAttribute) + 1) + "." + "Value", replaceableAttribute.getValue());
            }
            if (!replaceableAttribute.isSetReplace()) continue;
            hashMap.put("Attribute." + (list.indexOf(replaceableAttribute) + 1) + "." + "Replace", replaceableAttribute.isReplace() + "");
        }
        return hashMap;
    }

    private Map<String, String> convertGetAttributes(GetAttributesRequest getAttributesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "GetAttributes");
        if (getAttributesRequest.isSetDomainName()) {
            hashMap.put("DomainName", getAttributesRequest.getDomainName());
        }
        if (getAttributesRequest.isSetItemName()) {
            hashMap.put("ItemName", getAttributesRequest.getItemName());
        }
        List<String> list = getAttributesRequest.getAttributeName();
        for (String string : list) {
            hashMap.put("AttributeName." + (list.indexOf(string) + 1), string);
        }
        return hashMap;
    }

    private Map<String, String> convertDeleteAttributes(DeleteAttributesRequest deleteAttributesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "DeleteAttributes");
        if (deleteAttributesRequest.isSetDomainName()) {
            hashMap.put("DomainName", deleteAttributesRequest.getDomainName());
        }
        if (deleteAttributesRequest.isSetItemName()) {
            hashMap.put("ItemName", deleteAttributesRequest.getItemName());
        }
        List<Attribute> list = deleteAttributesRequest.getAttribute();
        for (Attribute attribute : list) {
            if (attribute.isSetName()) {
                hashMap.put("Attribute." + (list.indexOf(attribute) + 1) + "." + "Name", attribute.getName());
            }
            if (!attribute.isSetValue()) continue;
            hashMap.put("Attribute." + (list.indexOf(attribute) + 1) + "." + "Value", attribute.getValue());
        }
        return hashMap;
    }

    private Map<String, String> convertQuery(QueryRequest queryRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "Query");
        if (queryRequest.isSetDomainName()) {
            hashMap.put("DomainName", queryRequest.getDomainName());
        }
        if (queryRequest.isSetQueryExpression()) {
            hashMap.put("QueryExpression", queryRequest.getQueryExpression());
        }
        if (queryRequest.isSetMaxNumberOfItems()) {
            hashMap.put("MaxNumberOfItems", queryRequest.getMaxNumberOfItems() + "");
        }
        if (queryRequest.isSetNextToken()) {
            hashMap.put("NextToken", queryRequest.getNextToken());
        }
        return hashMap;
    }

    private Map<String, String> convertQueryWithAttributes(QueryWithAttributesRequest queryWithAttributesRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Action", "QueryWithAttributes");
        List<String> list = queryWithAttributesRequest.getAttributeName();
        for (String string : list) {
            hashMap.put("AttributeName." + (list.indexOf(string) + 1), string);
        }
        if (queryWithAttributesRequest.isSetDomainName()) {
            hashMap.put("DomainName", queryWithAttributesRequest.getDomainName());
        }
        if (queryWithAttributesRequest.isSetQueryExpression()) {
            hashMap.put("QueryExpression", queryWithAttributesRequest.getQueryExpression());
        }
        if (queryWithAttributesRequest.isSetMaxNumberOfItems()) {
            hashMap.put("MaxNumberOfItems", queryWithAttributesRequest.getMaxNumberOfItems() + "");
        }
        if (queryWithAttributesRequest.isSetNextToken()) {
            hashMap.put("NextToken", queryWithAttributesRequest.getNextToken());
        }
        return hashMap;
    }

    static {
        ERROR_PATTERN_ONE = Pattern.compile(".*\\<RequestId>(.*)\\</RequestId>.*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*", 40);
        ERROR_PATTERN_TWO = Pattern.compile(".*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message>\\</Error>.*(\\<Error>)?.*\\<RequestID>(.*)\\</RequestID>.*", 40);
        ERROR_PATTERN_THREE = Pattern.compile(".*\\<Error>\\<Code>(.*)\\</Code>\\<Message>(.*)\\</Message><BoxUsage>(.*)</BoxUsage>\\</Error>.*(\\<Error>)?.*\\<RequestID>(.*)\\</RequestID>.*", 40);
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.amazonaws.sdb.model", (ClassLoader)AmazonSimpleDB.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            throw new ExceptionInInitializerError(jAXBException);
        }
        unmarshaller = new ThreadLocal<Unmarshaller>(){

            @Override
            protected synchronized Unmarshaller initialValue() {
                try {
                    return jaxbContext.createUnmarshaller();
                }
                catch (JAXBException jAXBException) {
                    throw new ExceptionInInitializerError(jAXBException);
                }
            }
        };
    }
}

