/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.sdb.mock;

import com.amazonaws.sdb.AmazonSimpleDB;
import com.amazonaws.sdb.AmazonSimpleDBException;
import com.amazonaws.sdb.model.CreateDomainRequest;
import com.amazonaws.sdb.model.CreateDomainResponse;
import com.amazonaws.sdb.model.DeleteAttributesRequest;
import com.amazonaws.sdb.model.DeleteAttributesResponse;
import com.amazonaws.sdb.model.DeleteDomainRequest;
import com.amazonaws.sdb.model.DeleteDomainResponse;
import com.amazonaws.sdb.model.GetAttributesRequest;
import com.amazonaws.sdb.model.GetAttributesResponse;
import com.amazonaws.sdb.model.ListDomainsRequest;
import com.amazonaws.sdb.model.ListDomainsResponse;
import com.amazonaws.sdb.model.PutAttributesRequest;
import com.amazonaws.sdb.model.PutAttributesResponse;
import com.amazonaws.sdb.model.QueryRequest;
import com.amazonaws.sdb.model.QueryResponse;
import com.amazonaws.sdb.model.QueryWithAttributesRequest;
import com.amazonaws.sdb.model.QueryWithAttributesResponse;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleDBMock
implements AmazonSimpleDB {
    private final Log log = LogFactory.getLog(AmazonSimpleDBMock.class);
    private static JAXBContext jaxbContext;
    private static ThreadLocal<Unmarshaller> unmarshaller;
    private ExecutorService asyncExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "AmazonSimpleDBMock-Thread-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(Boolean.TRUE);
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    });

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws AmazonSimpleDBException {
        CreateDomainResponse createDomainResponse;
        try {
            createDomainResponse = (CreateDomainResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("CreateDomainResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + createDomainResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return createDomainResponse;
    }

    @Override
    public Future<CreateDomainResponse> createDomainAsync(final CreateDomainRequest createDomainRequest) {
        Future<CreateDomainResponse> future = this.asyncExecutor.submit(new Callable<CreateDomainResponse>(){

            @Override
            public CreateDomainResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.createDomain(createDomainRequest);
            }
        });
        return future;
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws AmazonSimpleDBException {
        ListDomainsResponse listDomainsResponse;
        try {
            listDomainsResponse = (ListDomainsResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("ListDomainsResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + listDomainsResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return listDomainsResponse;
    }

    @Override
    public Future<ListDomainsResponse> listDomainsAsync(final ListDomainsRequest listDomainsRequest) {
        Future<ListDomainsResponse> future = this.asyncExecutor.submit(new Callable<ListDomainsResponse>(){

            @Override
            public ListDomainsResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.listDomains(listDomainsRequest);
            }
        });
        return future;
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws AmazonSimpleDBException {
        DeleteDomainResponse deleteDomainResponse;
        try {
            deleteDomainResponse = (DeleteDomainResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("DeleteDomainResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + deleteDomainResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return deleteDomainResponse;
    }

    @Override
    public Future<DeleteDomainResponse> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) {
        Future<DeleteDomainResponse> future = this.asyncExecutor.submit(new Callable<DeleteDomainResponse>(){

            @Override
            public DeleteDomainResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.deleteDomain(deleteDomainRequest);
            }
        });
        return future;
    }

    @Override
    public PutAttributesResponse putAttributes(PutAttributesRequest putAttributesRequest) throws AmazonSimpleDBException {
        PutAttributesResponse putAttributesResponse;
        try {
            putAttributesResponse = (PutAttributesResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("PutAttributesResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + putAttributesResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return putAttributesResponse;
    }

    @Override
    public Future<PutAttributesResponse> putAttributesAsync(final PutAttributesRequest putAttributesRequest) {
        Future<PutAttributesResponse> future = this.asyncExecutor.submit(new Callable<PutAttributesResponse>(){

            @Override
            public PutAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.putAttributes(putAttributesRequest);
            }
        });
        return future;
    }

    @Override
    public GetAttributesResponse getAttributes(GetAttributesRequest getAttributesRequest) throws AmazonSimpleDBException {
        GetAttributesResponse getAttributesResponse;
        try {
            getAttributesResponse = (GetAttributesResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("GetAttributesResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + getAttributesResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return getAttributesResponse;
    }

    @Override
    public Future<GetAttributesResponse> getAttributesAsync(final GetAttributesRequest getAttributesRequest) {
        Future<GetAttributesResponse> future = this.asyncExecutor.submit(new Callable<GetAttributesResponse>(){

            @Override
            public GetAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.getAttributes(getAttributesRequest);
            }
        });
        return future;
    }

    @Override
    public DeleteAttributesResponse deleteAttributes(DeleteAttributesRequest deleteAttributesRequest) throws AmazonSimpleDBException {
        DeleteAttributesResponse deleteAttributesResponse;
        try {
            deleteAttributesResponse = (DeleteAttributesResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("DeleteAttributesResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + deleteAttributesResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return deleteAttributesResponse;
    }

    @Override
    public Future<DeleteAttributesResponse> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest) {
        Future<DeleteAttributesResponse> future = this.asyncExecutor.submit(new Callable<DeleteAttributesResponse>(){

            @Override
            public DeleteAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.deleteAttributes(deleteAttributesRequest);
            }
        });
        return future;
    }

    @Override
    public QueryResponse query(QueryRequest queryRequest) throws AmazonSimpleDBException {
        QueryResponse queryResponse;
        try {
            queryResponse = (QueryResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("QueryResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + queryResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return queryResponse;
    }

    @Override
    public Future<QueryResponse> queryAsync(final QueryRequest queryRequest) {
        Future<QueryResponse> future = this.asyncExecutor.submit(new Callable<QueryResponse>(){

            @Override
            public QueryResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.query(queryRequest);
            }
        });
        return future;
    }

    @Override
    public QueryWithAttributesResponse queryWithAttributes(QueryWithAttributesRequest queryWithAttributesRequest) throws AmazonSimpleDBException {
        QueryWithAttributesResponse queryWithAttributesResponse;
        try {
            queryWithAttributesResponse = (QueryWithAttributesResponse)this.getUnmarshaller().unmarshal(new InputSource(this.getClass().getResourceAsStream("QueryWithAttributesResponse.xml")));
            this.log.debug((Object)("Response from Mock Service: " + queryWithAttributesResponse.toXML()));
        }
        catch (JAXBException jAXBException) {
            throw new AmazonSimpleDBException("Unable to process mock response", jAXBException);
        }
        return queryWithAttributesResponse;
    }

    @Override
    public Future<QueryWithAttributesResponse> queryWithAttributesAsync(final QueryWithAttributesRequest queryWithAttributesRequest) {
        Future<QueryWithAttributesResponse> future = this.asyncExecutor.submit(new Callable<QueryWithAttributesResponse>(){

            @Override
            public QueryWithAttributesResponse call() throws AmazonSimpleDBException {
                return AmazonSimpleDBMock.this.queryWithAttributes(queryWithAttributesRequest);
            }
        });
        return future;
    }

    private Unmarshaller getUnmarshaller() {
        return unmarshaller.get();
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.amazonaws.sdb.model", (ClassLoader)AmazonSimpleDB.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            throw new ExceptionInInitializerError(jAXBException);
        }
        unmarshaller = new ThreadLocal<Unmarshaller>(){

            @Override
            protected synchronized Unmarshaller initialValue() {
                try {
                    return jaxbContext.createUnmarshaller();
                }
                catch (JAXBException jAXBException) {
                    throw new ExceptionInInitializerError(jAXBException);
                }
            }
        };
    }
}

