/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AwsServletRegistration
implements ServletRegistration,
ServletRegistration.Dynamic,
Comparable<AwsServletRegistration> {
    private String servletName;
    private Servlet servlet;
    private AwsServletContext ctx;
    private Map<String, String> initParameters;
    private int loadOnStartup;
    private String runAsRole;
    private boolean asyncSupported;
    private Map<String, AwsServletRegistration> servletPathMappings;

    public AwsServletRegistration(String name, Servlet s, AwsServletContext context) {
        this.servletName = name;
        this.servlet = s;
        this.ctx = context;
        this.initParameters = new HashMap<String, String>();
        this.servletPathMappings = new HashMap<String, AwsServletRegistration>();
        this.loadOnStartup = -1;
        this.asyncSupported = true;
    }

    public Set<String> addMapping(String ... strings) {
        HashSet<String> failedMappings = new HashSet<String>();
        for (String s : strings) {
            if (this.servletPathMappings.containsKey(s)) {
                failedMappings.add(s);
                continue;
            }
            this.servletPathMappings.put(s, this);
        }
        return failedMappings;
    }

    public Collection<String> getMappings() {
        return this.servletPathMappings.keySet();
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public String getName() {
        return this.servletName;
    }

    public String getClassName() {
        return this.servlet.getClass().getName();
    }

    public boolean setInitParameter(String s, String s1) {
        if (this.initParameters.containsKey(s)) {
            return false;
        }
        this.initParameters.put(s, s1);
        return true;
    }

    public String getInitParameter(String s) {
        return this.initParameters.get(s);
    }

    public Set<String> setInitParameters(Map<String, String> map) {
        HashSet<String> failedParameters = new HashSet<String>();
        for (Map.Entry<String, String> param : map.entrySet()) {
            if (this.initParameters.containsKey(param.getKey())) {
                failedParameters.add(param.getKey());
            }
            this.initParameters.put(param.getKey(), param.getValue());
        }
        return failedParameters;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setLoadOnStartup(int i) {
        this.loadOnStartup = i;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public Set<String> setServletSecurity(ServletSecurityElement servletSecurityElement) {
        return null;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfigElement) {
    }

    public void setRunAsRole(String s) {
        this.runAsRole = s;
    }

    public void setAsyncSupported(boolean b) {
        this.asyncSupported = b;
    }

    @Override
    public int compareTo(AwsServletRegistration r) {
        return Integer.compare(this.loadOnStartup, r.getLoadOnStartup());
    }

    @SuppressFBWarnings(value={"HE_EQUALS_USE_HASHCODE"})
    public boolean equals(Object r) {
        if (r == null || !AwsServletRegistration.class.isAssignableFrom(r.getClass())) {
            return false;
        }
        return ((AwsServletRegistration)r).getName().equals(this.getName()) && ((AwsServletRegistration)r).getServlet() == this.getServlet();
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public ServletConfig getServletConfig() {
        return new ServletConfig(){

            public String getServletName() {
                return AwsServletRegistration.this.servletName;
            }

            public ServletContext getServletContext() {
                return AwsServletRegistration.this.ctx;
            }

            public String getInitParameter(String s) {
                return (String)AwsServletRegistration.this.initParameters.get(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(AwsServletRegistration.this.initParameters.keySet());
            }
        };
    }
}

