/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AccountIdentifiers;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.zzb;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String zza;
    private final String zzb;
    private final JSONObject zzc;

    public Purchase(@NonNull String string, @NonNull String string2) throws JSONException {
        this.zza = string;
        this.zzb = string2;
        super(this.zza);
        this.zzc = string;
    }

    @NonNull
    public String getOrderId() {
        return this.zzc.optString("orderId");
    }

    @NonNull
    public String getPackageName() {
        return this.zzc.optString("packageName");
    }

    @zzb
    @NonNull
    public String getSku() {
        return this.zzc.optString("productId");
    }

    public long getPurchaseTime() {
        return this.zzc.optLong("purchaseTime");
    }

    @NonNull
    public String getPurchaseToken() {
        Purchase purchase = purchase.zzc;
        return purchase.optString("token", purchase.optString("purchaseToken"));
    }

    public int getPurchaseState() {
        switch (this.zzc.optInt("purchaseState", 1)) {
            default: {
                return 1;
            }
            case 4: 
        }
        return 2;
    }

    @NonNull
    public String getDeveloperPayload() {
        return this.zzc.optString("developerPayload");
    }

    public boolean isAcknowledged() {
        return this.zzc.optBoolean("acknowledged", true);
    }

    public boolean isAutoRenewing() {
        return this.zzc.optBoolean("autoRenewing");
    }

    @NonNull
    public String getOriginalJson() {
        return this.zza;
    }

    @NonNull
    public String getSignature() {
        return this.zzb;
    }

    @Nullable
    public AccountIdentifiers getAccountIdentifiers() {
        String string = ((Purchase)((Object)string2)).zzc.optString("obfuscatedAccountId");
        String string2 = ((Purchase)((Object)string2)).zzc.optString("obfuscatedProfileId");
        if (string == null && string2 == null) {
            return null;
        }
        AccountIdentifiers accountIdentifiers = new AccountIdentifiers(string, string2);
        return accountIdentifiers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public String toString() {
        String string = String.valueOf(((Purchase)((Object)string)).zza);
        String string2 = "Purchase. Json: ";
        if (string.length() == 0) return new String(string2);
        return string2.concat(string);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Purchase)) {
            return false;
        }
        return TextUtils.equals((CharSequence)this.zza, (CharSequence)((Purchase)(object = (Purchase)object)).getOriginalJson()) && TextUtils.equals((CharSequence)this.zzb, (CharSequence)((Purchase)object).getSignature());
    }

    public int hashCode() {
        return this.zza.hashCode();
    }

    public static class PurchasesResult {
        @Nullable
        private final List<Purchase> zza;
        private final BillingResult zzb;

        public PurchasesResult(@NonNull BillingResult billingResult, @Nullable List<Purchase> list) {
            this.zza = list;
            this.zzb = billingResult;
        }

        @NonNull
        public BillingResult getBillingResult() {
            return this.zzb;
        }

        public int getResponseCode() {
            return this.getBillingResult().getResponseCode();
        }

        @Nullable
        public List<Purchase> getPurchasesList() {
            return this.zza;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PurchaseState {
        public static final int UNSPECIFIED_STATE = 0;
        public static final int PURCHASED = 1;
        public static final int PENDING = 2;
    }
}

