/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.databinding.BindingAdapter;
import android.util.SparseBooleanArray;
import android.widget.TableLayout;
import java.util.regex.Pattern;

public class TableLayoutBindingAdapter {
    private static Pattern sColumnPattern = Pattern.compile("\\s*,\\s*");
    private static final int MAX_COLUMNS = 20;

    @BindingAdapter(value={"android:collapseColumns"})
    public static void setCollapseColumns(TableLayout view, CharSequence columnsStr) {
        SparseBooleanArray columns = TableLayoutBindingAdapter.parseColumns(columnsStr);
        for (int i = 0; i < 20; ++i) {
            boolean isCollapsed = columns.get(i, false);
            if (isCollapsed == view.isColumnCollapsed(i)) continue;
            view.setColumnCollapsed(i, isCollapsed);
        }
    }

    @BindingAdapter(value={"android:shrinkColumns"})
    public static void setShrinkColumns(TableLayout view, CharSequence columnsStr) {
        if (columnsStr != null && columnsStr.length() > 0 && columnsStr.charAt(0) == '*') {
            view.setShrinkAllColumns(true);
        } else {
            view.setShrinkAllColumns(false);
            SparseBooleanArray columns = TableLayoutBindingAdapter.parseColumns(columnsStr);
            int columnCount = columns.size();
            for (int i = 0; i < columnCount; ++i) {
                int column = columns.keyAt(i);
                boolean shrinkable = columns.valueAt(i);
                if (!shrinkable) continue;
                view.setColumnShrinkable(column, shrinkable);
            }
        }
    }

    @BindingAdapter(value={"android:stretchColumns"})
    public static void setStretchColumns(TableLayout view, CharSequence columnsStr) {
        if (columnsStr != null && columnsStr.length() > 0 && columnsStr.charAt(0) == '*') {
            view.setStretchAllColumns(true);
        } else {
            view.setStretchAllColumns(false);
            SparseBooleanArray columns = TableLayoutBindingAdapter.parseColumns(columnsStr);
            int columnCount = columns.size();
            for (int i = 0; i < columnCount; ++i) {
                int column = columns.keyAt(i);
                boolean stretchable = columns.valueAt(i);
                if (!stretchable) continue;
                view.setColumnStretchable(column, stretchable);
            }
        }
    }

    private static SparseBooleanArray parseColumns(CharSequence sequence) {
        String[] columnDefs;
        SparseBooleanArray columns = new SparseBooleanArray();
        if (sequence == null) {
            return columns;
        }
        for (String columnIdentifier : columnDefs = sColumnPattern.split(sequence)) {
            try {
                int columnIndex = Integer.parseInt(columnIdentifier);
                if (columnIndex < 0) continue;
                columns.put(columnIndex, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return columns;
    }
}

