/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.databinding.BindingAdapter;
import android.databinding.InverseBindingListener;
import android.databinding.InverseBindingMethod;
import android.databinding.InverseBindingMethods;
import android.support.annotation.RestrictTo;
import android.widget.RadioGroup;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@InverseBindingMethods(value={@InverseBindingMethod(type=RadioGroup.class, attribute="android:checkedButton", method="getCheckedRadioButtonId")})
public class RadioGroupBindingAdapter {
    @BindingAdapter(value={"android:checkedButton"})
    public static void setCheckedButton(RadioGroup view, int id2) {
        if (id2 != view.getCheckedRadioButtonId()) {
            view.check(id2);
        }
    }

    @BindingAdapter(value={"android:onCheckedChanged", "android:checkedButtonAttrChanged"}, requireAll=false)
    public static void setListeners(RadioGroup view, final RadioGroup.OnCheckedChangeListener listener, final InverseBindingListener attrChange) {
        if (attrChange == null) {
            view.setOnCheckedChangeListener(listener);
        } else {
            view.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

                public void onCheckedChanged(RadioGroup group, int checkedId) {
                    if (listener != null) {
                        listener.onCheckedChanged(group, checkedId);
                    }
                    attrChange.onChange();
                }
            });
        }
    }
}

