/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.databinding.BindingAdapter;
import android.databinding.BindingMethod;
import android.databinding.BindingMethods;
import android.databinding.InverseBindingAdapter;
import android.databinding.InverseBindingListener;
import android.databinding.adapters.ListenerUtil;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.RestrictTo;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TextKeyListener;
import android.text.method.TransformationMethod;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.android.databinding.library.baseAdapters.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@BindingMethods(value={@BindingMethod(type=TextView.class, attribute="android:autoLink", method="setAutoLinkMask"), @BindingMethod(type=TextView.class, attribute="android:drawablePadding", method="setCompoundDrawablePadding"), @BindingMethod(type=TextView.class, attribute="android:editorExtras", method="setInputExtras"), @BindingMethod(type=TextView.class, attribute="android:inputType", method="setRawInputType"), @BindingMethod(type=TextView.class, attribute="android:scrollHorizontally", method="setHorizontallyScrolling"), @BindingMethod(type=TextView.class, attribute="android:textAllCaps", method="setAllCaps"), @BindingMethod(type=TextView.class, attribute="android:textColorHighlight", method="setHighlightColor"), @BindingMethod(type=TextView.class, attribute="android:textColorHint", method="setHintTextColor"), @BindingMethod(type=TextView.class, attribute="android:textColorLink", method="setLinkTextColor"), @BindingMethod(type=TextView.class, attribute="android:onEditorAction", method="setOnEditorActionListener")})
public class TextViewBindingAdapter {
    private static final String TAG = "TextViewBindingAdapters";
    public static final int INTEGER = 1;
    public static final int SIGNED = 3;
    public static final int DECIMAL = 5;

    @BindingAdapter(value={"android:text"})
    public static void setText(TextView view, CharSequence text) {
        CharSequence oldText = view.getText();
        if (text == oldText || text == null && oldText.length() == 0) {
            return;
        }
        if (text instanceof Spanned ? text.equals(oldText) : !TextViewBindingAdapter.haveContentsChanged(text, oldText)) {
            return;
        }
        view.setText(text);
    }

    @InverseBindingAdapter(attribute="android:text", event="android:textAttrChanged")
    public static String getTextString(TextView view) {
        return view.getText().toString();
    }

    @BindingAdapter(value={"android:autoText"})
    public static void setAutoText(TextView view, boolean autoText) {
        int inputType;
        KeyListener listener = view.getKeyListener();
        TextKeyListener.Capitalize capitalize = TextKeyListener.Capitalize.NONE;
        int n = inputType = listener != null ? listener.getInputType() : 0;
        if ((inputType & 0x1000) != 0) {
            capitalize = TextKeyListener.Capitalize.CHARACTERS;
        } else if ((inputType & 0x2000) != 0) {
            capitalize = TextKeyListener.Capitalize.WORDS;
        } else if ((inputType & 0x4000) != 0) {
            capitalize = TextKeyListener.Capitalize.SENTENCES;
        }
        view.setKeyListener((KeyListener)TextKeyListener.getInstance((boolean)autoText, (TextKeyListener.Capitalize)capitalize));
    }

    @BindingAdapter(value={"android:capitalize"})
    public static void setCapitalize(TextView view, TextKeyListener.Capitalize capitalize) {
        KeyListener listener = view.getKeyListener();
        int inputType = listener.getInputType();
        boolean autoText = (inputType & 0x8000) != 0;
        view.setKeyListener((KeyListener)TextKeyListener.getInstance((boolean)autoText, (TextKeyListener.Capitalize)capitalize));
    }

    @BindingAdapter(value={"android:bufferType"})
    public static void setBufferType(TextView view, TextView.BufferType bufferType) {
        view.setText(view.getText(), bufferType);
    }

    @BindingAdapter(value={"android:digits"})
    public static void setDigits(TextView view, CharSequence digits) {
        if (digits != null) {
            view.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)digits.toString()));
        } else if (view.getKeyListener() instanceof DigitsKeyListener) {
            view.setKeyListener(null);
        }
    }

    @BindingAdapter(value={"android:numeric"})
    public static void setNumeric(TextView view, int numeric) {
        view.setKeyListener((KeyListener)DigitsKeyListener.getInstance(((numeric & 3) != 0 ? 1 : 0) != 0, ((numeric & 5) != 0 ? 1 : 0) != 0));
    }

    @BindingAdapter(value={"android:phoneNumber"})
    public static void setPhoneNumber(TextView view, boolean phoneNumber) {
        if (phoneNumber) {
            view.setKeyListener((KeyListener)DialerKeyListener.getInstance());
        } else if (view.getKeyListener() instanceof DialerKeyListener) {
            view.setKeyListener(null);
        }
    }

    private static void setIntrinsicBounds(Drawable drawable) {
        if (drawable != null) {
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        }
    }

    @BindingAdapter(value={"android:drawableBottom"})
    public static void setDrawableBottom(TextView view, Drawable drawable) {
        TextViewBindingAdapter.setIntrinsicBounds(drawable);
        Drawable[] drawables = view.getCompoundDrawables();
        view.setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawable);
    }

    @BindingAdapter(value={"android:drawableLeft"})
    public static void setDrawableLeft(TextView view, Drawable drawable) {
        TextViewBindingAdapter.setIntrinsicBounds(drawable);
        Drawable[] drawables = view.getCompoundDrawables();
        view.setCompoundDrawables(drawable, drawables[1], drawables[2], drawables[3]);
    }

    @BindingAdapter(value={"android:drawableRight"})
    public static void setDrawableRight(TextView view, Drawable drawable) {
        TextViewBindingAdapter.setIntrinsicBounds(drawable);
        Drawable[] drawables = view.getCompoundDrawables();
        view.setCompoundDrawables(drawables[0], drawables[1], drawable, drawables[3]);
    }

    @BindingAdapter(value={"android:drawableTop"})
    public static void setDrawableTop(TextView view, Drawable drawable) {
        TextViewBindingAdapter.setIntrinsicBounds(drawable);
        Drawable[] drawables = view.getCompoundDrawables();
        view.setCompoundDrawables(drawables[0], drawable, drawables[2], drawables[3]);
    }

    @BindingAdapter(value={"android:drawableStart"})
    public static void setDrawableStart(TextView view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 17) {
            TextViewBindingAdapter.setDrawableLeft(view, drawable);
        } else {
            TextViewBindingAdapter.setIntrinsicBounds(drawable);
            Drawable[] drawables = view.getCompoundDrawablesRelative();
            view.setCompoundDrawablesRelative(drawable, drawables[1], drawables[2], drawables[3]);
        }
    }

    @BindingAdapter(value={"android:drawableEnd"})
    public static void setDrawableEnd(TextView view, Drawable drawable) {
        if (Build.VERSION.SDK_INT < 17) {
            TextViewBindingAdapter.setDrawableRight(view, drawable);
        } else {
            TextViewBindingAdapter.setIntrinsicBounds(drawable);
            Drawable[] drawables = view.getCompoundDrawablesRelative();
            view.setCompoundDrawablesRelative(drawables[0], drawables[1], drawable, drawables[3]);
        }
    }

    @BindingAdapter(value={"android:imeActionLabel"})
    public static void setImeActionLabel(TextView view, CharSequence value) {
        view.setImeActionLabel(value, view.getImeActionId());
    }

    @BindingAdapter(value={"android:imeActionId"})
    public static void setImeActionLabel(TextView view, int value) {
        view.setImeActionLabel(view.getImeActionLabel(), value);
    }

    @BindingAdapter(value={"android:inputMethod"})
    public static void setInputMethod(TextView view, CharSequence inputMethod) {
        try {
            Class<?> c = Class.forName(inputMethod.toString());
            view.setKeyListener((KeyListener)c.newInstance());
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Could not create input method: " + inputMethod), (Throwable)e);
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)("Could not create input method: " + inputMethod), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("Could not create input method: " + inputMethod), (Throwable)e);
        }
    }

    @BindingAdapter(value={"android:lineSpacingExtra"})
    public static void setLineSpacingExtra(TextView view, float value) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setLineSpacing(value, view.getLineSpacingMultiplier());
        } else {
            view.setLineSpacing(value, 1.0f);
        }
    }

    @BindingAdapter(value={"android:lineSpacingMultiplier"})
    public static void setLineSpacingMultiplier(TextView view, float value) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setLineSpacing(view.getLineSpacingExtra(), value);
        } else {
            view.setLineSpacing(0.0f, value);
        }
    }

    @BindingAdapter(value={"android:maxLength"})
    public static void setMaxLength(TextView view, int value) {
        InputFilter[] filters = view.getFilters();
        if (filters == null) {
            filters = new InputFilter[]{new InputFilter.LengthFilter(value)};
        } else {
            boolean foundMaxLength = false;
            for (int i = 0; i < filters.length; ++i) {
                InputFilter filter = filters[i];
                if (!(filter instanceof InputFilter.LengthFilter)) continue;
                foundMaxLength = true;
                boolean replace = true;
                if (Build.VERSION.SDK_INT >= 21) {
                    boolean bl = replace = ((InputFilter.LengthFilter)filter).getMax() != value;
                }
                if (!replace) break;
                filters[i] = new InputFilter.LengthFilter(value);
                break;
            }
            if (!foundMaxLength) {
                InputFilter[] oldFilters = filters;
                filters = new InputFilter[oldFilters.length + 1];
                System.arraycopy(oldFilters, 0, filters, 0, oldFilters.length);
                filters[filters.length - 1] = new InputFilter.LengthFilter(value);
            }
        }
        view.setFilters(filters);
    }

    @BindingAdapter(value={"android:password"})
    public static void setPassword(TextView view, boolean password) {
        if (password) {
            view.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        } else if (view.getTransformationMethod() instanceof PasswordTransformationMethod) {
            view.setTransformationMethod(null);
        }
    }

    @BindingAdapter(value={"android:shadowColor"})
    public static void setShadowColor(TextView view, int color) {
        if (Build.VERSION.SDK_INT >= 16) {
            float dx = view.getShadowDx();
            float dy = view.getShadowDy();
            float r = view.getShadowRadius();
            view.setShadowLayer(r, dx, dy, color);
        }
    }

    @BindingAdapter(value={"android:shadowDx"})
    public static void setShadowDx(TextView view, float dx) {
        if (Build.VERSION.SDK_INT >= 16) {
            int color = view.getShadowColor();
            float dy = view.getShadowDy();
            float r = view.getShadowRadius();
            view.setShadowLayer(r, dx, dy, color);
        }
    }

    @BindingAdapter(value={"android:shadowDy"})
    public static void setShadowDy(TextView view, float dy) {
        if (Build.VERSION.SDK_INT >= 16) {
            int color = view.getShadowColor();
            float dx = view.getShadowDx();
            float r = view.getShadowRadius();
            view.setShadowLayer(r, dx, dy, color);
        }
    }

    @BindingAdapter(value={"android:shadowRadius"})
    public static void setShadowRadius(TextView view, float r) {
        if (Build.VERSION.SDK_INT >= 16) {
            int color = view.getShadowColor();
            float dx = view.getShadowDx();
            float dy = view.getShadowDy();
            view.setShadowLayer(r, dx, dy, color);
        }
    }

    @BindingAdapter(value={"android:textSize"})
    public static void setTextSize(TextView view, float size) {
        view.setTextSize(0, size);
    }

    private static boolean haveContentsChanged(CharSequence str1, CharSequence str2) {
        if (str1 == null != (str2 == null)) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        int length = str1.length();
        if (length != str2.length()) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            return true;
        }
        return false;
    }

    @BindingAdapter(value={"android:beforeTextChanged", "android:onTextChanged", "android:afterTextChanged", "android:textAttrChanged"}, requireAll=false)
    public static void setTextWatcher(TextView view, final BeforeTextChanged before, final OnTextChanged on, final AfterTextChanged after, final InverseBindingListener textAttrChanged) {
        TextWatcher newValue = before == null && after == null && on == null && textAttrChanged == null ? null : new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after2) {
                if (before != null) {
                    before.beforeTextChanged(s, start, count, after2);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before2, int count) {
                if (on != null) {
                    on.onTextChanged(s, start, before2, count);
                }
                if (textAttrChanged != null) {
                    textAttrChanged.onChange();
                }
            }

            public void afterTextChanged(Editable s) {
                if (after != null) {
                    after.afterTextChanged(s);
                }
            }
        };
        TextWatcher oldValue = ListenerUtil.trackListener((View)view, newValue, R.id.textWatcher);
        if (oldValue != null) {
            view.removeTextChangedListener(oldValue);
        }
        if (newValue != null) {
            view.addTextChangedListener(newValue);
        }
    }

    public static interface OnTextChanged {
        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);
    }

    public static interface BeforeTextChanged {
        public void beforeTextChanged(CharSequence var1, int var2, int var3, int var4);
    }

    public static interface AfterTextChanged {
        public void afterTextChanged(Editable var1);
    }
}

