/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.CallbackWrapper;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import java.util.Collections;
import java.util.List;

public class CallbackArgExpr
extends IdentifierExpr {
    private int mArgIndex;
    private String mName;
    private ModelClass mClassFromCallback;

    public CallbackArgExpr(int argIndex, String name) {
        super(name);
        this.mArgIndex = argIndex;
        this.mName = name;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public void setClassFromCallback(ModelClass modelClass) {
        this.mClassFromCallback = modelClass;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Preconditions.checkNotNull((Object)this.mClassFromCallback, (String)"%s is not defined. It should either be a variable defined in the layout file or a parameter of the Callback.", (Object[])new Object[]{this.mName});
        return this.mClassFromCallback;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return Collections.emptyList();
    }

    @Override
    protected KCode generateCode() {
        return new KCode(CallbackWrapper.ARG_PREFIX + this.mArgIndex);
    }

    @Override
    protected String computeUniqueKey() {
        return CallbackWrapper.ARG_PREFIX + this.mArgIndex;
    }

    @Override
    public String getInvertibleError() {
        return "Callback arguments cannot be inverted";
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return new CallbackArgExpr(this.mArgIndex, this.mName);
    }
}

