/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.util.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DataBindingCompilerArgs {
    private static final String PREFIX = "android.databinding.";
    private static final String PARAM_BUILD_FOLDER = "android.databinding.bindingBuildFolder";
    private static final String PARAM_AAR_OUT_FOLDER = "android.databinding.generationalFileOutDir";
    private static final String PARAM_SDK_DIR = "android.databinding.sdkDir";
    private static final String PARAM_ARTIFACT_TYPE = "android.databinding.artifactType";
    private static final String PARAM_XML_OUT_DIR = "android.databinding.xmlOutDir";
    private static final String PARAM_EXPORT_CLASS_LIST_TO = "android.databinding.exportClassListTo";
    private static final String PARAM_MODULE_PKG = "android.databinding.modulePackage";
    private static final String PARAM_MIN_API = "android.databinding.minApi";
    private static final String PARAM_ENABLE_DEBUG_LOGS = "android.databinding.enableDebugLogs";
    private static final String PARAM_PRINT_ENCODED_ERROR_LOGS = "android.databinding.printEncodedErrors";
    private static final String PARAM_IS_TEST_VARIANT = "android.databinding.isTestVariant";
    private static final String PARAM_ENABLE_FOR_TESTS = "android.databinding.enableForTests";
    private static final String PARAM_ENABLE_V2 = "android.databinding.enableV2";
    private static final String PARAM_CLASS_LOG_DIR = "android.databinding.classLogFile";
    private static final String PARAM_BASE_FEATURE_INFO = "android.databinding.baseFeatureInfo";
    private static final String PARAM_FEATURE_INFO = "android.databinding.featureInfo";
    public static final Set<String> ALL_PARAMS = Sets.newHashSet((Object[])new String[]{"android.databinding.bindingBuildFolder", "android.databinding.generationalFileOutDir", "android.databinding.sdkDir", "android.databinding.artifactType", "android.databinding.xmlOutDir", "android.databinding.exportClassListTo", "android.databinding.modulePackage", "android.databinding.minApi", "android.databinding.enableDebugLogs", "android.databinding.printEncodedErrors", "android.databinding.isTestVariant", "android.databinding.enableForTests", "android.databinding.enableV2", "android.databinding.classLogFile", "android.databinding.baseFeatureInfo", "android.databinding.featureInfo"});
    private String mBuildFolder;
    private String mAarOutFolder;
    private String mSdkDir;
    private String mXmlOutDir;
    private String mExportClassListTo;
    private String mModulePackage;
    private String mClassLogDir;
    private String mBaseFeatureInfoFolder;
    private String mFeatureInfo;
    private int mMinApi;
    private Type mArtifactType;
    private boolean mIsTestVariant;
    private boolean mEnableDebugLogs;
    private boolean mPrintEncodedErrorLogs;
    private boolean mEnabledForTests;
    private boolean mEnableV2;

    private DataBindingCompilerArgs() {
    }

    public static DataBindingCompilerArgs readFromOptions(Map<String, String> options) {
        Type buildType;
        DataBindingCompilerArgs args = new DataBindingCompilerArgs();
        args.mBuildFolder = options.get(PARAM_BUILD_FOLDER);
        args.mAarOutFolder = options.get(PARAM_AAR_OUT_FOLDER);
        args.mSdkDir = options.get(PARAM_SDK_DIR);
        args.mXmlOutDir = options.get(PARAM_XML_OUT_DIR);
        args.mExportClassListTo = options.get(PARAM_EXPORT_CLASS_LIST_TO);
        args.mModulePackage = options.get(PARAM_MODULE_PKG);
        args.mClassLogDir = options.get(PARAM_CLASS_LOG_DIR);
        args.mMinApi = Integer.parseInt(options.get(PARAM_MIN_API));
        args.mBaseFeatureInfoFolder = options.get(PARAM_BASE_FEATURE_INFO);
        args.mFeatureInfo = options.get(PARAM_FEATURE_INFO);
        String artifactType = options.get(PARAM_ARTIFACT_TYPE);
        args.mArtifactType = buildType = Type.valueOf(artifactType);
        args.mEnableDebugLogs = DataBindingCompilerArgs.deserialize(options.get(PARAM_ENABLE_DEBUG_LOGS));
        args.mPrintEncodedErrorLogs = DataBindingCompilerArgs.deserialize(options.get(PARAM_PRINT_ENCODED_ERROR_LOGS));
        args.mIsTestVariant = DataBindingCompilerArgs.deserialize(options.get(PARAM_IS_TEST_VARIANT));
        args.mEnabledForTests = DataBindingCompilerArgs.deserialize(options.get(PARAM_ENABLE_FOR_TESTS));
        args.mEnableV2 = DataBindingCompilerArgs.deserialize(options.get(PARAM_ENABLE_V2));
        return args;
    }

    public String getBuildFolder() {
        return this.mBuildFolder;
    }

    public String getAarOutFolder() {
        return this.mAarOutFolder;
    }

    public String getSdkDir() {
        return this.mSdkDir;
    }

    public String getXmlOutDir() {
        return this.mXmlOutDir;
    }

    public String getExportClassListTo() {
        return this.mExportClassListTo;
    }

    public String getModulePackage() {
        return this.mModulePackage;
    }

    public Type artifactType() {
        return this.mArtifactType;
    }

    public String getClassLogDir() {
        return this.mClassLogDir;
    }

    public String getBaseFeatureInfoFolder() {
        return this.mBaseFeatureInfoFolder;
    }

    public String getFeatureInfoFolder() {
        return this.mFeatureInfo;
    }

    public boolean isTestVariant() {
        return this.mIsTestVariant;
    }

    public boolean isLibrary() {
        return this.mArtifactType == Type.LIBRARY;
    }

    public boolean isApp() {
        return this.mArtifactType == Type.APPLICATION;
    }

    public boolean isFeature() {
        return this.mArtifactType == Type.FEATURE;
    }

    public boolean enableDebugLogs() {
        return this.mEnableDebugLogs;
    }

    public boolean shouldPrintEncodedErrorLogs() {
        return this.mPrintEncodedErrorLogs;
    }

    public int getMinApi() {
        return this.mMinApi;
    }

    public boolean isEnabledForTests() {
        return this.mEnabledForTests;
    }

    public boolean isEnableV2() {
        return this.mEnableV2;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> args = new HashMap<String, String>();
        DataBindingCompilerArgs.putIfNotNull(this.mBuildFolder, args, PARAM_BUILD_FOLDER, this.mBuildFolder);
        DataBindingCompilerArgs.putIfNotNull(this.mAarOutFolder, args, PARAM_AAR_OUT_FOLDER, this.mAarOutFolder);
        DataBindingCompilerArgs.putIfNotNull(this.mSdkDir, args, PARAM_SDK_DIR, this.mSdkDir);
        DataBindingCompilerArgs.putIfNotNull(this.mXmlOutDir, args, PARAM_XML_OUT_DIR, this.mXmlOutDir);
        DataBindingCompilerArgs.putIfNotNull(this.mExportClassListTo, args, PARAM_EXPORT_CLASS_LIST_TO, this.mExportClassListTo);
        DataBindingCompilerArgs.putIfNotNull(this.mModulePackage, args, PARAM_MODULE_PKG, this.mModulePackage);
        DataBindingCompilerArgs.putIfNotNull(this.mClassLogDir, args, PARAM_CLASS_LOG_DIR, this.mClassLogDir);
        DataBindingCompilerArgs.putIfNotNull(this.mBaseFeatureInfoFolder, args, PARAM_BASE_FEATURE_INFO, this.mBaseFeatureInfoFolder);
        DataBindingCompilerArgs.putIfNotNull(this.mFeatureInfo, args, PARAM_FEATURE_INFO, this.mFeatureInfo);
        args.put(PARAM_MIN_API, String.valueOf(this.mMinApi));
        DataBindingCompilerArgs.putIfNotNull((Object)this.mArtifactType, args, PARAM_ARTIFACT_TYPE, this.mArtifactType.name());
        args.put(PARAM_ENABLE_DEBUG_LOGS, DataBindingCompilerArgs.serialize(this.mEnableDebugLogs));
        args.put(PARAM_PRINT_ENCODED_ERROR_LOGS, DataBindingCompilerArgs.serialize(this.mPrintEncodedErrorLogs));
        args.put(PARAM_IS_TEST_VARIANT, DataBindingCompilerArgs.serialize(this.mIsTestVariant));
        args.put(PARAM_ENABLE_FOR_TESTS, DataBindingCompilerArgs.serialize(this.mEnabledForTests));
        args.put(PARAM_ENABLE_V2, DataBindingCompilerArgs.serialize(this.mEnableV2));
        return args;
    }

    public DataBindingCompilerArgs copyAsV1(String modulePackage) {
        Map<String, String> asMap = this.toMap();
        asMap.put(PARAM_ENABLE_V2, DataBindingCompilerArgs.serialize(false));
        asMap.put(PARAM_MODULE_PKG, modulePackage);
        return DataBindingCompilerArgs.readFromOptions(asMap);
    }

    private static void putIfNotNull(Object data, Map<String, String> map, String key, String value) {
        if (data != null) {
            map.put(key, value);
        }
    }

    private static String serialize(boolean boolValue) {
        return boolValue ? "1" : "0";
    }

    private static boolean deserialize(String boolValue) {
        return boolValue != null && "1".equals(boolValue.trim());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Type {
        LIBRARY,
        APPLICATION,
        FEATURE;

    }

    public static class Builder {
        private File mBuildFolder;
        private File mBundleFolder;
        private File mSdkDir;
        private File mXmlOutDir;
        private File mExportClassListTo;
        private File mClassLogDir;
        private String mModulePackage;
        private File mBaseFeatureInfoFolder;
        private File mFeatureInfoFolder;
        private Type mType;
        private Integer mMinApi;
        private boolean mEnableDebugLogs;
        private boolean mPrintEncodedErrorLogs;
        private boolean mIsTestVariant;
        private boolean mEnabledForTests;
        private boolean mEnableV2;

        private Builder() {
        }

        public Builder buildFolder(File buildFolder) {
            this.mBuildFolder = buildFolder;
            return this;
        }

        public Builder modulePackage(String modulePackage) {
            this.mModulePackage = modulePackage;
            return this;
        }

        public Builder bundleFolder(File bundleFolder) {
            this.mBundleFolder = bundleFolder;
            return this;
        }

        public Builder sdkDir(File sdkDir) {
            this.mSdkDir = sdkDir;
            return this;
        }

        public Builder xmlOutDir(File xmlOutDir) {
            this.mXmlOutDir = xmlOutDir;
            return this;
        }

        public Builder baseFeatureInfoFolder(File baseFeatureInfoFolder) {
            this.mBaseFeatureInfoFolder = baseFeatureInfoFolder;
            return this;
        }

        public Builder featureInfoFolder(File featureInfoFolder) {
            this.mFeatureInfoFolder = featureInfoFolder;
            return this;
        }

        public Builder classLogDir(File classLogDir) {
            this.mClassLogDir = classLogDir;
            return this;
        }

        public Builder exportClassListTo(File exportClassListTo) {
            this.mExportClassListTo = exportClassListTo;
            return this;
        }

        public Builder enableDebugLogs(boolean enableDebugLogs) {
            this.mEnableDebugLogs = enableDebugLogs;
            return this;
        }

        public Builder type(Type type) {
            this.mType = type;
            return this;
        }

        public Builder printEncodedErrorLogs(boolean printEncodedErrorLogs) {
            this.mPrintEncodedErrorLogs = printEncodedErrorLogs;
            return this;
        }

        public Builder minApi(int minApi) {
            this.mMinApi = minApi;
            return this;
        }

        public Builder testVariant(boolean testVariant) {
            this.mIsTestVariant = testVariant;
            return this;
        }

        public Builder enabledForTests(boolean enabledForTests) {
            this.mEnabledForTests = enabledForTests;
            return this;
        }

        public Builder enableV2(boolean enableV2) {
            this.mEnableV2 = enableV2;
            return this;
        }

        public DataBindingCompilerArgs build() {
            DataBindingCompilerArgs args = new DataBindingCompilerArgs();
            Preconditions.checkNotNull((Object)this.mType, "Must specify type of the build. Lib or App or Test? or not", new Object[0]);
            args.mArtifactType = this.mType;
            Preconditions.checkNotNull(this.mBuildFolder, "Must provide the build folder for data binding", new Object[0]);
            args.mBuildFolder = this.mBuildFolder.getAbsolutePath();
            Preconditions.checkNotNull(this.mSdkDir, "Must provide sdk directory", new Object[0]);
            args.mSdkDir = this.mSdkDir.getAbsolutePath();
            Preconditions.checkNotNull(this.mXmlOutDir, "Must provide xml out directory", new Object[0]);
            args.mXmlOutDir = this.mXmlOutDir.getAbsolutePath();
            Preconditions.checkNotNull(this.mClassLogDir, "Must provide class log directory", new Object[0]);
            args.mClassLogDir = this.mClassLogDir.getAbsolutePath();
            Preconditions.check(this.mType != Type.LIBRARY || this.mIsTestVariant || this.mBundleFolder != null, "Must specify bundle folder (aar out folder) for library projects", new Object[0]);
            args.mAarOutFolder = this.mBundleFolder.getAbsolutePath();
            Preconditions.check(this.mType != Type.LIBRARY || this.mIsTestVariant || this.mExportClassListTo != null, "Must provide a folder to export generated class list", new Object[0]);
            Preconditions.checkNotNull(this.mModulePackage, "Must provide a module package", new Object[0]);
            args.mModulePackage = this.mModulePackage;
            if (args.mArtifactType == Type.FEATURE) {
                Preconditions.check(this.mFeatureInfoFolder != null, "must provide a feature info folder while compiling a non-base feature module", new Object[0]);
            }
            args.mBaseFeatureInfoFolder = this.mBaseFeatureInfoFolder == null ? null : this.mBaseFeatureInfoFolder.getAbsolutePath();
            args.mFeatureInfo = this.mFeatureInfoFolder == null ? null : this.mFeatureInfoFolder.getAbsolutePath();
            Preconditions.checkNotNull(this.mMinApi, "Must provide the min api for the project", new Object[0]);
            args.mMinApi = this.mMinApi;
            if (this.mExportClassListTo != null) {
                args.mExportClassListTo = this.mExportClassListTo.getAbsolutePath();
            }
            args.mEnableDebugLogs = this.mEnableDebugLogs;
            args.mPrintEncodedErrorLogs = this.mPrintEncodedErrorLogs;
            args.mIsTestVariant = this.mIsTestVariant;
            args.mEnabledForTests = this.mEnabledForTests;
            args.mEnableV2 = this.mEnableV2;
            return args;
        }
    }
}

