/*
 * Decompiled with CFR 0.152.
 */
package com.android.signflinger;

import com.android.apksig.util.RunnablesExecutor;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;

public class SignedApkOptions {
    final PrivateKey privateKey;
    final List<X509Certificate> certificates;
    final RunnablesExecutor executor;
    final boolean v1Enabled;
    final boolean v2Enabled;
    final String v1CreatedBy;
    final String v1BuiltBy;
    final boolean v1TrustManifest;
    final int minSdkVersion;

    private SignedApkOptions(PrivateKey privateKey, List<X509Certificate> certificates, RunnablesExecutor executor, boolean v1Enabled, boolean v2Enabled, String v1CreatedBy, String v1BuiltBy, boolean v1TrustManifest, int minSdkVersion) {
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.executor = executor;
        this.v1Enabled = v1Enabled;
        this.v2Enabled = v2Enabled;
        this.v1CreatedBy = v1CreatedBy;
        this.v1BuiltBy = v1BuiltBy;
        this.v1TrustManifest = v1TrustManifest;
        this.minSdkVersion = minSdkVersion;
    }

    public static class Builder {
        PrivateKey privateKey;
        List<X509Certificate> certificates;
        RunnablesExecutor executor;
        boolean v1Enabled = false;
        boolean v2Enabled = true;
        String v1CreatedBy = "Signflinger";
        String v1BuiltBy = "Signflinger";
        boolean v1TrustManifest;
        int minSdkVersion;

        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder setCertificates(List<X509Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        public Builder setExecutor(RunnablesExecutor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setV1Enabled(boolean enabled) {
            this.v1Enabled = enabled;
            return this;
        }

        public Builder setV2Enabled(boolean enabled) {
            this.v2Enabled = enabled;
            return this;
        }

        public Builder setV1CreatedBy(String creator) {
            this.v1CreatedBy = creator;
            return this;
        }

        public Builder setV1BuiltBy(String builder) {
            this.v1BuiltBy = builder;
            return this;
        }

        public Builder setV1TrustManifest(boolean trust) {
            this.v1TrustManifest = trust;
            return this;
        }

        public Builder setMinSdkVersion(int minSdkVersion) {
            this.minSdkVersion = minSdkVersion;
            return this;
        }

        public SignedApkOptions build() {
            return new SignedApkOptions(this.privateKey, this.certificates, this.executor, this.v1Enabled, this.v2Enabled, this.v1CreatedBy, this.v1BuiltBy, this.v1TrustManifest, this.minSdkVersion);
        }
    }
}

