/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatEditText;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;

class AppCompatTextViewAutoSizeHelper {
    private static final RectF TEMP_RECTF = new RectF();
    private static final int DEFAULT_AUTO_SIZE_MIN_TEXT_SIZE_IN_SP = 12;
    private static final int DEFAULT_AUTO_SIZE_MAX_TEXT_SIZE_IN_SP = 112;
    private static final int DEFAULT_AUTO_SIZE_GRANULARITY_IN_PX = 1;
    static final int UNSET_AUTO_SIZE_UNIFORM_CONFIGURATION_VALUE = -1;
    private static final int VERY_WIDE = 0x100000;
    private int mAutoSizeTextType = 0;
    private boolean mNeedsAutoSizeText = false;
    private int mAutoSizeStepGranularityInPx = -1;
    private int mAutoSizeMinTextSizeInPx = -1;
    private int mAutoSizeMaxTextSizeInPx = -1;
    private int[] mAutoSizeTextSizesInPx = new int[0];
    private boolean mHasPresetAutoSizeValues = false;
    private TextPaint mTempTextPaint;
    private Hashtable<String, Method> mMethodByNameCache = new Hashtable();
    private final TextView mTextView;
    private final Context mContext;

    AppCompatTextViewAutoSizeHelper(TextView textView) {
        this.mTextView = textView;
        this.mContext = this.mTextView.getContext();
    }

    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        int autoSizeStepSizeArrayResId;
        int autoSizeMinTextSizeInPx = -1;
        int autoSizeMaxTextSizeInPx = -1;
        int autoSizeStepGranularityInPx = -1;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.AppCompatTextView, defStyleAttr, 0);
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeTextType)) {
            this.mAutoSizeTextType = a.getInt(R.styleable.AppCompatTextView_autoSizeTextType, 0);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeStepGranularity)) {
            autoSizeStepGranularityInPx = a.getDimensionPixelSize(R.styleable.AppCompatTextView_autoSizeStepGranularity, -1);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeMinTextSize)) {
            autoSizeMinTextSizeInPx = a.getDimensionPixelSize(R.styleable.AppCompatTextView_autoSizeMinTextSize, -1);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeMaxTextSize)) {
            autoSizeMaxTextSizeInPx = a.getDimensionPixelSize(R.styleable.AppCompatTextView_autoSizeMaxTextSize, -1);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizePresetSizes) && (autoSizeStepSizeArrayResId = a.getResourceId(R.styleable.AppCompatTextView_autoSizePresetSizes, 0)) > 0) {
            TypedArray autoSizePreDefTextSizes = a.getResources().obtainTypedArray(autoSizeStepSizeArrayResId);
            this.setupAutoSizeUniformPresetSizes(autoSizePreDefTextSizes);
            autoSizePreDefTextSizes.recycle();
        }
        a.recycle();
        if (this.supportsAutoSizeText()) {
            if (this.mAutoSizeTextType == 1) {
                if (!this.mHasPresetAutoSizeValues) {
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    if (autoSizeMinTextSizeInPx == -1) {
                        autoSizeMinTextSizeInPx = (int)TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)displayMetrics);
                    }
                    if (autoSizeMaxTextSizeInPx == -1) {
                        autoSizeMaxTextSizeInPx = (int)TypedValue.applyDimension((int)2, (float)112.0f, (DisplayMetrics)displayMetrics);
                    }
                    if (autoSizeStepGranularityInPx == -1) {
                        autoSizeStepGranularityInPx = 1;
                    }
                    this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, autoSizeStepGranularityInPx);
                }
                this.setupAutoSizeText();
            }
        } else {
            this.mAutoSizeTextType = 0;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setAutoSizeTextTypeWithDefaults(int autoSizeTextType) {
        if (this.supportsAutoSizeText()) {
            switch (autoSizeTextType) {
                case 0: {
                    this.clearAutoSizeConfiguration();
                    break;
                }
                case 1: {
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    int autoSizeMinTextSizeInPx = (int)TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)displayMetrics);
                    int autoSizeMaxTextSizeInPx = (int)TypedValue.applyDimension((int)2, (float)112.0f, (DisplayMetrics)displayMetrics);
                    this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, 1);
                    this.setupAutoSizeText();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown auto-size text type: " + autoSizeTextType);
                }
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setAutoSizeTextTypeUniformWithConfiguration(int autoSizeMinTextSize, int autoSizeMaxTextSize, int autoSizeStepGranularity, int unit) throws IllegalArgumentException {
        if (this.supportsAutoSizeText()) {
            DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
            int autoSizeMinTextSizeInPx = (int)TypedValue.applyDimension((int)unit, (float)autoSizeMinTextSize, (DisplayMetrics)displayMetrics);
            int autoSizeMaxTextSizeInPx = (int)TypedValue.applyDimension((int)unit, (float)autoSizeMaxTextSize, (DisplayMetrics)displayMetrics);
            int autoSizeStepGranularityInPx = (int)TypedValue.applyDimension((int)unit, (float)autoSizeStepGranularity, (DisplayMetrics)displayMetrics);
            this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, autoSizeStepGranularityInPx);
            this.setupAutoSizeText();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setAutoSizeTextTypeUniformWithPresetSizes(@NonNull int[] presetSizes, int unit) throws IllegalArgumentException {
        if (this.supportsAutoSizeText()) {
            int presetSizesLength = presetSizes.length;
            if (presetSizesLength > 0) {
                int[] presetSizesInPx = new int[presetSizesLength];
                if (unit == 0) {
                    presetSizesInPx = Arrays.copyOf(presetSizes, presetSizesLength);
                } else {
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    for (int i = 0; i < presetSizesLength; ++i) {
                        presetSizesInPx[i] = (int)TypedValue.applyDimension((int)unit, (float)presetSizes[i], (DisplayMetrics)displayMetrics);
                    }
                }
                this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(presetSizesInPx);
                if (!this.setupAutoSizeUniformPresetSizesConfiguration()) {
                    throw new IllegalArgumentException("None of the preset sizes is valid: " + Arrays.toString(presetSizes));
                }
            } else {
                this.mHasPresetAutoSizeValues = false;
            }
            this.setupAutoSizeText();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getAutoSizeTextType() {
        return this.mAutoSizeTextType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getAutoSizeStepGranularity() {
        return this.mAutoSizeStepGranularityInPx;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getAutoSizeMinTextSize() {
        return this.mAutoSizeMinTextSizeInPx;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int getAutoSizeMaxTextSize() {
        return this.mAutoSizeMaxTextSizeInPx;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    int[] getAutoSizeTextAvailableSizes() {
        return this.mAutoSizeTextSizesInPx;
    }

    private void setupAutoSizeUniformPresetSizes(TypedArray textSizes) {
        int textSizesLength = textSizes.length();
        int[] parsedSizes = new int[textSizesLength];
        if (textSizesLength > 0) {
            for (int i = 0; i < textSizesLength; ++i) {
                parsedSizes[i] = textSizes.getDimensionPixelSize(i, -1);
            }
            this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(parsedSizes);
            this.setupAutoSizeUniformPresetSizesConfiguration();
        }
    }

    private boolean setupAutoSizeUniformPresetSizesConfiguration() {
        int sizesLength = this.mAutoSizeTextSizesInPx.length;
        boolean bl = this.mHasPresetAutoSizeValues = sizesLength > 0;
        if (this.mHasPresetAutoSizeValues) {
            this.mAutoSizeTextType = 1;
            this.mAutoSizeMinTextSizeInPx = this.mAutoSizeTextSizesInPx[0];
            this.mAutoSizeMaxTextSizeInPx = this.mAutoSizeTextSizesInPx[sizesLength - 1];
            this.mAutoSizeStepGranularityInPx = -1;
        }
        return this.mHasPresetAutoSizeValues;
    }

    private int[] cleanupAutoSizePresetSizes(int[] presetValues) {
        int presetValuesLength = presetValues.length;
        if (presetValuesLength == 0) {
            return presetValues;
        }
        Arrays.sort(presetValues);
        ArrayList<Integer> uniqueValidSizes = new ArrayList<Integer>();
        for (int i = 0; i < presetValuesLength; ++i) {
            int currentPresetValue = presetValues[i];
            if (currentPresetValue <= 0 || Collections.binarySearch(uniqueValidSizes, currentPresetValue) >= 0) continue;
            uniqueValidSizes.add(currentPresetValue);
        }
        if (presetValuesLength == uniqueValidSizes.size()) {
            return presetValues;
        }
        int uniqueValidSizesLength = uniqueValidSizes.size();
        int[] cleanedUpSizes = new int[uniqueValidSizesLength];
        for (int i = 0; i < uniqueValidSizesLength; ++i) {
            cleanedUpSizes[i] = (Integer)uniqueValidSizes.get(i);
        }
        return cleanedUpSizes;
    }

    private void validateAndSetAutoSizeTextTypeUniformConfiguration(int autoSizeMinTextSizeInPx, int autoSizeMaxTextSizeInPx, int autoSizeStepGranularityInPx) throws IllegalArgumentException {
        if (autoSizeMinTextSizeInPx <= 0) {
            throw new IllegalArgumentException("Minimum auto-size text size (" + autoSizeMinTextSizeInPx + "px) is less or equal to (0px)");
        }
        if (autoSizeMaxTextSizeInPx <= autoSizeMinTextSizeInPx) {
            throw new IllegalArgumentException("Maximum auto-size text size (" + autoSizeMaxTextSizeInPx + "px) is less or equal to minimum auto-size " + "text size (" + autoSizeMinTextSizeInPx + "px)");
        }
        if (autoSizeStepGranularityInPx <= 0) {
            throw new IllegalArgumentException("The auto-size step granularity (" + autoSizeStepGranularityInPx + "px) is less or equal to (0px)");
        }
        this.mAutoSizeTextType = 1;
        this.mAutoSizeMinTextSizeInPx = autoSizeMinTextSizeInPx;
        this.mAutoSizeMaxTextSizeInPx = autoSizeMaxTextSizeInPx;
        this.mAutoSizeStepGranularityInPx = autoSizeStepGranularityInPx;
        this.mHasPresetAutoSizeValues = false;
    }

    private void setupAutoSizeText() {
        if (this.supportsAutoSizeText() && this.mAutoSizeTextType == 1) {
            if (!this.mHasPresetAutoSizeValues || this.mAutoSizeTextSizesInPx.length == 0) {
                int autoSizeValuesLength = (int)Math.ceil((float)(this.mAutoSizeMaxTextSizeInPx - this.mAutoSizeMinTextSizeInPx) / (float)this.mAutoSizeStepGranularityInPx);
                if ((this.mAutoSizeMaxTextSizeInPx - this.mAutoSizeMinTextSizeInPx) % this.mAutoSizeStepGranularityInPx == 0) {
                    ++autoSizeValuesLength;
                }
                this.mAutoSizeTextSizesInPx = new int[autoSizeValuesLength];
                int sizeToAdd = this.mAutoSizeMinTextSizeInPx;
                for (int i = 0; i < autoSizeValuesLength; ++i) {
                    this.mAutoSizeTextSizesInPx[i] = sizeToAdd;
                    sizeToAdd += this.mAutoSizeStepGranularityInPx;
                }
            }
            this.mNeedsAutoSizeText = true;
            this.autoSizeText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void autoSizeText() {
        int maxHeight;
        int maxWidth = this.mTextView.getWidth() - this.mTextView.getTotalPaddingLeft() - this.mTextView.getTotalPaddingRight();
        int n = maxHeight = Build.VERSION.SDK_INT >= 21 ? this.mTextView.getHeight() - this.mTextView.getExtendedPaddingBottom() - this.mTextView.getExtendedPaddingBottom() : this.mTextView.getHeight() - this.mTextView.getCompoundPaddingBottom() - this.mTextView.getCompoundPaddingTop();
        if (maxWidth <= 0 || maxHeight <= 0) {
            return;
        }
        RectF rectF = TEMP_RECTF;
        synchronized (rectF) {
            TEMP_RECTF.setEmpty();
            AppCompatTextViewAutoSizeHelper.TEMP_RECTF.right = maxWidth;
            AppCompatTextViewAutoSizeHelper.TEMP_RECTF.bottom = maxHeight;
            float optimalTextSize = this.findLargestTextSizeWhichFits(TEMP_RECTF);
            if (optimalTextSize != this.mTextView.getTextSize()) {
                this.setTextSizeInternal(0, optimalTextSize);
            }
        }
    }

    private void clearAutoSizeConfiguration() {
        this.mAutoSizeTextType = 0;
        this.mAutoSizeMinTextSizeInPx = -1;
        this.mAutoSizeMaxTextSizeInPx = -1;
        this.mAutoSizeStepGranularityInPx = -1;
        this.mAutoSizeTextSizesInPx = new int[0];
        this.mNeedsAutoSizeText = false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setTextSizeInternal(int unit, float size) {
        Resources res = this.mContext == null ? Resources.getSystem() : this.mContext.getResources();
        this.setRawTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)res.getDisplayMetrics()));
    }

    private void setRawTextSize(float size) {
        if (size != this.mTextView.getPaint().getTextSize()) {
            this.mTextView.getPaint().setTextSize(size);
            if (this.mTextView.getLayout() != null) {
                this.mNeedsAutoSizeText = false;
                try {
                    String methodName = "nullLayouts";
                    Method method = this.mMethodByNameCache.get("nullLayouts");
                    if (method == null && (method = TextView.class.getDeclaredMethod("nullLayouts", new Class[0])) != null) {
                        method.setAccessible(true);
                        this.mMethodByNameCache.put("nullLayouts", method);
                    }
                    if (method != null) {
                        method.invoke((Object)this.mTextView, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mTextView.requestLayout();
                this.mTextView.invalidate();
            }
        }
    }

    private int findLargestTextSizeWhichFits(RectF availableSpace) {
        int sizesCount = this.mAutoSizeTextSizesInPx.length;
        if (sizesCount == 0) {
            throw new IllegalStateException("No available text sizes to choose from.");
        }
        int bestSizeIndex = 0;
        int lowIndex = bestSizeIndex + 1;
        int highIndex = sizesCount - 1;
        while (lowIndex <= highIndex) {
            int sizeToTryIndex = (lowIndex + highIndex) / 2;
            if (this.suggestedSizeFitsInSpace(this.mAutoSizeTextSizesInPx[sizeToTryIndex], availableSpace)) {
                bestSizeIndex = lowIndex;
                lowIndex = sizeToTryIndex + 1;
                continue;
            }
            bestSizeIndex = highIndex = sizeToTryIndex - 1;
        }
        return this.mAutoSizeTextSizesInPx[bestSizeIndex];
    }

    private boolean suggestedSizeFitsInSpace(int suggestedSizeInPx, RectF availableSpace) {
        StaticLayout layout2;
        int availableWidth;
        CharSequence text = this.mTextView.getText();
        int maxLines = Build.VERSION.SDK_INT >= 16 ? this.mTextView.getMaxLines() : -1;
        boolean horizontallyScrolling = this.invokeAndReturnWithDefault(this.mTextView, "getHorizontallyScrolling", false);
        int n = availableWidth = horizontallyScrolling ? 0x100000 : this.mTextView.getMeasuredWidth() - this.mTextView.getTotalPaddingLeft() - this.mTextView.getTotalPaddingRight();
        if (this.mTempTextPaint == null) {
            this.mTempTextPaint = new TextPaint();
        } else {
            this.mTempTextPaint.reset();
        }
        this.mTempTextPaint.set(this.mTextView.getPaint());
        this.mTempTextPaint.setTextSize((float)suggestedSizeInPx);
        Layout.Alignment alignment = this.invokeAndReturnWithDefault(this.mTextView, "getLayoutAlignment", Layout.Alignment.ALIGN_NORMAL);
        StaticLayout staticLayout = layout2 = Build.VERSION.SDK_INT >= 23 ? this.createStaticLayoutForMeasuring(text, alignment, availableWidth, maxLines) : this.createStaticLayoutForMeasuringPre23(text, alignment, availableWidth);
        if (maxLines != -1 && layout2.getLineCount() > maxLines) {
            return false;
        }
        return !((float)layout2.getHeight() > availableSpace.bottom);
    }

    @TargetApi(value=23)
    private StaticLayout createStaticLayoutForMeasuring(CharSequence text, Layout.Alignment alignment, int availableWidth, int maxLines) {
        TextDirectionHeuristic textDirectionHeuristic = this.invokeAndReturnWithDefault(this.mTextView, "getTextDirectionHeuristic", TextDirectionHeuristics.FIRSTSTRONG_LTR);
        StaticLayout.Builder layoutBuilder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)this.mTempTextPaint, (int)availableWidth);
        return layoutBuilder.setAlignment(alignment).setLineSpacing(this.mTextView.getLineSpacingExtra(), this.mTextView.getLineSpacingMultiplier()).setIncludePad(this.mTextView.getIncludeFontPadding()).setBreakStrategy(this.mTextView.getBreakStrategy()).setHyphenationFrequency(this.mTextView.getHyphenationFrequency()).setMaxLines(maxLines == -1 ? Integer.MAX_VALUE : maxLines).setTextDirection(textDirectionHeuristic).build();
    }

    @TargetApi(value=14)
    private StaticLayout createStaticLayoutForMeasuringPre23(CharSequence text, Layout.Alignment alignment, int availableWidth) {
        float lineSpacingMultiplier = 1.0f;
        float lineSpacingAdd = 0.0f;
        boolean includePad = true;
        if (Build.VERSION.SDK_INT >= 16) {
            lineSpacingMultiplier = this.mTextView.getLineSpacingMultiplier();
            lineSpacingAdd = this.mTextView.getLineSpacingExtra();
            includePad = this.mTextView.getIncludeFontPadding();
        } else {
            lineSpacingMultiplier = this.invokeAndReturnWithDefault(this.mTextView, "getLineSpacingMultiplier", Float.valueOf(lineSpacingMultiplier)).floatValue();
            lineSpacingAdd = this.invokeAndReturnWithDefault(this.mTextView, "getLineSpacingExtra", Float.valueOf(lineSpacingAdd)).floatValue();
            includePad = this.invokeAndReturnWithDefault(this.mTextView, "getIncludeFontPadding", includePad);
        }
        return new StaticLayout(text, this.mTempTextPaint, availableWidth, alignment, lineSpacingMultiplier, lineSpacingAdd, includePad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invokeAndReturnWithDefault(@NonNull Object object, @NonNull String methodName, @NonNull T defaultValue) {
        Object result = null;
        boolean exceptionThrown = false;
        try {
            Method method = this.mMethodByNameCache.get(methodName);
            if (method == null && (method = TextView.class.getDeclaredMethod(methodName, new Class[0])) != null) {
                method.setAccessible(true);
                this.mMethodByNameCache.put(methodName, method);
            }
            if ((result = method.invoke(object, new Object[0])) == null && exceptionThrown) {
                result = defaultValue;
            }
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        finally {
            if (result == null && exceptionThrown) {
                result = defaultValue;
            }
        }
        return (T)result;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    boolean isAutoSizeEnabled() {
        return this.supportsAutoSizeText() && this.mAutoSizeTextType != 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    boolean getNeedsAutoSizeText() {
        return this.mNeedsAutoSizeText;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setNeedsAutoSizeText(boolean needsAutoSizeText) {
        this.mNeedsAutoSizeText = needsAutoSizeText;
    }

    private boolean supportsAutoSizeText() {
        return !(this.mTextView instanceof AppCompatEditText);
    }
}

