/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Rect;
import android.support.annotation.RestrictTo;
import android.support.v7.appcompat.R;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class TooltipPopup {
    private static final String TAG = "TooltipPopup";
    private final Context mContext;
    private final View mContentView;
    private final TextView mMessageView;
    private final WindowManager.LayoutParams mLayoutParams = new WindowManager.LayoutParams();
    private final Rect mTmpDisplayFrame = new Rect();
    private final int[] mTmpAnchorPos = new int[2];
    private final int[] mTmpAppPos = new int[2];

    TooltipPopup(Context context) {
        this.mContext = context;
        this.mContentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.tooltip, null);
        this.mMessageView = (TextView)this.mContentView.findViewById(R.id.message);
        this.mLayoutParams.setTitle((CharSequence)this.getClass().getSimpleName());
        this.mLayoutParams.packageName = this.mContext.getPackageName();
        this.mLayoutParams.type = 1002;
        this.mLayoutParams.width = -2;
        this.mLayoutParams.height = -2;
        this.mLayoutParams.format = -3;
        this.mLayoutParams.windowAnimations = R.style.Animation_AppCompat_Tooltip;
        this.mLayoutParams.flags = 24;
    }

    void show(View anchorView, int anchorX, int anchorY, boolean fromTouch, CharSequence tooltipText) {
        if (this.isShowing()) {
            this.hide();
        }
        this.mMessageView.setText(tooltipText);
        this.computePosition(anchorView, anchorX, anchorY, fromTouch, this.mLayoutParams);
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        wm.addView(this.mContentView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    void hide() {
        if (!this.isShowing()) {
            return;
        }
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        wm.removeView(this.mContentView);
    }

    boolean isShowing() {
        return this.mContentView.getParent() != null;
    }

    void updateContent(CharSequence tooltipText) {
        this.mMessageView.setText(tooltipText);
    }

    private void computePosition(View anchorView, int anchorX, int anchorY, boolean fromTouch, WindowManager.LayoutParams outParams) {
        int offsetAbove;
        int offsetBelow;
        int tooltipPreciseAnchorThreshold = this.mContext.getResources().getDimensionPixelOffset(R.dimen.tooltip_precise_anchor_threshold);
        int offsetX = anchorView.getWidth() >= tooltipPreciseAnchorThreshold ? anchorX : anchorView.getWidth() / 2;
        if (anchorView.getHeight() >= tooltipPreciseAnchorThreshold) {
            int offsetExtra = this.mContext.getResources().getDimensionPixelOffset(R.dimen.tooltip_precise_anchor_extra_offset);
            offsetBelow = anchorY + offsetExtra;
            offsetAbove = anchorY - offsetExtra;
        } else {
            offsetBelow = anchorView.getHeight();
            offsetAbove = 0;
        }
        outParams.gravity = 49;
        int tooltipOffset = this.mContext.getResources().getDimensionPixelOffset(fromTouch ? R.dimen.tooltip_y_offset_touch : R.dimen.tooltip_y_offset_non_touch);
        View appView = TooltipPopup.getAppRootView(anchorView);
        if (appView == null) {
            Log.e((String)TAG, (String)"Cannot find app view");
            return;
        }
        appView.getWindowVisibleDisplayFrame(this.mTmpDisplayFrame);
        if (this.mTmpDisplayFrame.left < 0 && this.mTmpDisplayFrame.top < 0) {
            Resources res = this.mContext.getResources();
            int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
            int statusBarHeight = resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
            DisplayMetrics metrics = res.getDisplayMetrics();
            this.mTmpDisplayFrame.set(0, statusBarHeight, metrics.widthPixels, metrics.heightPixels);
        }
        appView.getLocationOnScreen(this.mTmpAppPos);
        anchorView.getLocationOnScreen(this.mTmpAnchorPos);
        this.mTmpAnchorPos[0] = this.mTmpAnchorPos[0] - this.mTmpAppPos[0];
        this.mTmpAnchorPos[1] = this.mTmpAnchorPos[1] - this.mTmpAppPos[1];
        outParams.x = this.mTmpAnchorPos[0] + offsetX - this.mTmpDisplayFrame.width() / 2;
        int spec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mContentView.measure(spec, spec);
        int tooltipHeight = this.mContentView.getMeasuredHeight();
        int yAbove = this.mTmpAnchorPos[1] + offsetAbove - tooltipOffset - tooltipHeight;
        int yBelow = this.mTmpAnchorPos[1] + offsetBelow + tooltipOffset;
        outParams.y = fromTouch ? (yAbove >= 0 ? yAbove : yBelow) : (yBelow + tooltipHeight <= this.mTmpDisplayFrame.height() ? yBelow : yAbove);
    }

    private static View getAppRootView(View anchorView) {
        Context context = anchorView.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return ((Activity)context).getWindow().getDecorView();
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return anchorView.getRootView();
    }
}

