/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.Optimizer;
import android.support.constraint.solver.widgets.Rectangle;
import android.support.constraint.solver.widgets.Snapshot;
import android.support.constraint.solver.widgets.WidgetContainer;
import java.util.ArrayList;
import java.util.Arrays;

public class ConstraintWidgetContainer
extends WidgetContainer {
    private static final boolean USE_THREAD = false;
    private static final boolean USE_SNAPSHOT = true;
    private static final int MAX_ITERATIONS = 8;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_OPTIMIZE = false;
    private static final boolean DEBUG_LAYOUT = false;
    protected LinearSystem mSystem = new LinearSystem();
    protected LinearSystem mBackgroundSystem = null;
    private Snapshot mSnapshot;
    static boolean ALLOW_ROOT_GROUP = true;
    int mWrapWidth;
    int mWrapHeight;
    int mPaddingLeft;
    int mPaddingTop;
    int mPaddingRight;
    int mPaddingBottom;
    private int mHorizontalChainsSize = 0;
    private int mVerticalChainsSize = 0;
    private ConstraintWidget[] mMatchConstraintsChainedWidgets = new ConstraintWidget[4];
    private ConstraintWidget[] mVerticalChainsArray = new ConstraintWidget[4];
    private ConstraintWidget[] mHorizontalChainsArray = new ConstraintWidget[4];
    public static final int OPTIMIZATION_NONE = 1;
    public static final int OPTIMIZATION_ALL = 2;
    public static final int OPTIMIZATION_BASIC = 4;
    public static final int OPTIMIZATION_CHAIN = 8;
    private int mOptimizationLevel = 2;
    private boolean[] flags = new boolean[3];
    private static final int FLAG_CHAIN_OPTIMIZE = 0;
    private static final int FLAG_CHAIN_DANGLING = 1;
    private static final int FLAG_RECOMPUTE_BOUNDS = 2;
    private ConstraintWidget[] mChainEnds = new ConstraintWidget[4];
    private static final int CHAIN_FIRST = 0;
    private static final int CHAIN_LAST = 1;
    private static final int CHAIN_FIRST_VISIBLE = 2;
    private static final int CHAIN_LAST_VISIBLE = 3;
    private boolean mWidthMeasuredTooSmall = false;
    private boolean mHeightMeasuredTooSmall = false;

    public ConstraintWidgetContainer() {
    }

    public ConstraintWidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ConstraintWidgetContainer(int width, int height) {
        super(width, height);
    }

    public void setOptimizationLevel(int value) {
        this.mOptimizationLevel = value;
    }

    @Override
    public String getType() {
        return "ConstraintLayout";
    }

    @Override
    public void reset() {
        this.mSystem.reset();
        this.mPaddingLeft = 0;
        this.mPaddingRight = 0;
        this.mPaddingTop = 0;
        this.mPaddingBottom = 0;
        super.reset();
    }

    public boolean isWidthMeasuredTooSmall() {
        return this.mWidthMeasuredTooSmall;
    }

    public boolean isHeightMeasuredTooSmall() {
        return this.mHeightMeasuredTooSmall;
    }

    public static ConstraintWidgetContainer createContainer(ConstraintWidgetContainer container, String name, ArrayList<ConstraintWidget> widgets, int padding) {
        Rectangle bounds = ConstraintWidgetContainer.getBounds(widgets);
        if (bounds.width == 0 || bounds.height == 0) {
            return null;
        }
        if (padding > 0) {
            int maxPadding = Math.min(bounds.x, bounds.y);
            if (padding > maxPadding) {
                padding = maxPadding;
            }
            bounds.grow(padding, padding);
        }
        container.setOrigin(bounds.x, bounds.y);
        container.setDimension(bounds.width, bounds.height);
        container.setDebugName(name);
        ConstraintWidget parent = widgets.get(0).getParent();
        int widgetsSize = widgets.size();
        for (int i = 0; i < widgetsSize; ++i) {
            ConstraintWidget widget = widgets.get(i);
            if (widget.getParent() != parent) continue;
            container.add(widget);
            widget.setX(widget.getX() - bounds.x);
            widget.setY(widget.getY() - bounds.y);
        }
        return container;
    }

    public boolean addChildrenToSolver(LinearSystem system, int group) {
        this.addToSolver(system, group);
        int count = this.mChildren.size();
        boolean setMatchParent = false;
        if (this.mOptimizationLevel == 2 || this.mOptimizationLevel == 4) {
            if (this.optimize(system)) {
                return false;
            }
        } else {
            setMatchParent = true;
        }
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (widget instanceof ConstraintWidgetContainer) {
                ConstraintWidget.DimensionBehaviour horizontalBehaviour = widget.mHorizontalDimensionBehaviour;
                ConstraintWidget.DimensionBehaviour verticalBehaviour = widget.mVerticalDimensionBehaviour;
                if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                }
                if (verticalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                }
                widget.addToSolver(system, group);
                if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    widget.setHorizontalDimensionBehaviour(horizontalBehaviour);
                }
                if (verticalBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) continue;
                widget.setVerticalDimensionBehaviour(verticalBehaviour);
                continue;
            }
            if (setMatchParent) {
                Optimizer.checkMatchParent(this, system, widget);
            }
            widget.addToSolver(system, group);
        }
        if (this.mHorizontalChainsSize > 0) {
            this.applyHorizontalChain(system);
        }
        if (this.mVerticalChainsSize > 0) {
            this.applyVerticalChain(system);
        }
        return true;
    }

    private boolean optimize(LinearSystem system) {
        ConstraintWidget widget;
        int i;
        int count = this.mChildren.size();
        boolean done = false;
        int dv = 0;
        int dh = 0;
        int n = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            ConstraintWidget widget2 = (ConstraintWidget)this.mChildren.get(i2);
            widget2.mHorizontalResolution = -1;
            widget2.mVerticalResolution = -1;
            if (widget2.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget2.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            widget2.mHorizontalResolution = 1;
            widget2.mVerticalResolution = 1;
        }
        while (!done) {
            int prev = dv;
            int preh = dh;
            dv = 0;
            dh = 0;
            ++n;
            for (i = 0; i < count; ++i) {
                widget = (ConstraintWidget)this.mChildren.get(i);
                if (widget.mHorizontalResolution == -1) {
                    if (this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        widget.mHorizontalResolution = 1;
                    } else {
                        Optimizer.checkHorizontalSimpleDependency(this, system, widget);
                    }
                }
                if (widget.mVerticalResolution == -1) {
                    if (this.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        widget.mVerticalResolution = 1;
                    } else {
                        Optimizer.checkVerticalSimpleDependency(this, system, widget);
                    }
                }
                if (widget.mVerticalResolution == -1) {
                    ++dv;
                }
                if (widget.mHorizontalResolution != -1) continue;
                ++dh;
            }
            if (dv == 0 && dh == 0) {
                done = true;
                continue;
            }
            if (prev != dv || preh != dh) continue;
            done = true;
        }
        int sh = 0;
        int sv = 0;
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)this.mChildren.get(i);
            if (widget.mHorizontalResolution == 1 || widget.mHorizontalResolution == -1) {
                ++sh;
            }
            if (widget.mVerticalResolution != 1 && widget.mVerticalResolution != -1) continue;
            ++sv;
        }
        return sh == 0 && sv == 0;
    }

    private void applyHorizontalChain(LinearSystem system) {
        for (int i = 0; i < this.mHorizontalChainsSize; ++i) {
            Object left;
            boolean isWrapContent;
            ConstraintWidget first = this.mHorizontalChainsArray[i];
            int numMatchConstraints = this.countMatchConstraintsChainedWidgets(system, this.mChainEnds, this.mHorizontalChainsArray[i], 0, this.flags);
            ConstraintWidget currentWidget = this.mChainEnds[2];
            if (currentWidget == null) continue;
            if (this.flags[1]) {
                int x = first.getDrawX();
                while (currentWidget != null) {
                    system.addEquality(currentWidget.mLeft.mSolverVariable, x);
                    ConstraintWidget next = currentWidget.mHorizontalNextWidget;
                    x += currentWidget.mLeft.getMargin() + currentWidget.getWidth() + currentWidget.mRight.getMargin();
                    currentWidget = next;
                }
                continue;
            }
            boolean isChainSpread = first.mHorizontalChainStyle == 0;
            boolean isChainPacked = first.mHorizontalChainStyle == 2;
            ConstraintWidget widget = first;
            boolean bl = isWrapContent = this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if ((this.mOptimizationLevel == 2 || this.mOptimizationLevel == 8) && this.flags[0] && widget.mHorizontalChainFixedPosition && !isChainPacked && !isWrapContent && first.mHorizontalChainStyle == 0) {
                Optimizer.applyDirectResolutionHorizontalChain(this, system, numMatchConstraints, widget);
                continue;
            }
            if (numMatchConstraints == 0 || isChainPacked) {
                SolverVariable rightTarget;
                int leftMargin;
                ConstraintWidget previousVisibleWidget = null;
                ConstraintWidget lastWidget = null;
                ConstraintWidget firstVisibleWidget = currentWidget;
                boolean isLast = false;
                ConstraintWidget next = null;
                while (currentWidget != null) {
                    next = currentWidget.mHorizontalNextWidget;
                    if (next == null) {
                        lastWidget = this.mChainEnds[1];
                        isLast = true;
                    }
                    if (isChainPacked) {
                        left = currentWidget.mLeft;
                        int margin = ((ConstraintAnchor)left).getMargin();
                        if (previousVisibleWidget != null) {
                            int previousMargin = previousVisibleWidget.mRight.getMargin();
                            margin += previousMargin;
                        }
                        int strength = 1;
                        if (firstVisibleWidget != currentWidget) {
                            strength = 3;
                        }
                        system.addGreaterThan(((ConstraintAnchor)left).mSolverVariable, ((ConstraintAnchor)left).mTarget.mSolverVariable, margin, strength);
                        if (currentWidget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            ConstraintAnchor right = currentWidget.mRight;
                            if (currentWidget.mMatchConstraintDefaultWidth == 1) {
                                int dimension = Math.max(currentWidget.mMatchConstraintMinWidth, currentWidget.getWidth());
                                system.addEquality(right.mSolverVariable, ((ConstraintAnchor)left).mSolverVariable, dimension, 3);
                            } else {
                                system.addGreaterThan(((ConstraintAnchor)left).mSolverVariable, ((ConstraintAnchor)left).mTarget.mSolverVariable, ((ConstraintAnchor)left).mMargin, 3);
                                system.addLowerThan(right.mSolverVariable, ((ConstraintAnchor)left).mSolverVariable, currentWidget.mMatchConstraintMinWidth, 3);
                            }
                        }
                    } else if (!isChainSpread && isLast && previousVisibleWidget != null) {
                        if (currentWidget.mRight.mTarget == null) {
                            system.addEquality(currentWidget.mRight.mSolverVariable, currentWidget.getDrawRight());
                        } else {
                            int margin = currentWidget.mRight.getMargin();
                            system.addEquality(currentWidget.mRight.mSolverVariable, lastWidget.mRight.mTarget.mSolverVariable, -margin, 5);
                        }
                    } else if (!isChainSpread && !isLast && previousVisibleWidget == null) {
                        if (currentWidget.mLeft.mTarget == null) {
                            system.addEquality(currentWidget.mLeft.mSolverVariable, currentWidget.getDrawX());
                        } else {
                            int margin = currentWidget.mLeft.getMargin();
                            system.addEquality(currentWidget.mLeft.mSolverVariable, first.mLeft.mTarget.mSolverVariable, margin, 5);
                        }
                    } else {
                        SolverVariable leftTarget;
                        left = currentWidget.mLeft;
                        ConstraintAnchor right = currentWidget.mRight;
                        leftMargin = ((ConstraintAnchor)left).getMargin();
                        int rightMargin = right.getMargin();
                        system.addGreaterThan(((ConstraintAnchor)left).mSolverVariable, ((ConstraintAnchor)left).mTarget.mSolverVariable, leftMargin, 1);
                        system.addLowerThan(right.mSolverVariable, right.mTarget.mSolverVariable, -rightMargin, 1);
                        SolverVariable solverVariable = leftTarget = ((ConstraintAnchor)left).mTarget != null ? ((ConstraintAnchor)left).mTarget.mSolverVariable : null;
                        if (previousVisibleWidget == null) {
                            SolverVariable solverVariable2 = leftTarget = first.mLeft.mTarget != null ? first.mLeft.mTarget.mSolverVariable : null;
                        }
                        if (next == null) {
                            ConstraintWidget constraintWidget = next = lastWidget.mRight.mTarget != null ? lastWidget.mRight.mTarget.mOwner : null;
                        }
                        if (next != null) {
                            rightTarget = next.mLeft.mSolverVariable;
                            if (isLast) {
                                SolverVariable solverVariable3 = rightTarget = lastWidget.mRight.mTarget != null ? lastWidget.mRight.mTarget.mSolverVariable : null;
                            }
                            if (leftTarget != null && rightTarget != null) {
                                system.addCentering(((ConstraintAnchor)left).mSolverVariable, leftTarget, leftMargin, 0.5f, rightTarget, right.mSolverVariable, rightMargin, 4);
                            }
                        }
                    }
                    previousVisibleWidget = currentWidget;
                    currentWidget = isLast ? null : next;
                }
                if (!isChainPacked) continue;
                left = firstVisibleWidget.mLeft;
                ConstraintAnchor right = lastWidget.mRight;
                leftMargin = ((ConstraintAnchor)left).getMargin();
                int rightMargin = right.getMargin();
                SolverVariable leftTarget = first.mLeft.mTarget != null ? first.mLeft.mTarget.mSolverVariable : null;
                SolverVariable solverVariable = rightTarget = lastWidget.mRight.mTarget != null ? lastWidget.mRight.mTarget.mSolverVariable : null;
                if (leftTarget == null || rightTarget == null) continue;
                system.addLowerThan(right.mSolverVariable, rightTarget, -rightMargin, 1);
                system.addCentering(((ConstraintAnchor)left).mSolverVariable, leftTarget, leftMargin, first.mHorizontalBiasPercent, rightTarget, right.mSolverVariable, rightMargin, 4);
                continue;
            }
            ConstraintWidget previous = null;
            float totalWeights = 0.0f;
            while (currentWidget != null) {
                int margin;
                if (currentWidget.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    margin = currentWidget.mLeft.getMargin();
                    if (previous != null) {
                        margin += previous.mRight.getMargin();
                    }
                    int strength = 3;
                    if (currentWidget.mLeft.mTarget.mOwner.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 2;
                    }
                    system.addGreaterThan(currentWidget.mLeft.mSolverVariable, currentWidget.mLeft.mTarget.mSolverVariable, margin, strength);
                    margin = currentWidget.mRight.getMargin();
                    if (currentWidget.mRight.mTarget.mOwner.mLeft.mTarget != null && currentWidget.mRight.mTarget.mOwner.mLeft.mTarget.mOwner == currentWidget) {
                        margin += currentWidget.mRight.mTarget.mOwner.mLeft.getMargin();
                    }
                    strength = 3;
                    if (currentWidget.mRight.mTarget.mOwner.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 2;
                    }
                    system.addLowerThan(currentWidget.mRight.mSolverVariable, currentWidget.mRight.mTarget.mSolverVariable, -margin, strength);
                } else {
                    totalWeights += currentWidget.mHorizontalWeight;
                    margin = 0;
                    if (currentWidget.mRight.mTarget != null) {
                        margin = currentWidget.mRight.getMargin();
                        if (currentWidget != this.mChainEnds[3]) {
                            margin += currentWidget.mRight.mTarget.mOwner.mLeft.getMargin();
                        }
                    }
                    system.addGreaterThan(currentWidget.mRight.mSolverVariable, currentWidget.mLeft.mSolverVariable, 0, 1);
                    system.addLowerThan(currentWidget.mRight.mSolverVariable, currentWidget.mRight.mTarget.mSolverVariable, -margin, 1);
                }
                previous = currentWidget;
                currentWidget = currentWidget.mHorizontalNextWidget;
            }
            if (numMatchConstraints == 1) {
                ConstraintWidget w = this.mMatchConstraintsChainedWidgets[0];
                int leftMargin = w.mLeft.getMargin();
                if (w.mLeft.mTarget != null) {
                    leftMargin += w.mLeft.mTarget.getMargin();
                }
                int rightMargin = w.mRight.getMargin();
                if (w.mRight.mTarget != null) {
                    rightMargin += w.mRight.mTarget.getMargin();
                }
                SolverVariable rightTarget = widget.mRight.mTarget.mSolverVariable;
                if (w == this.mChainEnds[3]) {
                    rightTarget = this.mChainEnds[1].mRight.mTarget.mSolverVariable;
                }
                if (w.mMatchConstraintDefaultWidth == 1) {
                    system.addGreaterThan(widget.mLeft.mSolverVariable, widget.mLeft.mTarget.mSolverVariable, leftMargin, 1);
                    system.addLowerThan(widget.mRight.mSolverVariable, rightTarget, -rightMargin, 1);
                    system.addEquality(widget.mRight.mSolverVariable, widget.mLeft.mSolverVariable, widget.getWidth(), 2);
                    continue;
                }
                system.addEquality(w.mLeft.mSolverVariable, w.mLeft.mTarget.mSolverVariable, leftMargin, 1);
                system.addEquality(w.mRight.mSolverVariable, rightTarget, -rightMargin, 1);
                continue;
            }
            for (int j = 0; j < numMatchConstraints - 1; ++j) {
                ConstraintWidget current = this.mMatchConstraintsChainedWidgets[j];
                ConstraintWidget nextWidget = this.mMatchConstraintsChainedWidgets[j + 1];
                left = current.mLeft.mSolverVariable;
                SolverVariable right = current.mRight.mSolverVariable;
                SolverVariable nextLeft = nextWidget.mLeft.mSolverVariable;
                SolverVariable nextRight = nextWidget.mRight.mSolverVariable;
                if (nextWidget == this.mChainEnds[3]) {
                    nextRight = this.mChainEnds[1].mRight.mSolverVariable;
                }
                int margin = current.mLeft.getMargin();
                if (current.mLeft.mTarget != null && current.mLeft.mTarget.mOwner.mRight.mTarget != null && current.mLeft.mTarget.mOwner.mRight.mTarget.mOwner == current) {
                    margin += current.mLeft.mTarget.mOwner.mRight.getMargin();
                }
                system.addGreaterThan((SolverVariable)left, current.mLeft.mTarget.mSolverVariable, margin, 2);
                margin = current.mRight.getMargin();
                if (current.mRight.mTarget != null && current.mHorizontalNextWidget != null) {
                    margin += current.mHorizontalNextWidget.mLeft.mTarget != null ? current.mHorizontalNextWidget.mLeft.getMargin() : 0;
                }
                system.addLowerThan(right, current.mRight.mTarget.mSolverVariable, -margin, 2);
                if (j + 1 == numMatchConstraints - 1) {
                    margin = nextWidget.mLeft.getMargin();
                    if (nextWidget.mLeft.mTarget != null && nextWidget.mLeft.mTarget.mOwner.mRight.mTarget != null && nextWidget.mLeft.mTarget.mOwner.mRight.mTarget.mOwner == nextWidget) {
                        margin += nextWidget.mLeft.mTarget.mOwner.mRight.getMargin();
                    }
                    system.addGreaterThan(nextLeft, nextWidget.mLeft.mTarget.mSolverVariable, margin, 2);
                    ConstraintAnchor anchor = nextWidget.mRight;
                    if (nextWidget == this.mChainEnds[3]) {
                        anchor = this.mChainEnds[1].mRight;
                    }
                    margin = anchor.getMargin();
                    if (anchor.mTarget != null && anchor.mTarget.mOwner.mLeft.mTarget != null && anchor.mTarget.mOwner.mLeft.mTarget.mOwner == nextWidget) {
                        margin += anchor.mTarget.mOwner.mLeft.getMargin();
                    }
                    system.addLowerThan(nextRight, anchor.mTarget.mSolverVariable, -margin, 2);
                }
                if (widget.mMatchConstraintMaxWidth > 0) {
                    system.addLowerThan(right, (SolverVariable)left, widget.mMatchConstraintMaxWidth, 2);
                }
                ArrayRow row = system.createRow();
                row.createRowEqualDimension(current.mHorizontalWeight, totalWeights, nextWidget.mHorizontalWeight, (SolverVariable)left, current.mLeft.getMargin(), right, current.mRight.getMargin(), nextLeft, nextWidget.mLeft.getMargin(), nextRight, nextWidget.mRight.getMargin());
                system.addConstraint(row);
            }
        }
    }

    private void applyVerticalChain(LinearSystem system) {
        for (int i = 0; i < this.mVerticalChainsSize; ++i) {
            Object top;
            boolean isWrapContent;
            ConstraintWidget first = this.mVerticalChainsArray[i];
            int numMatchConstraints = this.countMatchConstraintsChainedWidgets(system, this.mChainEnds, this.mVerticalChainsArray[i], 1, this.flags);
            ConstraintWidget currentWidget = this.mChainEnds[2];
            if (currentWidget == null) continue;
            if (this.flags[1]) {
                int y = first.getDrawY();
                while (currentWidget != null) {
                    system.addEquality(currentWidget.mTop.mSolverVariable, y);
                    ConstraintWidget next = currentWidget.mVerticalNextWidget;
                    y += currentWidget.mTop.getMargin() + currentWidget.getHeight() + currentWidget.mBottom.getMargin();
                    currentWidget = next;
                }
                continue;
            }
            boolean isChainSpread = first.mVerticalChainStyle == 0;
            boolean isChainPacked = first.mVerticalChainStyle == 2;
            ConstraintWidget widget = first;
            boolean bl = isWrapContent = this.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if ((this.mOptimizationLevel == 2 || this.mOptimizationLevel == 8) && this.flags[0] && widget.mVerticalChainFixedPosition && !isChainPacked && !isWrapContent && first.mVerticalChainStyle == 0) {
                Optimizer.applyDirectResolutionVerticalChain(this, system, numMatchConstraints, widget);
                continue;
            }
            if (numMatchConstraints == 0 || isChainPacked) {
                SolverVariable bottomTarget;
                SolverVariable topTarget;
                int topMargin;
                ConstraintWidget previousVisibleWidget = null;
                ConstraintWidget lastWidget = null;
                ConstraintWidget firstVisibleWidget = currentWidget;
                boolean isLast = false;
                ConstraintWidget next = null;
                while (currentWidget != null) {
                    next = currentWidget.mVerticalNextWidget;
                    if (next == null) {
                        lastWidget = this.mChainEnds[1];
                        isLast = true;
                    }
                    if (isChainPacked) {
                        top = currentWidget.mTop;
                        int margin = ((ConstraintAnchor)top).getMargin();
                        if (previousVisibleWidget != null) {
                            int previousMargin = previousVisibleWidget.mBottom.getMargin();
                            margin += previousMargin;
                        }
                        int strength = 1;
                        if (firstVisibleWidget != currentWidget) {
                            strength = 3;
                        }
                        SolverVariable source = null;
                        SolverVariable target = null;
                        if (((ConstraintAnchor)top).mTarget != null) {
                            source = ((ConstraintAnchor)top).mSolverVariable;
                            target = ((ConstraintAnchor)top).mTarget.mSolverVariable;
                        } else if (currentWidget.mBaseline.mTarget != null) {
                            source = currentWidget.mBaseline.mSolverVariable;
                            target = currentWidget.mBaseline.mTarget.mSolverVariable;
                            margin -= ((ConstraintAnchor)top).getMargin();
                        }
                        if (source != null && target != null) {
                            system.addGreaterThan(source, target, margin, strength);
                        }
                        if (currentWidget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                            ConstraintAnchor bottom = currentWidget.mBottom;
                            if (currentWidget.mMatchConstraintDefaultHeight == 1) {
                                int dimension = Math.max(currentWidget.mMatchConstraintMinHeight, currentWidget.getHeight());
                                system.addEquality(bottom.mSolverVariable, ((ConstraintAnchor)top).mSolverVariable, dimension, 3);
                            } else {
                                system.addGreaterThan(((ConstraintAnchor)top).mSolverVariable, ((ConstraintAnchor)top).mTarget.mSolverVariable, ((ConstraintAnchor)top).mMargin, 3);
                                system.addLowerThan(bottom.mSolverVariable, ((ConstraintAnchor)top).mSolverVariable, currentWidget.mMatchConstraintMinHeight, 3);
                            }
                        }
                    } else if (!isChainSpread && isLast && previousVisibleWidget != null) {
                        if (currentWidget.mBottom.mTarget == null) {
                            system.addEquality(currentWidget.mBottom.mSolverVariable, currentWidget.getDrawBottom());
                        } else {
                            int margin = currentWidget.mBottom.getMargin();
                            system.addEquality(currentWidget.mBottom.mSolverVariable, lastWidget.mBottom.mTarget.mSolverVariable, -margin, 5);
                        }
                    } else if (!isChainSpread && !isLast && previousVisibleWidget == null) {
                        if (currentWidget.mTop.mTarget == null) {
                            system.addEquality(currentWidget.mTop.mSolverVariable, currentWidget.getDrawY());
                        } else {
                            int margin = currentWidget.mTop.getMargin();
                            system.addEquality(currentWidget.mTop.mSolverVariable, first.mTop.mTarget.mSolverVariable, margin, 5);
                        }
                    } else {
                        top = currentWidget.mTop;
                        ConstraintAnchor bottom = currentWidget.mBottom;
                        topMargin = ((ConstraintAnchor)top).getMargin();
                        int bottomMargin = bottom.getMargin();
                        system.addGreaterThan(((ConstraintAnchor)top).mSolverVariable, ((ConstraintAnchor)top).mTarget.mSolverVariable, topMargin, 1);
                        system.addLowerThan(bottom.mSolverVariable, bottom.mTarget.mSolverVariable, -bottomMargin, 1);
                        SolverVariable solverVariable = topTarget = ((ConstraintAnchor)top).mTarget != null ? ((ConstraintAnchor)top).mTarget.mSolverVariable : null;
                        if (previousVisibleWidget == null) {
                            SolverVariable solverVariable2 = topTarget = first.mTop.mTarget != null ? first.mTop.mTarget.mSolverVariable : null;
                        }
                        if (next == null) {
                            ConstraintWidget constraintWidget = next = lastWidget.mBottom.mTarget != null ? lastWidget.mBottom.mTarget.mOwner : null;
                        }
                        if (next != null) {
                            bottomTarget = next.mTop.mSolverVariable;
                            if (isLast) {
                                SolverVariable solverVariable3 = bottomTarget = lastWidget.mBottom.mTarget != null ? lastWidget.mBottom.mTarget.mSolverVariable : null;
                            }
                            if (topTarget != null && bottomTarget != null) {
                                system.addCentering(((ConstraintAnchor)top).mSolverVariable, topTarget, topMargin, 0.5f, bottomTarget, bottom.mSolverVariable, bottomMargin, 4);
                            }
                        }
                    }
                    previousVisibleWidget = currentWidget;
                    currentWidget = isLast ? null : next;
                }
                if (!isChainPacked) continue;
                top = firstVisibleWidget.mTop;
                ConstraintAnchor bottom = lastWidget.mBottom;
                topMargin = ((ConstraintAnchor)top).getMargin();
                int bottomMargin = bottom.getMargin();
                topTarget = first.mTop.mTarget != null ? first.mTop.mTarget.mSolverVariable : null;
                SolverVariable solverVariable = bottomTarget = lastWidget.mBottom.mTarget != null ? lastWidget.mBottom.mTarget.mSolverVariable : null;
                if (topTarget == null || bottomTarget == null) continue;
                system.addLowerThan(bottom.mSolverVariable, bottomTarget, -bottomMargin, 1);
                system.addCentering(((ConstraintAnchor)top).mSolverVariable, topTarget, topMargin, first.mVerticalBiasPercent, bottomTarget, bottom.mSolverVariable, bottomMargin, 4);
                continue;
            }
            ConstraintWidget previous = null;
            float totalWeights = 0.0f;
            while (currentWidget != null) {
                int margin;
                if (currentWidget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    margin = currentWidget.mTop.getMargin();
                    if (previous != null) {
                        margin += previous.mBottom.getMargin();
                    }
                    int strength = 3;
                    if (currentWidget.mTop.mTarget.mOwner.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 2;
                    }
                    system.addGreaterThan(currentWidget.mTop.mSolverVariable, currentWidget.mTop.mTarget.mSolverVariable, margin, strength);
                    margin = currentWidget.mBottom.getMargin();
                    if (currentWidget.mBottom.mTarget.mOwner.mTop.mTarget != null && currentWidget.mBottom.mTarget.mOwner.mTop.mTarget.mOwner == currentWidget) {
                        margin += currentWidget.mBottom.mTarget.mOwner.mTop.getMargin();
                    }
                    strength = 3;
                    if (currentWidget.mBottom.mTarget.mOwner.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        strength = 2;
                    }
                    system.addLowerThan(currentWidget.mBottom.mSolverVariable, currentWidget.mBottom.mTarget.mSolverVariable, -margin, strength);
                } else {
                    totalWeights += currentWidget.mVerticalWeight;
                    margin = 0;
                    if (currentWidget.mBottom.mTarget != null) {
                        margin = currentWidget.mBottom.getMargin();
                        if (currentWidget != this.mChainEnds[3]) {
                            margin += currentWidget.mBottom.mTarget.mOwner.mTop.getMargin();
                        }
                    }
                    system.addGreaterThan(currentWidget.mBottom.mSolverVariable, currentWidget.mTop.mSolverVariable, 0, 1);
                    system.addLowerThan(currentWidget.mBottom.mSolverVariable, currentWidget.mBottom.mTarget.mSolverVariable, -margin, 1);
                }
                previous = currentWidget;
                currentWidget = currentWidget.mVerticalNextWidget;
            }
            if (numMatchConstraints == 1) {
                ConstraintWidget w = this.mMatchConstraintsChainedWidgets[0];
                int topMargin = w.mTop.getMargin();
                if (w.mTop.mTarget != null) {
                    topMargin += w.mTop.mTarget.getMargin();
                }
                int bottomMargin = w.mBottom.getMargin();
                if (w.mBottom.mTarget != null) {
                    bottomMargin += w.mBottom.mTarget.getMargin();
                }
                SolverVariable bottomTarget = widget.mBottom.mTarget.mSolverVariable;
                if (w == this.mChainEnds[3]) {
                    bottomTarget = this.mChainEnds[1].mBottom.mTarget.mSolverVariable;
                }
                if (w.mMatchConstraintDefaultHeight == 1) {
                    system.addGreaterThan(widget.mTop.mSolverVariable, widget.mTop.mTarget.mSolverVariable, topMargin, 1);
                    system.addLowerThan(widget.mBottom.mSolverVariable, bottomTarget, -bottomMargin, 1);
                    system.addEquality(widget.mBottom.mSolverVariable, widget.mTop.mSolverVariable, widget.getHeight(), 2);
                    continue;
                }
                system.addEquality(w.mTop.mSolverVariable, w.mTop.mTarget.mSolverVariable, topMargin, 1);
                system.addEquality(w.mBottom.mSolverVariable, bottomTarget, -bottomMargin, 1);
                continue;
            }
            for (int j = 0; j < numMatchConstraints - 1; ++j) {
                ConstraintWidget current = this.mMatchConstraintsChainedWidgets[j];
                ConstraintWidget nextWidget = this.mMatchConstraintsChainedWidgets[j + 1];
                top = current.mTop.mSolverVariable;
                SolverVariable bottom = current.mBottom.mSolverVariable;
                SolverVariable nextTop = nextWidget.mTop.mSolverVariable;
                SolverVariable nextBottom = nextWidget.mBottom.mSolverVariable;
                if (nextWidget == this.mChainEnds[3]) {
                    nextBottom = this.mChainEnds[1].mBottom.mSolverVariable;
                }
                int margin = current.mTop.getMargin();
                if (current.mTop.mTarget != null && current.mTop.mTarget.mOwner.mBottom.mTarget != null && current.mTop.mTarget.mOwner.mBottom.mTarget.mOwner == current) {
                    margin += current.mTop.mTarget.mOwner.mBottom.getMargin();
                }
                system.addGreaterThan((SolverVariable)top, current.mTop.mTarget.mSolverVariable, margin, 2);
                margin = current.mBottom.getMargin();
                if (current.mBottom.mTarget != null && current.mVerticalNextWidget != null) {
                    margin += current.mVerticalNextWidget.mTop.mTarget != null ? current.mVerticalNextWidget.mTop.getMargin() : 0;
                }
                system.addLowerThan(bottom, current.mBottom.mTarget.mSolverVariable, -margin, 2);
                if (j + 1 == numMatchConstraints - 1) {
                    margin = nextWidget.mTop.getMargin();
                    if (nextWidget.mTop.mTarget != null && nextWidget.mTop.mTarget.mOwner.mBottom.mTarget != null && nextWidget.mTop.mTarget.mOwner.mBottom.mTarget.mOwner == nextWidget) {
                        margin += nextWidget.mTop.mTarget.mOwner.mBottom.getMargin();
                    }
                    system.addGreaterThan(nextTop, nextWidget.mTop.mTarget.mSolverVariable, margin, 2);
                    ConstraintAnchor anchor = nextWidget.mBottom;
                    if (nextWidget == this.mChainEnds[3]) {
                        anchor = this.mChainEnds[1].mBottom;
                    }
                    margin = anchor.getMargin();
                    if (anchor.mTarget != null && anchor.mTarget.mOwner.mTop.mTarget != null && anchor.mTarget.mOwner.mTop.mTarget.mOwner == nextWidget) {
                        margin += anchor.mTarget.mOwner.mTop.getMargin();
                    }
                    system.addLowerThan(nextBottom, anchor.mTarget.mSolverVariable, -margin, 2);
                }
                if (widget.mMatchConstraintMaxHeight > 0) {
                    system.addLowerThan(bottom, (SolverVariable)top, widget.mMatchConstraintMaxHeight, 2);
                }
                ArrayRow row = system.createRow();
                row.createRowEqualDimension(current.mVerticalWeight, totalWeights, nextWidget.mVerticalWeight, (SolverVariable)top, current.mTop.getMargin(), bottom, current.mBottom.getMargin(), nextTop, nextWidget.mTop.getMargin(), nextBottom, nextWidget.mBottom.getMargin());
                system.addConstraint(row);
            }
        }
    }

    public void updateChildrenFromSolver(LinearSystem system, int group, boolean[] flags) {
        flags[2] = false;
        this.updateFromSolver(system, group);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            widget.updateFromSolver(system, group);
            if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getWidth() < widget.getWrapWidth()) {
                flags[2] = true;
            }
            if (widget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getHeight() >= widget.getWrapHeight()) continue;
            flags[2] = true;
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    @Override
    public void layout() {
        int height;
        int width;
        int prex = this.mX;
        int prey = this.mY;
        int prew = Math.max(0, this.getWidth());
        int preh = Math.max(0, this.getHeight());
        this.mWidthMeasuredTooSmall = false;
        this.mHeightMeasuredTooSmall = false;
        if (this.mParent != null) {
            if (this.mSnapshot == null) {
                this.mSnapshot = new Snapshot(this);
            }
            this.mSnapshot.updateFrom(this);
            this.setX(this.mPaddingLeft);
            this.setY(this.mPaddingTop);
            this.resetAnchors();
            this.resetSolverVariables(this.mSystem.getCache());
        } else {
            this.mX = 0;
            this.mY = 0;
        }
        boolean wrap_override = false;
        ConstraintWidget.DimensionBehaviour originalVerticalDimensionBehaviour = this.mVerticalDimensionBehaviour;
        ConstraintWidget.DimensionBehaviour originalHorizontalDimensionBehaviour = this.mHorizontalDimensionBehaviour;
        if (this.mOptimizationLevel == 2 && (this.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
            this.findWrapSize(this.mChildren, this.flags);
            wrap_override = this.flags[0];
            if (prew > 0 && preh > 0 && (this.mWrapWidth > prew || this.mWrapHeight > preh)) {
                wrap_override = false;
            }
            if (wrap_override) {
                if (this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.mHorizontalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
                    if (prew > 0 && prew < this.mWrapWidth) {
                        this.mWidthMeasuredTooSmall = true;
                        this.setWidth(prew);
                    } else {
                        this.setWidth(Math.max(this.mMinWidth, this.mWrapWidth));
                    }
                }
                if (this.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.mVerticalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
                    if (preh > 0 && preh < this.mWrapHeight) {
                        this.mHeightMeasuredTooSmall = true;
                        this.setHeight(preh);
                    } else {
                        this.setHeight(Math.max(this.mMinHeight, this.mWrapHeight));
                    }
                }
            }
        }
        this.resetChains();
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        boolean needsSolving = true;
        int countSolve = 0;
        while (needsSolving) {
            ++countSolve;
            try {
                this.mSystem.reset();
                needsSolving = this.addChildrenToSolver(this.mSystem, Integer.MAX_VALUE);
                if (needsSolving) {
                    this.mSystem.minimize();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (needsSolving) {
                this.updateChildrenFromSolver(this.mSystem, Integer.MAX_VALUE, this.flags);
            } else {
                this.updateFromSolver(this.mSystem, Integer.MAX_VALUE);
                for (int i = 0; i < count; ++i) {
                    ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
                    if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getWidth() < widget.getWrapWidth()) {
                        this.flags[2] = true;
                        break;
                    }
                    if (widget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || widget.getHeight() >= widget.getWrapHeight()) continue;
                    this.flags[2] = true;
                    break;
                }
            }
            needsSolving = false;
            if (countSolve < 8 && this.flags[2]) {
                int maxX = 0;
                int maxY = 0;
                for (int i = 0; i < count; ++i) {
                    ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
                    maxX = Math.max(maxX, widget.mX + widget.getWidth());
                    maxY = Math.max(maxY, widget.mY + widget.getHeight());
                }
                maxX = Math.max(this.mMinWidth, maxX);
                maxY = Math.max(this.mMinHeight, maxY);
                if (originalHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && this.getWidth() < maxX) {
                    this.setWidth(maxX);
                    this.mHorizontalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    wrap_override = true;
                    needsSolving = true;
                }
                if (originalVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && this.getHeight() < maxY) {
                    this.setHeight(maxY);
                    this.mVerticalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    wrap_override = true;
                    needsSolving = true;
                }
            }
            if ((width = Math.max(this.mMinWidth, this.getWidth())) > this.getWidth()) {
                this.setWidth(width);
                this.mHorizontalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
                wrap_override = true;
                needsSolving = true;
            }
            if ((height = Math.max(this.mMinHeight, this.getHeight())) > this.getHeight()) {
                this.setHeight(height);
                this.mVerticalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
                wrap_override = true;
                needsSolving = true;
            }
            if (wrap_override) continue;
            if (this.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && prew > 0 && this.getWidth() > prew) {
                this.mWidthMeasuredTooSmall = true;
                wrap_override = true;
                this.mHorizontalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
                this.setWidth(prew);
                needsSolving = true;
            }
            if (this.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || preh <= 0 || this.getHeight() <= preh) continue;
            this.mHeightMeasuredTooSmall = true;
            wrap_override = true;
            this.mVerticalDimensionBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
            this.setHeight(preh);
            needsSolving = true;
        }
        if (this.mParent != null) {
            width = Math.max(this.mMinWidth, this.getWidth());
            height = Math.max(this.mMinHeight, this.getHeight());
            this.mSnapshot.applyTo(this);
            this.setWidth(width + this.mPaddingLeft + this.mPaddingRight);
            this.setHeight(height + this.mPaddingTop + this.mPaddingBottom);
        } else {
            this.mX = prex;
            this.mY = prey;
        }
        if (wrap_override) {
            this.mHorizontalDimensionBehaviour = originalHorizontalDimensionBehaviour;
            this.mVerticalDimensionBehaviour = originalVerticalDimensionBehaviour;
        }
        this.resetSolverVariables(this.mSystem.getCache());
        if (this == this.getRootConstraintContainer()) {
            this.updateDrawPosition();
        }
    }

    static int setGroup(ConstraintAnchor anchor, int group) {
        int oldGroup = anchor.mGroup;
        if (anchor.mOwner.getParent() == null) {
            return group;
        }
        if (oldGroup <= group) {
            return oldGroup;
        }
        anchor.mGroup = group;
        ConstraintAnchor opposite = anchor.getOpposite();
        ConstraintAnchor target = anchor.mTarget;
        group = opposite != null ? ConstraintWidgetContainer.setGroup(opposite, group) : group;
        group = target != null ? ConstraintWidgetContainer.setGroup(target, group) : group;
        anchor.mGroup = group = opposite != null ? ConstraintWidgetContainer.setGroup(opposite, group) : group;
        return group;
    }

    public int layoutFindGroupsSimple() {
        int size = this.mChildren.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            widget.mLeft.mGroup = 0;
            widget.mRight.mGroup = 0;
            widget.mTop.mGroup = 1;
            widget.mBottom.mGroup = 1;
            widget.mBaseline.mGroup = 1;
        }
        return 2;
    }

    public void findHorizontalWrapRecursive(ConstraintWidget widget, boolean[] flags) {
        if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio > 0.0f) {
            flags[0] = false;
            return;
        }
        int w = widget.getOptimizerWrapWidth();
        if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio > 0.0f) {
            flags[0] = false;
            return;
        }
        int distToRight = w;
        int distToLeft = w;
        ConstraintWidget leftWidget = null;
        ConstraintWidget rightWidget = null;
        widget.mHorizontalWrapVisited = true;
        if (widget instanceof Guideline) {
            Guideline guideline = (Guideline)widget;
            if (guideline.getOrientation() == 1) {
                distToLeft = 0;
                distToRight = 0;
                if (guideline.getRelativeBegin() != -1) {
                    distToLeft = guideline.getRelativeBegin();
                } else if (guideline.getRelativeEnd() != -1) {
                    distToRight = guideline.getRelativeEnd();
                }
            }
        } else if (!widget.mRight.isConnected() && !widget.mLeft.isConnected()) {
            distToLeft += widget.getX();
        } else {
            if (widget.mRight.mTarget != null && widget.mLeft.mTarget != null && (widget.mRight.mTarget == widget.mLeft.mTarget || widget.mRight.mTarget.mOwner == widget.mLeft.mTarget.mOwner && widget.mRight.mTarget.mOwner != widget.mParent)) {
                flags[0] = false;
                return;
            }
            if (widget.mRight.mTarget != null) {
                rightWidget = widget.mRight.mTarget.mOwner;
                distToRight += widget.mRight.getMargin();
                if (!rightWidget.isRoot() && !rightWidget.mHorizontalWrapVisited) {
                    this.findHorizontalWrapRecursive(rightWidget, flags);
                }
            }
            if (widget.mLeft.mTarget != null) {
                leftWidget = widget.mLeft.mTarget.mOwner;
                distToLeft += widget.mLeft.getMargin();
                if (!leftWidget.isRoot() && !leftWidget.mHorizontalWrapVisited) {
                    this.findHorizontalWrapRecursive(leftWidget, flags);
                }
            }
            if (widget.mRight.mTarget != null && !rightWidget.isRoot()) {
                if (widget.mRight.mTarget.mType == ConstraintAnchor.Type.RIGHT) {
                    distToRight += rightWidget.mDistToRight - rightWidget.getOptimizerWrapWidth();
                } else if (widget.mRight.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToRight += rightWidget.mDistToRight;
                }
                boolean bl = widget.mRightHasCentered = rightWidget.mRightHasCentered || rightWidget.mLeft.mTarget != null && rightWidget.mRight.mTarget != null && rightWidget.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mRightHasCentered && (rightWidget.mLeft.mTarget == null || rightWidget.mLeft.mTarget.mOwner != widget)) {
                    distToRight += distToRight - rightWidget.mDistToRight;
                }
            }
            if (widget.mLeft.mTarget != null && !leftWidget.isRoot()) {
                if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.LEFT) {
                    distToLeft += leftWidget.mDistToLeft - leftWidget.getOptimizerWrapWidth();
                } else if (widget.mLeft.mTarget.getType() == ConstraintAnchor.Type.RIGHT) {
                    distToLeft += leftWidget.mDistToLeft;
                }
                boolean bl = widget.mLeftHasCentered = leftWidget.mLeftHasCentered || leftWidget.mLeft.mTarget != null && leftWidget.mRight.mTarget != null && leftWidget.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mLeftHasCentered && (leftWidget.mRight.mTarget == null || leftWidget.mRight.mTarget.mOwner != widget)) {
                    distToLeft += distToLeft - leftWidget.mDistToLeft;
                }
            }
        }
        if (widget.getVisibility() == 8) {
            distToLeft -= widget.mWidth;
            distToRight -= widget.mWidth;
        }
        widget.mDistToLeft = distToLeft;
        widget.mDistToRight = distToRight;
    }

    public void findVerticalWrapRecursive(ConstraintWidget widget, boolean[] flags) {
        int h;
        if (widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mDimensionRatio > 0.0f) {
            flags[0] = false;
            return;
        }
        int distToTop = h = widget.getOptimizerWrapHeight();
        int distToBottom = h;
        ConstraintWidget topWidget = null;
        ConstraintWidget bottomWidget = null;
        widget.mVerticalWrapVisited = true;
        if (widget instanceof Guideline) {
            Guideline guideline = (Guideline)widget;
            if (guideline.getOrientation() == 0) {
                distToTop = 0;
                distToBottom = 0;
                if (guideline.getRelativeBegin() != -1) {
                    distToTop = guideline.getRelativeBegin();
                } else if (guideline.getRelativeEnd() != -1) {
                    distToBottom = guideline.getRelativeEnd();
                }
            }
        } else if (widget.mBaseline.mTarget == null && widget.mTop.mTarget == null && widget.mBottom.mTarget == null) {
            distToTop += widget.getY();
        } else {
            if (widget.mBottom.mTarget != null && widget.mTop.mTarget != null && (widget.mBottom.mTarget == widget.mTop.mTarget || widget.mBottom.mTarget.mOwner == widget.mTop.mTarget.mOwner && widget.mBottom.mTarget.mOwner != widget.mParent)) {
                flags[0] = false;
                return;
            }
            if (widget.mBaseline.isConnected()) {
                ConstraintWidget baseLineWidget = widget.mBaseline.mTarget.getOwner();
                if (!baseLineWidget.mVerticalWrapVisited) {
                    this.findVerticalWrapRecursive(baseLineWidget, flags);
                }
                distToTop = Math.max(baseLineWidget.mDistToTop - baseLineWidget.mHeight + h, h);
                distToBottom = Math.max(baseLineWidget.mDistToBottom - baseLineWidget.mHeight + h, h);
                if (widget.getVisibility() == 8) {
                    distToTop -= widget.mHeight;
                    distToBottom -= widget.mHeight;
                }
                widget.mDistToTop = distToTop;
                widget.mDistToBottom = distToBottom;
                return;
            }
            if (widget.mTop.isConnected()) {
                topWidget = widget.mTop.mTarget.getOwner();
                distToTop += widget.mTop.getMargin();
                if (!topWidget.isRoot() && !topWidget.mVerticalWrapVisited) {
                    this.findVerticalWrapRecursive(topWidget, flags);
                }
            }
            if (widget.mBottom.isConnected()) {
                bottomWidget = widget.mBottom.mTarget.getOwner();
                distToBottom += widget.mBottom.getMargin();
                if (!bottomWidget.isRoot() && !bottomWidget.mVerticalWrapVisited) {
                    this.findVerticalWrapRecursive(bottomWidget, flags);
                }
            }
            if (widget.mTop.mTarget != null && !topWidget.isRoot()) {
                if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToTop += topWidget.mDistToTop - topWidget.getOptimizerWrapHeight();
                } else if (widget.mTop.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToTop += topWidget.mDistToTop;
                }
                boolean bl = widget.mTopHasCentered = topWidget.mTopHasCentered || topWidget.mTop.mTarget != null && topWidget.mTop.mTarget.mOwner != widget && topWidget.mBottom.mTarget != null && topWidget.mBottom.mTarget.mOwner != widget && topWidget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mTopHasCentered && (topWidget.mBottom.mTarget == null || topWidget.mBottom.mTarget.mOwner != widget)) {
                    distToTop += distToTop - topWidget.mDistToTop;
                }
            }
            if (widget.mBottom.mTarget != null && !bottomWidget.isRoot()) {
                if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.BOTTOM) {
                    distToBottom += bottomWidget.mDistToBottom - bottomWidget.getOptimizerWrapHeight();
                } else if (widget.mBottom.mTarget.getType() == ConstraintAnchor.Type.TOP) {
                    distToBottom += bottomWidget.mDistToBottom;
                }
                boolean bl = widget.mBottomHasCentered = bottomWidget.mBottomHasCentered || bottomWidget.mTop.mTarget != null && bottomWidget.mTop.mTarget.mOwner != widget && bottomWidget.mBottom.mTarget != null && bottomWidget.mBottom.mTarget.mOwner != widget && bottomWidget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                if (widget.mBottomHasCentered && (bottomWidget.mTop.mTarget == null || bottomWidget.mTop.mTarget.mOwner != widget)) {
                    distToBottom += distToBottom - bottomWidget.mDistToBottom;
                }
            }
        }
        if (widget.getVisibility() == 8) {
            distToTop -= widget.mHeight;
            distToBottom -= widget.mHeight;
        }
        widget.mDistToTop = distToTop;
        widget.mDistToBottom = distToBottom;
    }

    public void findWrapSize(ArrayList<ConstraintWidget> children, boolean[] flags) {
        int maxTopDist = 0;
        int maxLeftDist = 0;
        int maxRightDist = 0;
        int maxBottomDist = 0;
        int maxConnectWidth = 0;
        int maxConnectHeight = 0;
        int size = children.size();
        flags[0] = true;
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = children.get(j);
            if (widget.isRoot()) continue;
            if (!widget.mHorizontalWrapVisited) {
                this.findHorizontalWrapRecursive(widget, flags);
            }
            if (!widget.mVerticalWrapVisited) {
                this.findVerticalWrapRecursive(widget, flags);
            }
            if (!flags[0]) {
                return;
            }
            int connectWidth = widget.mDistToLeft + widget.mDistToRight - widget.getWidth();
            int connectHeight = widget.mDistToTop + widget.mDistToBottom - widget.getHeight();
            if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                connectWidth = widget.getWidth() + widget.mLeft.mMargin + widget.mRight.mMargin;
            }
            if (widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                connectHeight = widget.getHeight() + widget.mTop.mMargin + widget.mBottom.mMargin;
            }
            if (widget.getVisibility() == 8) {
                connectWidth = 0;
                connectHeight = 0;
            }
            maxLeftDist = Math.max(maxLeftDist, widget.mDistToLeft);
            maxRightDist = Math.max(maxRightDist, widget.mDistToRight);
            maxBottomDist = Math.max(maxBottomDist, widget.mDistToBottom);
            maxTopDist = Math.max(maxTopDist, widget.mDistToTop);
            maxConnectWidth = Math.max(maxConnectWidth, connectWidth);
            maxConnectHeight = Math.max(maxConnectHeight, connectHeight);
        }
        int max = Math.max(maxLeftDist, maxRightDist);
        this.mWrapWidth = Math.max(this.mMinWidth, Math.max(max, maxConnectWidth));
        max = Math.max(maxTopDist, maxBottomDist);
        this.mWrapHeight = Math.max(this.mMinHeight, Math.max(max, maxConnectHeight));
        for (int j = 0; j < size; ++j) {
            ConstraintWidget child = children.get(j);
            child.mHorizontalWrapVisited = false;
            child.mVerticalWrapVisited = false;
            child.mLeftHasCentered = false;
            child.mRightHasCentered = false;
            child.mTopHasCentered = false;
            child.mBottomHasCentered = false;
        }
    }

    public int layoutFindGroups() {
        ConstraintAnchor anchor;
        ConstraintAnchor.Type[] dir = new ConstraintAnchor.Type[]{ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.BASELINE, ConstraintAnchor.Type.BOTTOM};
        int label = 1;
        int size = this.mChildren.size();
        for (int j = 0; j < size; ++j) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            ConstraintAnchor anchor2 = null;
            anchor2 = widget.mLeft;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mTop;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mRight;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mBottom;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) == label) {
                    ++label;
                }
            } else {
                anchor2.mGroup = Integer.MAX_VALUE;
            }
            anchor2 = widget.mBaseline;
            if (anchor2.mTarget != null) {
                if (ConstraintWidgetContainer.setGroup(anchor2, label) != label) continue;
                ++label;
                continue;
            }
            anchor2.mGroup = Integer.MAX_VALUE;
        }
        boolean notDone = true;
        int count = 0;
        int fix = 0;
        while (notDone) {
            notDone = false;
            ++count;
            for (int j = 0; j < size; ++j) {
                ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
                for (int i = 0; i < dir.length; ++i) {
                    ConstraintAnchor opposite;
                    ConstraintAnchor.Type type = dir[i];
                    anchor = null;
                    switch (type) {
                        case LEFT: {
                            anchor = widget.mLeft;
                            break;
                        }
                        case TOP: {
                            anchor = widget.mTop;
                            break;
                        }
                        case RIGHT: {
                            anchor = widget.mRight;
                            break;
                        }
                        case BOTTOM: {
                            anchor = widget.mBottom;
                            break;
                        }
                        case BASELINE: {
                            anchor = widget.mBaseline;
                        }
                    }
                    ConstraintAnchor target = anchor.mTarget;
                    if (target == null) continue;
                    if (target.mOwner.getParent() != null && target.mGroup != anchor.mGroup) {
                        anchor.mGroup = anchor.mGroup > target.mGroup ? target.mGroup : anchor.mGroup;
                        target.mGroup = anchor.mGroup;
                        ++fix;
                        notDone = true;
                    }
                    if ((opposite = target.getOpposite()) == null || opposite.mGroup == anchor.mGroup) continue;
                    anchor.mGroup = anchor.mGroup > opposite.mGroup ? opposite.mGroup : anchor.mGroup;
                    opposite.mGroup = anchor.mGroup;
                    ++fix;
                    notDone = true;
                }
            }
        }
        int index = 0;
        int[] table = new int[this.mChildren.size() * dir.length + 1];
        Arrays.fill(table, -1);
        for (int j = 0; j < size; ++j) {
            int g;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(j);
            anchor = null;
            anchor = widget.mLeft;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mTop;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mRight;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mBottom;
            if (anchor.mGroup != Integer.MAX_VALUE) {
                g = anchor.mGroup;
                if (table[g] == -1) {
                    table[g] = index++;
                }
                anchor.mGroup = table[g];
            }
            anchor = widget.mBaseline;
            if (anchor.mGroup == Integer.MAX_VALUE) continue;
            g = anchor.mGroup;
            if (table[g] == -1) {
                table[g] = index++;
            }
            anchor.mGroup = table[g];
        }
        return index;
    }

    public void layoutWithGroup(int numOfGroups) {
        int i;
        int prex = this.mX;
        int prey = this.mY;
        if (this.mParent != null) {
            if (this.mSnapshot == null) {
                this.mSnapshot = new Snapshot(this);
            }
            this.mSnapshot.updateFrom(this);
            this.mX = 0;
            this.mY = 0;
            this.resetAnchors();
            this.resetSolverVariables(this.mSystem.getCache());
        } else {
            this.mX = 0;
            this.mY = 0;
        }
        int count = this.mChildren.size();
        for (i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        this.mLeft.mGroup = 0;
        this.mRight.mGroup = 0;
        this.mTop.mGroup = 1;
        this.mBottom.mGroup = 1;
        this.mSystem.reset();
        for (i = 0; i < numOfGroups; ++i) {
            try {
                this.addToSolver(this.mSystem, i);
                this.mSystem.minimize();
                this.updateFromSolver(this.mSystem, i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateFromSolver(this.mSystem, -2);
        }
        if (this.mParent != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            this.mSnapshot.applyTo(this);
            this.setWidth(width);
            this.setHeight(height);
        } else {
            this.mX = prex;
            this.mY = prey;
        }
        if (this == this.getRootConstraintContainer()) {
            this.updateDrawPosition();
        }
    }

    public boolean handlesInternalConstraints() {
        return false;
    }

    public ArrayList<Guideline> getVerticalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 1) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public ArrayList<Guideline> getHorizontalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 0) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public LinearSystem getSystem() {
        return this.mSystem;
    }

    private void resetChains() {
        this.mHorizontalChainsSize = 0;
        this.mVerticalChainsSize = 0;
    }

    void addChain(ConstraintWidget constraintWidget, int type) {
        ConstraintWidget widget = constraintWidget;
        if (type == 0) {
            while (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner.mRight.mTarget != null && widget.mLeft.mTarget.mOwner.mRight.mTarget == widget.mLeft && widget.mLeft.mTarget.mOwner != widget) {
                widget = widget.mLeft.mTarget.mOwner;
            }
            this.addHorizontalChain(widget);
        } else if (type == 1) {
            while (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner.mBottom.mTarget != null && widget.mTop.mTarget.mOwner.mBottom.mTarget == widget.mTop && widget.mTop.mTarget.mOwner != widget) {
                widget = widget.mTop.mTarget.mOwner;
            }
            this.addVerticalChain(widget);
        }
    }

    private void addHorizontalChain(ConstraintWidget widget) {
        for (int i = 0; i < this.mHorizontalChainsSize; ++i) {
            if (this.mHorizontalChainsArray[i] != widget) continue;
            return;
        }
        if (this.mHorizontalChainsSize + 1 >= this.mHorizontalChainsArray.length) {
            this.mHorizontalChainsArray = Arrays.copyOf(this.mHorizontalChainsArray, this.mHorizontalChainsArray.length * 2);
        }
        this.mHorizontalChainsArray[this.mHorizontalChainsSize] = widget;
        ++this.mHorizontalChainsSize;
    }

    private void addVerticalChain(ConstraintWidget widget) {
        for (int i = 0; i < this.mVerticalChainsSize; ++i) {
            if (this.mVerticalChainsArray[i] != widget) continue;
            return;
        }
        if (this.mVerticalChainsSize + 1 >= this.mVerticalChainsArray.length) {
            this.mVerticalChainsArray = Arrays.copyOf(this.mVerticalChainsArray, this.mVerticalChainsArray.length * 2);
        }
        this.mVerticalChainsArray[this.mVerticalChainsSize] = widget;
        ++this.mVerticalChainsSize;
    }

    private int countMatchConstraintsChainedWidgets(LinearSystem system, ConstraintWidget[] chainEnds, ConstraintWidget widget, int direction, boolean[] flags) {
        int count = 0;
        flags[0] = true;
        flags[1] = false;
        chainEnds[0] = null;
        chainEnds[2] = null;
        chainEnds[1] = null;
        chainEnds[3] = null;
        if (direction == 0) {
            boolean fixedPosition = true;
            ConstraintWidget first = widget;
            ConstraintWidget last = null;
            if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            widget.mHorizontalNextWidget = null;
            ConstraintWidget firstVisible = null;
            if (widget.getVisibility() != 8) {
                firstVisible = widget;
            }
            ConstraintWidget lastVisible = firstVisible;
            while (widget.mRight.mTarget != null) {
                widget.mHorizontalNextWidget = null;
                if (widget.getVisibility() != 8) {
                    if (firstVisible == null) {
                        firstVisible = widget;
                    }
                    if (lastVisible != null && lastVisible != widget) {
                        lastVisible.mHorizontalNextWidget = widget;
                    }
                    lastVisible = widget;
                } else {
                    system.addEquality(widget.mLeft.mSolverVariable, widget.mLeft.mTarget.mSolverVariable, 0, 5);
                    system.addEquality(widget.mRight.mSolverVariable, widget.mLeft.mSolverVariable, 0, 5);
                }
                if (widget.getVisibility() != 8 && widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        flags[0] = false;
                    }
                    if (widget.mDimensionRatio <= 0.0f) {
                        flags[0] = false;
                        if (count + 1 >= this.mMatchConstraintsChainedWidgets.length) {
                            this.mMatchConstraintsChainedWidgets = Arrays.copyOf(this.mMatchConstraintsChainedWidgets, this.mMatchConstraintsChainedWidgets.length * 2);
                        }
                        this.mMatchConstraintsChainedWidgets[count++] = widget;
                    }
                }
                if (widget.mRight.mTarget.mOwner.mLeft.mTarget == null || widget.mRight.mTarget.mOwner.mLeft.mTarget.mOwner != widget || widget.mRight.mTarget.mOwner == widget) break;
                last = widget = widget.mRight.mTarget.mOwner;
            }
            if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            if (first.mLeft.mTarget == null || last.mRight.mTarget == null) {
                flags[1] = true;
            }
            first.mHorizontalChainFixedPosition = fixedPosition;
            last.mHorizontalNextWidget = null;
            chainEnds[0] = first;
            chainEnds[2] = firstVisible;
            chainEnds[1] = last;
            chainEnds[3] = lastVisible;
        } else {
            boolean fixedPosition = true;
            ConstraintWidget first = widget;
            ConstraintWidget last = null;
            if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            widget.mVerticalNextWidget = null;
            ConstraintWidget firstVisible = null;
            if (widget.getVisibility() != 8) {
                firstVisible = widget;
            }
            ConstraintWidget lastVisible = firstVisible;
            while (widget.mBottom.mTarget != null) {
                widget.mVerticalNextWidget = null;
                if (widget.getVisibility() != 8) {
                    if (firstVisible == null) {
                        firstVisible = widget;
                    }
                    if (lastVisible != null && lastVisible != widget) {
                        lastVisible.mVerticalNextWidget = widget;
                    }
                    lastVisible = widget;
                } else {
                    system.addEquality(widget.mTop.mSolverVariable, widget.mTop.mTarget.mSolverVariable, 0, 5);
                    system.addEquality(widget.mBottom.mSolverVariable, widget.mTop.mSolverVariable, 0, 5);
                }
                if (widget.getVisibility() != 8 && widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        flags[0] = false;
                    }
                    if (widget.mDimensionRatio <= 0.0f) {
                        flags[0] = false;
                        if (count + 1 >= this.mMatchConstraintsChainedWidgets.length) {
                            this.mMatchConstraintsChainedWidgets = Arrays.copyOf(this.mMatchConstraintsChainedWidgets, this.mMatchConstraintsChainedWidgets.length * 2);
                        }
                        this.mMatchConstraintsChainedWidgets[count++] = widget;
                    }
                }
                if (widget.mBottom.mTarget.mOwner.mTop.mTarget == null || widget.mBottom.mTarget.mOwner.mTop.mTarget.mOwner != widget || widget.mBottom.mTarget.mOwner == widget) break;
                last = widget = widget.mBottom.mTarget.mOwner;
            }
            if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner != this) {
                fixedPosition = false;
            }
            if (first.mTop.mTarget == null || last.mBottom.mTarget == null) {
                flags[1] = true;
            }
            first.mVerticalChainFixedPosition = fixedPosition;
            last.mVerticalNextWidget = null;
            chainEnds[0] = first;
            chainEnds[2] = firstVisible;
            chainEnds[1] = last;
            chainEnds[3] = lastVisible;
        }
        return count;
    }
}

