/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;

class Chain {
    private static final boolean DEBUG = false;

    Chain() {
    }

    static void applyChainConstraints(ConstraintWidgetContainer constraintWidgetContainer, LinearSystem system, int orientation) {
        int offset = 0;
        int chainsSize = 0;
        ConstraintWidget[] chainsArray = null;
        if (orientation == 0) {
            offset = 0;
            chainsSize = constraintWidgetContainer.mHorizontalChainsSize;
            chainsArray = constraintWidgetContainer.mHorizontalChainsArray;
        } else {
            offset = 2;
            chainsSize = constraintWidgetContainer.mVerticalChainsSize;
            chainsArray = constraintWidgetContainer.mVerticalChainsArray;
        }
        for (int i = 0; i < chainsSize; ++i) {
            ConstraintWidget first = chainsArray[i];
            Chain.applyChainConstraints(constraintWidgetContainer, system, orientation, offset, first);
        }
    }

    static void applyChainConstraints(ConstraintWidgetContainer container, LinearSystem system, int orientation, int offset, ConstraintWidget first) {
        SolverVariable beginNextTarget;
        SolverVariable beginNext;
        ConstraintAnchor beginNextAnchor;
        SolverVariable beginTarget;
        ConstraintWidget widget = first;
        ConstraintWidget next = null;
        ConstraintWidget firstVisibleWidget = null;
        ConstraintWidget lastVisibleWidget = null;
        boolean done = false;
        int numMatchConstraints = 0;
        float totalWeights = 0.0f;
        ConstraintWidget firstMatchConstraintsWidget = null;
        ConstraintWidget previousMatchConstraintsWidget = null;
        boolean isWrapContent = container.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        boolean isChainSpread = false;
        boolean isChainSpreadInside = false;
        boolean isChainPacked = false;
        if (orientation == 0) {
            isChainSpread = first.mHorizontalChainStyle == 0;
            isChainSpreadInside = first.mHorizontalChainStyle == 1;
            isChainPacked = first.mHorizontalChainStyle == 2;
        } else {
            isChainSpread = first.mVerticalChainStyle == 0;
            isChainSpreadInside = first.mVerticalChainStyle == 1;
            boolean bl = isChainPacked = first.mVerticalChainStyle == 2;
        }
        while (!done) {
            ConstraintAnchor nextAnchor;
            widget.mListNextVisibleWidget[orientation] = null;
            if (widget.getVisibility() != 8) {
                if (lastVisibleWidget != null) {
                    lastVisibleWidget.mListNextVisibleWidget[orientation] = widget;
                }
                if (firstVisibleWidget == null) {
                    firstVisibleWidget = widget;
                }
                lastVisibleWidget = widget;
            }
            ConstraintAnchor begin = widget.mListAnchors[offset];
            int strength = 1;
            int margin = begin.getMargin();
            system.addGreaterThan(begin.mSolverVariable, begin.mTarget.mSolverVariable, margin, 6);
            system.addEquality(begin.mSolverVariable, begin.mTarget.mSolverVariable, margin, strength);
            widget.mListNextMatchConstraintsWidget[orientation] = null;
            if (widget.getVisibility() != 8 && widget.mListDimensionBehaviors[orientation] == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                ++numMatchConstraints;
                totalWeights += widget.mWeight[orientation];
                if (firstMatchConstraintsWidget == null) {
                    firstMatchConstraintsWidget = widget;
                } else {
                    previousMatchConstraintsWidget.mListNextMatchConstraintsWidget[orientation] = widget;
                }
                previousMatchConstraintsWidget = widget;
                if (isWrapContent) {
                    system.addGreaterThan(widget.mListAnchors[offset + 1].mSolverVariable, widget.mListAnchors[offset].mSolverVariable, 0, 6);
                }
            }
            if (isWrapContent) {
                system.addGreaterThan(widget.mListAnchors[offset].mSolverVariable, container.mListAnchors[offset].mSolverVariable, 0, 6);
            }
            if ((nextAnchor = widget.mListAnchors[offset + 1].mTarget) != null) {
                next = nextAnchor.mOwner;
                if (next.mListAnchors[offset].mTarget == null || next.mListAnchors[offset].mTarget.mOwner != widget) {
                    next = null;
                }
            } else {
                next = null;
            }
            if (next != null) {
                widget = next;
                continue;
            }
            done = true;
        }
        ConstraintWidget last = widget;
        if (lastVisibleWidget != null && last.mListAnchors[offset + 1].mTarget != null) {
            ConstraintAnchor end = lastVisibleWidget.mListAnchors[offset + 1];
            system.addLowerThan(end.mSolverVariable, last.mListAnchors[offset + 1].mTarget.mSolverVariable, -end.getMargin(), 6);
        }
        if (isWrapContent) {
            system.addGreaterThan(container.mListAnchors[offset + 1].mSolverVariable, last.mListAnchors[offset + 1].mSolverVariable, last.mListAnchors[offset + 1].getMargin(), 6);
        }
        if (numMatchConstraints > 0) {
            widget = firstMatchConstraintsWidget;
            while (widget != null) {
                next = widget.mListNextMatchConstraintsWidget[orientation];
                if (next != null) {
                    ArrayRow row = system.createRow();
                    float currentWeight = widget.mWeight[orientation];
                    float nextWeight = next.mWeight[orientation];
                    SolverVariable begin = widget.mListAnchors[offset].mSolverVariable;
                    SolverVariable end = widget.mListAnchors[offset + 1].mSolverVariable;
                    SolverVariable nextBegin = next.mListAnchors[offset].mSolverVariable;
                    SolverVariable nextEnd = next.mListAnchors[offset + 1].mSolverVariable;
                    row.createRowEqualMatchDimensions(currentWeight, totalWeights, nextWeight, begin, end, nextBegin, nextEnd);
                    system.addConstraint(row);
                }
                widget = next;
            }
        }
        if (firstVisibleWidget == lastVisibleWidget || isChainPacked) {
            SolverVariable endTarget;
            ConstraintAnchor begin = first.mListAnchors[offset];
            ConstraintAnchor end = last.mListAnchors[offset + 1];
            SolverVariable beginTarget2 = first.mListAnchors[offset].mTarget != null ? first.mListAnchors[offset].mTarget.mSolverVariable : null;
            SolverVariable solverVariable = endTarget = last.mListAnchors[offset + 1].mTarget != null ? last.mListAnchors[offset + 1].mTarget.mSolverVariable : null;
            if (beginTarget2 != null && endTarget != null) {
                float bias = 0.5f;
                bias = orientation == 0 ? first.mHorizontalBiasPercent : first.mVerticalBiasPercent;
                int beginMargin = begin.getMargin();
                if (lastVisibleWidget == null) {
                    lastVisibleWidget = last;
                }
                int endMargin = lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                system.addCentering(begin.mSolverVariable, beginTarget2, beginMargin, bias, endTarget, end.mSolverVariable, endMargin, 4);
            }
        } else if (isChainSpread && firstVisibleWidget != null) {
            widget = firstVisibleWidget;
            ConstraintWidget previousVisibleWidget = firstVisibleWidget;
            while (widget != null) {
                next = widget.mListNextVisibleWidget[orientation];
                if (next != null || widget == lastVisibleWidget) {
                    ConstraintAnchor beginAnchor = widget.mListAnchors[offset];
                    SolverVariable begin = beginAnchor.mSolverVariable;
                    SolverVariable solverVariable = beginTarget = beginAnchor.mTarget != null ? beginAnchor.mTarget.mSolverVariable : null;
                    if (previousVisibleWidget != widget) {
                        beginTarget = previousVisibleWidget.mListAnchors[offset + 1].mSolverVariable;
                    }
                    beginNextAnchor = null;
                    beginNext = null;
                    beginNextTarget = null;
                    int beginMargin = beginAnchor.getMargin();
                    int nextMargin = 0;
                    if (next != null) {
                        beginNextAnchor = next.mListAnchors[offset];
                        beginNext = beginNextAnchor.mSolverVariable;
                        beginNextTarget = beginNextAnchor.mTarget != null ? beginNextAnchor.mTarget.mSolverVariable : null;
                        nextMargin = beginNextAnchor.getMargin();
                    } else {
                        beginNextAnchor = last.mListAnchors[offset + 1].mTarget;
                        if (beginNextAnchor != null) {
                            beginNext = beginNextAnchor.mSolverVariable;
                        }
                        beginNextTarget = widget.mListAnchors[offset + 1].mSolverVariable;
                    }
                    if (begin != null && beginTarget != null && beginNext != null && beginNextTarget != null) {
                        int margin1 = 0;
                        if (widget == firstVisibleWidget) {
                            margin1 = firstVisibleWidget.mListAnchors[offset].getMargin();
                        }
                        int margin2 = 0;
                        if (widget == lastVisibleWidget) {
                            margin2 = lastVisibleWidget.mListAnchors[offset + 1].getMargin();
                        }
                        system.addCentering(begin, beginTarget, margin1, 0.5f, beginNext, beginNextTarget, margin2, 4);
                    }
                }
                previousVisibleWidget = widget;
                widget = next;
            }
        } else if (isChainSpreadInside && firstVisibleWidget != null) {
            widget = firstVisibleWidget;
            ConstraintWidget previousVisibleWidget = firstVisibleWidget;
            while (widget != null) {
                next = widget.mListNextVisibleWidget[orientation];
                if (widget != firstVisibleWidget && next != null) {
                    if (next == lastVisibleWidget) {
                        next = null;
                    }
                    ConstraintAnchor beginAnchor = widget.mListAnchors[offset];
                    SolverVariable begin = beginAnchor.mSolverVariable;
                    beginTarget = beginAnchor.mTarget != null ? beginAnchor.mTarget.mSolverVariable : null;
                    beginTarget = previousVisibleWidget.mListAnchors[offset + 1].mSolverVariable;
                    beginNextAnchor = null;
                    beginNext = null;
                    beginNextTarget = null;
                    int beginMargin = beginAnchor.getMargin();
                    int nextMargin = 0;
                    if (next != null) {
                        beginNextAnchor = next.mListAnchors[offset];
                        beginNext = beginNextAnchor.mSolverVariable;
                        beginNextTarget = beginNextAnchor.mTarget != null ? beginNextAnchor.mTarget.mSolverVariable : null;
                        nextMargin = beginNextAnchor.getMargin();
                    } else {
                        beginNextAnchor = widget.mListAnchors[offset + 1].mTarget;
                        if (beginNextAnchor != null) {
                            beginNext = beginNextAnchor.mSolverVariable;
                        }
                        beginNextTarget = widget.mListAnchors[offset + 1].mSolverVariable;
                    }
                    if (begin != null && beginTarget != null && beginNext != null && beginNextTarget != null) {
                        system.addCentering(begin, beginTarget, 0, 0.5f, beginNext, beginNextTarget, 0, 4);
                    }
                }
                previousVisibleWidget = widget;
                widget = next;
            }
            ConstraintAnchor begin = firstVisibleWidget.mListAnchors[offset];
            ConstraintAnchor beginTarget3 = first.mListAnchors[offset].mTarget;
            ConstraintAnchor end = lastVisibleWidget.mListAnchors[offset + 1];
            ConstraintAnchor endTarget = last.mListAnchors[offset + 1].mTarget;
            if (beginTarget3 != null) {
                if (firstVisibleWidget != lastVisibleWidget) {
                    system.addEquality(begin.mSolverVariable, beginTarget3.mSolverVariable, begin.getMargin(), 6);
                } else if (endTarget != null) {
                    system.addCentering(begin.mSolverVariable, beginTarget3.mSolverVariable, begin.getMargin(), 0.5f, end.mSolverVariable, endTarget.mSolverVariable, end.getMargin(), 6);
                }
            }
            if (endTarget != null && firstVisibleWidget != lastVisibleWidget) {
                system.addEquality(end.mSolverVariable, endTarget.mSolverVariable, end.getMargin(), 6);
            }
        }
    }
}

