/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import java.util.HashSet;

public class ResolutionNode {
    ConstraintAnchor myAnchor;
    float computedValue;
    ResolutionNode target;
    float offset;
    HashSet<ResolutionNode> dependents = new HashSet(4);
    ResolutionNode resolvedTarget;
    float resolvedOffset;
    int type = 0;
    public static final int UNCONNECTED = 0;
    public static final int DIRECT_CONNECTION = 1;
    public static final int CENTER_CONNECTION = 2;
    public static final int MATCH_CONNECTION = 3;
    public static final int CHAIN_CONNECTION = 4;
    public static final int BARRIER_CONNECTION = 5;
    public static final int UNRESOLVED = 0;
    public static final int RESOLVED = 1;
    int state = 0;
    private ResolutionNode opposite;
    private float oppositeOffset;

    public ResolutionNode(ConstraintAnchor anchor) {
        this.myAnchor = anchor;
    }

    public String toString() {
        if (this.state == 1) {
            if (this.resolvedTarget == this) {
                return "[" + this.myAnchor + ", RESOLVED: " + this.resolvedOffset + "]";
            }
            return "[" + this.myAnchor + ", RESOLVED: " + this.resolvedTarget + ":" + this.resolvedOffset + "]";
        }
        return "{ " + this.myAnchor + " UNRESOLVED}";
    }

    public void didResolve() {
        this.state = 1;
        for (ResolutionNode node : this.dependents) {
            node.resolve();
        }
    }

    public void resolve(ResolutionNode target, float offset) {
        this.resolvedTarget = target;
        this.resolvedOffset = offset;
        this.didResolve();
    }

    String sType(int type) {
        if (type == 1) {
            return "DIRECT";
        }
        if (type == 2) {
            return "CENTER";
        }
        if (type == 3) {
            return "MATCH";
        }
        if (type == 4) {
            return "CHAIN";
        }
        if (type == 5) {
            return "BARRIER";
        }
        return "UNCONNECTED";
    }

    public void resolve() {
        if (this.state == 1) {
            return;
        }
        if (this.type == 4) {
            return;
        }
        if (this.type == 1 && (this.target == null || this.target.state == 1)) {
            if (this.target == null) {
                this.resolvedTarget = this;
                this.resolvedOffset = this.offset;
            } else {
                this.resolvedTarget = this.target.resolvedTarget;
                this.resolvedOffset = this.target.resolvedOffset + this.offset;
            }
            this.didResolve();
        } else if (this.type == 2 && this.target != null && this.target.state == 1 && this.opposite != null && this.opposite.target != null && this.opposite.target.state == 1) {
            if (LinearSystem.getMetrics() != null) {
                ++LinearSystem.getMetrics().centerConnectionResolved;
            }
            this.resolvedTarget = this.target.resolvedTarget;
            this.opposite.resolvedTarget = this.opposite.target.resolvedTarget;
            float distance = 0.0f;
            float percent = 0.5f;
            distance = this.oppositeOffset > 0.0f ? this.target.resolvedOffset - this.opposite.target.resolvedOffset : this.opposite.target.resolvedOffset - this.target.resolvedOffset;
            if (this.myAnchor.mType == ConstraintAnchor.Type.LEFT || this.myAnchor.mType == ConstraintAnchor.Type.RIGHT) {
                distance -= (float)this.myAnchor.mOwner.getWidth();
                percent = this.myAnchor.mOwner.mHorizontalBiasPercent;
            } else {
                distance -= (float)this.myAnchor.mOwner.getHeight();
                percent = this.myAnchor.mOwner.mVerticalBiasPercent;
            }
            int margin = this.myAnchor.getMargin();
            int oppositeMargin = this.opposite.myAnchor.getMargin();
            if (this.myAnchor.getTarget() == this.opposite.myAnchor.getTarget()) {
                percent = 0.5f;
                margin = 0;
                oppositeMargin = 0;
            }
            distance -= (float)margin;
            distance -= (float)oppositeMargin;
            if (this.oppositeOffset > 0.0f) {
                this.opposite.resolvedOffset = this.opposite.target.resolvedOffset + (float)oppositeMargin + distance * percent;
                this.resolvedOffset = this.target.resolvedOffset - (float)margin - distance * (1.0f - percent);
            } else {
                this.resolvedOffset = this.target.resolvedOffset + (float)margin + distance * percent;
                this.opposite.resolvedOffset = this.opposite.target.resolvedOffset - (float)oppositeMargin - distance * (1.0f - percent);
            }
            this.didResolve();
            this.opposite.didResolve();
        } else if (this.type == 3 && this.target != null && this.target.state == 1 && this.opposite != null && this.opposite.target != null && this.opposite.target.state == 1) {
            if (LinearSystem.getMetrics() != null) {
                ++LinearSystem.getMetrics().matchConnectionResolved;
            }
            this.resolvedTarget = this.target.resolvedTarget;
            this.opposite.resolvedTarget = this.opposite.target.resolvedTarget;
            this.resolvedOffset = this.target.resolvedOffset + this.offset;
            this.opposite.resolvedOffset = this.opposite.target.resolvedOffset + this.opposite.offset;
            this.didResolve();
            this.opposite.didResolve();
        } else if (this.type == 5) {
            this.myAnchor.mOwner.resolve();
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addDependent(ResolutionNode node) {
        this.dependents.add(node);
    }

    public void resetResolution() {
        this.state = 0;
        this.resolvedTarget = null;
        this.resolvedOffset = 0.0f;
    }

    public void reset() {
        this.target = null;
        this.offset = 0.0f;
        this.dependents.clear();
        this.resolvedTarget = null;
        this.resolvedOffset = 0.0f;
        this.computedValue = 0.0f;
        this.opposite = null;
        this.oppositeOffset = 0.0f;
        this.type = 0;
        this.state = 0;
    }

    public void update() {
        ConstraintAnchor targetAnchor = this.myAnchor.getTarget();
        if (targetAnchor == null) {
            return;
        }
        if (targetAnchor.getTarget() == this.myAnchor) {
            this.type = 4;
            targetAnchor.getResolutionNode().type = 4;
        }
        int margin = this.myAnchor.getMargin();
        if (this.myAnchor.mType == ConstraintAnchor.Type.RIGHT || this.myAnchor.mType == ConstraintAnchor.Type.BOTTOM) {
            margin = -margin;
        }
        this.dependsOn(targetAnchor.getResolutionNode(), margin);
    }

    public void useAnchor(ConstraintAnchor anchor) {
        ResolutionNode node = anchor.getResolutionNode();
    }

    public void dependsOn(int type, ResolutionNode node, int offset) {
        this.type = type;
        this.target = node;
        this.offset = offset;
        this.target.addDependent(this);
    }

    public void dependsOn(ResolutionNode node, int offset) {
        this.target = node;
        this.offset = offset;
        this.target.addDependent(this);
    }

    public void setOpposite(ResolutionNode opposite, float oppositeOffset) {
        this.opposite = opposite;
        this.oppositeOffset = oppositeOffset;
    }

    void addResolvedValue(LinearSystem system) {
        SolverVariable sv = this.myAnchor.getSolverVariable();
        if (this.resolvedTarget == null) {
            system.addEquality(sv, (int)this.resolvedOffset);
        } else {
            SolverVariable v = system.createObjectVariable(this.resolvedTarget.myAnchor);
            system.addEquality(sv, v, (int)this.resolvedOffset, 6);
        }
    }
}

