/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets.analyzer;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.analyzer.Dependency;
import android.support.constraint.solver.widgets.analyzer.DependencyNode;
import android.support.constraint.solver.widgets.analyzer.DimensionDependency;
import android.support.constraint.solver.widgets.analyzer.HorizontalWidgetRun;
import android.support.constraint.solver.widgets.analyzer.RunGroup;
import android.support.constraint.solver.widgets.analyzer.VerticalWidgetRun;

public abstract class WidgetRun
implements Dependency {
    public int matchConstraintsType;
    ConstraintWidget widget;
    RunGroup runGroup;
    protected ConstraintWidget.DimensionBehaviour dimensionBehavior;
    DimensionDependency dimension = new DimensionDependency(this);
    public int orientation = 0;
    boolean resolved = false;
    public DependencyNode start = new DependencyNode(this);
    public DependencyNode end = new DependencyNode(this);
    protected RunType mRunType = RunType.NONE;

    public WidgetRun(ConstraintWidget widget) {
        this.widget = widget;
    }

    abstract void clear();

    abstract void apply();

    abstract void applyToWidget();

    abstract void reset();

    abstract boolean supportsWrapComputation();

    public boolean isCenterConnection() {
        DependencyNode dependency;
        int i;
        int connections = 0;
        int count = this.start.targets.size();
        for (i = 0; i < count; ++i) {
            dependency = this.start.targets.get(i);
            if (dependency.run == this) continue;
            ++connections;
        }
        count = this.end.targets.size();
        for (i = 0; i < count; ++i) {
            dependency = this.end.targets.get(i);
            if (dependency.run == this) continue;
            ++connections;
        }
        return connections >= 2;
    }

    public long wrapSize(int direction) {
        if (this.dimension.resolved) {
            long size = this.dimension.value;
            size = this.isCenterConnection() ? (size += (long)(this.start.margin - this.end.margin)) : (direction == 0 ? (size += (long)this.start.margin) : (size -= (long)this.end.margin));
            return size;
        }
        return 0L;
    }

    protected final DependencyNode getTarget(ConstraintAnchor anchor) {
        if (anchor.mTarget == null) {
            return null;
        }
        DependencyNode target = null;
        ConstraintWidget targetWidget = anchor.mTarget.mOwner;
        ConstraintAnchor.Type targetType = anchor.mTarget.mType;
        switch (targetType) {
            case LEFT: {
                HorizontalWidgetRun run = targetWidget.horizontalRun;
                target = run.start;
                break;
            }
            case RIGHT: {
                HorizontalWidgetRun run = targetWidget.horizontalRun;
                target = run.end;
                break;
            }
            case TOP: {
                VerticalWidgetRun run = targetWidget.verticalRun;
                target = run.start;
                break;
            }
            case BASELINE: {
                VerticalWidgetRun run = targetWidget.verticalRun;
                target = run.baseline;
                break;
            }
            case BOTTOM: {
                VerticalWidgetRun run = targetWidget.verticalRun;
                target = run.end;
            }
        }
        return target;
    }

    protected void updateRunCenter(Dependency dependency, ConstraintAnchor startAnchor, ConstraintAnchor endAnchor, int orientation) {
        float bias;
        DependencyNode startTarget = this.getTarget(startAnchor);
        DependencyNode endTarget = this.getTarget(endAnchor);
        if (!startTarget.resolved || !endTarget.resolved) {
            return;
        }
        int startPos = startTarget.value + startAnchor.getMargin();
        int endPos = endTarget.value - endAnchor.getMargin();
        int distance = endPos - startPos;
        if (!this.dimension.resolved && this.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            this.resolveDimension(orientation, distance);
        }
        if (!this.dimension.resolved) {
            return;
        }
        if (this.dimension.value == distance) {
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            return;
        }
        float f = bias = orientation == 0 ? this.widget.getHorizontalBiasPercent() : this.widget.getVerticalBiasPercent();
        if (startTarget == endTarget) {
            startPos = startTarget.value;
            endPos = endTarget.value;
            bias = 0.5f;
        }
        int availableDistance = endPos - startPos - this.dimension.value;
        this.start.resolve((int)(0.5f + (float)startPos + (float)availableDistance * bias));
        this.end.resolve(this.start.value + this.dimension.value);
    }

    private void resolveDimension(int orientation, int distance) {
        switch (this.matchConstraintsType) {
            case 0: {
                this.dimension.resolve(this.getLimitedDimension(distance, orientation));
                break;
            }
            case 2: {
                WidgetRun run;
                ConstraintWidget parent = this.widget.getParent();
                if (parent == null) break;
                WidgetRun widgetRun = run = orientation == 0 ? parent.horizontalRun : parent.verticalRun;
                if (!run.dimension.resolved) break;
                float percent = orientation == 0 ? this.widget.mMatchConstraintPercentWidth : this.widget.mMatchConstraintPercentHeight;
                int targetDimensionValue = run.dimension.value;
                int size = (int)(0.5f + (float)targetDimensionValue * percent);
                this.dimension.resolve(this.getLimitedDimension(size, orientation));
                break;
            }
            case 1: {
                int wrapValue = this.getLimitedDimension(this.dimension.wrapValue, orientation);
                this.dimension.resolve(Math.min(wrapValue, distance));
                break;
            }
            case 3: {
                WidgetRun run;
                if (this.widget.horizontalRun.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.widget.horizontalRun.matchConstraintsType == 3 && this.widget.verticalRun.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.widget.verticalRun.matchConstraintsType == 3) break;
                WidgetRun widgetRun = run = orientation == 0 ? this.widget.verticalRun : this.widget.horizontalRun;
                if (!run.dimension.resolved) break;
                float ratio = this.widget.getDimensionRatio();
                int value = orientation == 1 ? (int)(0.5f + (float)run.dimension.value / ratio) : (int)(0.5f + ratio * (float)run.dimension.value);
                this.dimension.resolve(value);
            }
        }
    }

    protected void updateRunStart(Dependency dependency) {
    }

    protected void updateRunEnd(Dependency dependency) {
    }

    @Override
    public void update(Dependency dependency) {
    }

    protected final int getLimitedDimension(int dimension, int orientation) {
        if (orientation == 0) {
            int max = this.widget.mMatchConstraintMaxWidth;
            int min = this.widget.mMatchConstraintMinWidth;
            int value = Math.max(min, dimension);
            if (max > 0) {
                value = Math.min(max, dimension);
            }
            if (value != dimension) {
                dimension = value;
            }
        } else {
            int max = this.widget.mMatchConstraintMaxHeight;
            int min = this.widget.mMatchConstraintMinHeight;
            int value = Math.max(min, dimension);
            if (max > 0) {
                value = Math.min(max, dimension);
            }
            if (value != dimension) {
                dimension = value;
            }
        }
        return dimension;
    }

    protected final DependencyNode getTarget(ConstraintAnchor anchor, int orientation) {
        if (anchor.mTarget == null) {
            return null;
        }
        DependencyNode target = null;
        ConstraintWidget targetWidget = anchor.mTarget.mOwner;
        WidgetRun run = orientation == 0 ? targetWidget.horizontalRun : targetWidget.verticalRun;
        ConstraintAnchor.Type targetType = anchor.mTarget.mType;
        switch (targetType) {
            case LEFT: 
            case TOP: {
                target = run.start;
                break;
            }
            case RIGHT: 
            case BOTTOM: {
                target = run.end;
            }
        }
        return target;
    }

    protected final void addTarget(DependencyNode node, DependencyNode target, int margin) {
        node.targets.add(target);
        node.margin = margin;
        target.dependencies.add(node);
    }

    protected final void addTarget(DependencyNode node, DependencyNode target, int marginFactor, DimensionDependency dimensionDependency) {
        node.targets.add(target);
        node.targets.add(this.dimension);
        node.marginFactor = marginFactor;
        node.marginDependency = dimensionDependency;
        target.dependencies.add(node);
        dimensionDependency.dependencies.add(node);
    }

    public long getWrapDimension() {
        if (this.dimension.resolved) {
            return this.dimension.value;
        }
        return 0L;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    static enum RunType {
        NONE,
        START,
        END,
        CENTER;

    }
}

