/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets.analyzer;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.analyzer.Dependency;
import android.support.constraint.solver.widgets.analyzer.DependencyNode;
import android.support.constraint.solver.widgets.analyzer.WidgetRun;
import java.util.ArrayList;

public class ChainRun
extends WidgetRun {
    ArrayList<WidgetRun> widgets = new ArrayList();
    private int chainStyle;

    public ChainRun(ConstraintWidget widget, int orientation) {
        super(widget);
        this.orientation = orientation;
        this.build();
    }

    public String toString() {
        String log = "ChainRun " + (this.orientation == 0 ? "horizontal : " : "vertical : ");
        for (WidgetRun run : this.widgets) {
            log = log + "<";
            log = log + run;
            log = log + "> ";
        }
        return log;
    }

    @Override
    boolean supportsWrapComputation() {
        int count = this.widgets.size();
        for (int i = 0; i < count; ++i) {
            WidgetRun run = this.widgets.get(i);
            if (run.supportsWrapComputation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getWrapDimension() {
        int count = this.widgets.size();
        long wrapDimension = 0L;
        for (int i = 0; i < count; ++i) {
            WidgetRun run = this.widgets.get(i);
            wrapDimension += (long)run.start.margin;
            wrapDimension += run.getWrapDimension();
            wrapDimension += (long)run.end.margin;
        }
        return wrapDimension;
    }

    private void build() {
        boolean isInRtl;
        ConstraintWidget current = this.widget;
        ConstraintWidget previous = current.getPreviousChainMember(this.orientation);
        while (previous != null) {
            current = previous;
            previous = current.getPreviousChainMember(this.orientation);
        }
        this.widget = current;
        this.widgets.add(current.getRun(this.orientation));
        ConstraintWidget next = current.getNextChainMember(this.orientation);
        while (next != null) {
            current = next;
            this.widgets.add(current.getRun(this.orientation));
            next = current.getNextChainMember(this.orientation);
        }
        for (WidgetRun run : this.widgets) {
            if (this.orientation == 0) {
                run.widget.horizontalChainRun = this;
                continue;
            }
            if (this.orientation != 1) continue;
            run.widget.verticalChainRun = this;
        }
        boolean bl = isInRtl = this.orientation == 0 && ((ConstraintWidgetContainer)this.widget.getParent()).isRtl();
        if (isInRtl && this.widgets.size() > 1) {
            this.widget = this.widgets.get((int)(this.widgets.size() - 1)).widget;
        }
        this.chainStyle = this.orientation == 0 ? this.widget.getHorizontalChainStyle() : this.widget.getVerticalChainStyle();
    }

    @Override
    void clear() {
        this.runGroup = null;
        for (WidgetRun run : this.widgets) {
            run.clear();
        }
    }

    @Override
    void reset() {
        this.start.resolved = false;
        this.end.resolved = false;
    }

    @Override
    public void update(Dependency dependency) {
        block74: {
            int gap;
            float bias;
            int position;
            int lastVisibleWidget;
            int firstVisibleWidget;
            int count;
            int numMatchConstraints;
            int size;
            int distance;
            boolean isInRtl;
            block75: {
                int dimension;
                int i;
                int numVisibleWidgets;
                block73: {
                    if (!this.start.resolved || !this.end.resolved) {
                        return;
                    }
                    ConstraintWidget parent = this.widget.getParent();
                    isInRtl = false;
                    if (parent != null && parent instanceof ConstraintWidgetContainer) {
                        isInRtl = ((ConstraintWidgetContainer)parent).isRtl();
                    }
                    distance = this.end.value - this.start.value;
                    size = 0;
                    numMatchConstraints = 0;
                    float weights = 0.0f;
                    numVisibleWidgets = 0;
                    count = this.widgets.size();
                    firstVisibleWidget = -1;
                    for (int i2 = 0; i2 < count; ++i2) {
                        WidgetRun run = this.widgets.get(i2);
                        if (run.widget.getVisibility() == 8) continue;
                        firstVisibleWidget = i2;
                        break;
                    }
                    lastVisibleWidget = -1;
                    for (int i3 = count - 1; i3 >= 0; --i3) {
                        WidgetRun run = this.widgets.get(i3);
                        if (run.widget.getVisibility() == 8) continue;
                        lastVisibleWidget = i3;
                        break;
                    }
                    for (int j = 0; j < 2; ++j) {
                        for (int i4 = 0; i4 < count; ++i4) {
                            boolean treatAsFixed;
                            WidgetRun run = this.widgets.get(i4);
                            if (run.widget.getVisibility() == 8) continue;
                            ++numVisibleWidgets;
                            if (i4 > 0 && i4 >= firstVisibleWidget) {
                                size += run.start.margin;
                            }
                            int dimension2 = run.dimension.value;
                            boolean bl = treatAsFixed = run.dimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                            if (treatAsFixed) {
                                if (this.orientation == 0 && !run.widget.horizontalRun.dimension.resolved) {
                                    return;
                                }
                                if (this.orientation == 1 && !run.widget.verticalRun.dimension.resolved) {
                                    return;
                                }
                            } else if (run.matchConstraintsType == 1 && j == 0) {
                                treatAsFixed = true;
                                dimension2 = run.dimension.wrapValue;
                                ++numMatchConstraints;
                            } else if (run.dimension.resolved) {
                                treatAsFixed = true;
                            }
                            if (!treatAsFixed) {
                                ++numMatchConstraints;
                                float weight = run.widget.mWeight[this.orientation];
                                if (weight >= 0.0f) {
                                    weights += weight;
                                }
                            } else {
                                size += dimension2;
                            }
                            if (i4 >= count - 1 || i4 >= lastVisibleWidget) continue;
                            size += -run.end.margin;
                        }
                        if (size < distance || numMatchConstraints == 0) break;
                        numVisibleWidgets = 0;
                        numMatchConstraints = 0;
                        size = 0;
                        weights = 0.0f;
                    }
                    position = this.start.value;
                    if (isInRtl) {
                        position = this.end.value;
                    }
                    if (size > distance) {
                        position = isInRtl ? (position += (int)(0.5f + (float)(size - distance) / 2.0f)) : (position -= (int)(0.5f + (float)(size - distance) / 2.0f));
                    }
                    int matchConstraintsDimension = 0;
                    if (numMatchConstraints > 0) {
                        matchConstraintsDimension = (int)(0.5f + (float)(distance - size) / (float)numMatchConstraints);
                        int appliedLimits = 0;
                        for (i = 0; i < count; ++i) {
                            int value;
                            int min;
                            int max;
                            WidgetRun run = this.widgets.get(i);
                            if (run.widget.getVisibility() == 8 || run.dimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || run.dimension.resolved) continue;
                            int dimension3 = matchConstraintsDimension;
                            if (weights > 0.0f) {
                                float weight = run.widget.mWeight[this.orientation];
                                dimension3 = (int)(0.5f + weight * (float)(distance - size) / weights);
                            }
                            if (this.orientation == 0) {
                                max = run.widget.mMatchConstraintMaxWidth;
                                min = run.widget.mMatchConstraintMinWidth;
                                value = dimension3;
                                if (run.matchConstraintsType == 1) {
                                    value = Math.min(value, run.dimension.wrapValue);
                                }
                                value = Math.max(min, value);
                                if (max > 0) {
                                    value = Math.min(max, value);
                                }
                                if (value != dimension3) {
                                    ++appliedLimits;
                                    dimension3 = value;
                                }
                            } else {
                                max = run.widget.mMatchConstraintMaxHeight;
                                min = run.widget.mMatchConstraintMinHeight;
                                value = dimension3;
                                if (run.matchConstraintsType == 1) {
                                    value = Math.min(value, run.dimension.wrapValue);
                                }
                                value = Math.max(min, value);
                                if (max > 0) {
                                    value = Math.min(max, value);
                                }
                                if (value != dimension3) {
                                    ++appliedLimits;
                                    dimension3 = value;
                                }
                            }
                            run.dimension.resolve(dimension3);
                        }
                        if (appliedLimits > 0) {
                            numMatchConstraints -= appliedLimits;
                            size = 0;
                            for (i = 0; i < count; ++i) {
                                WidgetRun run = this.widgets.get(i);
                                if (run.widget.getVisibility() == 8) continue;
                                if (i > 0 && i >= firstVisibleWidget) {
                                    size += run.start.margin;
                                }
                                size += run.dimension.value;
                                if (i >= count - 1 || i >= lastVisibleWidget) continue;
                                size += -run.end.margin;
                            }
                        }
                        if (this.chainStyle == 2 && appliedLimits == 0) {
                            this.chainStyle = 0;
                        }
                    }
                    if (size > distance) {
                        this.chainStyle = 2;
                    }
                    if (this.chainStyle != 1) break block73;
                    int gap2 = 0;
                    if (numVisibleWidgets > 1) {
                        gap2 = (distance - size) / (numVisibleWidgets - 1);
                    } else if (numVisibleWidgets == 1) {
                        gap2 = (distance - size) / 2;
                    }
                    if (numMatchConstraints > 0) {
                        gap2 = 0;
                    }
                    for (i = 0; i < count; ++i) {
                        int index = i;
                        if (isInRtl) {
                            index = count - (i + 1);
                        }
                        WidgetRun run = this.widgets.get(index);
                        if (run.widget.getVisibility() == 8) {
                            run.start.resolve(position);
                            run.end.resolve(position);
                            continue;
                        }
                        if (i > 0) {
                            position = isInRtl ? (position -= gap2) : (position += gap2);
                        }
                        if (i > 0 && i >= firstVisibleWidget) {
                            position = isInRtl ? (position -= run.start.margin) : (position += run.start.margin);
                        }
                        if (isInRtl) {
                            run.end.resolve(position);
                        } else {
                            run.start.resolve(position);
                        }
                        dimension = run.dimension.value;
                        if (run.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.matchConstraintsType == 1) {
                            dimension = run.dimension.wrapValue;
                        }
                        position = isInRtl ? (position -= dimension) : (position += dimension);
                        if (isInRtl) {
                            run.start.resolve(position);
                        } else {
                            run.end.resolve(position);
                        }
                        run.resolved = true;
                        if (i >= count - 1 || i >= lastVisibleWidget) continue;
                        if (isInRtl) {
                            position -= -run.end.margin;
                            continue;
                        }
                        position += -run.end.margin;
                    }
                    break block74;
                }
                if (this.chainStyle != 0) break block75;
                int gap3 = (distance - size) / (numVisibleWidgets + 1);
                if (numMatchConstraints > 0) {
                    gap3 = 0;
                }
                for (i = 0; i < count; ++i) {
                    int index = i;
                    if (isInRtl) {
                        index = count - (i + 1);
                    }
                    WidgetRun run = this.widgets.get(index);
                    if (run.widget.getVisibility() == 8) {
                        run.start.resolve(position);
                        run.end.resolve(position);
                        continue;
                    }
                    position = isInRtl ? (position -= gap3) : (position += gap3);
                    if (i > 0 && i >= firstVisibleWidget) {
                        position = isInRtl ? (position -= run.start.margin) : (position += run.start.margin);
                    }
                    if (isInRtl) {
                        run.end.resolve(position);
                    } else {
                        run.start.resolve(position);
                    }
                    dimension = run.dimension.value;
                    if (run.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.matchConstraintsType == 1) {
                        dimension = Math.min(dimension, run.dimension.wrapValue);
                    }
                    position = isInRtl ? (position -= dimension) : (position += dimension);
                    if (isInRtl) {
                        run.start.resolve(position);
                    } else {
                        run.end.resolve(position);
                    }
                    if (i >= count - 1 || i >= lastVisibleWidget) continue;
                    if (isInRtl) {
                        position -= -run.end.margin;
                        continue;
                    }
                    position += -run.end.margin;
                }
                break block74;
            }
            if (this.chainStyle != 2) break block74;
            float f = bias = this.orientation == 0 ? this.widget.getHorizontalBiasPercent() : this.widget.getVerticalBiasPercent();
            if (isInRtl) {
                bias = 1.0f - bias;
            }
            if ((gap = (int)(0.5f + (float)(distance - size) * bias)) < 0 || numMatchConstraints > 0) {
                gap = 0;
            }
            position = isInRtl ? (position -= gap) : (position += gap);
            for (int i = 0; i < count; ++i) {
                int index = i;
                if (isInRtl) {
                    index = count - (i + 1);
                }
                WidgetRun run = this.widgets.get(index);
                if (run.widget.getVisibility() == 8) {
                    run.start.resolve(position);
                    run.end.resolve(position);
                    continue;
                }
                if (i > 0 && i >= firstVisibleWidget) {
                    position = isInRtl ? (position -= run.start.margin) : (position += run.start.margin);
                }
                if (isInRtl) {
                    run.end.resolve(position);
                } else {
                    run.start.resolve(position);
                }
                int dimension = run.dimension.value;
                if (run.dimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && run.matchConstraintsType == 1) {
                    dimension = run.dimension.wrapValue;
                }
                position = isInRtl ? (position -= dimension) : (position += dimension);
                if (isInRtl) {
                    run.start.resolve(position);
                } else {
                    run.end.resolve(position);
                }
                if (i >= count - 1 || i >= lastVisibleWidget) continue;
                if (isInRtl) {
                    position -= -run.end.margin;
                    continue;
                }
                position += -run.end.margin;
            }
        }
    }

    @Override
    public void applyToWidget() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            WidgetRun run = this.widgets.get(i);
            run.applyToWidget();
        }
    }

    private ConstraintWidget getFirstVisibleWidget() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            WidgetRun run = this.widgets.get(i);
            if (run.widget.getVisibility() == 8) continue;
            return run.widget;
        }
        return null;
    }

    private ConstraintWidget getLastVisibleWidget() {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            WidgetRun run = this.widgets.get(i);
            if (run.widget.getVisibility() == 8) continue;
            return run.widget;
        }
        return null;
    }

    @Override
    void apply() {
        for (WidgetRun run : this.widgets) {
            run.apply();
        }
        int count = this.widgets.size();
        if (count < 1) {
            return;
        }
        ConstraintWidget firstWidget = this.widgets.get((int)0).widget;
        ConstraintWidget lastWidget = this.widgets.get((int)(count - 1)).widget;
        if (this.orientation == 0) {
            ConstraintAnchor startAnchor = firstWidget.mLeft;
            ConstraintAnchor endAnchor = lastWidget.mRight;
            DependencyNode startTarget = this.getTarget(startAnchor, 0);
            int startMargin = startAnchor.getMargin();
            ConstraintWidget firstVisibleWidget = this.getFirstVisibleWidget();
            if (firstVisibleWidget != null) {
                startMargin = firstVisibleWidget.mLeft.getMargin();
            }
            if (startTarget != null) {
                this.addTarget(this.start, startTarget, startMargin);
            }
            DependencyNode endTarget = this.getTarget(endAnchor, 0);
            int endMargin = endAnchor.getMargin();
            ConstraintWidget lastVisibleWidget = this.getLastVisibleWidget();
            if (lastVisibleWidget != null) {
                endMargin = lastVisibleWidget.mRight.getMargin();
            }
            if (endTarget != null) {
                this.addTarget(this.end, endTarget, -endMargin);
            }
        } else {
            ConstraintAnchor startAnchor = firstWidget.mTop;
            ConstraintAnchor endAnchor = lastWidget.mBottom;
            DependencyNode startTarget = this.getTarget(startAnchor, 1);
            int startMargin = startAnchor.getMargin();
            ConstraintWidget firstVisibleWidget = this.getFirstVisibleWidget();
            if (firstVisibleWidget != null) {
                startMargin = firstVisibleWidget.mTop.getMargin();
            }
            if (startTarget != null) {
                this.addTarget(this.start, startTarget, startMargin);
            }
            DependencyNode endTarget = this.getTarget(endAnchor, 1);
            int endMargin = endAnchor.getMargin();
            ConstraintWidget lastVisibleWidget = this.getLastVisibleWidget();
            if (lastVisibleWidget != null) {
                endMargin = lastVisibleWidget.mBottom.getMargin();
            }
            if (endTarget != null) {
                this.addTarget(this.end, endTarget, -endMargin);
            }
        }
        this.start.updateDelegate = this;
        this.end.updateDelegate = this;
    }
}

