/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets.analyzer;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.widgets.Analyzer;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.Helper;
import android.support.constraint.solver.widgets.Optimizer;
import android.support.constraint.solver.widgets.VirtualLayout;
import java.util.ArrayList;

public class BasicMeasure {
    private static final boolean DEBUG = false;
    private static final int MODE_SHIFT = 30;
    public static final int UNSPECIFIED = 0;
    public static final int EXACTLY = 0x40000000;
    public static final int AT_MOST = Integer.MIN_VALUE;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    public static final int FIXED = -3;
    private final ArrayList<ConstraintWidget> mVariableDimensionsWidgets = new ArrayList();
    private ConstraintWidgetContainer constraintWidgetContainer;

    public void updateHierarchy(ConstraintWidgetContainer layout) {
        this.mVariableDimensionsWidgets.clear();
        int childCount = layout.mChildren.size();
        for (int i = 0; i < childCount; ++i) {
            ConstraintWidget widget = (ConstraintWidget)layout.mChildren.get(i);
            if (widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getHorizontalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.getVerticalDimensionBehaviour() != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) continue;
            this.mVariableDimensionsWidgets.add(widget);
        }
        layout.invalidateGraph();
    }

    public BasicMeasure(ConstraintWidgetContainer constraintWidgetContainer) {
        this.constraintWidgetContainer = constraintWidgetContainer;
    }

    private void solveLinearSystem(String reason) {
        this.constraintWidgetContainer.layout();
    }

    private void measureChildren(ConstraintWidgetContainer layout) {
        int childCount = layout.mChildren.size();
        Measurer measurer = layout.getMeasurer();
        for (int i = 0; i < childCount; ++i) {
            boolean skip;
            ConstraintWidget child = (ConstraintWidget)layout.mChildren.get(i);
            if (child instanceof Guideline || child.horizontalRun.dimension.resolved && child.verticalRun.dimension.resolved) continue;
            ConstraintWidget.DimensionBehaviour widthBehavior = child.getDimensionBehaviour(0);
            ConstraintWidget.DimensionBehaviour heightBehavior = child.getDimensionBehaviour(1);
            boolean bl = skip = widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultWidth != 1 && heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultHeight != 1;
            if (skip) continue;
            measurer.measure(child, child.getHorizontalDimensionBehaviour(), child.getWidth(), child.getVerticalDimensionBehaviour(), child.getHeight());
        }
        measurer.didMeasures();
    }

    public void simpleSolverMeasure(ConstraintWidgetContainer layout, int optimizationLevel, int widthMode, int widthSize, int heightMode, int heightSize, int lastMeasureWidth, int lastMeasureHeight) {
        boolean optimize;
        Measurer measurer = layout.getMeasurer();
        int childCount = layout.mChildren.size();
        int startingWidth = layout.getWidth();
        int startingHeight = layout.getHeight();
        boolean optimizeWrap = Optimizer.enabled(optimizationLevel, 128);
        boolean bl = optimize = optimizeWrap || Optimizer.enabled(optimizationLevel, 64);
        if (optimize) {
            for (int i = 0; i < childCount; ++i) {
                boolean ratio;
                ConstraintWidget child = (ConstraintWidget)layout.mChildren.get(i);
                boolean matchWidth = child.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean matchHeight = child.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                boolean bl2 = ratio = matchWidth && matchHeight && child.getDimensionRatio() > 0.0f;
                if (child.isInHorizontalChain() && ratio) {
                    optimize = false;
                    break;
                }
                if (!child.isInVerticalChain() || !ratio) continue;
                optimize = false;
                break;
            }
        }
        if (optimize && LinearSystem.sMetrics != null) {
            ++LinearSystem.sMetrics.measures;
        }
        boolean allSolved = false;
        boolean bl3 = widthMode == 0x40000000 && heightMode == 0x40000000;
        int computations = 0;
        if (optimize &= bl3) {
            if (widthMode == 0x40000000 && heightMode == 0x40000000) {
                allSolved = layout.directMeasure(optimizeWrap);
                computations = 2;
            } else {
                int paddingLeft = layout.getX();
                int paddingTop = layout.getY();
                allSolved = layout.directMeasureSetup(optimizeWrap);
                if (widthMode == 0x40000000) {
                    allSolved &= layout.directMeasureWithOrientation(optimizeWrap, 0);
                    ++computations;
                }
                if (heightMode == 0x40000000) {
                    allSolved &= layout.directMeasureWithOrientation(optimizeWrap, 1);
                    ++computations;
                }
                layout.setX(paddingLeft);
                layout.setY(paddingTop);
            }
            if (allSolved) {
                layout.updateFromRuns(widthMode == 0x40000000, heightMode == 0x40000000);
            }
        } else {
            layout.horizontalRun.clear();
            layout.verticalRun.clear();
            for (ConstraintWidget child : layout.getChildren()) {
                child.horizontalRun.clear();
                child.verticalRun.clear();
            }
        }
        if (!allSolved || computations != 2) {
            int sizeDependentWidgetsCount;
            if (childCount > 0) {
                this.measureChildren(layout);
            }
            int optimizations = layout.getOptimizationLevel();
            layout.setOptimizationLevel(64);
            if (childCount > 0) {
                this.solveLinearSystem("First pass");
            }
            if ((sizeDependentWidgetsCount = this.mVariableDimensionsWidgets.size()) > 0) {
                boolean needSolverPass = false;
                boolean containerWrapWidth = layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                boolean containerWrapHeight = layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                int minWidth = Math.max(layout.getWidth(), this.constraintWidgetContainer.getMinWidth());
                int minHeight = Math.max(layout.getHeight(), this.constraintWidgetContainer.getMinHeight());
                for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                    ConstraintWidget widget = this.mVariableDimensionsWidgets.get(i);
                    if (widget instanceof Helper && !(widget instanceof VirtualLayout) || widget instanceof Guideline || widget.getVisibility() == 8 || widget.horizontalRun.dimension.resolved && widget.verticalRun.dimension.resolved) continue;
                    int preWidth = widget.getWidth();
                    int preHeight = widget.getHeight();
                    int preBaselineDistance = widget.getBaselineDistance();
                    needSolverPass |= measurer.deprecatedMeasure(widget);
                    int measuredWidth = widget.getWidth();
                    int measuredHeight = widget.getHeight();
                    if (measuredWidth != preWidth) {
                        widget.setWidth(measuredWidth);
                        if (containerWrapWidth && widget.getRight() > minWidth) {
                            int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                            minWidth = Math.max(minWidth, w);
                        }
                        needSolverPass = true;
                    }
                    if (measuredHeight != preHeight) {
                        widget.setHeight(measuredHeight);
                        if (containerWrapHeight && widget.getBottom() > minHeight) {
                            int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                            minHeight = Math.max(minHeight, h);
                        }
                        needSolverPass = true;
                    }
                    if (widget.hasBaseline() && preBaselineDistance != widget.getBaselineDistance()) {
                        needSolverPass = true;
                    }
                    if (!(widget instanceof VirtualLayout)) continue;
                    VirtualLayout virtualLayout = (VirtualLayout)widget;
                    needSolverPass |= virtualLayout.needSolverPass();
                }
                if (needSolverPass) {
                    layout.setWidth(startingWidth);
                    layout.setHeight(startingHeight);
                    this.solveLinearSystem("2nd pass");
                    needSolverPass = false;
                    if (layout.getWidth() < minWidth) {
                        layout.setWidth(minWidth);
                        needSolverPass = true;
                    }
                    if (layout.getHeight() < minHeight) {
                        layout.setHeight(minHeight);
                        needSolverPass = true;
                    }
                    if (needSolverPass) {
                        this.solveLinearSystem("3rd pass");
                    }
                }
            }
            layout.setOptimizationLevel(optimizations);
        }
    }

    public void solverMeasure(ConstraintWidgetContainer layout, boolean runAnalyzer, int widthMode, int widthSize, int heightMode, int heightSize, int lastMeasureWidth, int lastMeasureHeight, ArrayList<ConstraintWidget> variableDimensionsWidgets) {
        int sizeDependentWidgetsCount;
        Measurer measurer = layout.getMeasurer();
        int childCount = layout.mChildren.size();
        int startingWidth = layout.getWidth();
        int startingHeight = layout.getHeight();
        if (childCount > 0) {
            this.measureChildren(layout);
        }
        if (childCount > 0 && runAnalyzer) {
            Analyzer.determineGroups(layout);
        }
        if (layout.mGroupsWrapOptimized) {
            if (layout.mHorizontalWrapOptimized && widthMode == Integer.MIN_VALUE) {
                if (layout.mWrapFixedWidth < widthSize) {
                    layout.setWidth(layout.mWrapFixedWidth);
                }
                layout.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
            }
            if (layout.mVerticalWrapOptimized && heightMode == Integer.MIN_VALUE) {
                if (layout.mWrapFixedHeight < heightSize) {
                    layout.setHeight(layout.mWrapFixedHeight);
                }
                layout.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
            }
        }
        if ((this.constraintWidgetContainer.getOptimizationLevel() & 0x20) == 32) {
            int width = layout.getWidth();
            int height = layout.getHeight();
            if (lastMeasureWidth != width && widthMode == 0x40000000) {
                Analyzer.setPosition(layout.mWidgetGroups, 0, width);
            }
            if (lastMeasureHeight != height && heightMode == 0x40000000) {
                Analyzer.setPosition(layout.mWidgetGroups, 1, height);
            }
            if (layout.mHorizontalWrapOptimized && layout.mWrapFixedWidth > widthSize) {
                Analyzer.setPosition(layout.mWidgetGroups, 0, widthSize);
            }
            if (layout.mVerticalWrapOptimized && layout.mWrapFixedHeight > heightSize) {
                Analyzer.setPosition(layout.mWidgetGroups, 1, heightSize);
            }
            if ((this.constraintWidgetContainer.getOptimizationLevel() & 4) == 4) {
                Analyzer.setLayoutNodes(layout);
            }
        }
        if (childCount > 0) {
            this.solveLinearSystem("First pass");
        }
        if ((sizeDependentWidgetsCount = variableDimensionsWidgets.size()) > 0) {
            boolean needSolverPass = false;
            boolean containerWrapWidth = layout.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            boolean containerWrapHeight = layout.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            int minWidth = Math.max(layout.getWidth(), this.constraintWidgetContainer.getMinWidth());
            int minHeight = Math.max(layout.getHeight(), this.constraintWidgetContainer.getMinHeight());
            for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                ConstraintWidget widget = variableDimensionsWidgets.get(i);
                if (widget instanceof Helper || widget instanceof Guideline || widget.getVisibility() == 8) continue;
                int preWidth = widget.getWidth();
                int preHeight = widget.getHeight();
                int preBaselineDistance = widget.getBaselineDistance();
                needSolverPass |= measurer.deprecatedMeasure(widget);
                int measuredWidth = widget.getWidth();
                int measuredHeight = widget.getHeight();
                if (measuredWidth != preWidth) {
                    widget.setWidth(measuredWidth);
                    if (containerWrapWidth && widget.getRight() > minWidth) {
                        int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                        minWidth = Math.max(minWidth, w);
                    }
                    needSolverPass = true;
                }
                if (measuredHeight != preHeight) {
                    widget.setHeight(measuredHeight);
                    if (containerWrapHeight && widget.getBottom() > minHeight) {
                        int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                        minHeight = Math.max(minHeight, h);
                    }
                    needSolverPass = true;
                }
                if (!widget.hasBaseline() || preBaselineDistance == widget.getBaselineDistance()) continue;
                needSolverPass = true;
            }
            if (needSolverPass) {
                layout.setWidth(startingWidth);
                layout.setHeight(startingHeight);
                this.solveLinearSystem("2nd pass");
                needSolverPass = false;
                if (layout.getWidth() < minWidth) {
                    layout.setWidth(minWidth);
                    needSolverPass = true;
                }
                if (layout.getHeight() < minHeight) {
                    layout.setHeight(minHeight);
                    needSolverPass = true;
                }
                if (needSolverPass) {
                    this.solveLinearSystem("3rd pass");
                }
            }
        }
    }

    public static class Measure {
        public ConstraintWidget.DimensionBehaviour horizontalBehavior;
        public ConstraintWidget.DimensionBehaviour verticalBehavior;
        public int horizontalDimension;
        public int verticalDimension;
        public int measuredWidth;
        public int measuredHeight;
        public int measuredBaseline;
    }

    public static interface Measurer {
        public void measure(ConstraintWidget var1, Measure var2);

        public void measure(ConstraintWidget var1, ConstraintWidget.DimensionBehaviour var2, int var3, ConstraintWidget.DimensionBehaviour var4, int var5);

        public boolean deprecatedMeasure(ConstraintWidget var1);

        public void didMeasures();
    }

    public static enum MeasureType {

    }
}

