/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.constraint.ConstraintSet;
import android.support.constraint.Guideline;
import android.support.constraint.R;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public class ConstraintLayout
extends ViewGroup {
    static final boolean ALLOWS_EMBEDDED = false;
    public static final String VERSION = "ConstraintLayout-1.0.0";
    private static final String TAG = "ConstraintLayout";
    private static final boolean SIMPLE_LAYOUT = true;
    SparseArray<View> mChildrenByIds = new SparseArray();
    private final ArrayList<ConstraintWidget> mVariableDimensionsWidgets = new ArrayList(100);
    ConstraintWidgetContainer mLayoutWidget = new ConstraintWidgetContainer();
    private int mMinWidth = 0;
    private int mMinHeight = 0;
    private int mMaxWidth = Integer.MAX_VALUE;
    private int mMaxHeight = Integer.MAX_VALUE;
    private boolean mDirtyHierarchy = true;
    private int mOptimizationLevel = 2;
    private ConstraintSet mConstraintSet = null;

    public ConstraintLayout(Context context) {
        super(context);
        this.init(null);
    }

    public ConstraintLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ConstraintLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void setId(int id) {
        this.mChildrenByIds.remove(this.getId());
        super.setId(id);
        this.mChildrenByIds.put(this.getId(), (Object)this);
    }

    private void init(AttributeSet attrs) {
        this.mLayoutWidget.setCompanionWidget((Object)this);
        this.mChildrenByIds.put(this.getId(), (Object)this);
        this.mConstraintSet = null;
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ConstraintLayout_Layout_android_minWidth) {
                    this.mMinWidth = a.getDimensionPixelOffset(attr, this.mMinWidth);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_minHeight) {
                    this.mMinHeight = a.getDimensionPixelOffset(attr, this.mMinHeight);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_maxWidth) {
                    this.mMaxWidth = a.getDimensionPixelOffset(attr, this.mMaxWidth);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_maxHeight) {
                    this.mMaxHeight = a.getDimensionPixelOffset(attr, this.mMaxHeight);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_optimizationLevel) {
                    this.mOptimizationLevel = a.getInt(attr, this.mOptimizationLevel);
                    continue;
                }
                if (attr != R.styleable.ConstraintLayout_Layout_constraintSet) continue;
                int id = a.getResourceId(attr, 0);
                this.mConstraintSet = new ConstraintSet();
                this.mConstraintSet.load(this.getContext(), id);
            }
            a.recycle();
        }
        this.mLayoutWidget.setOptimizationLevel(this.mOptimizationLevel);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        if (Build.VERSION.SDK_INT < 14) {
            this.onViewAdded(child);
        }
    }

    public void removeView(View view) {
        super.removeView(view);
        if (Build.VERSION.SDK_INT < 14) {
            this.onViewRemoved(view);
        }
    }

    public void onViewAdded(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onViewAdded(view);
        }
        ConstraintWidget widget = this.getViewWidget(view);
        if (view instanceof Guideline && !(widget instanceof android.support.constraint.solver.widgets.Guideline)) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            layoutParams.widget = new android.support.constraint.solver.widgets.Guideline();
            layoutParams.isGuideline = true;
            ((android.support.constraint.solver.widgets.Guideline)layoutParams.widget).setOrientation(layoutParams.orientation);
            widget = layoutParams.widget;
        }
        this.mChildrenByIds.put(view.getId(), (Object)view);
        this.mDirtyHierarchy = true;
    }

    public void onViewRemoved(View view) {
        if (Build.VERSION.SDK_INT >= 14) {
            super.onViewRemoved(view);
        }
        this.mChildrenByIds.remove(view.getId());
        this.mLayoutWidget.remove(this.getViewWidget(view));
        this.mDirtyHierarchy = true;
    }

    public void setMinWidth(int value) {
        if (value == this.mMinWidth) {
            return;
        }
        this.mMinWidth = value;
        this.requestLayout();
    }

    public void setMinHeight(int value) {
        if (value == this.mMinHeight) {
            return;
        }
        this.mMinHeight = value;
        this.requestLayout();
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public void setMaxWidth(int value) {
        if (value == this.mMaxWidth) {
            return;
        }
        this.mMaxWidth = value;
        this.requestLayout();
    }

    public void setMaxHeight(int value) {
        if (value == this.mMaxHeight) {
            return;
        }
        this.mMaxHeight = value;
        this.requestLayout();
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    private void updateHierarchy() {
        int count = this.getChildCount();
        boolean recompute = false;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!child.isLayoutRequested()) continue;
            recompute = true;
            break;
        }
        if (recompute) {
            this.mVariableDimensionsWidgets.clear();
            this.setChildrenConstraints();
        }
    }

    private void setChildrenConstraints() {
        if (this.mConstraintSet != null) {
            this.mConstraintSet.applyToInternal(this);
        }
        int count = this.getChildCount();
        this.mLayoutWidget.removeAllChildren();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget target;
            View child = this.getChildAt(i);
            ConstraintWidget widget = this.getViewWidget(child);
            if (widget == null) continue;
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            widget.reset();
            widget.setVisibility(child.getVisibility());
            widget.setCompanionWidget((Object)child);
            this.mLayoutWidget.add(widget);
            if (!layoutParams.verticalDimensionFixed || !layoutParams.horizontalDimensionFixed) {
                this.mVariableDimensionsWidgets.add(widget);
            }
            if (layoutParams.isGuideline) {
                android.support.constraint.solver.widgets.Guideline guideline = (android.support.constraint.solver.widgets.Guideline)widget;
                if (layoutParams.guideBegin != -1) {
                    guideline.setGuideBegin(layoutParams.guideBegin);
                }
                if (layoutParams.guideEnd != -1) {
                    guideline.setGuideEnd(layoutParams.guideEnd);
                }
                if (layoutParams.guidePercent == -1.0f) continue;
                guideline.setGuidePercent(layoutParams.guidePercent);
                continue;
            }
            if (layoutParams.resolvedLeftToLeft == -1 && layoutParams.resolvedLeftToRight == -1 && layoutParams.resolvedRightToLeft == -1 && layoutParams.resolvedRightToRight == -1 && layoutParams.topToTop == -1 && layoutParams.topToBottom == -1 && layoutParams.bottomToTop == -1 && layoutParams.bottomToBottom == -1 && layoutParams.baselineToBaseline == -1 && layoutParams.editorAbsoluteX == -1 && layoutParams.editorAbsoluteY == -1 && layoutParams.width != -1 && layoutParams.height != -1) continue;
            int resolvedLeftToLeft = layoutParams.resolvedLeftToLeft;
            int resolvedLeftToRight = layoutParams.resolvedLeftToRight;
            int resolvedRightToLeft = layoutParams.resolvedRightToLeft;
            int resolvedRightToRight = layoutParams.resolvedRightToRight;
            int resolveGoneLeftMargin = layoutParams.resolveGoneLeftMargin;
            int resolveGoneRightMargin = layoutParams.resolveGoneRightMargin;
            float resolvedHorizontalBias = layoutParams.resolvedHorizontalBias;
            if (Build.VERSION.SDK_INT < 17) {
                resolvedLeftToLeft = layoutParams.leftToLeft;
                resolvedLeftToRight = layoutParams.leftToRight;
                resolvedRightToLeft = layoutParams.rightToLeft;
                resolvedRightToRight = layoutParams.rightToRight;
                resolveGoneLeftMargin = layoutParams.goneLeftMargin;
                resolveGoneRightMargin = layoutParams.goneRightMargin;
                resolvedHorizontalBias = layoutParams.horizontalBias;
                if (resolvedLeftToLeft == -1 && resolvedLeftToRight == -1) {
                    if (layoutParams.startToStart != -1) {
                        resolvedLeftToLeft = layoutParams.startToStart;
                    } else if (layoutParams.startToEnd != -1) {
                        resolvedLeftToRight = layoutParams.startToEnd;
                    }
                }
                if (resolvedRightToLeft == -1 && resolvedRightToRight == -1) {
                    if (layoutParams.endToStart != -1) {
                        resolvedRightToLeft = layoutParams.endToStart;
                    } else if (layoutParams.endToEnd != -1) {
                        resolvedRightToRight = layoutParams.endToEnd;
                    }
                }
            }
            if (resolvedLeftToLeft != -1) {
                target = this.getTargetWidget(resolvedLeftToLeft);
                if (target != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.LEFT, target, ConstraintAnchor.Type.LEFT, layoutParams.leftMargin, resolveGoneLeftMargin);
                }
            } else if (resolvedLeftToRight != -1 && (target = this.getTargetWidget(resolvedLeftToRight)) != null) {
                widget.immediateConnect(ConstraintAnchor.Type.LEFT, target, ConstraintAnchor.Type.RIGHT, layoutParams.leftMargin, resolveGoneLeftMargin);
            }
            if (resolvedRightToLeft != -1) {
                target = this.getTargetWidget(resolvedRightToLeft);
                if (target != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.RIGHT, target, ConstraintAnchor.Type.LEFT, layoutParams.rightMargin, resolveGoneRightMargin);
                }
            } else if (resolvedRightToRight != -1 && (target = this.getTargetWidget(resolvedRightToRight)) != null) {
                widget.immediateConnect(ConstraintAnchor.Type.RIGHT, target, ConstraintAnchor.Type.RIGHT, layoutParams.rightMargin, resolveGoneRightMargin);
            }
            if (layoutParams.topToTop != -1) {
                target = this.getTargetWidget(layoutParams.topToTop);
                if (target != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.TOP, target, ConstraintAnchor.Type.TOP, layoutParams.topMargin, layoutParams.goneTopMargin);
                }
            } else if (layoutParams.topToBottom != -1 && (target = this.getTargetWidget(layoutParams.topToBottom)) != null) {
                widget.immediateConnect(ConstraintAnchor.Type.TOP, target, ConstraintAnchor.Type.BOTTOM, layoutParams.topMargin, layoutParams.goneTopMargin);
            }
            if (layoutParams.bottomToTop != -1) {
                target = this.getTargetWidget(layoutParams.bottomToTop);
                if (target != null) {
                    widget.immediateConnect(ConstraintAnchor.Type.BOTTOM, target, ConstraintAnchor.Type.TOP, layoutParams.bottomMargin, layoutParams.goneBottomMargin);
                }
            } else if (layoutParams.bottomToBottom != -1 && (target = this.getTargetWidget(layoutParams.bottomToBottom)) != null) {
                widget.immediateConnect(ConstraintAnchor.Type.BOTTOM, target, ConstraintAnchor.Type.BOTTOM, layoutParams.bottomMargin, layoutParams.goneBottomMargin);
            }
            if (layoutParams.baselineToBaseline != -1) {
                View view = (View)this.mChildrenByIds.get(layoutParams.baselineToBaseline);
                ConstraintWidget target2 = this.getTargetWidget(layoutParams.baselineToBaseline);
                if (target2 != null && view != null && view.getLayoutParams() instanceof LayoutParams) {
                    LayoutParams targetParams = (LayoutParams)view.getLayoutParams();
                    layoutParams.needsBaseline = true;
                    targetParams.needsBaseline = true;
                    ConstraintAnchor baseline = widget.getAnchor(ConstraintAnchor.Type.BASELINE);
                    ConstraintAnchor targetBaseline = target2.getAnchor(ConstraintAnchor.Type.BASELINE);
                    baseline.connect(targetBaseline, 0, -1, ConstraintAnchor.Strength.STRONG, 0, true);
                    widget.getAnchor(ConstraintAnchor.Type.TOP).reset();
                    widget.getAnchor(ConstraintAnchor.Type.BOTTOM).reset();
                }
            }
            if (resolvedHorizontalBias >= 0.0f && resolvedHorizontalBias != 0.5f) {
                widget.setHorizontalBiasPercent(resolvedHorizontalBias);
            }
            if (layoutParams.verticalBias >= 0.0f && layoutParams.verticalBias != 0.5f) {
                widget.setVerticalBiasPercent(layoutParams.verticalBias);
            }
            if (this.isInEditMode() && (layoutParams.editorAbsoluteX != -1 || layoutParams.editorAbsoluteY != -1)) {
                widget.setOrigin(layoutParams.editorAbsoluteX, layoutParams.editorAbsoluteY);
            }
            if (!layoutParams.horizontalDimensionFixed) {
                if (layoutParams.width == -1) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.LEFT).mMargin = layoutParams.leftMargin;
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.RIGHT).mMargin = layoutParams.rightMargin;
                } else {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    widget.setWidth(0);
                }
            } else {
                widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                widget.setWidth(layoutParams.width);
            }
            if (!layoutParams.verticalDimensionFixed) {
                if (layoutParams.height == -1) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.TOP).mMargin = layoutParams.topMargin;
                    widget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.BOTTOM).mMargin = layoutParams.bottomMargin;
                } else {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    widget.setHeight(0);
                }
            } else {
                widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                widget.setHeight(layoutParams.height);
            }
            if (layoutParams.dimensionRatio != null) {
                widget.setDimensionRatio(layoutParams.dimensionRatio);
            }
            widget.setHorizontalWeight(layoutParams.horizontalWeight);
            widget.setVerticalWeight(layoutParams.verticalWeight);
            widget.setHorizontalChainStyle(layoutParams.horizontalChainStyle);
            widget.setVerticalChainStyle(layoutParams.verticalChainStyle);
            widget.setHorizontalMatchStyle(layoutParams.matchConstraintDefaultWidth, layoutParams.matchConstraintMinWidth, layoutParams.matchConstraintMaxWidth);
            widget.setVerticalMatchStyle(layoutParams.matchConstraintDefaultHeight, layoutParams.matchConstraintMinHeight, layoutParams.matchConstraintMaxHeight);
        }
    }

    private final ConstraintWidget getTargetWidget(int id) {
        if (id == 0) {
            return this.mLayoutWidget;
        }
        View view = (View)this.mChildrenByIds.get(id);
        if (view == this) {
            return this.mLayoutWidget;
        }
        return view == null ? null : ((LayoutParams)view.getLayoutParams()).widget;
    }

    private final ConstraintWidget getViewWidget(View view) {
        if (view == this) {
            return this.mLayoutWidget;
        }
        return view == null ? null : ((LayoutParams)view.getLayoutParams()).widget;
    }

    private void internalMeasureChildren(int parentWidthSpec, int parentHeightSpec) {
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        int widgetsCount = this.getChildCount();
        for (int i = 0; i < widgetsCount; ++i) {
            int baseline;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            ConstraintWidget widget = params.widget;
            if (params.isGuideline) continue;
            int width = params.width;
            int height = params.height;
            boolean doMeasure = params.horizontalDimensionFixed || params.verticalDimensionFixed || !params.horizontalDimensionFixed && params.matchConstraintDefaultWidth == 1 || params.width == -1 || !params.verticalDimensionFixed && (params.matchConstraintDefaultHeight == 1 || params.height == -1);
            boolean didWrapMeasureWidth = false;
            boolean didWrapMeasureHeight = false;
            if (doMeasure) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                if (width == 0 || width == -1) {
                    childWidthMeasureSpec = ConstraintLayout.getChildMeasureSpec((int)parentWidthSpec, (int)widthPadding, (int)-2);
                    didWrapMeasureWidth = true;
                } else {
                    childWidthMeasureSpec = ConstraintLayout.getChildMeasureSpec((int)parentWidthSpec, (int)widthPadding, (int)width);
                }
                if (height == 0 || height == -1) {
                    childHeightMeasureSpec = ConstraintLayout.getChildMeasureSpec((int)parentHeightSpec, (int)heightPadding, (int)-2);
                    didWrapMeasureHeight = true;
                } else {
                    childHeightMeasureSpec = ConstraintLayout.getChildMeasureSpec((int)parentHeightSpec, (int)heightPadding, (int)height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                width = child.getMeasuredWidth();
                height = child.getMeasuredHeight();
            }
            widget.setWidth(width);
            widget.setHeight(height);
            if (didWrapMeasureWidth) {
                widget.setWrapWidth(width);
            }
            if (didWrapMeasureHeight) {
                widget.setWrapHeight(height);
            }
            if (!params.needsBaseline || (baseline = child.getBaseline()) == -1) continue;
            widget.setBaselineDistance(baseline);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        this.mLayoutWidget.setX(paddingLeft);
        this.mLayoutWidget.setY(paddingTop);
        this.setSelfDimensionBehaviour(widthMeasureSpec, heightMeasureSpec);
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            this.updateHierarchy();
        }
        this.internalMeasureChildren(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() > 0) {
            this.solveLinearSystem();
        }
        int childState = 0;
        int sizeDependentWidgetsCount = this.mVariableDimensionsWidgets.size();
        int heightPadding = paddingTop + this.getPaddingBottom();
        int widthPadding = paddingLeft + this.getPaddingRight();
        if (sizeDependentWidgetsCount > 0) {
            boolean needSolverPass = false;
            boolean containerWrapWidth = this.mLayoutWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            boolean containerWrapHeight = this.mLayoutWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            for (int i = 0; i < sizeDependentWidgetsCount; ++i) {
                int baseline;
                View child;
                ConstraintWidget widget = this.mVariableDimensionsWidgets.get(i);
                if (widget instanceof android.support.constraint.solver.widgets.Guideline || (child = (View)widget.getCompanionWidget()) == null || child.getVisibility() == 8) continue;
                int widthSpec = 0;
                int heightSpec = 0;
                LayoutParams params = (LayoutParams)child.getLayoutParams();
                widthSpec = params.width == -2 ? ConstraintLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)widthPadding, (int)params.width) : View.MeasureSpec.makeMeasureSpec((int)widget.getWidth(), (int)0x40000000);
                heightSpec = params.height == -2 ? ConstraintLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)heightPadding, (int)params.height) : View.MeasureSpec.makeMeasureSpec((int)widget.getHeight(), (int)0x40000000);
                child.measure(widthSpec, heightSpec);
                int measuredWidth = child.getMeasuredWidth();
                int measuredHeight = child.getMeasuredHeight();
                if (measuredWidth != widget.getWidth()) {
                    widget.setWidth(measuredWidth);
                    if (containerWrapWidth && widget.getRight() > this.mLayoutWidget.getWidth()) {
                        int w = widget.getRight() + widget.getAnchor(ConstraintAnchor.Type.RIGHT).getMargin();
                        this.mLayoutWidget.setWidth(Math.max(this.mMinWidth, w));
                    }
                    needSolverPass = true;
                }
                if (measuredHeight != widget.getHeight()) {
                    widget.setHeight(measuredHeight);
                    if (containerWrapHeight && widget.getBottom() > this.mLayoutWidget.getHeight()) {
                        int h = widget.getBottom() + widget.getAnchor(ConstraintAnchor.Type.BOTTOM).getMargin();
                        this.mLayoutWidget.setHeight(Math.max(this.mMinHeight, h));
                    }
                    needSolverPass = true;
                }
                if (params.needsBaseline && (baseline = child.getBaseline()) != -1 && baseline != widget.getBaselineDistance()) {
                    widget.setBaselineDistance(baseline);
                    needSolverPass = true;
                }
                if (Build.VERSION.SDK_INT < 11) continue;
                childState = ConstraintLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            }
            if (needSolverPass) {
                this.solveLinearSystem();
            }
        }
        int androidLayoutWidth = this.mLayoutWidget.getWidth() + widthPadding;
        int androidLayoutHeight = this.mLayoutWidget.getHeight() + heightPadding;
        if (Build.VERSION.SDK_INT >= 11) {
            int resolvedWidthSize = ConstraintLayout.resolveSizeAndState((int)androidLayoutWidth, (int)widthMeasureSpec, (int)childState);
            int resolvedHeightSize = ConstraintLayout.resolveSizeAndState((int)androidLayoutHeight, (int)heightMeasureSpec, (int)(childState << 16));
            resolvedWidthSize = Math.min(this.mMaxWidth, resolvedWidthSize);
            resolvedHeightSize = Math.min(this.mMaxHeight, resolvedHeightSize);
            resolvedWidthSize &= 0xFFFFFF;
            resolvedHeightSize &= 0xFFFFFF;
            if (this.mLayoutWidget.isWidthMeasuredTooSmall()) {
                resolvedWidthSize |= 0x1000000;
            }
            if (this.mLayoutWidget.isHeightMeasuredTooSmall()) {
                resolvedHeightSize |= 0x1000000;
            }
            this.setMeasuredDimension(resolvedWidthSize, resolvedHeightSize);
        } else {
            this.setMeasuredDimension(androidLayoutWidth, androidLayoutHeight);
        }
    }

    private void setSelfDimensionBehaviour(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightPadding = this.getPaddingTop() + this.getPaddingBottom();
        int widthPadding = this.getPaddingLeft() + this.getPaddingRight();
        ConstraintWidget.DimensionBehaviour widthBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
        ConstraintWidget.DimensionBehaviour heightBehaviour = ConstraintWidget.DimensionBehaviour.FIXED;
        int desiredWidth = 0;
        int desiredHeight = 0;
        ViewGroup.LayoutParams params = this.getLayoutParams();
        switch (widthMode) {
            case -2147483648: {
                widthBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                desiredWidth = widthSize;
                break;
            }
            case 0: {
                widthBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                break;
            }
            case 0x40000000: {
                desiredWidth = Math.min(this.mMaxWidth, widthSize) - widthPadding;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                heightBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                desiredHeight = heightSize;
                break;
            }
            case 0: {
                heightBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                break;
            }
            case 0x40000000: {
                desiredHeight = Math.min(this.mMaxHeight, heightSize) - heightPadding;
            }
        }
        this.mLayoutWidget.setMinWidth(0);
        this.mLayoutWidget.setMinHeight(0);
        this.mLayoutWidget.setHorizontalDimensionBehaviour(widthBehaviour);
        this.mLayoutWidget.setWidth(desiredWidth);
        this.mLayoutWidget.setVerticalDimensionBehaviour(heightBehaviour);
        this.mLayoutWidget.setHeight(desiredHeight);
        this.mLayoutWidget.setMinWidth(this.mMinWidth - this.getPaddingLeft() - this.getPaddingRight());
        this.mLayoutWidget.setMinHeight(this.mMinHeight - this.getPaddingTop() - this.getPaddingBottom());
    }

    protected void solveLinearSystem() {
        this.mLayoutWidget.layout();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int widgetsCount = this.getChildCount();
        boolean isInEditMode = this.isInEditMode();
        for (int i = 0; i < widgetsCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 && !params.isGuideline && !isInEditMode) continue;
            ConstraintWidget widget = params.widget;
            int l = widget.getDrawX();
            int t = widget.getDrawY();
            int r = l + widget.getWidth();
            int b = t + widget.getHeight();
            child.layout(l, t, r, b);
        }
    }

    public void setOptimizationLevel(int level) {
        this.mLayoutWidget.setOptimizationLevel(level);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void setConstraintSet(ConstraintSet set) {
        this.mConstraintSet = set;
    }

    public void requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public static final int MATCH_CONSTRAINT = 0;
        public static final int PARENT_ID = 0;
        public static final int UNSET = -1;
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL = 1;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int TOP = 3;
        public static final int BOTTOM = 4;
        public static final int BASELINE = 5;
        public static final int START = 6;
        public static final int END = 7;
        public static final int MATCH_CONSTRAINT_WRAP = 1;
        public static final int MATCH_CONSTRAINT_SPREAD = 0;
        public static final int CHAIN_SPREAD = 0;
        public static final int CHAIN_SPREAD_INSIDE = 1;
        public static final int CHAIN_PACKED = 2;
        public int guideBegin = -1;
        public int guideEnd = -1;
        public float guidePercent = -1.0f;
        public int leftToLeft = -1;
        public int leftToRight = -1;
        public int rightToLeft = -1;
        public int rightToRight = -1;
        public int topToTop = -1;
        public int topToBottom = -1;
        public int bottomToTop = -1;
        public int bottomToBottom = -1;
        public int baselineToBaseline = -1;
        public int startToEnd = -1;
        public int startToStart = -1;
        public int endToStart = -1;
        public int endToEnd = -1;
        public int goneLeftMargin = -1;
        public int goneTopMargin = -1;
        public int goneRightMargin = -1;
        public int goneBottomMargin = -1;
        public int goneStartMargin = -1;
        public int goneEndMargin = -1;
        public float horizontalBias = 0.5f;
        public float verticalBias = 0.5f;
        public String dimensionRatio = null;
        float dimensionRatioValue = 0.0f;
        int dimensionRatioSide = 1;
        public float horizontalWeight = 0.0f;
        public float verticalWeight = 0.0f;
        public int horizontalChainStyle = 0;
        public int verticalChainStyle = 0;
        public int matchConstraintDefaultWidth = 0;
        public int matchConstraintDefaultHeight = 0;
        public int matchConstraintMinWidth = 0;
        public int matchConstraintMinHeight = 0;
        public int matchConstraintMaxWidth = 0;
        public int matchConstraintMaxHeight = 0;
        public int editorAbsoluteX = -1;
        public int editorAbsoluteY = -1;
        public int orientation = -1;
        boolean horizontalDimensionFixed = true;
        boolean verticalDimensionFixed = true;
        boolean needsBaseline = false;
        boolean isGuideline = false;
        int resolvedLeftToLeft = -1;
        int resolvedLeftToRight = -1;
        int resolvedRightToLeft = -1;
        int resolvedRightToRight = -1;
        int resolveGoneLeftMargin = -1;
        int resolveGoneRightMargin = -1;
        float resolvedHorizontalBias = 0.5f;
        ConstraintWidget widget = new ConstraintWidget();

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.guideBegin = source.guideBegin;
            this.guideEnd = source.guideEnd;
            this.guidePercent = source.guidePercent;
            this.leftToLeft = source.leftToLeft;
            this.leftToRight = source.leftToRight;
            this.rightToLeft = source.rightToLeft;
            this.rightToRight = source.rightToRight;
            this.topToTop = source.topToTop;
            this.topToBottom = source.topToBottom;
            this.bottomToTop = source.bottomToTop;
            this.bottomToBottom = source.bottomToBottom;
            this.baselineToBaseline = source.baselineToBaseline;
            this.startToEnd = source.startToEnd;
            this.startToStart = source.startToStart;
            this.endToStart = source.endToStart;
            this.endToEnd = source.endToEnd;
            this.goneLeftMargin = source.goneLeftMargin;
            this.goneTopMargin = source.goneTopMargin;
            this.goneRightMargin = source.goneRightMargin;
            this.goneBottomMargin = source.goneBottomMargin;
            this.goneStartMargin = source.goneStartMargin;
            this.goneEndMargin = source.goneEndMargin;
            this.horizontalBias = source.horizontalBias;
            this.verticalBias = source.verticalBias;
            this.dimensionRatio = source.dimensionRatio;
            this.dimensionRatioValue = source.dimensionRatioValue;
            this.dimensionRatioSide = source.dimensionRatioSide;
            this.horizontalWeight = source.horizontalWeight;
            this.verticalWeight = source.verticalWeight;
            this.horizontalChainStyle = source.horizontalChainStyle;
            this.verticalChainStyle = source.verticalChainStyle;
            this.matchConstraintDefaultWidth = source.matchConstraintDefaultWidth;
            this.matchConstraintDefaultHeight = source.matchConstraintDefaultHeight;
            this.matchConstraintMinWidth = source.matchConstraintMinWidth;
            this.matchConstraintMaxWidth = source.matchConstraintMaxWidth;
            this.matchConstraintMinHeight = source.matchConstraintMinHeight;
            this.matchConstraintMaxHeight = source.matchConstraintMaxHeight;
            this.editorAbsoluteX = source.editorAbsoluteX;
            this.editorAbsoluteY = source.editorAbsoluteY;
            this.orientation = source.orientation;
            this.horizontalDimensionFixed = source.horizontalDimensionFixed;
            this.verticalDimensionFixed = source.verticalDimensionFixed;
            this.needsBaseline = source.needsBaseline;
            this.isGuideline = source.isGuideline;
            this.resolvedLeftToLeft = source.resolvedLeftToLeft;
            this.resolvedLeftToRight = source.resolvedLeftToRight;
            this.resolvedRightToLeft = source.resolvedRightToLeft;
            this.resolvedRightToRight = source.resolvedRightToRight;
            this.resolveGoneLeftMargin = source.resolveGoneLeftMargin;
            this.resolveGoneRightMargin = source.resolveGoneRightMargin;
            this.resolvedHorizontalBias = source.resolvedHorizontalBias;
            this.widget = source.widget;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintLeft_toLeftOf) {
                    this.leftToLeft = a.getResourceId(attr, this.leftToLeft);
                    if (this.leftToLeft != -1) continue;
                    this.leftToLeft = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintLeft_toRightOf) {
                    this.leftToRight = a.getResourceId(attr, this.leftToRight);
                    if (this.leftToRight != -1) continue;
                    this.leftToRight = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintRight_toLeftOf) {
                    this.rightToLeft = a.getResourceId(attr, this.rightToLeft);
                    if (this.rightToLeft != -1) continue;
                    this.rightToLeft = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintRight_toRightOf) {
                    this.rightToRight = a.getResourceId(attr, this.rightToRight);
                    if (this.rightToRight != -1) continue;
                    this.rightToRight = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintTop_toTopOf) {
                    this.topToTop = a.getResourceId(attr, this.topToTop);
                    if (this.topToTop != -1) continue;
                    this.topToTop = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintTop_toBottomOf) {
                    this.topToBottom = a.getResourceId(attr, this.topToBottom);
                    if (this.topToBottom != -1) continue;
                    this.topToBottom = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintBottom_toTopOf) {
                    this.bottomToTop = a.getResourceId(attr, this.bottomToTop);
                    if (this.bottomToTop != -1) continue;
                    this.bottomToTop = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintBottom_toBottomOf) {
                    this.bottomToBottom = a.getResourceId(attr, this.bottomToBottom);
                    if (this.bottomToBottom != -1) continue;
                    this.bottomToBottom = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_toBaselineOf) {
                    this.baselineToBaseline = a.getResourceId(attr, this.baselineToBaseline);
                    if (this.baselineToBaseline != -1) continue;
                    this.baselineToBaseline = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_editor_absoluteX) {
                    this.editorAbsoluteX = a.getDimensionPixelOffset(attr, this.editorAbsoluteX);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_editor_absoluteY) {
                    this.editorAbsoluteY = a.getDimensionPixelOffset(attr, this.editorAbsoluteY);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintGuide_begin) {
                    this.guideBegin = a.getDimensionPixelOffset(attr, this.guideBegin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintGuide_end) {
                    this.guideEnd = a.getDimensionPixelOffset(attr, this.guideEnd);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintGuide_percent) {
                    this.guidePercent = a.getFloat(attr, this.guidePercent);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_android_orientation) {
                    this.orientation = a.getInt(attr, this.orientation);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintStart_toEndOf) {
                    this.startToEnd = a.getResourceId(attr, this.startToEnd);
                    if (this.startToEnd != -1) continue;
                    this.startToEnd = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintStart_toStartOf) {
                    this.startToStart = a.getResourceId(attr, this.startToStart);
                    if (this.startToStart != -1) continue;
                    this.startToStart = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintEnd_toStartOf) {
                    this.endToStart = a.getResourceId(attr, this.endToStart);
                    if (this.endToStart != -1) continue;
                    this.endToStart = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintEnd_toEndOf) {
                    this.endToEnd = a.getResourceId(attr, this.endToEnd);
                    if (this.endToEnd != -1) continue;
                    this.endToEnd = a.getInt(attr, -1);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_goneMarginLeft) {
                    this.goneLeftMargin = a.getDimensionPixelSize(attr, this.goneLeftMargin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_goneMarginTop) {
                    this.goneTopMargin = a.getDimensionPixelSize(attr, this.goneTopMargin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_goneMarginRight) {
                    this.goneRightMargin = a.getDimensionPixelSize(attr, this.goneRightMargin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_goneMarginBottom) {
                    this.goneBottomMargin = a.getDimensionPixelSize(attr, this.goneBottomMargin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_goneMarginStart) {
                    this.goneStartMargin = a.getDimensionPixelSize(attr, this.goneStartMargin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_goneMarginEnd) {
                    this.goneEndMargin = a.getDimensionPixelSize(attr, this.goneEndMargin);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_bias) {
                    this.horizontalBias = a.getFloat(attr, this.horizontalBias);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintVertical_bias) {
                    this.verticalBias = a.getFloat(attr, this.verticalBias);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintDimensionRatio) {
                    this.dimensionRatio = a.getString(attr);
                    this.dimensionRatioValue = Float.NaN;
                    this.dimensionRatioSide = -1;
                    if (this.dimensionRatio == null) continue;
                    int len = this.dimensionRatio.length();
                    int commaIndex = this.dimensionRatio.indexOf(44);
                    if (commaIndex > 0 && commaIndex < len - 1) {
                        String dimension = this.dimensionRatio.substring(0, commaIndex);
                        if (dimension.equalsIgnoreCase("W")) {
                            this.dimensionRatioSide = 0;
                        } else if (dimension.equalsIgnoreCase("H")) {
                            this.dimensionRatioSide = 1;
                        }
                        ++commaIndex;
                    } else {
                        commaIndex = 0;
                    }
                    int colonIndex = this.dimensionRatio.indexOf(58);
                    if (colonIndex >= 0 && colonIndex < len - 1) {
                        String nominator = this.dimensionRatio.substring(commaIndex, colonIndex);
                        String denominator = this.dimensionRatio.substring(colonIndex + 1);
                        if (nominator.length() <= 0 || denominator.length() <= 0) continue;
                        try {
                            float nominatorValue = Float.parseFloat(nominator);
                            float denominatorValue = Float.parseFloat(denominator);
                            if (!(nominatorValue > 0.0f) || !(denominatorValue > 0.0f)) continue;
                            if (this.dimensionRatioSide == 1) {
                                this.dimensionRatioValue = Math.abs(denominatorValue / nominatorValue);
                                continue;
                            }
                            this.dimensionRatioValue = Math.abs(nominatorValue / denominatorValue);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    String r = this.dimensionRatio.substring(commaIndex);
                    if (r.length() <= 0) continue;
                    try {
                        this.dimensionRatioValue = Float.parseFloat(r);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_weight) {
                    this.horizontalWeight = a.getFloat(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintVertical_weight) {
                    this.verticalWeight = a.getFloat(attr, 0.0f);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_chainStyle) {
                    this.horizontalChainStyle = a.getInt(attr, 0);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintVertical_chainStyle) {
                    this.verticalChainStyle = a.getInt(attr, 0);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintWidth_default) {
                    this.matchConstraintDefaultWidth = a.getInt(attr, 0);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintHeight_default) {
                    this.matchConstraintDefaultHeight = a.getInt(attr, 0);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintWidth_min) {
                    this.matchConstraintMinWidth = a.getDimensionPixelSize(attr, this.matchConstraintMinWidth);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintWidth_max) {
                    this.matchConstraintMaxWidth = a.getDimensionPixelSize(attr, this.matchConstraintMaxWidth);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintHeight_min) {
                    this.matchConstraintMinHeight = a.getDimensionPixelSize(attr, this.matchConstraintMinHeight);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_layout_constraintHeight_max) {
                    this.matchConstraintMaxHeight = a.getDimensionPixelSize(attr, this.matchConstraintMaxHeight);
                    continue;
                }
                if (attr != R.styleable.ConstraintLayout_Layout_layout_constraintLeft_creator && attr != R.styleable.ConstraintLayout_Layout_layout_constraintTop_creator && attr != R.styleable.ConstraintLayout_Layout_layout_constraintRight_creator && attr != R.styleable.ConstraintLayout_Layout_layout_constraintBottom_creator && attr != R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_creator) continue;
            }
            a.recycle();
            this.validate();
        }

        public void validate() {
            this.isGuideline = false;
            this.horizontalDimensionFixed = true;
            this.verticalDimensionFixed = true;
            if (this.width == 0 || this.width == -1) {
                this.horizontalDimensionFixed = false;
            }
            if (this.height == 0 || this.height == -1) {
                this.verticalDimensionFixed = false;
            }
            if (this.guidePercent != -1.0f || this.guideBegin != -1 || this.guideEnd != -1) {
                this.isGuideline = true;
                this.horizontalDimensionFixed = true;
                this.verticalDimensionFixed = true;
                if (!(this.widget instanceof android.support.constraint.solver.widgets.Guideline)) {
                    this.widget = new android.support.constraint.solver.widgets.Guideline();
                }
                ((android.support.constraint.solver.widgets.Guideline)this.widget).setOrientation(this.orientation);
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        @TargetApi(value=17)
        public void resolveLayoutDirection(int layoutDirection) {
            boolean isRtl;
            super.resolveLayoutDirection(layoutDirection);
            this.resolvedRightToLeft = -1;
            this.resolvedRightToRight = -1;
            this.resolvedLeftToLeft = -1;
            this.resolvedLeftToRight = -1;
            this.resolveGoneLeftMargin = -1;
            this.resolveGoneRightMargin = -1;
            this.resolveGoneLeftMargin = this.goneLeftMargin;
            this.resolveGoneRightMargin = this.goneRightMargin;
            this.resolvedHorizontalBias = this.horizontalBias;
            boolean bl = isRtl = 1 == this.getLayoutDirection();
            if (isRtl) {
                if (this.startToEnd != -1) {
                    this.resolvedRightToLeft = this.startToEnd;
                } else if (this.startToStart != -1) {
                    this.resolvedRightToRight = this.startToStart;
                }
                if (this.endToStart != -1) {
                    this.resolvedLeftToRight = this.endToStart;
                }
                if (this.endToEnd != -1) {
                    this.resolvedLeftToLeft = this.endToEnd;
                }
                if (this.goneStartMargin != -1) {
                    this.resolveGoneRightMargin = this.goneStartMargin;
                }
                if (this.goneEndMargin != -1) {
                    this.resolveGoneLeftMargin = this.goneEndMargin;
                }
                this.resolvedHorizontalBias = 1.0f - this.horizontalBias;
            } else {
                if (this.startToEnd != -1) {
                    this.resolvedLeftToRight = this.startToEnd;
                }
                if (this.startToStart != -1) {
                    this.resolvedLeftToLeft = this.startToStart;
                }
                if (this.endToStart != -1) {
                    this.resolvedRightToLeft = this.endToStart;
                }
                if (this.endToEnd != -1) {
                    this.resolvedRightToRight = this.endToEnd;
                }
                if (this.goneStartMargin != -1) {
                    this.resolveGoneLeftMargin = this.goneStartMargin;
                }
                if (this.goneEndMargin != -1) {
                    this.resolveGoneRightMargin = this.goneEndMargin;
                }
            }
            if (this.endToStart == -1 && this.endToEnd == -1) {
                if (this.rightToLeft != -1) {
                    this.resolvedRightToLeft = this.rightToLeft;
                } else if (this.rightToRight != -1) {
                    this.resolvedRightToRight = this.rightToRight;
                }
            }
            if (this.startToStart == -1 && this.startToEnd == -1) {
                if (this.leftToLeft != -1) {
                    this.resolvedLeftToLeft = this.leftToLeft;
                } else if (this.leftToRight != -1) {
                    this.resolvedLeftToRight = this.leftToRight;
                }
            }
        }
    }
}

