/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.os.Build;
import android.support.constraint.Barrier;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.Constraints;
import android.support.constraint.Guideline;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.support.constraint.motion.utils.Easing;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConstraintSet {
    private static final String TAG = "ConstraintSet";
    private static final String ERROR_MESSAGE = "XML parser error must be within a Constraint ";
    private HashMap<String, ConstraintAttribute> mSavedAttributes = new HashMap();
    private boolean mForceId = true;
    public static final int UNSET = -1;
    public static final int MATCH_CONSTRAINT = 0;
    public static final int WRAP_CONTENT = -2;
    public static final int MATCH_CONSTRAINT_WRAP = 1;
    public static final int MATCH_CONSTRAINT_SPREAD = 0;
    public static final int PARENT_ID = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL_GUIDELINE = 0;
    public static final int VERTICAL_GUIDELINE = 1;
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int BASELINE = 5;
    public static final int START = 6;
    public static final int END = 7;
    public static final int CHAIN_SPREAD = 0;
    public static final int CHAIN_SPREAD_INSIDE = 1;
    public static final int CHAIN_PACKED = 2;
    private static final boolean DEBUG = false;
    private static final int[] VISIBILITY_FLAGS = new int[]{0, 4, 8};
    private static final int BARRIER_TYPE = 1;
    private HashMap<Integer, Constraint> mConstraints = new HashMap();
    private static SparseIntArray mapToConstant = new SparseIntArray();
    private static final int BASELINE_TO_BASELINE = 1;
    private static final int BOTTOM_MARGIN = 2;
    private static final int BOTTOM_TO_BOTTOM = 3;
    private static final int BOTTOM_TO_TOP = 4;
    private static final int DIMENSION_RATIO = 5;
    private static final int EDITOR_ABSOLUTE_X = 6;
    private static final int EDITOR_ABSOLUTE_Y = 7;
    private static final int END_MARGIN = 8;
    private static final int END_TO_END = 9;
    private static final int END_TO_START = 10;
    private static final int GONE_BOTTOM_MARGIN = 11;
    private static final int GONE_END_MARGIN = 12;
    private static final int GONE_LEFT_MARGIN = 13;
    private static final int GONE_RIGHT_MARGIN = 14;
    private static final int GONE_START_MARGIN = 15;
    private static final int GONE_TOP_MARGIN = 16;
    private static final int GUIDE_BEGIN = 17;
    private static final int GUIDE_END = 18;
    private static final int GUIDE_PERCENT = 19;
    private static final int HORIZONTAL_BIAS = 20;
    private static final int LAYOUT_HEIGHT = 21;
    private static final int LAYOUT_VISIBILITY = 22;
    private static final int LAYOUT_WIDTH = 23;
    private static final int LEFT_MARGIN = 24;
    private static final int LEFT_TO_LEFT = 25;
    private static final int LEFT_TO_RIGHT = 26;
    private static final int ORIENTATION = 27;
    private static final int RIGHT_MARGIN = 28;
    private static final int RIGHT_TO_LEFT = 29;
    private static final int RIGHT_TO_RIGHT = 30;
    private static final int START_MARGIN = 31;
    private static final int START_TO_END = 32;
    private static final int START_TO_START = 33;
    private static final int TOP_MARGIN = 34;
    private static final int TOP_TO_BOTTOM = 35;
    private static final int TOP_TO_TOP = 36;
    private static final int VERTICAL_BIAS = 37;
    private static final int VIEW_ID = 38;
    private static final int HORIZONTAL_WEIGHT = 39;
    private static final int VERTICAL_WEIGHT = 40;
    private static final int HORIZONTAL_STYLE = 41;
    private static final int VERTICAL_STYLE = 42;
    private static final int ALPHA = 43;
    private static final int ELEVATION = 44;
    private static final int ROTATION_X = 45;
    private static final int ROTATION_Y = 46;
    private static final int SCALE_X = 47;
    private static final int SCALE_Y = 48;
    private static final int TRANSFORM_PIVOT_X = 49;
    private static final int TRANSFORM_PIVOT_Y = 50;
    private static final int TRANSLATION_X = 51;
    private static final int TRANSLATION_Y = 52;
    private static final int TRANSLATION_Z = 53;
    private static final int WIDTH_DEFAULT = 54;
    private static final int HEIGHT_DEFAULT = 55;
    private static final int WIDTH_MAX = 56;
    private static final int HEIGHT_MAX = 57;
    private static final int WIDTH_MIN = 58;
    private static final int HEIGHT_MIN = 59;
    private static final int ROTATION = 60;
    private static final int CIRCLE = 61;
    private static final int CIRCLE_RADIUS = 62;
    private static final int CIRCLE_ANGLE = 63;
    private static final int ANIMATE_RELATIVE_TO = 64;
    private static final int TRANSITION_EASING = 65;
    private static final int DRAW_PATH = 66;
    private static final int TRANSITION_PATH_ROTATE = 67;
    private static final int PROGRESS = 68;
    private static final int WIDTH_PERCENT = 69;
    private static final int HEIGHT_PERCENT = 70;
    private static final int CHAIN_USE_RTL = 71;
    private static final int BARRIER_DIRECTION = 72;
    private static final int CONSTRAINT_REFERENCED_IDS = 73;
    private static final int BARRIER_ALLOWS_GONE_WIDGETS = 74;
    private static final int PATH_MOTION_ARC = 75;
    private static final int UNUSED = 76;

    public HashMap<String, ConstraintAttribute> getCustomAttributeSet() {
        return this.mSavedAttributes;
    }

    public Constraint getParameters(int mId) {
        return this.get(mId);
    }

    public void readFallback(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = constraintLayout.getChildAt(i);
            ConstraintLayout.LayoutParams param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            Constraint constraint = this.mConstraints.get(id2);
            if (!constraint.layout.mApply) {
                constraint.fillFrom(id2, param);
                constraint.layout.mApply = true;
            }
            constraint.propertySet.visibility = view.getVisibility();
            if (Build.VERSION.SDK_INT < 17) continue;
            if (!constraint.propertySet.mApply) {
                constraint.propertySet.alpha = view.getAlpha();
                constraint.propertySet.mApply = true;
            }
            if (constraint.transform.mApply) continue;
            constraint.transform.mApply = true;
            constraint.transform.rotation = view.getRotation();
            constraint.transform.rotationX = view.getRotationX();
            constraint.transform.rotationY = view.getRotationY();
            constraint.transform.scaleX = view.getScaleX();
            constraint.transform.scaleY = view.getScaleY();
            float pivotX = view.getPivotX();
            float pivotY = view.getPivotY();
            if ((double)pivotX != 0.0 || (double)pivotY != 0.0) {
                constraint.transform.transformPivotX = pivotX;
                constraint.transform.transformPivotY = pivotY;
            }
            constraint.transform.translationX = view.getTranslationX();
            constraint.transform.translationY = view.getTranslationY();
            if (Build.VERSION.SDK_INT < 21) continue;
            constraint.transform.translationZ = view.getTranslationZ();
            if (!constraint.transform.applyElevation) continue;
            constraint.transform.elevation = view.getElevation();
        }
    }

    public void clone(Context context, int constraintLayoutId) {
        this.clone((ConstraintLayout)LayoutInflater.from((Context)context).inflate(constraintLayoutId, null));
    }

    public void clone(ConstraintSet set) {
        this.mConstraints.clear();
        for (Integer key : set.mConstraints.keySet()) {
            this.mConstraints.put(key, set.mConstraints.get(key).clone());
        }
    }

    public void clone(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        this.mConstraints.clear();
        for (int i = 0; i < count; ++i) {
            View view = constraintLayout.getChildAt(i);
            ConstraintLayout.LayoutParams param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            Constraint constraint = this.mConstraints.get(id2);
            constraint.mCustomConstraints = ConstraintAttribute.extractAttributes(this.mSavedAttributes, view);
            constraint.fillFrom(id2, param);
            constraint.propertySet.visibility = view.getVisibility();
            if (Build.VERSION.SDK_INT >= 17) {
                constraint.propertySet.alpha = view.getAlpha();
                constraint.transform.rotation = view.getRotation();
                constraint.transform.rotationX = view.getRotationX();
                constraint.transform.rotationY = view.getRotationY();
                constraint.transform.scaleX = view.getScaleX();
                constraint.transform.scaleY = view.getScaleY();
                float pivotX = view.getPivotX();
                float pivotY = view.getPivotY();
                if ((double)pivotX != 0.0 || (double)pivotY != 0.0) {
                    constraint.transform.transformPivotX = pivotX;
                    constraint.transform.transformPivotY = pivotY;
                }
                constraint.transform.translationX = view.getTranslationX();
                constraint.transform.translationY = view.getTranslationY();
                if (Build.VERSION.SDK_INT >= 21) {
                    constraint.transform.translationZ = view.getTranslationZ();
                    if (constraint.transform.applyElevation) {
                        constraint.transform.elevation = view.getElevation();
                    }
                }
            }
            if (!(view instanceof Barrier)) continue;
            Barrier barrier = (Barrier)view;
            constraint.layout.mBarrierAllowsGoneWidgets = barrier.allowsGoneWidget();
            constraint.layout.mReferenceIds = barrier.getReferencedIds();
            constraint.layout.mBarrierDirection = barrier.getType();
        }
    }

    public void clone(Constraints constraints) {
        int count = constraints.getChildCount();
        this.mConstraints.clear();
        for (int i = 0; i < count; ++i) {
            View view = constraints.getChildAt(i);
            Constraints.LayoutParams param = (Constraints.LayoutParams)view.getLayoutParams();
            int id2 = view.getId();
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) {
                this.mConstraints.put(id2, new Constraint());
            }
            Constraint constraint = this.mConstraints.get(id2);
            if (view instanceof ConstraintHelper) {
                ConstraintHelper helper = (ConstraintHelper)view;
                constraint.fillFromConstraints(helper, id2, param);
            }
            constraint.fillFromConstraints(id2, param);
        }
    }

    public void applyTo(ConstraintLayout constraintLayout) {
        this.applyToInternal(constraintLayout, true);
        constraintLayout.setConstraintSet(null);
    }

    public void applyToWithoutCustom(ConstraintLayout constraintLayout) {
        this.applyToInternal(constraintLayout, false);
        constraintLayout.setConstraintSet(null);
    }

    public void applyCustomAttributes(ConstraintLayout constraintLayout) {
        int count = constraintLayout.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = constraintLayout.getChildAt(i);
            int id2 = view.getId();
            if (!this.mConstraints.containsKey(id2)) {
                Log.v((String)TAG, (String)("id unknown " + Debug.getName(view)));
                continue;
            }
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (!this.mConstraints.containsKey(id2)) continue;
            Constraint constraint = this.mConstraints.get(id2);
            ConstraintAttribute.setAttributes(view, constraint.mCustomConstraints);
        }
    }

    void applyToInternal(ConstraintLayout constraintLayout, boolean applyCustom) {
        ConstraintLayout.LayoutParams param;
        int count = constraintLayout.getChildCount();
        HashSet<Integer> used = new HashSet<Integer>(this.mConstraints.keySet());
        for (int i = 0; i < count; ++i) {
            View view = constraintLayout.getChildAt(i);
            int id2 = view.getId();
            if (!this.mConstraints.containsKey(id2)) {
                Log.w((String)TAG, (String)("id unknown " + Debug.getName(view)));
                continue;
            }
            if (this.mForceId && id2 == -1) {
                throw new RuntimeException("All children of ConstraintLayout must have ids to use ConstraintSet");
            }
            if (id2 == -1) continue;
            if (this.mConstraints.containsKey(id2)) {
                used.remove(id2);
                Constraint constraint = this.mConstraints.get(id2);
                if (view instanceof Barrier) {
                    constraint.layout.mHelperType = 1;
                }
                if (constraint.layout.mHelperType != -1) {
                    switch (constraint.layout.mHelperType) {
                        case 1: {
                            Barrier barrier = (Barrier)view;
                            barrier.setId(id2);
                            barrier.setType(constraint.layout.mBarrierDirection);
                            barrier.setAllowsGoneWidget(constraint.layout.mBarrierAllowsGoneWidgets);
                            if (constraint.layout.mReferenceIds != null) {
                                barrier.setReferencedIds(constraint.layout.mReferenceIds);
                                break;
                            }
                            if (constraint.layout.mReferenceIdString == null) break;
                            constraint.layout.mReferenceIds = this.convertReferenceString(barrier, constraint.layout.mReferenceIdString);
                            barrier.setReferencedIds(constraint.layout.mReferenceIds);
                        }
                    }
                }
                param = (ConstraintLayout.LayoutParams)view.getLayoutParams();
                constraint.applyTo(param);
                if (applyCustom) {
                    ConstraintAttribute.setAttributes(view, constraint.mCustomConstraints);
                }
                view.setLayoutParams((ViewGroup.LayoutParams)param);
                view.setVisibility(constraint.propertySet.visibility);
                if (Build.VERSION.SDK_INT < 17) continue;
                view.setAlpha(constraint.propertySet.alpha);
                view.setRotation(constraint.transform.rotation);
                view.setRotationX(constraint.transform.rotationX);
                view.setRotationY(constraint.transform.rotationY);
                view.setScaleX(constraint.transform.scaleX);
                view.setScaleY(constraint.transform.scaleY);
                if (!Float.isNaN(constraint.transform.transformPivotX)) {
                    view.setPivotX(constraint.transform.transformPivotX);
                }
                if (!Float.isNaN(constraint.transform.transformPivotY)) {
                    view.setPivotY(constraint.transform.transformPivotY);
                }
                view.setTranslationX(constraint.transform.translationX);
                view.setTranslationY(constraint.transform.translationY);
                if (Build.VERSION.SDK_INT < 21) continue;
                view.setTranslationZ(constraint.transform.translationZ);
                if (!constraint.transform.applyElevation) continue;
                view.setElevation(constraint.transform.elevation);
                continue;
            }
            Log.v((String)TAG, (String)("WARNING NO CONSTRAINTS for view " + id2));
        }
        for (Integer id3 : used) {
            Constraint constraint = this.mConstraints.get(id3);
            if (constraint.layout.mHelperType != -1) {
                switch (constraint.layout.mHelperType) {
                    case 1: {
                        Barrier barrier = new Barrier(constraintLayout.getContext());
                        barrier.setId(id3);
                        if (constraint.layout.mReferenceIds != null) {
                            barrier.setReferencedIds(constraint.layout.mReferenceIds);
                        } else if (constraint.layout.mReferenceIdString != null) {
                            constraint.layout.mReferenceIds = this.convertReferenceString(barrier, constraint.layout.mReferenceIdString);
                            barrier.setReferencedIds(constraint.layout.mReferenceIds);
                        }
                        barrier.setType(constraint.layout.mBarrierDirection);
                        param = constraintLayout.generateDefaultLayoutParams();
                        barrier.validateParams();
                        constraint.applyTo(param);
                        constraintLayout.addView(barrier, (ViewGroup.LayoutParams)param);
                    }
                }
            }
            if (!constraint.layout.mIsGuideline) continue;
            Guideline g = new Guideline(constraintLayout.getContext());
            g.setId(id3);
            param = constraintLayout.generateDefaultLayoutParams();
            constraint.applyTo(param);
            constraintLayout.addView(g, (ViewGroup.LayoutParams)param);
        }
    }

    public void center(int centerID, int firstID, int firstSide, int firstMargin, int secondId, int secondSide, int secondMargin, float bias) {
        if (firstMargin < 0) {
            throw new IllegalArgumentException("margin must be > 0");
        }
        if (secondMargin < 0) {
            throw new IllegalArgumentException("margin must be > 0");
        }
        if (bias <= 0.0f || bias > 1.0f) {
            throw new IllegalArgumentException("bias must be between 0 and 1 inclusive");
        }
        if (firstSide == 1 || firstSide == 2) {
            this.connect(centerID, 1, firstID, firstSide, firstMargin);
            this.connect(centerID, 2, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            constraint.layout.horizontalBias = bias;
        } else if (firstSide == 6 || firstSide == 7) {
            this.connect(centerID, 6, firstID, firstSide, firstMargin);
            this.connect(centerID, 7, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            constraint.layout.horizontalBias = bias;
        } else {
            this.connect(centerID, 3, firstID, firstSide, firstMargin);
            this.connect(centerID, 4, secondId, secondSide, secondMargin);
            Constraint constraint = this.mConstraints.get(centerID);
            constraint.layout.verticalBias = bias;
        }
    }

    public void centerHorizontally(int centerID, int leftId, int leftSide, int leftMargin, int rightId, int rightSide, int rightMargin, float bias) {
        this.connect(centerID, 1, leftId, leftSide, leftMargin);
        this.connect(centerID, 2, rightId, rightSide, rightMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        constraint.layout.horizontalBias = bias;
    }

    public void centerHorizontallyRtl(int centerID, int startId, int startSide, int startMargin, int endId, int endSide, int endMargin, float bias) {
        this.connect(centerID, 6, startId, startSide, startMargin);
        this.connect(centerID, 7, endId, endSide, endMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        constraint.layout.horizontalBias = bias;
    }

    public void centerVertically(int centerID, int topId, int topSide, int topMargin, int bottomId, int bottomSide, int bottomMargin, float bias) {
        this.connect(centerID, 3, topId, topSide, topMargin);
        this.connect(centerID, 4, bottomId, bottomSide, bottomMargin);
        Constraint constraint = this.mConstraints.get(centerID);
        constraint.layout.verticalBias = bias;
    }

    public void createVerticalChain(int topId, int topSide, int bottomId, int bottomSide, int[] chainIds, float[] weights, int style) {
        if (chainIds.length < 2) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null && weights.length != chainIds.length) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null) {
            this.get((int)chainIds[0]).layout.verticalWeight = weights[0];
        }
        this.get((int)chainIds[0]).layout.verticalChainStyle = style;
        this.connect(chainIds[0], 3, topId, topSide, 0);
        for (int i = 1; i < chainIds.length; ++i) {
            int chainId = chainIds[i];
            this.connect(chainIds[i], 3, chainIds[i - 1], 4, 0);
            this.connect(chainIds[i - 1], 4, chainIds[i], 3, 0);
            if (weights == null) continue;
            this.get((int)chainIds[i]).layout.verticalWeight = weights[i];
        }
        this.connect(chainIds[chainIds.length - 1], 4, bottomId, bottomSide, 0);
    }

    public void createHorizontalChain(int leftId, int leftSide, int rightId, int rightSide, int[] chainIds, float[] weights, int style) {
        this.createHorizontalChain(leftId, leftSide, rightId, rightSide, chainIds, weights, style, 1, 2);
    }

    public void createHorizontalChainRtl(int startId, int startSide, int endId, int endSide, int[] chainIds, float[] weights, int style) {
        this.createHorizontalChain(startId, startSide, endId, endSide, chainIds, weights, style, 6, 7);
    }

    private void createHorizontalChain(int leftId, int leftSide, int rightId, int rightSide, int[] chainIds, float[] weights, int style, int left, int right) {
        if (chainIds.length < 2) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null && weights.length != chainIds.length) {
            throw new IllegalArgumentException("must have 2 or more widgets in a chain");
        }
        if (weights != null) {
            this.get((int)chainIds[0]).layout.horizontalWeight = weights[0];
        }
        this.get((int)chainIds[0]).layout.horizontalChainStyle = style;
        this.connect(chainIds[0], left, leftId, leftSide, -1);
        for (int i = 1; i < chainIds.length; ++i) {
            int chainId = chainIds[i];
            this.connect(chainIds[i], left, chainIds[i - 1], right, -1);
            this.connect(chainIds[i - 1], right, chainIds[i], left, -1);
            if (weights == null) continue;
            this.get((int)chainIds[i]).layout.horizontalWeight = weights[i];
        }
        this.connect(chainIds[chainIds.length - 1], right, rightId, rightSide, -1);
    }

    public void connect(int startID, int startSide, int endID, int endSide, int margin) {
        if (!this.mConstraints.containsKey(startID)) {
            this.mConstraints.put(startID, new Constraint());
        }
        Constraint constraint = this.mConstraints.get(startID);
        switch (startSide) {
            case 1: {
                if (endSide == 1) {
                    constraint.layout.leftToLeft = endID;
                    constraint.layout.leftToRight = -1;
                } else if (endSide == 2) {
                    constraint.layout.leftToRight = endID;
                    constraint.layout.leftToLeft = -1;
                } else {
                    throw new IllegalArgumentException("Left to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.leftMargin = margin;
                break;
            }
            case 2: {
                if (endSide == 1) {
                    constraint.layout.rightToLeft = endID;
                    constraint.layout.rightToRight = -1;
                } else if (endSide == 2) {
                    constraint.layout.rightToRight = endID;
                    constraint.layout.rightToLeft = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.rightMargin = margin;
                break;
            }
            case 3: {
                if (endSide == 3) {
                    constraint.layout.topToTop = endID;
                    constraint.layout.topToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                } else if (endSide == 4) {
                    constraint.layout.topToBottom = endID;
                    constraint.layout.topToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.topMargin = margin;
                break;
            }
            case 4: {
                if (endSide == 4) {
                    constraint.layout.bottomToBottom = endID;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                } else if (endSide == 3) {
                    constraint.layout.bottomToTop = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.bottomMargin = margin;
                break;
            }
            case 5: {
                if (endSide == 5) {
                    constraint.layout.baselineToBaseline = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 6: {
                if (endSide == 6) {
                    constraint.layout.startToStart = endID;
                    constraint.layout.startToEnd = -1;
                } else if (endSide == 7) {
                    constraint.layout.startToEnd = endID;
                    constraint.layout.startToStart = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.startMargin = margin;
                break;
            }
            case 7: {
                if (endSide == 7) {
                    constraint.layout.endToEnd = endID;
                    constraint.layout.endToStart = -1;
                } else if (endSide == 6) {
                    constraint.layout.endToStart = endID;
                    constraint.layout.endToEnd = -1;
                } else {
                    throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
                }
                constraint.layout.endMargin = margin;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.sideToString(startSide) + " to " + this.sideToString(endSide) + " unknown");
            }
        }
    }

    public void connect(int startID, int startSide, int endID, int endSide) {
        if (!this.mConstraints.containsKey(startID)) {
            this.mConstraints.put(startID, new Constraint());
        }
        Constraint constraint = this.mConstraints.get(startID);
        switch (startSide) {
            case 1: {
                if (endSide == 1) {
                    constraint.layout.leftToLeft = endID;
                    constraint.layout.leftToRight = -1;
                    break;
                }
                if (endSide == 2) {
                    constraint.layout.leftToRight = endID;
                    constraint.layout.leftToLeft = -1;
                    break;
                }
                throw new IllegalArgumentException("left to " + this.sideToString(endSide) + " undefined");
            }
            case 2: {
                if (endSide == 1) {
                    constraint.layout.rightToLeft = endID;
                    constraint.layout.rightToRight = -1;
                    break;
                }
                if (endSide == 2) {
                    constraint.layout.rightToRight = endID;
                    constraint.layout.rightToLeft = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 3: {
                if (endSide == 3) {
                    constraint.layout.topToTop = endID;
                    constraint.layout.topToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                    break;
                }
                if (endSide == 4) {
                    constraint.layout.topToBottom = endID;
                    constraint.layout.topToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 4: {
                if (endSide == 4) {
                    constraint.layout.bottomToBottom = endID;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.baselineToBaseline = -1;
                    break;
                }
                if (endSide == 3) {
                    constraint.layout.bottomToTop = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.baselineToBaseline = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 5: {
                if (endSide == 5) {
                    constraint.layout.baselineToBaseline = endID;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topToBottom = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 6: {
                if (endSide == 6) {
                    constraint.layout.startToStart = endID;
                    constraint.layout.startToEnd = -1;
                    break;
                }
                if (endSide == 7) {
                    constraint.layout.startToEnd = endID;
                    constraint.layout.startToStart = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            case 7: {
                if (endSide == 7) {
                    constraint.layout.endToEnd = endID;
                    constraint.layout.endToStart = -1;
                    break;
                }
                if (endSide == 6) {
                    constraint.layout.endToStart = endID;
                    constraint.layout.endToEnd = -1;
                    break;
                }
                throw new IllegalArgumentException("right to " + this.sideToString(endSide) + " undefined");
            }
            default: {
                throw new IllegalArgumentException(this.sideToString(startSide) + " to " + this.sideToString(endSide) + " unknown");
            }
        }
    }

    public void centerHorizontally(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 1, 0, 0, 2, 0, 0.5f);
        } else {
            this.center(viewId, toView, 2, 0, toView, 1, 0, 0.5f);
        }
    }

    public void centerHorizontallyRtl(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 6, 0, 0, 7, 0, 0.5f);
        } else {
            this.center(viewId, toView, 7, 0, toView, 6, 0, 0.5f);
        }
    }

    public void centerVertically(int viewId, int toView) {
        if (toView == 0) {
            this.center(viewId, 0, 3, 0, 0, 4, 0, 0.5f);
        } else {
            this.center(viewId, toView, 4, 0, toView, 3, 0, 0.5f);
        }
    }

    public void clear(int viewId) {
        this.mConstraints.remove(viewId);
    }

    public void clear(int viewId, int anchor) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            switch (anchor) {
                case 1: {
                    constraint.layout.leftToRight = -1;
                    constraint.layout.leftToLeft = -1;
                    constraint.layout.leftMargin = -1;
                    constraint.layout.goneLeftMargin = -1;
                    break;
                }
                case 2: {
                    constraint.layout.rightToRight = -1;
                    constraint.layout.rightToLeft = -1;
                    constraint.layout.rightMargin = -1;
                    constraint.layout.goneRightMargin = -1;
                    break;
                }
                case 3: {
                    constraint.layout.topToBottom = -1;
                    constraint.layout.topToTop = -1;
                    constraint.layout.topMargin = -1;
                    constraint.layout.goneTopMargin = -1;
                    break;
                }
                case 4: {
                    constraint.layout.bottomToTop = -1;
                    constraint.layout.bottomToBottom = -1;
                    constraint.layout.bottomMargin = -1;
                    constraint.layout.goneBottomMargin = -1;
                    break;
                }
                case 5: {
                    constraint.layout.baselineToBaseline = -1;
                    break;
                }
                case 6: {
                    constraint.layout.startToEnd = -1;
                    constraint.layout.startToStart = -1;
                    constraint.layout.startMargin = -1;
                    constraint.layout.goneStartMargin = -1;
                    break;
                }
                case 7: {
                    constraint.layout.endToStart = -1;
                    constraint.layout.endToEnd = -1;
                    constraint.layout.endMargin = -1;
                    constraint.layout.goneEndMargin = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown constraint");
                }
            }
        }
    }

    public void setMargin(int viewId, int anchor, int value) {
        Constraint constraint = this.get(viewId);
        switch (anchor) {
            case 1: {
                constraint.layout.leftMargin = value;
                break;
            }
            case 2: {
                constraint.layout.rightMargin = value;
                break;
            }
            case 3: {
                constraint.layout.topMargin = value;
                break;
            }
            case 4: {
                constraint.layout.bottomMargin = value;
                break;
            }
            case 5: {
                throw new IllegalArgumentException("baseline does not support margins");
            }
            case 6: {
                constraint.layout.startMargin = value;
                break;
            }
            case 7: {
                constraint.layout.endMargin = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown constraint");
            }
        }
    }

    public void setGoneMargin(int viewId, int anchor, int value) {
        Constraint constraint = this.get(viewId);
        switch (anchor) {
            case 1: {
                constraint.layout.goneLeftMargin = value;
                break;
            }
            case 2: {
                constraint.layout.goneRightMargin = value;
                break;
            }
            case 3: {
                constraint.layout.goneTopMargin = value;
                break;
            }
            case 4: {
                constraint.layout.goneBottomMargin = value;
                break;
            }
            case 5: {
                throw new IllegalArgumentException("baseline does not support margins");
            }
            case 6: {
                constraint.layout.goneStartMargin = value;
                break;
            }
            case 7: {
                constraint.layout.goneEndMargin = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown constraint");
            }
        }
    }

    public void setHorizontalBias(int viewId, float bias) {
        this.get((int)viewId).layout.horizontalBias = bias;
    }

    public void setVerticalBias(int viewId, float bias) {
        this.get((int)viewId).layout.verticalBias = bias;
    }

    public void setDimensionRatio(int viewId, String ratio) {
        this.get((int)viewId).layout.dimensionRatio = ratio;
    }

    public void setVisibility(int viewId, int visibility) {
        this.get((int)viewId).propertySet.visibility = visibility;
    }

    public void setAlpha(int viewId, float alpha) {
        this.get((int)viewId).propertySet.alpha = alpha;
    }

    public boolean getApplyElevation(int viewId) {
        return this.get((int)viewId).transform.applyElevation;
    }

    public void setApplyElevation(int viewId, boolean apply) {
        this.get((int)viewId).transform.applyElevation = apply;
    }

    public void setElevation(int viewId, float elevation) {
        this.get((int)viewId).transform.elevation = elevation;
        this.get((int)viewId).transform.applyElevation = true;
    }

    public void setRotation(int viewId, float rotation) {
        this.get((int)viewId).transform.rotation = rotation;
    }

    public void setRotationX(int viewId, float rotationX) {
        this.get((int)viewId).transform.rotationX = rotationX;
    }

    public void setRotationY(int viewId, float rotationY) {
        this.get((int)viewId).transform.rotationY = rotationY;
    }

    public void setScaleX(int viewId, float scaleX) {
        this.get((int)viewId).transform.scaleX = scaleX;
    }

    public void setScaleY(int viewId, float scaleY) {
        this.get((int)viewId).transform.scaleY = scaleY;
    }

    public void setTransformPivotX(int viewId, float transformPivotX) {
        this.get((int)viewId).transform.transformPivotX = transformPivotX;
    }

    public void setTransformPivotY(int viewId, float transformPivotY) {
        this.get((int)viewId).transform.transformPivotY = transformPivotY;
    }

    public void setTransformPivot(int viewId, float transformPivotX, float transformPivotY) {
        Constraint constraint = this.get(viewId);
        constraint.transform.transformPivotY = transformPivotY;
        constraint.transform.transformPivotX = transformPivotX;
    }

    public void setTranslationX(int viewId, float translationX) {
        this.get((int)viewId).transform.translationX = translationX;
    }

    public void setTranslationY(int viewId, float translationY) {
        this.get((int)viewId).transform.translationY = translationY;
    }

    public void setTranslation(int viewId, float translationX, float translationY) {
        Constraint constraint = this.get(viewId);
        constraint.transform.translationX = translationX;
        constraint.transform.translationY = translationY;
    }

    public void setTranslationZ(int viewId, float translationZ) {
        this.get((int)viewId).transform.translationZ = translationZ;
    }

    public void setEditorAbsoluteX(int viewId, int position) {
        this.get((int)viewId).layout.editorAbsoluteX = position;
    }

    public void setEditorAbsoluteY(int viewId, int position) {
        this.get((int)viewId).layout.editorAbsoluteY = position;
    }

    public void constrainHeight(int viewId, int height) {
        this.get((int)viewId).layout.mHeight = height;
    }

    public void constrainWidth(int viewId, int width) {
        this.get((int)viewId).layout.mWidth = width;
    }

    public void constrainCircle(int viewId, int id2, int radius, float angle) {
        Constraint constraint = this.get(viewId);
        constraint.layout.circleConstraint = id2;
        constraint.layout.circleRadius = radius;
        constraint.layout.circleAngle = angle;
    }

    public void constrainMaxHeight(int viewId, int height) {
        this.get((int)viewId).layout.heightMax = height;
    }

    public void constrainMaxWidth(int viewId, int width) {
        this.get((int)viewId).layout.widthMax = width;
    }

    public void constrainMinHeight(int viewId, int height) {
        this.get((int)viewId).layout.heightMin = height;
    }

    public void constrainMinWidth(int viewId, int width) {
        this.get((int)viewId).layout.widthMin = width;
    }

    public void constrainPercentWidth(int viewId, float percent) {
        this.get((int)viewId).layout.widthPercent = percent;
    }

    public void constrainPercentHeight(int viewId, float percent) {
        this.get((int)viewId).layout.heightPercent = percent;
    }

    public void constrainDefaultHeight(int viewId, int height) {
        this.get((int)viewId).layout.heightDefault = height;
    }

    public void constrainDefaultWidth(int viewId, int width) {
        this.get((int)viewId).layout.widthDefault = width;
    }

    public void setHorizontalWeight(int viewId, float weight) {
        this.get((int)viewId).layout.horizontalWeight = weight;
    }

    public void setVerticalWeight(int viewId, float weight) {
        this.get((int)viewId).layout.verticalWeight = weight;
    }

    public void setHorizontalChainStyle(int viewId, int chainStyle) {
        this.get((int)viewId).layout.horizontalChainStyle = chainStyle;
    }

    public void setVerticalChainStyle(int viewId, int chainStyle) {
        this.get((int)viewId).layout.verticalChainStyle = chainStyle;
    }

    public void addToHorizontalChain(int viewId, int leftId, int rightId) {
        this.connect(viewId, 1, leftId, leftId == 0 ? 1 : 2, 0);
        this.connect(viewId, 2, rightId, rightId == 0 ? 2 : 1, 0);
        if (leftId != 0) {
            this.connect(leftId, 2, viewId, 1, 0);
        }
        if (rightId != 0) {
            this.connect(rightId, 1, viewId, 2, 0);
        }
    }

    public void addToHorizontalChainRTL(int viewId, int leftId, int rightId) {
        this.connect(viewId, 6, leftId, leftId == 0 ? 6 : 7, 0);
        this.connect(viewId, 7, rightId, rightId == 0 ? 7 : 6, 0);
        if (leftId != 0) {
            this.connect(leftId, 7, viewId, 6, 0);
        }
        if (rightId != 0) {
            this.connect(rightId, 6, viewId, 7, 0);
        }
    }

    public void addToVerticalChain(int viewId, int topId, int bottomId) {
        this.connect(viewId, 3, topId, topId == 0 ? 3 : 4, 0);
        this.connect(viewId, 4, bottomId, bottomId == 0 ? 4 : 3, 0);
        if (topId != 0) {
            this.connect(topId, 4, viewId, 3, 0);
        }
        if (topId != 0) {
            this.connect(bottomId, 3, viewId, 4, 0);
        }
    }

    public void removeFromVerticalChain(int viewId) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            int topId = constraint.layout.topToBottom;
            int bottomId = constraint.layout.bottomToTop;
            if (topId != -1 || bottomId != -1) {
                if (topId != -1 && bottomId != -1) {
                    this.connect(topId, 4, bottomId, 3, 0);
                    this.connect(bottomId, 3, topId, 4, 0);
                } else if (topId != -1 || bottomId != -1) {
                    if (constraint.layout.bottomToBottom != -1) {
                        this.connect(topId, 4, constraint.layout.bottomToBottom, 4, 0);
                    } else if (constraint.layout.topToTop != -1) {
                        this.connect(bottomId, 3, constraint.layout.topToTop, 3, 0);
                    }
                }
            }
        }
        this.clear(viewId, 3);
        this.clear(viewId, 4);
    }

    public void removeFromHorizontalChain(int viewId) {
        if (this.mConstraints.containsKey(viewId)) {
            Constraint constraint = this.mConstraints.get(viewId);
            int leftId = constraint.layout.leftToRight;
            int rightId = constraint.layout.rightToLeft;
            if (leftId != -1 || rightId != -1) {
                if (leftId != -1 && rightId != -1) {
                    this.connect(leftId, 2, rightId, 1, 0);
                    this.connect(rightId, 1, leftId, 2, 0);
                } else if (leftId != -1 || rightId != -1) {
                    if (constraint.layout.rightToRight != -1) {
                        this.connect(leftId, 2, constraint.layout.rightToRight, 2, 0);
                    } else if (constraint.layout.leftToLeft != -1) {
                        this.connect(rightId, 1, constraint.layout.leftToLeft, 1, 0);
                    }
                }
                this.clear(viewId, 1);
                this.clear(viewId, 2);
            } else {
                int startId = constraint.layout.startToEnd;
                int endId = constraint.layout.endToStart;
                if (startId != -1 || endId != -1) {
                    if (startId != -1 && endId != -1) {
                        this.connect(startId, 7, endId, 6, 0);
                        this.connect(endId, 6, leftId, 7, 0);
                    } else if (leftId != -1 || endId != -1) {
                        if (constraint.layout.rightToRight != -1) {
                            this.connect(leftId, 7, constraint.layout.rightToRight, 7, 0);
                        } else if (constraint.layout.leftToLeft != -1) {
                            this.connect(endId, 6, constraint.layout.leftToLeft, 6, 0);
                        }
                    }
                }
                this.clear(viewId, 6);
                this.clear(viewId, 7);
            }
        }
    }

    public void create(int guidelineID, int orientation) {
        Constraint constraint = this.get(guidelineID);
        constraint.layout.mIsGuideline = true;
        constraint.layout.orientation = orientation;
    }

    public void createBarrier(int id2, int direction, int ... referenced) {
        Constraint constraint = this.get(id2);
        constraint.layout.mHelperType = 1;
        constraint.layout.mBarrierDirection = direction;
        constraint.layout.mIsGuideline = false;
        constraint.layout.mReferenceIds = referenced;
    }

    public void setGuidelineBegin(int guidelineID, int margin) {
        this.get((int)guidelineID).layout.guideBegin = margin;
        this.get((int)guidelineID).layout.guideEnd = -1;
        this.get((int)guidelineID).layout.guidePercent = -1.0f;
    }

    public void setGuidelineEnd(int guidelineID, int margin) {
        this.get((int)guidelineID).layout.guideEnd = margin;
        this.get((int)guidelineID).layout.guideBegin = -1;
        this.get((int)guidelineID).layout.guidePercent = -1.0f;
    }

    public void setGuidelinePercent(int guidelineID, float ratio) {
        this.get((int)guidelineID).layout.guidePercent = ratio;
        this.get((int)guidelineID).layout.guideEnd = -1;
        this.get((int)guidelineID).layout.guideBegin = -1;
    }

    public void setBarrierType(int id2, int type) {
        Constraint constraint = this.get(id2);
        constraint.layout.mHelperType = type;
    }

    public void removeAttribute(String attributeName) {
        this.mSavedAttributes.remove(attributeName);
    }

    public void setIntValue(int viewId, String attributeName, int value) {
        this.get(viewId).setIntValue(attributeName, value);
    }

    public void setColorValue(int viewId, String attributeName, int value) {
        this.get(viewId).setColorValue(attributeName, value);
    }

    public void setFloatValue(int viewId, String attributeName, float value) {
        this.get(viewId).setFloatValue(attributeName, value);
    }

    public void setStringValue(int viewId, String attributeName, String value) {
        this.get(viewId).setStringValue(attributeName, value);
    }

    private void addAttributes(ConstraintAttribute.AttributeType attributeType, String ... attributeName) {
        ConstraintAttribute constraintAttribute = null;
        for (int i = 0; i < attributeName.length; ++i) {
            if (this.mSavedAttributes.containsKey(attributeName[i])) {
                constraintAttribute = this.mSavedAttributes.get(attributeName[i]);
                if (constraintAttribute.getType() == attributeType) continue;
                throw new IllegalArgumentException("ConstraintAttribute is already a " + constraintAttribute.getType().name());
            }
            constraintAttribute = new ConstraintAttribute(attributeName[i], attributeType);
            this.mSavedAttributes.put(attributeName[i], constraintAttribute);
        }
    }

    public void parseIntAttributes(Constraint set, String attributes) {
        String[] sp = attributes.split(",");
        for (int i = 0; i < sp.length; ++i) {
            String[] attr = sp[i].split("=");
            if (attr.length != 2) {
                Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
                continue;
            }
            set.setFloatValue(attr[0], Integer.decode(attr[1]).intValue());
        }
    }

    public void parseColorAttributes(Constraint set, String attributes) {
        String[] sp = attributes.split(",");
        for (int i = 0; i < sp.length; ++i) {
            String[] attr = sp[i].split("=");
            if (attr.length != 2) {
                Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
                continue;
            }
            set.setColorValue(attr[0], Color.parseColor((String)attr[1]));
        }
    }

    public void parseFloatAttributes(Constraint set, String attributes) {
        String[] sp = attributes.split(",");
        for (int i = 0; i < sp.length; ++i) {
            String[] attr = sp[i].split("=");
            if (attr.length != 2) {
                Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
                continue;
            }
            set.setFloatValue(attr[0], Float.parseFloat(attr[1]));
        }
    }

    public void parseStringAttributes(Constraint set, String attributes) {
        String[] sp = ConstraintSet.splitString(attributes);
        for (int i = 0; i < sp.length; ++i) {
            String[] attr = sp[i].split("=");
            Log.w((String)TAG, (String)(" Unable to parse " + sp[i]));
            set.setStringValue(attr[0], attr[1]);
        }
    }

    private static String[] splitString(String str) {
        char[] chars = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        boolean indouble = false;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ',' && !indouble) {
                list.add(new String(chars, start, i - start));
                start = i + 1;
                continue;
            }
            if (chars[i] != '\"') continue;
            indouble = !indouble;
        }
        list.add(new String(chars, start, chars.length - start));
        return list.toArray(new String[list.size()]);
    }

    public void addIntAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.INT_TYPE, attributeName);
    }

    public void addColorAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.COLOR_TYPE, attributeName);
    }

    public void addFloatAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.FLOAT_TYPE, attributeName);
    }

    public void addStringAttributes(String ... attributeName) {
        this.addAttributes(ConstraintAttribute.AttributeType.STRING_TYPE, attributeName);
    }

    private Constraint get(int id2) {
        if (!this.mConstraints.containsKey(id2)) {
            this.mConstraints.put(id2, new Constraint());
        }
        return this.mConstraints.get(id2);
    }

    private String sideToString(int side) {
        switch (side) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "top";
            }
            case 4: {
                return "bottom";
            }
            case 5: {
                return "baseline";
            }
            case 6: {
                return "start";
            }
            case 7: {
                return "end";
            }
        }
        return "undefined";
    }

    public void load(Context context, int resourceId) {
        Resources res = context.getResources();
        XmlResourceParser parser = res.getXml(resourceId);
        String document = null;
        String tagName = null;
        try {
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        Constraint constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                        if (tagName.equalsIgnoreCase("Guideline")) {
                            constraint.layout.mIsGuideline = true;
                        }
                        this.mConstraints.put(constraint.mViewId, constraint);
                        break;
                    }
                    case 3: {
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(Context context, XmlPullParser parser) {
        String tagName = null;
        try {
            Constraint constraint = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        String document = parser.getName();
                        break;
                    }
                    case 2: {
                        switch (tagName = parser.getName()) {
                            case "Constraint": {
                                constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Guideline": {
                                constraint = this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                constraint.layout.mIsGuideline = true;
                                break;
                            }
                            case "PropertySet": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.propertySet.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Transform": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.transform.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Layout": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.layout.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "Motion": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                constraint.motion.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
                                break;
                            }
                            case "CustomAttribute": {
                                if (constraint == null) {
                                    throw new RuntimeException(ERROR_MESSAGE + parser.getLineNumber());
                                }
                                ConstraintAttribute.parse(context, parser, constraint.mCustomConstraints);
                            }
                        }
                        break;
                    }
                    case 3: {
                        tagName = parser.getName();
                        if (TAG.equals(tagName)) {
                            return;
                        }
                        if (tagName.equalsIgnoreCase("Constraint")) {
                            this.mConstraints.put(constraint.mViewId, constraint);
                            constraint = null;
                        }
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int lookupID(TypedArray a, int index, int def) {
        int ret = a.getResourceId(index, def);
        if (ret == -1) {
            ret = a.getInt(index, -1);
        }
        return ret;
    }

    private Constraint fillFromAttributeList(Context context, AttributeSet attrs) {
        Constraint c = new Constraint();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Constraint);
        this.populateConstraint(context, c, a);
        a.recycle();
        return c;
    }

    private void populateConstraint(Context ctx, Constraint c, TypedArray a) {
        int N = a.getIndexCount();
        block72: for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr != R.styleable.Constraint_android_id) {
                c.motion.mApply = true;
                c.layout.mApply = true;
                c.propertySet.mApply = true;
                c.transform.mApply = true;
            }
            switch (mapToConstant.get(attr)) {
                case 25: {
                    c.layout.leftToLeft = ConstraintSet.lookupID(a, attr, c.layout.leftToLeft);
                    continue block72;
                }
                case 26: {
                    c.layout.leftToRight = ConstraintSet.lookupID(a, attr, c.layout.leftToRight);
                    continue block72;
                }
                case 29: {
                    c.layout.rightToLeft = ConstraintSet.lookupID(a, attr, c.layout.rightToLeft);
                    continue block72;
                }
                case 30: {
                    c.layout.rightToRight = ConstraintSet.lookupID(a, attr, c.layout.rightToRight);
                    continue block72;
                }
                case 36: {
                    c.layout.topToTop = ConstraintSet.lookupID(a, attr, c.layout.topToTop);
                    continue block72;
                }
                case 35: {
                    c.layout.topToBottom = ConstraintSet.lookupID(a, attr, c.layout.topToBottom);
                    continue block72;
                }
                case 4: {
                    c.layout.bottomToTop = ConstraintSet.lookupID(a, attr, c.layout.bottomToTop);
                    continue block72;
                }
                case 3: {
                    c.layout.bottomToBottom = ConstraintSet.lookupID(a, attr, c.layout.bottomToBottom);
                    continue block72;
                }
                case 1: {
                    c.layout.baselineToBaseline = ConstraintSet.lookupID(a, attr, c.layout.baselineToBaseline);
                    continue block72;
                }
                case 6: {
                    c.layout.editorAbsoluteX = a.getDimensionPixelOffset(attr, c.layout.editorAbsoluteX);
                    continue block72;
                }
                case 7: {
                    c.layout.editorAbsoluteY = a.getDimensionPixelOffset(attr, c.layout.editorAbsoluteY);
                    continue block72;
                }
                case 17: {
                    c.layout.guideBegin = a.getDimensionPixelOffset(attr, c.layout.guideBegin);
                    continue block72;
                }
                case 18: {
                    c.layout.guideEnd = a.getDimensionPixelOffset(attr, c.layout.guideEnd);
                    continue block72;
                }
                case 19: {
                    c.layout.guidePercent = a.getFloat(attr, c.layout.guidePercent);
                    continue block72;
                }
                case 27: {
                    c.layout.orientation = a.getInt(attr, c.layout.orientation);
                    continue block72;
                }
                case 32: {
                    c.layout.startToEnd = ConstraintSet.lookupID(a, attr, c.layout.startToEnd);
                    continue block72;
                }
                case 33: {
                    c.layout.startToStart = ConstraintSet.lookupID(a, attr, c.layout.startToStart);
                    continue block72;
                }
                case 10: {
                    c.layout.endToStart = ConstraintSet.lookupID(a, attr, c.layout.endToStart);
                    continue block72;
                }
                case 9: {
                    c.layout.endToEnd = ConstraintSet.lookupID(a, attr, c.layout.endToEnd);
                    continue block72;
                }
                case 61: {
                    c.layout.circleConstraint = ConstraintSet.lookupID(a, attr, c.layout.circleConstraint);
                    continue block72;
                }
                case 62: {
                    c.layout.circleRadius = a.getDimensionPixelSize(attr, c.layout.circleRadius);
                    continue block72;
                }
                case 63: {
                    c.layout.circleAngle = a.getFloat(attr, c.layout.circleAngle);
                    continue block72;
                }
                case 13: {
                    c.layout.goneLeftMargin = a.getDimensionPixelSize(attr, c.layout.goneLeftMargin);
                    continue block72;
                }
                case 16: {
                    c.layout.goneTopMargin = a.getDimensionPixelSize(attr, c.layout.goneTopMargin);
                    continue block72;
                }
                case 14: {
                    c.layout.goneRightMargin = a.getDimensionPixelSize(attr, c.layout.goneRightMargin);
                    continue block72;
                }
                case 11: {
                    c.layout.goneBottomMargin = a.getDimensionPixelSize(attr, c.layout.goneBottomMargin);
                    continue block72;
                }
                case 15: {
                    c.layout.goneStartMargin = a.getDimensionPixelSize(attr, c.layout.goneStartMargin);
                    continue block72;
                }
                case 12: {
                    c.layout.goneEndMargin = a.getDimensionPixelSize(attr, c.layout.goneEndMargin);
                    continue block72;
                }
                case 20: {
                    c.layout.horizontalBias = a.getFloat(attr, c.layout.horizontalBias);
                    continue block72;
                }
                case 37: {
                    c.layout.verticalBias = a.getFloat(attr, c.layout.verticalBias);
                    continue block72;
                }
                case 24: {
                    c.layout.leftMargin = a.getDimensionPixelSize(attr, c.layout.leftMargin);
                    continue block72;
                }
                case 28: {
                    c.layout.rightMargin = a.getDimensionPixelSize(attr, c.layout.rightMargin);
                    continue block72;
                }
                case 31: {
                    c.layout.startMargin = a.getDimensionPixelSize(attr, c.layout.startMargin);
                    continue block72;
                }
                case 8: {
                    c.layout.endMargin = a.getDimensionPixelSize(attr, c.layout.endMargin);
                    continue block72;
                }
                case 34: {
                    c.layout.topMargin = a.getDimensionPixelSize(attr, c.layout.topMargin);
                    continue block72;
                }
                case 2: {
                    c.layout.bottomMargin = a.getDimensionPixelSize(attr, c.layout.bottomMargin);
                    continue block72;
                }
                case 23: {
                    c.layout.mWidth = a.getLayoutDimension(attr, c.layout.mWidth);
                    continue block72;
                }
                case 21: {
                    c.layout.mHeight = a.getLayoutDimension(attr, c.layout.mHeight);
                    continue block72;
                }
                case 22: {
                    c.propertySet.visibility = a.getInt(attr, c.propertySet.visibility);
                    c.propertySet.visibility = VISIBILITY_FLAGS[c.propertySet.visibility];
                    continue block72;
                }
                case 43: {
                    c.propertySet.alpha = a.getFloat(attr, c.propertySet.alpha);
                    continue block72;
                }
                case 44: {
                    c.transform.applyElevation = true;
                    c.transform.elevation = a.getDimension(attr, c.transform.elevation);
                    continue block72;
                }
                case 60: {
                    c.transform.rotation = a.getFloat(attr, c.transform.rotation);
                    continue block72;
                }
                case 45: {
                    c.transform.rotationX = a.getFloat(attr, c.transform.rotationX);
                    continue block72;
                }
                case 46: {
                    c.transform.rotationY = a.getFloat(attr, c.transform.rotationY);
                    continue block72;
                }
                case 47: {
                    c.transform.scaleX = a.getFloat(attr, c.transform.scaleX);
                    continue block72;
                }
                case 48: {
                    c.transform.scaleY = a.getFloat(attr, c.transform.scaleY);
                    continue block72;
                }
                case 49: {
                    c.transform.transformPivotX = a.getFloat(attr, c.transform.transformPivotX);
                    continue block72;
                }
                case 50: {
                    c.transform.transformPivotY = a.getFloat(attr, c.transform.transformPivotY);
                    continue block72;
                }
                case 51: {
                    c.transform.translationX = a.getDimension(attr, c.transform.translationX);
                    continue block72;
                }
                case 52: {
                    c.transform.translationY = a.getDimension(attr, c.transform.translationY);
                    continue block72;
                }
                case 53: {
                    if (Build.VERSION.SDK_INT < 21) continue block72;
                    c.transform.translationZ = a.getDimension(attr, c.transform.translationZ);
                    continue block72;
                }
                case 40: {
                    c.layout.verticalWeight = a.getFloat(attr, c.layout.verticalWeight);
                    continue block72;
                }
                case 39: {
                    c.layout.horizontalWeight = a.getFloat(attr, c.layout.horizontalWeight);
                    continue block72;
                }
                case 42: {
                    c.layout.verticalChainStyle = a.getInt(attr, c.layout.verticalChainStyle);
                    continue block72;
                }
                case 41: {
                    c.layout.horizontalChainStyle = a.getInt(attr, c.layout.horizontalChainStyle);
                    continue block72;
                }
                case 38: {
                    c.mViewId = a.getResourceId(attr, c.mViewId);
                    continue block72;
                }
                case 5: {
                    c.layout.dimensionRatio = a.getString(attr);
                    continue block72;
                }
                case 69: {
                    c.layout.widthPercent = a.getFloat(attr, 1.0f);
                    continue block72;
                }
                case 70: {
                    c.layout.heightPercent = a.getFloat(attr, 1.0f);
                    continue block72;
                }
                case 68: {
                    c.propertySet.mProgress = a.getFloat(attr, c.propertySet.mProgress);
                    continue block72;
                }
                case 64: {
                    c.motion.mAnimateRelativeTo = ConstraintSet.lookupID(a, attr, c.motion.mAnimateRelativeTo);
                    continue block72;
                }
                case 65: {
                    TypedValue type = a.peekValue(attr);
                    if (type.type == 3) {
                        c.motion.mTransitionEasing = a.getString(attr);
                        continue block72;
                    }
                    c.motion.mTransitionEasing = Easing.NAMED_EASING[a.getInteger(attr, 0)];
                    continue block72;
                }
                case 75: {
                    c.motion.mPathMotionArc = a.getInt(attr, c.motion.mPathMotionArc);
                    continue block72;
                }
                case 67: {
                    c.motion.mPathRotate = a.getFloat(attr, c.motion.mPathRotate);
                    continue block72;
                }
                case 66: {
                    c.motion.mDrawPath = a.getInt(attr, 0);
                    continue block72;
                }
                case 71: {
                    Log.e((String)TAG, (String)"CURRENTLY UNSUPPORTED");
                    continue block72;
                }
                case 72: {
                    c.layout.mBarrierDirection = a.getInt(attr, c.layout.mBarrierDirection);
                    continue block72;
                }
                case 73: {
                    c.layout.mReferenceIdString = a.getString(attr);
                    continue block72;
                }
                case 74: {
                    c.layout.mBarrierAllowsGoneWidgets = a.getBoolean(attr, c.layout.mBarrierAllowsGoneWidgets);
                    continue block72;
                }
                case 76: {
                    Log.w((String)TAG, (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mapToConstant.get(attr)));
                    continue block72;
                }
                default: {
                    Log.w((String)TAG, (String)("Unknown attribute 0x" + Integer.toHexString(attr) + "   " + mapToConstant.get(attr)));
                }
            }
        }
    }

    private int[] convertReferenceString(View view, String referenceIdString) {
        String[] split = referenceIdString.split(",");
        Context context = view.getContext();
        int[] tags = new int[split.length];
        int count = 0;
        for (int i = 0; i < split.length; ++i) {
            ConstraintLayout constraintLayout;
            Object value;
            String idString = split[i];
            idString = idString.trim();
            int tag = 0;
            try {
                Class<R.id> res = R.id.class;
                Field field = res.getField(idString);
                tag = field.getInt(null);
            }
            catch (Exception res) {
                // empty catch block
            }
            if (tag == 0) {
                tag = context.getResources().getIdentifier(idString, "id", context.getPackageName());
            }
            if (tag == 0 && view.isInEditMode() && view.getParent() instanceof ConstraintLayout && (value = (constraintLayout = (ConstraintLayout)view.getParent()).getDesignInformation(0, idString)) != null && value instanceof Integer) {
                tag = (Integer)value;
            }
            tags[count++] = tag;
        }
        if (count != split.length) {
            tags = Arrays.copyOf(tags, count);
        }
        return tags;
    }

    public boolean isForceId() {
        return this.mForceId;
    }

    public void setForceId(boolean forceId) {
        this.mForceId = forceId;
    }

    static {
        mapToConstant.append(R.styleable.Constraint_layout_constraintLeft_toLeftOf, 25);
        mapToConstant.append(R.styleable.Constraint_layout_constraintLeft_toRightOf, 26);
        mapToConstant.append(R.styleable.Constraint_layout_constraintRight_toLeftOf, 29);
        mapToConstant.append(R.styleable.Constraint_layout_constraintRight_toRightOf, 30);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTop_toTopOf, 36);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTop_toBottomOf, 35);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBottom_toTopOf, 4);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBottom_toBottomOf, 3);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBaseline_toBaselineOf, 1);
        mapToConstant.append(R.styleable.Constraint_layout_editor_absoluteX, 6);
        mapToConstant.append(R.styleable.Constraint_layout_editor_absoluteY, 7);
        mapToConstant.append(R.styleable.Constraint_layout_constraintGuide_begin, 17);
        mapToConstant.append(R.styleable.Constraint_layout_constraintGuide_end, 18);
        mapToConstant.append(R.styleable.Constraint_layout_constraintGuide_percent, 19);
        mapToConstant.append(R.styleable.Constraint_android_orientation, 27);
        mapToConstant.append(R.styleable.Constraint_layout_constraintStart_toEndOf, 32);
        mapToConstant.append(R.styleable.Constraint_layout_constraintStart_toStartOf, 33);
        mapToConstant.append(R.styleable.Constraint_layout_constraintEnd_toStartOf, 10);
        mapToConstant.append(R.styleable.Constraint_layout_constraintEnd_toEndOf, 9);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginLeft, 13);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginTop, 16);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginRight, 14);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginBottom, 11);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginStart, 15);
        mapToConstant.append(R.styleable.Constraint_layout_goneMarginEnd, 12);
        mapToConstant.append(R.styleable.Constraint_layout_constraintVertical_weight, 40);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHorizontal_weight, 39);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHorizontal_chainStyle, 41);
        mapToConstant.append(R.styleable.Constraint_layout_constraintVertical_chainStyle, 42);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHorizontal_bias, 20);
        mapToConstant.append(R.styleable.Constraint_layout_constraintVertical_bias, 37);
        mapToConstant.append(R.styleable.Constraint_layout_constraintDimensionRatio, 5);
        mapToConstant.append(R.styleable.Constraint_layout_constraintLeft_creator, 76);
        mapToConstant.append(R.styleable.Constraint_layout_constraintTop_creator, 76);
        mapToConstant.append(R.styleable.Constraint_layout_constraintRight_creator, 76);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBottom_creator, 76);
        mapToConstant.append(R.styleable.Constraint_layout_constraintBaseline_creator, 76);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginLeft, 24);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginRight, 28);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginStart, 31);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginEnd, 8);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginTop, 34);
        mapToConstant.append(R.styleable.Constraint_android_layout_marginBottom, 2);
        mapToConstant.append(R.styleable.Constraint_android_layout_width, 23);
        mapToConstant.append(R.styleable.Constraint_android_layout_height, 21);
        mapToConstant.append(R.styleable.Constraint_android_visibility, 22);
        mapToConstant.append(R.styleable.Constraint_android_alpha, 43);
        mapToConstant.append(R.styleable.Constraint_android_elevation, 44);
        mapToConstant.append(R.styleable.Constraint_android_rotationX, 45);
        mapToConstant.append(R.styleable.Constraint_android_rotationY, 46);
        mapToConstant.append(R.styleable.Constraint_android_rotation, 60);
        mapToConstant.append(R.styleable.Constraint_android_scaleX, 47);
        mapToConstant.append(R.styleable.Constraint_android_scaleY, 48);
        mapToConstant.append(R.styleable.Constraint_android_transformPivotX, 49);
        mapToConstant.append(R.styleable.Constraint_android_transformPivotY, 50);
        mapToConstant.append(R.styleable.Constraint_android_translationX, 51);
        mapToConstant.append(R.styleable.Constraint_android_translationY, 52);
        mapToConstant.append(R.styleable.Constraint_android_translationZ, 53);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_default, 54);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_default, 55);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_max, 56);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_max, 57);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_min, 58);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_min, 59);
        mapToConstant.append(R.styleable.Constraint_layout_constraintCircle, 61);
        mapToConstant.append(R.styleable.Constraint_layout_constraintCircleRadius, 62);
        mapToConstant.append(R.styleable.Constraint_layout_constraintCircleAngle, 63);
        mapToConstant.append(R.styleable.Constraint_animate_relativeTo, 64);
        mapToConstant.append(R.styleable.Constraint_transitionEasing, 65);
        mapToConstant.append(R.styleable.Constraint_drawPath, 66);
        mapToConstant.append(R.styleable.Constraint_transitionPathRotate, 67);
        mapToConstant.append(R.styleable.Constraint_android_id, 38);
        mapToConstant.append(R.styleable.Constraint_progress, 68);
        mapToConstant.append(R.styleable.Constraint_layout_constraintWidth_percent, 69);
        mapToConstant.append(R.styleable.Constraint_layout_constraintHeight_percent, 70);
        mapToConstant.append(R.styleable.Constraint_chainUseRtl, 71);
        mapToConstant.append(R.styleable.Constraint_barrierDirection, 72);
        mapToConstant.append(R.styleable.Constraint_constraint_referenced_ids, 73);
        mapToConstant.append(R.styleable.Constraint_barrierAllowsGoneWidgets, 74);
        mapToConstant.append(R.styleable.Constraint_pathMotionArc, 75);
    }

    public static class Constraint {
        int mViewId;
        public final PropertySet propertySet = new PropertySet();
        public final Motion motion = new Motion();
        public final Layout layout = new Layout();
        public final Transform transform = new Transform();
        public HashMap<String, ConstraintAttribute> mCustomConstraints = new HashMap();

        private ConstraintAttribute get(String attributeName, ConstraintAttribute.AttributeType attributeType) {
            ConstraintAttribute ret;
            if (this.mCustomConstraints.containsKey(attributeName)) {
                ret = this.mCustomConstraints.get(attributeName);
                if (ret.getType() != attributeType) {
                    throw new IllegalArgumentException("ConstraintAttribute is already a " + ret.getType().name());
                }
            } else {
                ret = new ConstraintAttribute(attributeName, attributeType);
                this.mCustomConstraints.put(attributeName, ret);
            }
            return ret;
        }

        private void setStringValue(String attributeName, String value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.STRING_TYPE).setStringValue(value);
        }

        private void setFloatValue(String attributeName, float value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.FLOAT_TYPE).setFloatValue(value);
        }

        private void setIntValue(String attributeName, int value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.INT_TYPE).setIntValue(value);
        }

        private void setColorValue(String attributeName, int value) {
            this.get(attributeName, ConstraintAttribute.AttributeType.COLOR_TYPE).setColorValue(value);
        }

        public Constraint clone() {
            Constraint clone = new Constraint();
            clone.layout.copyFrom(this.layout);
            clone.motion.copyFrom(this.motion);
            clone.propertySet.copyFrom(this.propertySet);
            clone.transform.copyFrom(this.transform);
            clone.mViewId = this.mViewId;
            return clone;
        }

        private void fillFromConstraints(ConstraintHelper helper, int viewId, Constraints.LayoutParams param) {
            this.fillFromConstraints(viewId, param);
            if (helper instanceof Barrier) {
                this.layout.mHelperType = 1;
                Barrier barrier = (Barrier)helper;
                this.layout.mBarrierDirection = barrier.getType();
                this.layout.mReferenceIds = barrier.getReferencedIds();
            }
        }

        private void fillFromConstraints(int viewId, Constraints.LayoutParams param) {
            this.fillFrom(viewId, param);
            this.propertySet.alpha = param.alpha;
            this.transform.rotation = param.rotation;
            this.transform.rotationX = param.rotationX;
            this.transform.rotationY = param.rotationY;
            this.transform.scaleX = param.scaleX;
            this.transform.scaleY = param.scaleY;
            this.transform.transformPivotX = param.transformPivotX;
            this.transform.transformPivotY = param.transformPivotY;
            this.transform.translationX = param.translationX;
            this.transform.translationY = param.translationY;
            this.transform.translationZ = param.translationZ;
            this.transform.elevation = param.elevation;
            this.transform.applyElevation = param.applyElevation;
        }

        private void fillFrom(int viewId, ConstraintLayout.LayoutParams param) {
            this.mViewId = viewId;
            this.layout.leftToLeft = param.leftToLeft;
            this.layout.leftToRight = param.leftToRight;
            this.layout.rightToLeft = param.rightToLeft;
            this.layout.rightToRight = param.rightToRight;
            this.layout.topToTop = param.topToTop;
            this.layout.topToBottom = param.topToBottom;
            this.layout.bottomToTop = param.bottomToTop;
            this.layout.bottomToBottom = param.bottomToBottom;
            this.layout.baselineToBaseline = param.baselineToBaseline;
            this.layout.startToEnd = param.startToEnd;
            this.layout.startToStart = param.startToStart;
            this.layout.endToStart = param.endToStart;
            this.layout.endToEnd = param.endToEnd;
            this.layout.horizontalBias = param.horizontalBias;
            this.layout.verticalBias = param.verticalBias;
            this.layout.dimensionRatio = param.dimensionRatio;
            this.layout.circleConstraint = param.circleConstraint;
            this.layout.circleRadius = param.circleRadius;
            this.layout.circleAngle = param.circleAngle;
            this.layout.editorAbsoluteX = param.editorAbsoluteX;
            this.layout.editorAbsoluteY = param.editorAbsoluteY;
            this.layout.orientation = param.orientation;
            this.layout.guidePercent = param.guidePercent;
            this.layout.guideBegin = param.guideBegin;
            this.layout.guideEnd = param.guideEnd;
            this.layout.mWidth = param.width;
            this.layout.mHeight = param.height;
            this.layout.leftMargin = param.leftMargin;
            this.layout.rightMargin = param.rightMargin;
            this.layout.topMargin = param.topMargin;
            this.layout.bottomMargin = param.bottomMargin;
            this.layout.verticalWeight = param.verticalWeight;
            this.layout.horizontalWeight = param.horizontalWeight;
            this.layout.verticalChainStyle = param.verticalChainStyle;
            this.layout.horizontalChainStyle = param.horizontalChainStyle;
            this.layout.constrainedWidth = param.constrainedWidth;
            this.layout.constrainedHeight = param.constrainedHeight;
            this.layout.widthDefault = param.matchConstraintDefaultWidth;
            this.layout.heightDefault = param.matchConstraintDefaultHeight;
            this.layout.constrainedWidth = param.constrainedWidth;
            this.layout.widthMax = param.matchConstraintMaxWidth;
            this.layout.heightMax = param.matchConstraintMaxHeight;
            this.layout.widthMin = param.matchConstraintMinWidth;
            this.layout.heightMin = param.matchConstraintMinHeight;
            this.layout.widthPercent = param.matchConstraintPercentWidth;
            this.layout.heightPercent = param.matchConstraintPercentHeight;
            int currentapiVersion = Build.VERSION.SDK_INT;
            if (currentapiVersion >= 17) {
                this.layout.endMargin = param.getMarginEnd();
                this.layout.startMargin = param.getMarginStart();
            }
        }

        public void applyTo(ConstraintLayout.LayoutParams param) {
            param.leftToLeft = this.layout.leftToLeft;
            param.leftToRight = this.layout.leftToRight;
            param.rightToLeft = this.layout.rightToLeft;
            param.rightToRight = this.layout.rightToRight;
            param.topToTop = this.layout.topToTop;
            param.topToBottom = this.layout.topToBottom;
            param.bottomToTop = this.layout.bottomToTop;
            param.bottomToBottom = this.layout.bottomToBottom;
            param.baselineToBaseline = this.layout.baselineToBaseline;
            param.startToEnd = this.layout.startToEnd;
            param.startToStart = this.layout.startToStart;
            param.endToStart = this.layout.endToStart;
            param.endToEnd = this.layout.endToEnd;
            param.leftMargin = this.layout.leftMargin;
            param.rightMargin = this.layout.rightMargin;
            param.topMargin = this.layout.topMargin;
            param.bottomMargin = this.layout.bottomMargin;
            param.goneStartMargin = this.layout.goneStartMargin;
            param.goneEndMargin = this.layout.goneEndMargin;
            param.horizontalBias = this.layout.horizontalBias;
            param.verticalBias = this.layout.verticalBias;
            param.circleConstraint = this.layout.circleConstraint;
            param.circleRadius = this.layout.circleRadius;
            param.circleAngle = this.layout.circleAngle;
            param.dimensionRatio = this.layout.dimensionRatio;
            param.editorAbsoluteX = this.layout.editorAbsoluteX;
            param.editorAbsoluteY = this.layout.editorAbsoluteY;
            param.verticalWeight = this.layout.verticalWeight;
            param.horizontalWeight = this.layout.horizontalWeight;
            param.verticalChainStyle = this.layout.verticalChainStyle;
            param.horizontalChainStyle = this.layout.horizontalChainStyle;
            param.constrainedWidth = this.layout.constrainedWidth;
            param.constrainedHeight = this.layout.constrainedHeight;
            param.matchConstraintDefaultWidth = this.layout.widthDefault;
            param.matchConstraintDefaultHeight = this.layout.heightDefault;
            param.matchConstraintMaxWidth = this.layout.widthMax;
            param.matchConstraintMaxHeight = this.layout.heightMax;
            param.matchConstraintMinWidth = this.layout.widthMin;
            param.matchConstraintMinHeight = this.layout.heightMin;
            param.matchConstraintPercentWidth = this.layout.widthPercent;
            param.matchConstraintPercentHeight = this.layout.heightPercent;
            param.orientation = this.layout.orientation;
            param.guidePercent = this.layout.guidePercent;
            param.guideBegin = this.layout.guideBegin;
            param.guideEnd = this.layout.guideEnd;
            param.width = this.layout.mWidth;
            param.height = this.layout.mHeight;
            if (Build.VERSION.SDK_INT >= 17) {
                param.setMarginStart(this.layout.startMargin);
                param.setMarginEnd(this.layout.endMargin);
            }
            param.validate();
        }
    }

    public static class Motion {
        public boolean mApply = false;
        public int mAnimateRelativeTo = -1;
        public String mTransitionEasing = null;
        public int mPathMotionArc = -1;
        public int mDrawPath = 0;
        public float mPathRotate = Float.NaN;
        private static SparseIntArray mapToConstant = new SparseIntArray();
        private static final int TRANSITION_PATH_ROTATE = 1;
        private static final int PATH_MOTION_ARC = 2;
        private static final int TRANSITION_EASING = 3;
        private static final int MOTION_DRAW_PATH = 4;
        private static final int ANIMATE_RELATIVE_TO = 5;

        public void copyFrom(Motion src) {
            this.mAnimateRelativeTo = src.mAnimateRelativeTo;
            this.mTransitionEasing = src.mTransitionEasing;
            this.mPathMotionArc = src.mPathMotionArc;
            this.mDrawPath = src.mDrawPath;
            this.mPathRotate = src.mPathRotate;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Motion);
            this.mApply = true;
            int N = a.getIndexCount();
            block7: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mapToConstant.get(attr)) {
                    case 1: {
                        this.mPathRotate = a.getFloat(attr, this.mPathRotate);
                        continue block7;
                    }
                    case 2: {
                        this.mPathMotionArc = a.getInt(attr, this.mPathMotionArc);
                        continue block7;
                    }
                    case 3: {
                        TypedValue type = a.peekValue(attr);
                        if (type.type == 3) {
                            this.mTransitionEasing = a.getString(attr);
                            continue block7;
                        }
                        this.mTransitionEasing = Easing.NAMED_EASING[a.getInteger(attr, 0)];
                        continue block7;
                    }
                    case 4: {
                        this.mDrawPath = a.getInt(attr, 0);
                        continue block7;
                    }
                    case 5: {
                        this.mAnimateRelativeTo = ConstraintSet.lookupID(a, attr, this.mAnimateRelativeTo);
                    }
                }
            }
            a.recycle();
        }

        static {
            mapToConstant.append(R.styleable.Motion_transitionPathRotate, 1);
            mapToConstant.append(R.styleable.Motion_pathMotionArc, 2);
            mapToConstant.append(R.styleable.Motion_transitionEasing, 3);
            mapToConstant.append(R.styleable.Motion_drawPath, 4);
            mapToConstant.append(R.styleable.Motion_animate_relativeTo, 5);
        }
    }

    public static class PropertySet {
        public boolean mApply = false;
        public int visibility = 0;
        public float alpha = 1.0f;
        public float mProgress = Float.NaN;

        public void copyFrom(PropertySet src) {
            this.visibility = src.visibility;
            this.alpha = src.alpha;
            this.mProgress = src.mProgress;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PropertySet);
            this.mApply = true;
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.PropertySet_alpha) {
                    this.alpha = a.getFloat(attr, this.alpha);
                    continue;
                }
                if (attr == R.styleable.PropertySet_visibility) {
                    this.visibility = a.getInt(attr, this.visibility);
                    continue;
                }
                if (attr != R.styleable.PropertySet_progress) continue;
                this.mProgress = a.getFloat(attr, this.mProgress);
            }
            a.recycle();
        }
    }

    public static class Transform {
        public boolean mApply = false;
        public float rotation = 0.0f;
        public float rotationX = 0.0f;
        public float rotationY = 0.0f;
        public float scaleX = 1.0f;
        public float scaleY = 1.0f;
        public float transformPivotX = Float.NaN;
        public float transformPivotY = Float.NaN;
        public float translationX = 0.0f;
        public float translationY = 0.0f;
        public float translationZ = 0.0f;
        public boolean applyElevation = false;
        public float elevation = 0.0f;
        private static SparseIntArray mapToConstant = new SparseIntArray();
        private static final int ROTATION = 1;
        private static final int ROTATION_X = 2;
        private static final int ROTATION_Y = 3;
        private static final int SCALE_X = 4;
        private static final int SCALE_Y = 5;
        private static final int TRANSFORM_PIVOT_X = 6;
        private static final int TRANSFORM_PIVOT_Y = 7;
        private static final int TRANSLATION_X = 8;
        private static final int TRANSLATION_Y = 9;
        private static final int TRANSLATION_Z = 10;
        private static final int ELEVATION = 11;

        public void copyFrom(Transform src) {
            this.rotation = src.rotation;
            this.rotationX = src.rotationX;
            this.rotationY = src.rotationY;
            this.scaleX = src.scaleX;
            this.scaleY = src.scaleY;
            this.transformPivotX = src.transformPivotX;
            this.transformPivotY = src.transformPivotY;
            this.translationX = src.translationX;
            this.translationY = src.translationY;
            this.translationZ = src.translationZ;
            this.applyElevation = src.applyElevation;
            this.elevation = src.elevation;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Transform);
            this.mApply = true;
            int N = a.getIndexCount();
            block13: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mapToConstant.get(attr)) {
                    case 1: {
                        this.rotation = a.getFloat(attr, this.rotation);
                        continue block13;
                    }
                    case 2: {
                        this.rotationX = a.getFloat(attr, this.rotationX);
                        continue block13;
                    }
                    case 3: {
                        this.rotationY = a.getFloat(attr, this.rotationY);
                        continue block13;
                    }
                    case 4: {
                        this.scaleX = a.getFloat(attr, this.scaleX);
                        continue block13;
                    }
                    case 5: {
                        this.scaleY = a.getFloat(attr, this.scaleY);
                        continue block13;
                    }
                    case 6: {
                        this.transformPivotX = a.getFloat(attr, this.transformPivotX);
                        continue block13;
                    }
                    case 7: {
                        this.transformPivotY = a.getFloat(attr, this.transformPivotY);
                        continue block13;
                    }
                    case 8: {
                        this.translationX = a.getDimension(attr, this.translationX);
                        continue block13;
                    }
                    case 9: {
                        this.translationY = a.getDimension(attr, this.translationY);
                        continue block13;
                    }
                    case 10: {
                        this.translationZ = a.getDimension(attr, this.translationZ);
                        continue block13;
                    }
                    case 11: {
                        this.applyElevation = true;
                        this.elevation = a.getDimension(attr, this.elevation);
                    }
                }
            }
            a.recycle();
        }

        static {
            mapToConstant.append(R.styleable.Transform_rotation, 1);
            mapToConstant.append(R.styleable.Transform_rotationX, 2);
            mapToConstant.append(R.styleable.Transform_rotationY, 3);
            mapToConstant.append(R.styleable.Transform_scaleX, 4);
            mapToConstant.append(R.styleable.Transform_scaleY, 5);
            mapToConstant.append(R.styleable.Transform_transformPivotX, 6);
            mapToConstant.append(R.styleable.Transform_transformPivotY, 7);
            mapToConstant.append(R.styleable.Transform_translationX, 8);
            mapToConstant.append(R.styleable.Transform_translationY, 9);
            mapToConstant.append(R.styleable.Transform_translationZ, 10);
            mapToConstant.append(R.styleable.Transform_elevation, 11);
        }
    }

    public static class Layout {
        public boolean mIsGuideline = false;
        public boolean mApply = false;
        public int mWidth;
        public int mHeight;
        public static final int UNSET = -1;
        public int guideBegin = -1;
        public int guideEnd = -1;
        public float guidePercent = -1.0f;
        public int leftToLeft = -1;
        public int leftToRight = -1;
        public int rightToLeft = -1;
        public int rightToRight = -1;
        public int topToTop = -1;
        public int topToBottom = -1;
        public int bottomToTop = -1;
        public int bottomToBottom = -1;
        public int baselineToBaseline = -1;
        public int startToEnd = -1;
        public int startToStart = -1;
        public int endToStart = -1;
        public int endToEnd = -1;
        public float horizontalBias = 0.5f;
        public float verticalBias = 0.5f;
        public String dimensionRatio = null;
        public int circleConstraint = -1;
        public int circleRadius = 0;
        public float circleAngle = 0.0f;
        public int editorAbsoluteX = -1;
        public int editorAbsoluteY = -1;
        public int orientation = -1;
        public int leftMargin = -1;
        public int rightMargin = -1;
        public int topMargin = -1;
        public int bottomMargin = -1;
        public int endMargin = -1;
        public int startMargin = -1;
        public int goneLeftMargin = -1;
        public int goneTopMargin = -1;
        public int goneRightMargin = -1;
        public int goneBottomMargin = -1;
        public int goneEndMargin = -1;
        public int goneStartMargin = -1;
        public float verticalWeight = 0.0f;
        public float horizontalWeight = 0.0f;
        public int horizontalChainStyle = 0;
        public int verticalChainStyle = 0;
        public int widthDefault = 0;
        public int heightDefault = 0;
        public int widthMax = -1;
        public int heightMax = -1;
        public int widthMin = -1;
        public int heightMin = -1;
        public float widthPercent = 1.0f;
        public float heightPercent = 1.0f;
        public int mBarrierDirection = -1;
        public int mHelperType = -1;
        public int[] mReferenceIds;
        public String mReferenceIdString;
        public boolean constrainedWidth = false;
        public boolean constrainedHeight = false;
        public boolean mBarrierAllowsGoneWidgets = true;
        private static SparseIntArray mapToConstant = new SparseIntArray();
        private static final int BASELINE_TO_BASELINE = 1;
        private static final int BOTTOM_MARGIN = 2;
        private static final int BOTTOM_TO_BOTTOM = 3;
        private static final int BOTTOM_TO_TOP = 4;
        private static final int DIMENSION_RATIO = 5;
        private static final int EDITOR_ABSOLUTE_X = 6;
        private static final int EDITOR_ABSOLUTE_Y = 7;
        private static final int END_MARGIN = 8;
        private static final int END_TO_END = 9;
        private static final int END_TO_START = 10;
        private static final int GONE_BOTTOM_MARGIN = 11;
        private static final int GONE_END_MARGIN = 12;
        private static final int GONE_LEFT_MARGIN = 13;
        private static final int GONE_RIGHT_MARGIN = 14;
        private static final int GONE_START_MARGIN = 15;
        private static final int GONE_TOP_MARGIN = 16;
        private static final int GUIDE_BEGIN = 17;
        private static final int GUIDE_END = 18;
        private static final int GUIDE_PERCENT = 19;
        private static final int HORIZONTAL_BIAS = 20;
        private static final int LAYOUT_HEIGHT = 21;
        private static final int LAYOUT_WIDTH = 22;
        private static final int LEFT_MARGIN = 23;
        private static final int LEFT_TO_LEFT = 24;
        private static final int LEFT_TO_RIGHT = 25;
        private static final int ORIENTATION = 26;
        private static final int RIGHT_MARGIN = 27;
        private static final int RIGHT_TO_LEFT = 28;
        private static final int RIGHT_TO_RIGHT = 29;
        private static final int START_MARGIN = 30;
        private static final int START_TO_END = 31;
        private static final int START_TO_START = 32;
        private static final int TOP_MARGIN = 33;
        private static final int TOP_TO_BOTTOM = 34;
        private static final int TOP_TO_TOP = 35;
        private static final int VERTICAL_BIAS = 36;
        private static final int HORIZONTAL_WEIGHT = 37;
        private static final int VERTICAL_WEIGHT = 38;
        private static final int HORIZONTAL_STYLE = 39;
        private static final int VERTICAL_STYLE = 40;
        private static final int CIRCLE = 61;
        private static final int CIRCLE_RADIUS = 62;
        private static final int CIRCLE_ANGLE = 63;
        private static final int WIDTH_PERCENT = 69;
        private static final int HEIGHT_PERCENT = 70;
        private static final int CHAIN_USE_RTL = 71;
        private static final int BARRIER_DIRECTION = 72;
        private static final int CONSTRAINT_REFERENCED_IDS = 73;
        private static final int BARRIER_ALLOWS_GONE_WIDGETS = 74;
        private static final int UNUSED = 76;

        public void copyFrom(Layout src) {
            this.mIsGuideline = src.mIsGuideline;
            this.mWidth = src.mWidth;
            this.mApply = src.mApply;
            this.mHeight = src.mHeight;
            this.guideBegin = src.guideBegin;
            this.guideEnd = src.guideEnd;
            this.guidePercent = src.guidePercent;
            this.leftToLeft = src.leftToLeft;
            this.leftToRight = src.leftToRight;
            this.rightToLeft = src.rightToLeft;
            this.rightToRight = src.rightToRight;
            this.topToTop = src.topToTop;
            this.topToBottom = src.topToBottom;
            this.bottomToTop = src.bottomToTop;
            this.bottomToBottom = src.bottomToBottom;
            this.baselineToBaseline = src.baselineToBaseline;
            this.startToEnd = src.startToEnd;
            this.startToStart = src.startToStart;
            this.endToStart = src.endToStart;
            this.endToEnd = src.endToEnd;
            this.horizontalBias = src.horizontalBias;
            this.verticalBias = src.verticalBias;
            this.dimensionRatio = src.dimensionRatio;
            this.circleConstraint = src.circleConstraint;
            this.circleRadius = src.circleRadius;
            this.circleAngle = src.circleAngle;
            this.editorAbsoluteX = src.editorAbsoluteX;
            this.editorAbsoluteY = src.editorAbsoluteY;
            this.orientation = src.orientation;
            this.leftMargin = src.leftMargin;
            this.rightMargin = src.rightMargin;
            this.topMargin = src.topMargin;
            this.bottomMargin = src.bottomMargin;
            this.endMargin = src.endMargin;
            this.startMargin = src.startMargin;
            this.goneLeftMargin = src.goneLeftMargin;
            this.goneTopMargin = src.goneTopMargin;
            this.goneRightMargin = src.goneRightMargin;
            this.goneBottomMargin = src.goneBottomMargin;
            this.goneEndMargin = src.goneEndMargin;
            this.goneStartMargin = src.goneStartMargin;
            this.verticalWeight = src.verticalWeight;
            this.horizontalWeight = src.horizontalWeight;
            this.horizontalChainStyle = src.horizontalChainStyle;
            this.verticalChainStyle = src.verticalChainStyle;
            this.widthDefault = src.widthDefault;
            this.heightDefault = src.heightDefault;
            this.widthMax = src.widthMax;
            this.heightMax = src.heightMax;
            this.widthMin = src.widthMin;
            this.heightMin = src.heightMin;
            this.widthPercent = src.widthPercent;
            this.heightPercent = src.heightPercent;
            this.mBarrierDirection = src.mBarrierDirection;
            this.mHelperType = src.mHelperType;
            this.mReferenceIds = (int[])(src.mReferenceIds != null ? Arrays.copyOf(src.mReferenceIds, src.mReferenceIds.length) : null);
            this.mReferenceIdString = src.mReferenceIdString;
            this.constrainedWidth = src.constrainedWidth;
            this.constrainedHeight = src.constrainedHeight;
            this.mBarrierAllowsGoneWidgets = src.mBarrierAllowsGoneWidgets;
        }

        void fillFromAttributeList(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Layout);
            this.mApply = true;
            int N = a.getIndexCount();
            block52: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mapToConstant.get(attr)) {
                    case 24: {
                        this.leftToLeft = ConstraintSet.lookupID(a, attr, this.leftToLeft);
                        continue block52;
                    }
                    case 25: {
                        this.leftToRight = ConstraintSet.lookupID(a, attr, this.leftToRight);
                        continue block52;
                    }
                    case 28: {
                        this.rightToLeft = ConstraintSet.lookupID(a, attr, this.rightToLeft);
                        continue block52;
                    }
                    case 29: {
                        this.rightToRight = ConstraintSet.lookupID(a, attr, this.rightToRight);
                        continue block52;
                    }
                    case 35: {
                        this.topToTop = ConstraintSet.lookupID(a, attr, this.topToTop);
                        continue block52;
                    }
                    case 34: {
                        this.topToBottom = ConstraintSet.lookupID(a, attr, this.topToBottom);
                        continue block52;
                    }
                    case 4: {
                        this.bottomToTop = ConstraintSet.lookupID(a, attr, this.bottomToTop);
                        continue block52;
                    }
                    case 3: {
                        this.bottomToBottom = ConstraintSet.lookupID(a, attr, this.bottomToBottom);
                        continue block52;
                    }
                    case 1: {
                        this.baselineToBaseline = ConstraintSet.lookupID(a, attr, this.baselineToBaseline);
                        continue block52;
                    }
                    case 6: {
                        this.editorAbsoluteX = a.getDimensionPixelOffset(attr, this.editorAbsoluteX);
                        continue block52;
                    }
                    case 7: {
                        this.editorAbsoluteY = a.getDimensionPixelOffset(attr, this.editorAbsoluteY);
                        continue block52;
                    }
                    case 17: {
                        this.guideBegin = a.getDimensionPixelOffset(attr, this.guideBegin);
                        continue block52;
                    }
                    case 18: {
                        this.guideEnd = a.getDimensionPixelOffset(attr, this.guideEnd);
                        continue block52;
                    }
                    case 19: {
                        this.guidePercent = a.getFloat(attr, this.guidePercent);
                        continue block52;
                    }
                    case 26: {
                        this.orientation = a.getInt(attr, this.orientation);
                        continue block52;
                    }
                    case 31: {
                        this.startToEnd = ConstraintSet.lookupID(a, attr, this.startToEnd);
                        continue block52;
                    }
                    case 32: {
                        this.startToStart = ConstraintSet.lookupID(a, attr, this.startToStart);
                        continue block52;
                    }
                    case 10: {
                        this.endToStart = ConstraintSet.lookupID(a, attr, this.endToStart);
                        continue block52;
                    }
                    case 9: {
                        this.endToEnd = ConstraintSet.lookupID(a, attr, this.endToEnd);
                        continue block52;
                    }
                    case 61: {
                        this.circleConstraint = ConstraintSet.lookupID(a, attr, this.circleConstraint);
                        continue block52;
                    }
                    case 62: {
                        this.circleRadius = a.getDimensionPixelSize(attr, this.circleRadius);
                        continue block52;
                    }
                    case 63: {
                        this.circleAngle = a.getFloat(attr, this.circleAngle);
                        continue block52;
                    }
                    case 13: {
                        this.goneLeftMargin = a.getDimensionPixelSize(attr, this.goneLeftMargin);
                        continue block52;
                    }
                    case 16: {
                        this.goneTopMargin = a.getDimensionPixelSize(attr, this.goneTopMargin);
                        continue block52;
                    }
                    case 14: {
                        this.goneRightMargin = a.getDimensionPixelSize(attr, this.goneRightMargin);
                        continue block52;
                    }
                    case 11: {
                        this.goneBottomMargin = a.getDimensionPixelSize(attr, this.goneBottomMargin);
                        continue block52;
                    }
                    case 15: {
                        this.goneStartMargin = a.getDimensionPixelSize(attr, this.goneStartMargin);
                        continue block52;
                    }
                    case 12: {
                        this.goneEndMargin = a.getDimensionPixelSize(attr, this.goneEndMargin);
                        continue block52;
                    }
                    case 20: {
                        this.horizontalBias = a.getFloat(attr, this.horizontalBias);
                        continue block52;
                    }
                    case 36: {
                        this.verticalBias = a.getFloat(attr, this.verticalBias);
                        continue block52;
                    }
                    case 23: {
                        this.leftMargin = a.getDimensionPixelSize(attr, this.leftMargin);
                        continue block52;
                    }
                    case 27: {
                        this.rightMargin = a.getDimensionPixelSize(attr, this.rightMargin);
                        continue block52;
                    }
                    case 30: {
                        this.startMargin = a.getDimensionPixelSize(attr, this.startMargin);
                        continue block52;
                    }
                    case 8: {
                        this.endMargin = a.getDimensionPixelSize(attr, this.endMargin);
                        continue block52;
                    }
                    case 33: {
                        this.topMargin = a.getDimensionPixelSize(attr, this.topMargin);
                        continue block52;
                    }
                    case 2: {
                        this.bottomMargin = a.getDimensionPixelSize(attr, this.bottomMargin);
                        continue block52;
                    }
                    case 22: {
                        this.mWidth = a.getLayoutDimension(attr, this.mWidth);
                        continue block52;
                    }
                    case 21: {
                        this.mHeight = a.getLayoutDimension(attr, this.mHeight);
                        continue block52;
                    }
                    case 38: {
                        this.verticalWeight = a.getFloat(attr, this.verticalWeight);
                        continue block52;
                    }
                    case 37: {
                        this.horizontalWeight = a.getFloat(attr, this.horizontalWeight);
                        continue block52;
                    }
                    case 40: {
                        this.verticalChainStyle = a.getInt(attr, this.verticalChainStyle);
                        continue block52;
                    }
                    case 39: {
                        this.horizontalChainStyle = a.getInt(attr, this.horizontalChainStyle);
                        continue block52;
                    }
                    case 5: {
                        this.dimensionRatio = a.getString(attr);
                        continue block52;
                    }
                    case 69: {
                        this.widthPercent = a.getFloat(attr, 1.0f);
                        continue block52;
                    }
                    case 70: {
                        this.heightPercent = a.getFloat(attr, 1.0f);
                        continue block52;
                    }
                    case 71: {
                        Log.e((String)ConstraintSet.TAG, (String)"CURRENTLY UNSUPPORTED");
                        continue block52;
                    }
                    case 72: {
                        this.mBarrierDirection = a.getInt(attr, this.mBarrierDirection);
                        continue block52;
                    }
                    case 73: {
                        this.mReferenceIdString = a.getString(attr);
                        continue block52;
                    }
                    case 74: {
                        this.mBarrierAllowsGoneWidgets = a.getBoolean(attr, this.mBarrierAllowsGoneWidgets);
                        continue block52;
                    }
                    case 76: {
                        Log.w((String)ConstraintSet.TAG, (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mapToConstant.get(attr)));
                        continue block52;
                    }
                    default: {
                        Log.w((String)ConstraintSet.TAG, (String)("Unknown attribute 0x" + Integer.toHexString(attr) + "   " + mapToConstant.get(attr)));
                    }
                }
            }
            a.recycle();
        }

        static {
            mapToConstant.append(R.styleable.Layout_layout_constraintLeft_toLeftOf, 24);
            mapToConstant.append(R.styleable.Layout_layout_constraintLeft_toRightOf, 25);
            mapToConstant.append(R.styleable.Layout_layout_constraintRight_toLeftOf, 28);
            mapToConstant.append(R.styleable.Layout_layout_constraintRight_toRightOf, 29);
            mapToConstant.append(R.styleable.Layout_layout_constraintTop_toTopOf, 35);
            mapToConstant.append(R.styleable.Layout_layout_constraintTop_toBottomOf, 34);
            mapToConstant.append(R.styleable.Layout_layout_constraintBottom_toTopOf, 4);
            mapToConstant.append(R.styleable.Layout_layout_constraintBottom_toBottomOf, 3);
            mapToConstant.append(R.styleable.Layout_layout_constraintBaseline_toBaselineOf, 1);
            mapToConstant.append(R.styleable.Layout_layout_editor_absoluteX, 6);
            mapToConstant.append(R.styleable.Layout_layout_editor_absoluteY, 7);
            mapToConstant.append(R.styleable.Layout_layout_constraintGuide_begin, 17);
            mapToConstant.append(R.styleable.Layout_layout_constraintGuide_end, 18);
            mapToConstant.append(R.styleable.Layout_layout_constraintGuide_percent, 19);
            mapToConstant.append(R.styleable.Layout_orientation, 26);
            mapToConstant.append(R.styleable.Layout_layout_constraintStart_toEndOf, 31);
            mapToConstant.append(R.styleable.Layout_layout_constraintStart_toStartOf, 32);
            mapToConstant.append(R.styleable.Layout_layout_constraintEnd_toStartOf, 10);
            mapToConstant.append(R.styleable.Layout_layout_constraintEnd_toEndOf, 9);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginLeft, 13);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginTop, 16);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginRight, 14);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginBottom, 11);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginStart, 15);
            mapToConstant.append(R.styleable.Layout_layout_goneMarginEnd, 12);
            mapToConstant.append(R.styleable.Layout_layout_constraintVertical_weight, 38);
            mapToConstant.append(R.styleable.Layout_layout_constraintHorizontal_weight, 37);
            mapToConstant.append(R.styleable.Layout_layout_constraintHorizontal_chainStyle, 39);
            mapToConstant.append(R.styleable.Layout_layout_constraintVertical_chainStyle, 40);
            mapToConstant.append(R.styleable.Layout_layout_constraintHorizontal_bias, 20);
            mapToConstant.append(R.styleable.Layout_layout_constraintVertical_bias, 36);
            mapToConstant.append(R.styleable.Layout_layout_constraintDimensionRatio, 5);
            mapToConstant.append(R.styleable.Layout_layout_constraintLeft_creator, 76);
            mapToConstant.append(R.styleable.Layout_layout_constraintTop_creator, 76);
            mapToConstant.append(R.styleable.Layout_layout_constraintRight_creator, 76);
            mapToConstant.append(R.styleable.Layout_layout_constraintBottom_creator, 76);
            mapToConstant.append(R.styleable.Layout_layout_constraintBaseline_creator, 76);
            mapToConstant.append(R.styleable.Layout_layout_marginLeft, 23);
            mapToConstant.append(R.styleable.Layout_layout_marginRight, 27);
            mapToConstant.append(R.styleable.Layout_layout_marginStart, 30);
            mapToConstant.append(R.styleable.Layout_layout_marginEnd, 8);
            mapToConstant.append(R.styleable.Layout_layout_marginTop, 33);
            mapToConstant.append(R.styleable.Layout_layout_marginBottom, 2);
            mapToConstant.append(R.styleable.Layout_layout_width, 22);
            mapToConstant.append(R.styleable.Layout_layout_height, 21);
            mapToConstant.append(R.styleable.Layout_layout_constraintCircle, 61);
            mapToConstant.append(R.styleable.Layout_layout_constraintCircleRadius, 62);
            mapToConstant.append(R.styleable.Layout_layout_constraintCircleAngle, 63);
            mapToConstant.append(R.styleable.Layout_layout_constraintWidth_percent, 69);
            mapToConstant.append(R.styleable.Layout_layout_constraintHeight_percent, 70);
            mapToConstant.append(R.styleable.Layout_chainUseRtl, 71);
            mapToConstant.append(R.styleable.Layout_barrierDirection, 72);
            mapToConstant.append(R.styleable.Layout_constraint_referenced_ids, 73);
            mapToConstant.append(R.styleable.Layout_barrierAllowsGoneWidgets, 74);
        }
    }
}

