/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.helper;

import android.content.Context;
import android.os.Build;
import android.support.constraint.ConstraintHelper;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.util.AttributeSet;
import android.view.View;

public class Layer
extends ConstraintHelper {
    private static final String TAG = "Layer";
    private float mRotationCenterX = Float.NaN;
    private float mRotationCenterY = Float.NaN;
    private float mGroupRotateAngle = Float.NaN;
    ConstraintLayout mContainer;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    protected float mComputedCenterX = Float.NaN;
    protected float mComputedCenterY = Float.NaN;
    protected float mComputedMaxX = Float.NaN;
    protected float mComputedMaxY = Float.NaN;
    protected float mComputedMinX = Float.NaN;
    protected float mComputedMinY = Float.NaN;
    boolean mNeedBounds = true;
    View[] mViews = null;
    private float mShiftX = 0.0f;
    private float mShiftY = 0.0f;

    public Layer(Context context) {
        super(context);
    }

    public Layer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public Layer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        this.mUseViewMeasure = false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mContainer = (ConstraintLayout)this.getParent();
    }

    @Override
    public void updatePreLayout(ConstraintLayout container) {
        this.mContainer = container;
        int visibility = this.getVisibility();
        float rotate = this.getRotation();
        if (rotate == 0.0f) {
            if (!Float.isNaN(this.mGroupRotateAngle)) {
                this.mGroupRotateAngle = rotate;
            }
        } else {
            this.mGroupRotateAngle = rotate;
        }
        float elevation = 0.0f;
        if (Build.VERSION.SDK_INT >= 21) {
            elevation = this.getElevation();
        }
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            View view = container.getViewById(id2);
            if (view == null) continue;
            view.setVisibility(visibility);
            if (!(elevation > 0.0f) || Build.VERSION.SDK_INT < 21) continue;
            view.setElevation(elevation);
        }
    }

    public void setRotation(float angle) {
        this.mGroupRotateAngle = angle;
        this.transform();
    }

    public void setScaleX(float scaleX) {
        this.mScaleX = scaleX;
        this.transform();
    }

    public void setScaleY(float scaleY) {
        this.mScaleY = scaleY;
        this.transform();
    }

    public void setPivotX(float pivotX) {
        this.mRotationCenterX = pivotX;
        this.transform();
    }

    public void setPivotY(float pivotY) {
        this.mRotationCenterY = pivotY;
        this.transform();
    }

    public void setTranslationX(float dx) {
        this.mShiftX = dx;
        this.transform();
    }

    public void setTranslationY(float dy) {
        this.mShiftY = dy;
        this.transform();
    }

    @Override
    public void updatePostLayout(ConstraintLayout container) {
        this.reCacheViews();
        this.mComputedCenterX = Float.NaN;
        this.mComputedCenterY = Float.NaN;
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        ConstraintWidget widget = params.getConstraintWidget();
        widget.setWidth(0);
        widget.setHeight(0);
        this.calcCenters();
        int left = (int)this.mComputedMinX - this.getPaddingLeft();
        int top = (int)this.mComputedMinY - this.getPaddingTop();
        int right = (int)this.mComputedMaxX + this.getPaddingRight();
        int bottom = (int)this.mComputedMaxY + this.getPaddingBottom();
        this.layout(left, top, right, bottom);
        if (!Float.isNaN(this.mGroupRotateAngle)) {
            this.transform();
        }
    }

    private void reCacheViews() {
        if (this.mContainer == null) {
            return;
        }
        if (this.mCount == 0) {
            return;
        }
        if (this.mViews == null || this.mViews.length != this.mCount) {
            this.mViews = new View[this.mCount];
        }
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            this.mViews[i] = this.mContainer.getViewById(id2);
        }
    }

    protected void calcCenters() {
        if (this.mContainer == null) {
            return;
        }
        if (!(this.mNeedBounds || Float.isNaN(this.mComputedCenterX) || Float.isNaN(this.mComputedCenterY))) {
            return;
        }
        if (Float.isNaN(this.mRotationCenterX) || Float.isNaN(this.mRotationCenterY)) {
            View[] views = this.getViews(this.mContainer);
            int minx = views[0].getLeft();
            int miny = views[0].getTop();
            int maxx = views[0].getRight();
            int maxy = views[0].getBottom();
            for (int i = 0; i < this.mCount; ++i) {
                View view = views[i];
                minx = Math.min(minx, view.getLeft());
                miny = Math.min(miny, view.getTop());
                maxx = Math.max(maxx, view.getRight());
                maxy = Math.max(maxy, view.getBottom());
            }
            this.mComputedMaxX = maxx;
            this.mComputedMaxY = maxy;
            this.mComputedMinX = minx;
            this.mComputedMinY = miny;
            this.mComputedCenterX = Float.isNaN(this.mRotationCenterX) ? (float)((minx + maxx) / 2) : this.mRotationCenterX;
            this.mComputedCenterY = Float.isNaN(this.mRotationCenterY) ? (float)((miny + maxy) / 2) : this.mRotationCenterY;
        } else {
            this.mComputedCenterY = this.mRotationCenterY;
            this.mComputedCenterX = this.mRotationCenterX;
        }
    }

    private void transform() {
        if (this.mContainer == null) {
            return;
        }
        if (this.mViews == null) {
            this.reCacheViews();
        }
        this.calcCenters();
        double rad = Math.toRadians(this.mGroupRotateAngle);
        float sin = (float)Math.sin(rad);
        float cos = (float)Math.cos(rad);
        float m11 = this.mScaleX * cos;
        float m12 = -this.mScaleY * sin;
        float m21 = this.mScaleX * sin;
        float m22 = this.mScaleY * cos;
        for (int i = 0; i < this.mCount; ++i) {
            View view = this.mViews[i];
            int x = (view.getLeft() + view.getRight()) / 2;
            int y = (view.getTop() + view.getBottom()) / 2;
            float dx = (float)x - this.mComputedCenterX;
            float dy = (float)y - this.mComputedCenterY;
            float shiftx = m11 * dx + m12 * dy - dx + this.mShiftX;
            float shifty = m21 * dx + m22 * dy - dy + this.mShiftY;
            view.setTranslationX(shiftx);
            view.setTranslationY(shifty);
            view.setScaleY(this.mScaleY);
            view.setScaleX(this.mScaleX);
            view.setRotation(this.mGroupRotateAngle);
        }
    }
}

